/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.applet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.util.NbBundle;

public class AppletSupport {
    private static final SpecificationVersion JDK_15;
    private static final String HTML_EXT = "html";
    private static final String CLASS_EXT = "class";
    private static final String POLICY_FILE_NAME = "applet";
    private static final String POLICY_FILE_EXT = "policy";
    public static Boolean unitTestingSupport_isApplet;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AppletSupport() {
    }

    public static boolean isApplet(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        if (unitTestingSupport_isApplet != null) {
            return unitTestingSupport_isApplet;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return AppletSupport.getAppletClassName(dataObject.getCookie(SourceCookie.class)) != null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static String getAppletClassName(Object object) {
        if (object == null || !(object instanceof SourceCookie)) {
            return null;
        }
        SourceCookie sourceCookie = (SourceCookie)object;
        String string = null;
        SourceElement sourceElement = sourceCookie.getSource();
        ClassElement[] classElementArray = sourceElement.getClasses();
        boolean bl = false;
        for (int i = 0; i < classElementArray.length; ++i) {
            JavaClass javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("java.applet.Applet");
            JavaClass javaClass2 = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("javax.swing.JApplet");
            JavaClass javaClass3 = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(classElementArray[i].getName().getFullName());
            if (javaClass3 instanceof UnresolvedClass || !javaClass3.isSubTypeOf((ClassDefinition)javaClass) && !javaClass3.isSubTypeOf((ClassDefinition)javaClass2)) continue;
            string = classElementArray[i].getName().getFullName();
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject generateHtml(FileObject fileObject, FileObject fileObject2, FileObject fileObject3) throws IOException {
        FileObject fileObject4 = fileObject2.getFileObject(fileObject.getName(), HTML_EXT);
        if (fileObject4 == null) {
            fileObject4 = fileObject2.createData(fileObject.getName(), HTML_EXT);
        }
        FileLock fileLock = fileObject4.lock();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(fileObject4.getOutputStream(fileLock));
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            String string = FileUtil.getRelativePath((FileObject)classPath2.findOwnerRoot(fileObject), (FileObject)fileObject);
            string = string.substring(0, string.length() - 5);
            String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject3);
            if (string2 == null) {
                string2 = fileObject3.getURL().toString();
            }
            AppletSupport.fillInFile(printWriter, string + "." + CLASS_EXT, "codebase=\"" + string2 + "\"");
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            fileLock.releaseLock();
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
        fileLock.releaseLock();
        if (printWriter != null) {
            printWriter.close();
        }
        return fileObject4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateSecurityPolicy(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject(POLICY_FILE_NAME, POLICY_FILE_EXT);
        try {
            if (fileObject2 == null) {
                fileObject2 = fileObject.createData(POLICY_FILE_NAME, POLICY_FILE_EXT);
            }
            FileLock fileLock = fileObject2.lock();
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(fileObject2.getOutputStream(fileLock));
                AppletSupport.fillInPolicyFile(printWriter);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                fileLock.releaseLock();
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
            fileLock.releaseLock();
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(1, "Problem when generating applet policy file: " + iOException);
        }
        return fileObject2;
    }

    public static URL generateHtmlFileURL(FileObject fileObject, FileObject fileObject2, FileObject fileObject3, String string) throws FileStateInvalidException {
        FileObject fileObject4 = null;
        Object var5_5 = null;
        if (fileObject == null || fileObject2 == null || fileObject3 == null) {
            return null;
        }
        try {
            fileObject4 = AppletSupport.generateHtml(fileObject, fileObject2, fileObject3);
            if (fileObject4 != null) {
                return AppletSupport.getHTMLPageURL(fileObject4, string);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static URL getHTMLPageURL(FileObject fileObject, String string) {
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError((Object)"htmlFile cannot be null");
        }
        JavaPlatform javaPlatform = J2SEProjectUtil.getActivePlatform(string);
        boolean bl = javaPlatform != null && javaPlatform.getSpecification().getVersion().compareTo((Object)JDK_15) >= 0;
        URL uRL = null;
        if (bl) {
            File file = FileUtil.toFile((FileObject)fileObject);
            try {
                String string2 = file.getAbsolutePath();
                if (File.separatorChar != '/') {
                    string2 = string2.replace(File.separatorChar, '/');
                }
                uRL = new URL("file", null, string2);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        } else {
            try {
                uRL = fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        return uRL;
    }

    private static void fillInFile(PrintWriter printWriter, String string, String string2) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)AppletSupport.class);
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.print("   <TITLE>");
        printWriter.print(resourceBundle.getString("GEN_title"));
        printWriter.println("</TITLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>\n");
        printWriter.print(resourceBundle.getString("GEN_warning"));
        printWriter.print("<H3><HR WIDTH=\"100%\">");
        printWriter.print(resourceBundle.getString("GEN_header"));
        printWriter.println("<HR WIDTH=\"100%\"></H3>\n");
        printWriter.println("<P>");
        if (string2 == null) {
            printWriter.print("<APPLET code=");
        } else {
            printWriter.print("<APPLET " + string2 + " code=");
        }
        printWriter.print("\"");
        printWriter.print(string);
        printWriter.print("\"");
        printWriter.println(" width=350 height=200></APPLET>");
        printWriter.println("</P>\n");
        printWriter.print("<HR WIDTH=\"100%\"><FONT SIZE=-1><I>");
        printWriter.print(resourceBundle.getString("GEN_copy"));
        printWriter.println("</I></FONT>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.flush();
    }

    private static void fillInPolicyFile(PrintWriter printWriter) {
        printWriter.println("grant {");
        printWriter.println("permission java.security.AllPermission;");
        printWriter.println("};");
        printWriter.flush();
    }

    static {
        $assertionsDisabled = !AppletSupport.class.desiredAssertionStatus();
        JDK_15 = new SpecificationVersion("1.5");
        unitTestingSupport_isApplet = null;
    }
}

