/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

public class ClassPathSupport {
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private AntProjectHelper antProjectHelper;
    private Set wellKnownPaths;
    private String libraryPrefix;
    private String librarySuffix;
    private String antArtifactPrefix;
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seproject$classpath$ClassPathSupport;

    public ClassPathSupport(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] stringArray, String string, String string2, String string3) {
        this.evaluator = propertyEvaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.wellKnownPaths = stringArray == null ? null : new HashSet<String>(Arrays.asList(stringArray));
        this.libraryPrefix = string;
        this.librarySuffix = string2;
        this.antArtifactPrefix = string3;
    }

    public Iterator itemsIterator(String string) {
        return this.itemsList(string).iterator();
    }

    public List itemsList(String string) {
        String[] stringArray = PropertyUtils.tokenizePath((String)(string == null ? "" : string));
        ArrayList<Item> arrayList = new ArrayList<Item>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            Item item;
            if (this.isWellKnownPath(stringArray[i])) {
                item = Item.create(stringArray[i]);
            } else if (this.isLibrary(stringArray[i])) {
                object2 = stringArray[i].substring(this.libraryPrefix.length(), stringArray[i].lastIndexOf(46));
                object = LibraryManager.getDefault().getLibrary((String)object2);
                item = object == null ? Item.createBroken(1, stringArray[i]) : Item.create(object, stringArray[i]);
            } else if (this.isAntArtifact(stringArray[i])) {
                object2 = this.referenceHelper.findArtifactAndLocation(stringArray[i]);
                if (object2[0] == null || object2[1] == null) {
                    item = Item.createBroken(2, stringArray[i]);
                } else {
                    File file;
                    object = (AntArtifact)object2[0];
                    URI uRI = (URI)object2[1];
                    File file2 = this.antProjectHelper.resolveFile(this.evaluator.evaluate(stringArray[i]));
                    item = file2.equals(file = new File(object.getScriptLocation().toURI().resolve(uRI).normalize())) ? Item.create((AntArtifact)object, uRI, stringArray[i]) : Item.createBroken(2, stringArray[i]);
                }
            } else {
                object2 = this.evaluator.evaluate(stringArray[i]);
                object = null;
                if (object2 != null) {
                    object = this.antProjectHelper.resolveFile((String)object2);
                }
                item = object == null || !object.exists() ? Item.createBroken(0, stringArray[i]) : Item.create((File)object, stringArray[i]);
            }
            arrayList.add(item);
        }
        return arrayList;
    }

    public String[] encodeToStrings(Iterator iterator) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            String string = null;
            switch (stringArray.getType()) {
                case 0: {
                    string = stringArray.getReference();
                    if (stringArray.isBroken() || string != null) break;
                    Object object = stringArray.getFile();
                    string = this.referenceHelper.createForeignFileReference((File)object, null);
                    break;
                }
                case 1: {
                    string = stringArray.getReference();
                    if (stringArray.isBroken()) break;
                    Object object = stringArray.getLibrary();
                    if (string != null || object == null) break;
                    string = this.getLibraryReference((Item)stringArray);
                    break;
                }
                case 2: {
                    string = stringArray.getReference();
                    if (stringArray.isBroken()) break;
                    AntArtifact antArtifact = stringArray.getArtifact();
                    if (string != null || antArtifact == null) break;
                    string = this.referenceHelper.addReference(stringArray.getArtifact(), stringArray.getArtifactURI());
                    break;
                }
                case 3: {
                    string = stringArray.getReference();
                }
            }
            if (string == null) continue;
            arrayList.add(string);
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = i < arrayList.size() - 1 ? arrayList.get(i) + ":" : (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String getLibraryReference(Item item) {
        if (item.getType() != 1) {
            throw new IllegalArgumentException("Item must be of type LIBRARY");
        }
        return this.libraryPrefix + item.getLibrary().getName() + this.librarySuffix;
    }

    private boolean isWellKnownPath(String string) {
        return this.wellKnownPaths == null ? false : this.wellKnownPaths.contains(string);
    }

    private boolean isAntArtifact(String string) {
        return this.antArtifactPrefix == null ? false : string.startsWith(this.antArtifactPrefix);
    }

    private boolean isLibrary(String string) {
        if (this.libraryPrefix != null && string.startsWith(this.libraryPrefix)) {
            return this.librarySuffix == null ? true : string.endsWith(this.librarySuffix);
        }
        return false;
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        private static final String BROKEN = "BrokenReference";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Item(int n, Object object, String string) {
            this.type = n;
            this.object = object;
            this.property = string;
        }

        private Item(int n, Object object, URI uRI, String string) {
            this(n, object, string);
            this.artifactURI = uRI;
        }

        public static Item create(Library library, String string) {
            if (library == null) {
                throw new IllegalArgumentException("library must not be null");
            }
            return new Item(1, library, string);
        }

        public static Item create(AntArtifact antArtifact, URI uRI, String string) {
            if (uRI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (antArtifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(2, antArtifact, uRI, string);
        }

        public static Item create(File file, String string) {
            if (file == null) {
                throw new IllegalArgumentException("file must not be null");
            }
            return new Item(0, file, string);
        }

        public static Item create(String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, string);
        }

        public static Item createBroken(int n, String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(n, BROKEN, string);
        }

        public int getType() {
            return this.type;
        }

        public Library getLibrary() {
            if (this.getType() != 1) {
                throw new IllegalArgumentException("Item is not of required type - LIBRARY");
            }
            if (!$assertionsDisabled && !(this.object instanceof Library)) {
                throw new AssertionError((Object)("Invalid object type: " + this.object.getClass().getName() + " instance: " + this.object.toString() + " expected type: Library"));
            }
            return (Library)this.object;
        }

        public File getFile() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return (File)this.object;
        }

        public AntArtifact getArtifact() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public String getReference() {
            return this.property;
        }

        public boolean isBroken() {
            return this.object == BROKEN;
        }

        public int hashCode() {
            int n = this.getType();
            if (this.object == BROKEN) {
                return BROKEN.hashCode();
            }
            switch (this.getType()) {
                case 2: {
                    n += this.getArtifact().getType().hashCode();
                    n += this.getArtifact().getScriptLocation().hashCode();
                    n += this.getArtifactURI().hashCode();
                    break;
                }
                case 3: {
                    n += this.property.hashCode();
                    break;
                }
                default: {
                    n += this.object.hashCode();
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Item)) {
                return false;
            }
            Item item = (Item)object;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 2: {
                    if (this.getArtifact().getType() != item.getArtifact().getType()) {
                        return false;
                    }
                    if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                        return false;
                    }
                    return this.getArtifactURI().equals(item.getArtifactURI());
                }
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$classpath$ClassPathSupport == null ? (class$org$netbeans$modules$java$j2seproject$classpath$ClassPathSupport = ClassPathSupport.class$("org.netbeans.modules.java.j2seproject.classpath.ClassPathSupport")) : class$org$netbeans$modules$java$j2seproject$classpath$ClassPathSupport).desiredAssertionStatus();
        }
    }
}

