/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.j2seproject.SourceRoots;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CompiledSourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private Map cache = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public CompiledSourceForBinaryQuery(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = sourceRoots2;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        SourceForBinaryQuery.Result result;
        if (FileUtil.getArchiveFile((URL)uRL) != null) {
            uRL = FileUtil.getArchiveFile((URL)uRL);
        }
        if ((result = (SourceForBinaryQuery.Result)this.cache.get(uRL)) != null) {
            return result;
        }
        SourceRoots sourceRoots = null;
        if (this.hasSources(uRL, "build.classes.dir")) {
            sourceRoots = this.sourceRoots;
        } else if (this.hasSources(uRL, "dist.jar")) {
            sourceRoots = this.sourceRoots;
        } else if (this.hasSources(uRL, "build.test.classes.dir")) {
            sourceRoots = this.testRoots;
        }
        if (sourceRoots == null) {
            return null;
        }
        result = new Result(sourceRoots);
        this.cache.put(uRL, result);
        return result;
    }

    private boolean hasSources(URL uRL, String string) {
        try {
            String string2 = this.evaluator.getProperty(string);
            if (string2 != null) {
                File file = this.helper.resolveFile(string2);
                URL uRL2 = file.toURI().toURL();
                if (!file.exists() && !file.getPath().toLowerCase().endsWith(".jar")) {
                    if (!$assertionsDisabled && uRL2.toExternalForm().endsWith("/")) {
                        throw new AssertionError(file);
                    }
                    uRL2 = new URL(uRL2.toExternalForm() + "/");
                }
                if (uRL2.equals(uRL)) {
                    return true;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
        }
        return false;
    }

    static {
        $assertionsDisabled = !CompiledSourceForBinaryQuery.class.desiredAssertionStatus();
    }

    private static class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private ArrayList listeners;
        private SourceRoots sourceRoots;

        public Result(SourceRoots sourceRoots) {
            this.sourceRoots = sourceRoots;
            this.sourceRoots.addPropertyChangeListener(this);
        }

        public FileObject[] getRoots() {
            return this.sourceRoots.getRoots();
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("roots".equals(propertyChangeEvent.getPropertyName())) {
                this.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            Iterator iterator;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                iterator = ((ArrayList)this.listeners.clone()).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }
    }
}

