/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.java.j2seproject.classpath.J2SEProjectClassPathExtender;
import org.netbeans.modules.java.j2seproject.ui.ActionFilterNode;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.LibrariesSourceGroup;
import org.netbeans.modules.java.j2seproject.ui.PlatformNode;
import org.netbeans.modules.java.j2seproject.ui.ProjectNode;
import org.netbeans.modules.java.j2seproject.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.modules.java.j2seproject.ui.customizer.LibrariesChooser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

final class LibrariesNode
extends AbstractNode {
    private static final Image ICON_BADGE = Utilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/libraries-badge.png");
    static final RequestProcessor rp = new RequestProcessor();
    private static Icon folderIconCache;
    private static Icon openedFolderIconCache;
    private final String displayName;
    private final Action[] librariesNodeActions;
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode;
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender;

    LibrariesNode(String string, Project project, PropertyEvaluator propertyEvaluator, UpdateHelper updateHelper, ReferenceHelper referenceHelper, String string2, String[] stringArray, String string3, Action[] actionArray) {
        super((Children)new LibrariesChildren(propertyEvaluator, updateHelper, referenceHelper, string2, stringArray, string3), Lookups.singleton((Object)project));
        this.displayName = string;
        this.librariesNodeActions = actionArray;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    public Action[] getActions(boolean bl) {
        return this.librariesNodeActions;
    }

    public boolean canCopy() {
        return false;
    }

    public static Action createAddProjectAction(Project project, String string) {
        return new AddProjectAction(project, string);
    }

    public static Action createAddLibraryAction(Project project, String string) {
        return new AddLibraryAction(project, string);
    }

    public static Action createAddFolderAction(Project project, String string) {
        return new AddFolderAction(project, string);
    }

    static synchronized Icon getFolderIcon(boolean bl) {
        if (openedFolderIconCache == null) {
            Node node = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(node.getOpenedIcon(1));
            folderIconCache = new ImageIcon(node.getIcon(1));
        }
        if (bl) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean bl, int n) {
        Icon icon = LibrariesNode.getFolderIcon(bl);
        Image image = ((ImageIcon)icon).getImage();
        image = Utilities.mergeImages((Image)image, (Image)ICON_BADGE, (int)7, (int)7);
        return image;
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class AddFolderAction
    extends AbstractAction {
        private final Project project;
        private final String classPathId;
        static final /* synthetic */ boolean $assertionsDisabled;

        public AddFolderAction(Project project, String string) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddFolder_Action"));
            this.project = project;
            this.classPathId = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setDialogTitle(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddJar_DialogTitle"));
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
            jFileChooser.setFileFilter(simpleFileFilter);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            File file = FoldersListSettings.getDefault().getLastUsedClassPathFolder();
            jFileChooser.setCurrentDirectory(file);
            int n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
            if (n == 0) {
                File[] fileArray = jFileChooser.getSelectedFiles();
                this.addJarFiles(fileArray, simpleFileFilter);
                file = FileUtil.normalizeFile((File)jFileChooser.getCurrentDirectory());
                FoldersListSettings.getDefault().setLastUsedClassPathFolder(file);
            }
        }

        private void addJarFiles(File[] fileArray, FileFilter fileFilter) {
            J2SEProjectClassPathExtender j2SEProjectClassPathExtender = (J2SEProjectClassPathExtender)this.project.getLookup().lookup(class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender == null ? (class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.classpath.J2SEProjectClassPathExtender")) : class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender);
            if (j2SEProjectClassPathExtender != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        if (!fileFilter.accept(fileArray[i])) continue;
                        FileObject fileObject = FileUtil.toFileObject((File)fileArray[i]);
                        if (!$assertionsDisabled && fileObject == null) {
                            throw new AssertionError(fileArray[i]);
                        }
                        j2SEProjectClassPathExtender.addArchiveFile(this.classPathId, fileObject);
                        continue;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            } else {
                ErrorManager.getDefault().log("J2SEProjectClassPathExtender not found in the project lookup of project: " + this.project.getProjectDirectory().getPath());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode).desiredAssertionStatus();
        }
    }

    private static class AddLibraryAction
    extends AbstractAction {
        private final Project project;
        private final String classPathId;

        public AddLibraryAction(Project project, String string) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddLibrary_Action"));
            this.project = project;
            this.classPathId = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{new JButton(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddLibrary")), DialogDescriptor.CANCEL_OPTION};
            ((JButton)objectArray[0]).setEnabled(false);
            ((JButton)objectArray[0]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"AD_AddLibrary"));
            LibrariesChooser librariesChooser = new LibrariesChooser((JButton)objectArray[0], Collections.EMPTY_SET);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)librariesChooser, NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_CustomizeCompile_Classpath_AddLibrary"), true, objectArray, objectArray[0], 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == objectArray[0]) {
                this.addLibraries(librariesChooser.getSelectedLibraries());
            }
            dialog.dispose();
        }

        private void addLibraries(Library[] libraryArray) {
            J2SEProjectClassPathExtender j2SEProjectClassPathExtender = (J2SEProjectClassPathExtender)this.project.getLookup().lookup(class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender == null ? (class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.classpath.J2SEProjectClassPathExtender")) : class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender);
            if (j2SEProjectClassPathExtender != null) {
                for (int i = 0; i < libraryArray.length; ++i) {
                    try {
                        j2SEProjectClassPathExtender.addLibrary(this.classPathId, libraryArray[i]);
                        continue;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            } else {
                ErrorManager.getDefault().log("J2SEProjectClassPathExtender not found in the project lookup of project: " + this.project.getProjectDirectory().getPath());
            }
        }
    }

    private static class AddProjectAction
    extends AbstractAction {
        private final Project project;
        private final String classPathId;

        public AddProjectAction(Project project, String string) {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"LBL_AddProject_Action"));
            this.project = project;
            this.classPathId = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AntArtifactChooser.ArtifactItem[] artifactItemArray = AntArtifactChooser.showDialog(new String[]{"jar", "folder"}, this.project, null);
            if (artifactItemArray != null) {
                this.addArtifacts(artifactItemArray);
            }
        }

        private void addArtifacts(AntArtifactChooser.ArtifactItem[] artifactItemArray) {
            J2SEProjectClassPathExtender j2SEProjectClassPathExtender = (J2SEProjectClassPathExtender)this.project.getLookup().lookup(class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender == null ? (class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.classpath.J2SEProjectClassPathExtender")) : class$org$netbeans$modules$java$j2seproject$classpath$J2SEProjectClassPathExtender);
            if (j2SEProjectClassPathExtender != null) {
                for (int i = 0; i < artifactItemArray.length; ++i) {
                    try {
                        j2SEProjectClassPathExtender.addAntArtifact(this.classPathId, artifactItemArray[i].getArtifact(), artifactItemArray[i].getArtifactURI());
                        continue;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            } else {
                ErrorManager.getDefault().log("J2SEProjectClassPathExtender not found in the project lookup of project: " + this.project.getProjectDirectory().getPath());
            }
        }
    }

    private static class Key {
        static final int TYPE_PLATFORM = 0;
        static final int TYPE_LIBRARY = 1;
        static final int TYPE_PROJECT = 2;
        private int type;
        private String classPathId;
        private String entryId;
        private SourceGroup sg;
        private AntArtifact antArtifact;
        private URI uri;

        Key() {
            this.type = 0;
        }

        Key(SourceGroup sourceGroup, String string, String string2) {
            this.type = 1;
            this.sg = sourceGroup;
            this.classPathId = string;
            this.entryId = string2;
        }

        Key(AntArtifact antArtifact, URI uRI, String string, String string2) {
            this.type = 2;
            this.antArtifact = antArtifact;
            this.uri = uRI;
            this.classPathId = string;
            this.entryId = string2;
        }

        public int getType() {
            return this.type;
        }

        public String getClassPathId() {
            return this.classPathId;
        }

        public String getEntryId() {
            return this.entryId;
        }

        public SourceGroup getSourceGroup() {
            return this.sg;
        }

        public AntArtifact getProject() {
            return this.antArtifact;
        }

        public URI getArtifactLocation() {
            return this.uri;
        }

        public int hashCode() {
            int n = this.type << 16;
            switch (this.type) {
                case 1: {
                    n ^= this.sg == null ? 0 : this.sg.hashCode();
                    break;
                }
                case 2: {
                    n ^= this.antArtifact == null ? 0 : this.antArtifact.hashCode();
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            if (key.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    return (this.sg == null ? key.sg == null : this.sg.equals(key.sg)) && (this.classPathId == null ? key.classPathId == null : this.classPathId.equals(key.classPathId)) && (this.entryId == null ? key.entryId == null : this.entryId.equals(key.entryId));
                }
                case 2: {
                    return (this.antArtifact == null ? key.antArtifact == null : this.antArtifact.equals(key.antArtifact)) && (this.classPathId == null ? key.classPathId == null : this.classPathId.equals(key.classPathId)) && (this.entryId == null ? key.entryId == null : this.entryId.equals(key.entryId));
                }
                case 0: {
                    return true;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class LibrariesChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private static final String LIBRARY_PREFIX = "${libs.";
        private static final String ANT_ARTIFACT_PREFIX = "${reference.";
        private static final String FILE_REF_PREFIX = "${file.reference.";
        private static final String REF_PREFIX = "${";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/libraries.gif";
        private static final String ARCHIVE_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/jar.gif";
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final String classPathProperty;
        private final String platformProperty;
        private final Set classPathIgnoreRef;
        private ClassPath fsListener;
        static final /* synthetic */ boolean $assertionsDisabled;

        LibrariesChildren(PropertyEvaluator propertyEvaluator, UpdateHelper updateHelper, ReferenceHelper referenceHelper, String string, String[] stringArray, String string2) {
            this.eval = propertyEvaluator;
            this.helper = updateHelper;
            this.refHelper = referenceHelper;
            this.classPathProperty = string;
            this.classPathIgnoreRef = new HashSet<String>(Arrays.asList(stringArray));
            this.platformProperty = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (this.classPathProperty.equals(string) || "roots".equals(string)) {
                LibrariesChildren librariesChildren = this;
                synchronized (librariesChildren) {
                    if (this.fsListener != null) {
                        this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
                rp.post(new Runnable(this){
                    private final /* synthetic */ LibrariesChildren this$0;
                    {
                        this.this$0 = librariesChildren;
                    }

                    public void run() {
                        LibrariesChildren.access$100(this.this$0, LibrariesChildren.access$000(this.this$0));
                    }
                });
            }
        }

        protected void addNotify() {
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
            this.setKeys(this.getKeys());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeNotify() {
            this.eval.removePropertyChangeListener((PropertyChangeListener)this);
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                if (this.fsListener != null) {
                    this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    this.fsListener = null;
                }
            }
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray = null;
            if (object instanceof Key) {
                Key key = (Key)object;
                switch (key.getType()) {
                    case 0: {
                        nodeArray = new Node[]{PlatformNode.create(this.eval, this.platformProperty)};
                        break;
                    }
                    case 2: {
                        nodeArray = new Node[]{new ProjectNode(key.getProject(), key.getArtifactLocation(), this.helper, this.refHelper, key.getClassPathId(), key.getEntryId())};
                        break;
                    }
                    case 1: {
                        nodeArray = new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)key.getSourceGroup()), this.helper, key.getClassPathId(), key.getEntryId())};
                    }
                }
            }
            if (nodeArray == null) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unknown key type");
                }
                nodeArray = new Node[]{};
            }
            return nodeArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getKeys() {
            EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
            EditableProperties editableProperties2 = this.helper.getProperties("nbproject/private/private.properties");
            EditableProperties editableProperties3 = PropertyUtils.getGlobalProperties();
            ArrayList arrayList = new ArrayList();
            List list = this.getKeys(editableProperties, editableProperties2, editableProperties3, this.classPathProperty, arrayList);
            FileObject fileObject = this.helper.getAntProjectHelper().getProjectDirectory();
            if (this.platformProperty != null && fileObject != null && fileObject.isValid() && !fileObject.isVirtual()) {
                list.add(new Key());
            }
            ClassPath classPath = ClassPathSupport.createClassPath((URL[])arrayList.toArray(new URL[arrayList.size()]));
            classPath.addPropertyChangeListener((PropertyChangeListener)this);
            classPath.getRoots();
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                this.fsListener = classPath;
            }
            return list;
        }

        private List getKeys(EditableProperties editableProperties, EditableProperties editableProperties2, EditableProperties editableProperties3, String string, List list) {
            ArrayList<Key> arrayList = new ArrayList<Key>();
            String string2 = editableProperties.getProperty(string);
            if (string2 == null) {
                string2 = editableProperties2.getProperty(string);
            }
            if (string2 == null) {
                string2 = editableProperties3.getProperty(string);
            }
            if (string2 == null) {
                return arrayList;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)string2)));
            while (arrayList2.size() > 0) {
                Object object;
                Object object2;
                Object object3;
                String string3 = (String)arrayList2.remove(0);
                String string4 = J2SEProjectProperties.getAntPropertyName(string3);
                if (this.classPathIgnoreRef.contains(string4)) continue;
                if (string3.startsWith(LIBRARY_PREFIX)) {
                    object3 = string3.substring(LIBRARY_PREFIX.length(), string3.lastIndexOf(46));
                    object2 = LibraryManager.getDefault().getLibrary((String)object3);
                    if (object2 == null) continue;
                    object = object2.getContent("classpath");
                    ImageIcon imageIcon = new ImageIcon(Utilities.loadImage((String)LIBRARIES_ICON));
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string5;
                        Object object4;
                        URL uRL = (URL)iterator.next();
                        list.add(uRL);
                        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                        if (fileObject == null) continue;
                        if ("jar".equals(uRL.getProtocol())) {
                            object4 = FileUtil.getArchiveFile((FileObject)fileObject);
                            string5 = object4.getNameExt();
                        } else {
                            object4 = FileUtil.toFile((FileObject)fileObject);
                            string5 = object4 != null ? ((File)object4).getAbsolutePath() : fileObject.getNameExt();
                        }
                        string5 = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode") : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode), (String)"TXT_LibraryPartFormat"), object2.getDisplayName(), string5);
                        object4 = new LibrariesSourceGroup(fileObject, string5, imageIcon, imageIcon);
                        arrayList.add(new Key((SourceGroup)object4, string, string4));
                    }
                    continue;
                }
                if (string3.startsWith(ANT_ARTIFACT_PREFIX)) {
                    object3 = this.refHelper.findArtifactAndLocation(string3);
                    if (object3[0] == null || object3[1] == null) continue;
                    object2 = (AntArtifact)object3[0];
                    object = (URI)object3[1];
                    arrayList.add(new Key((AntArtifact)object2, (URI)object, string, string4));
                    continue;
                }
                if (string3.startsWith(FILE_REF_PREFIX)) {
                    object3 = this.eval.getProperty(string4);
                    if (object3 == null || (object = LibrariesChildren.createFileSourceGroup((File)(object2 = this.helper.getAntProjectHelper().resolveFile((String)object3)), list)) == null) continue;
                    arrayList.add(new Key((SourceGroup)object, string, string4));
                    continue;
                }
                if (string3.startsWith(REF_PREFIX)) {
                    arrayList.addAll(this.getKeys(editableProperties, editableProperties2, editableProperties3, string4, list));
                    continue;
                }
                object3 = this.helper.getAntProjectHelper().resolveFile(string3);
                object2 = LibrariesChildren.createFileSourceGroup((File)object3, list);
                if (object2 == null) continue;
                arrayList.add(new Key((SourceGroup)object2, string, string4));
            }
            return arrayList;
        }

        private static SourceGroup createFileSourceGroup(File file, List list) {
            try {
                String string;
                String string2;
                Icon icon;
                Icon icon2;
                URL uRL = file.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)uRL)) {
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    icon2 = new ImageIcon(Utilities.loadImage((String)ARCHIVE_ICON));
                    icon = icon2;
                    string2 = file.getName();
                } else {
                    string = uRL.toExternalForm();
                    if (!string.endsWith("/")) {
                        uRL = new URL(string + "/");
                    }
                    icon = LibrariesNode.getFolderIcon(false);
                    icon2 = LibrariesNode.getFolderIcon(true);
                    string2 = file.getAbsolutePath();
                }
                list.add(uRL);
                string = URLMapper.findFileObject((URL)uRL);
                if (string != null) {
                    return new LibrariesSourceGroup((FileObject)string, string2, icon, icon2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
            return null;
        }

        static /* synthetic */ List access$000(LibrariesChildren librariesChildren) {
            return librariesChildren.getKeys();
        }

        static /* synthetic */ void access$100(LibrariesChildren librariesChildren, Collection collection) {
            librariesChildren.setKeys(collection);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode = LibrariesNode.class$("org.netbeans.modules.java.j2seproject.ui.LibrariesNode")) : class$org$netbeans$modules$java$j2seproject$ui$LibrariesNode).desiredAssertionStatus();
        }
    }
}

