/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.ui.ActionFilterNode;
import org.netbeans.modules.java.j2seproject.ui.LibrariesNode;
import org.netbeans.modules.java.j2seproject.ui.LibrariesSourceGroup;
import org.netbeans.modules.java.j2seproject.ui.ShowJavadocAction;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

class PlatformNode
extends AbstractNode
implements ChangeListener {
    private static final String PLATFORM_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/platform";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/jar.gif";
    private final PlatformProvider pp;

    private PlatformNode(PlatformProvider platformProvider) {
        super((Children)new PlatformContentChildren(), Lookups.singleton((Object)new JavadocProvider(platformProvider)));
        this.pp = platformProvider;
        this.pp.addChangeListener(this);
        this.setIconBase(PLATFORM_ICON);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String string;
        JavaPlatform javaPlatform = this.pp.getPlatform();
        String string2 = javaPlatform != null ? javaPlatform.getDisplayName() : ((string = this.pp.getPlatformId()) == null ? NbBundle.getMessage((Class)PlatformNode.class, (String)"TXT_BrokenPlatform") : MessageFormat.format(NbBundle.getMessage((Class)PlatformNode.class, (String)"FMT_BrokenPlatform"), string));
        return string2;
    }

    public String getHtmlDisplayName() {
        if (this.pp.getPlatform() == null) {
            String string = this.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
            return "<font color=\"#A40000\">" + string + "</font>";
        }
        return null;
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get((Class)ShowJavadocAction.class)};
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        LibrariesNode.rp.post(new Runnable(){

            public void run() {
                ((PlatformContentChildren)PlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    static PlatformNode create(PropertyEvaluator propertyEvaluator, String string) {
        PlatformProvider platformProvider = new PlatformProvider(propertyEvaluator, string);
        return new PlatformNode(platformProvider);
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        PlatformProvider platformProvider;

        private JavadocProvider(PlatformProvider platformProvider) {
            this.platformProvider = platformProvider;
        }

        public boolean hasJavadoc() {
            JavaPlatform javaPlatform = this.platformProvider.getPlatform();
            if (javaPlatform == null) {
                return false;
            }
            URL[] uRLArray = JavadocProvider.getJavadocRoots(javaPlatform);
            return uRLArray.length > 0;
        }

        public void showJavadoc() {
            JavaPlatform javaPlatform = this.platformProvider.getPlatform();
            if (javaPlatform != null) {
                URL[] uRLArray = JavadocProvider.getJavadocRoots(javaPlatform);
                URL uRL = ShowJavadocAction.findJavadoc("overview-summary.html", uRLArray);
                if (uRL == null) {
                    uRL = ShowJavadocAction.findJavadoc("index.html", uRLArray);
                }
                ShowJavadocAction.showJavaDoc(uRL, javaPlatform.getDisplayName());
            }
        }

        private static URL[] getJavadocRoots(JavaPlatform javaPlatform) {
            HashSet<URL> hashSet = new HashSet<URL>();
            List list = javaPlatform.getBootstrapLibraries().entries();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
                hashSet.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)entry.getURL()).getRoots()));
            }
            return hashSet.toArray(new URL[hashSet.size()]);
        }
    }

    private static class PlatformProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator evaluator;
        private final String platformPropName;
        private JavaPlatform platformCache;
        private List listeners;

        public PlatformProvider(PropertyEvaluator propertyEvaluator, String string) {
            this.evaluator = propertyEvaluator;
            this.platformPropName = string;
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        }

        public String getPlatformId() {
            return this.evaluator.getProperty(this.platformPropName);
        }

        public JavaPlatform getPlatform() {
            if (this.platformCache == null) {
                String string = this.getPlatformId();
                this.platformCache = J2SEProjectUtil.getActivePlatform(string);
                if (this.platformCache != null && this.platformCache.getInstallFolders().size() == 0) {
                    this.platformCache = null;
                }
                if (ErrorManager.getDefault().isLoggable(1) && this.platformCache == null) {
                    StringBuffer stringBuffer = new StringBuffer("RequestedPlatform: " + string + " not found.\nInstalled Platforms:\n");
                    JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
                    for (int i = 0; i < javaPlatformArray.length; ++i) {
                        stringBuffer.append("Name: " + javaPlatformArray[i].getProperties().get("platform.ant.name") + " Broken: " + (javaPlatformArray[i].getInstallFolders().size() == 0) + "\n");
                    }
                    ErrorManager.getDefault().log(1, stringBuffer.toString());
                }
            }
            return this.platformCache;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.platformPropName.equals(propertyChangeEvent.getPropertyName())) {
                this.platformCache = null;
                this.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }
    }

    private static class PlatformContentChildren
    extends Children.Keys {
        PlatformContentChildren() {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            SourceGroup sourceGroup = (SourceGroup)object;
            return new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)sourceGroup), null, null, null)};
        }

        private List getKeys() {
            JavaPlatform javaPlatform = ((PlatformNode)this.getNode()).pp.getPlatform();
            if (javaPlatform == null) {
                return Collections.EMPTY_LIST;
            }
            FileObject[] fileObjectArray = javaPlatform.getBootstrapLibraries().getRoots();
            ArrayList<LibrariesSourceGroup> arrayList = new ArrayList<LibrariesSourceGroup>(fileObjectArray.length);
            for (int i = 0; i < fileObjectArray.length; ++i) {
                try {
                    ImageIcon imageIcon;
                    ImageIcon imageIcon2;
                    FileObject fileObject;
                    if ("jar".equals(fileObjectArray[i].getURL().getProtocol())) {
                        fileObject = FileUtil.getArchiveFile((FileObject)fileObjectArray[i]);
                        imageIcon = imageIcon2 = new ImageIcon(Utilities.loadImage((String)PlatformNode.ARCHIVE_ICON));
                    } else {
                        fileObject = fileObjectArray[i];
                        imageIcon = null;
                        imageIcon2 = null;
                    }
                    if (!fileObject.isValid()) continue;
                    arrayList.add(new LibrariesSourceGroup(fileObjectArray[i], fileObject.getNameExt(), imageIcon, imageIcon2));
                    continue;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                }
            }
            return arrayList;
        }
    }
}

