/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AntArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private String[] artifactTypes;
    private JLabel jLabelJarFiles;
    private JLabel jLabelName;
    private JList jListArtifacts;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;

    public AntArtifactChooser(String[] stringArray, JFileChooser jFileChooser) {
        this.artifactTypes = stringArray;
        this.initComponents();
        this.jListArtifacts.setModel(new DefaultListModel());
        jFileChooser.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelJarFiles = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListArtifacts = new JList();
        this.setLayout(new GridBagLayout());
        this.jLabelName.setLabelFor(this.jTextFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelName, (String)NbBundle.getMessage((Class)AntArtifactChooser.class, (String)"LBL_AACH_ProjectName_JLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelName, gridBagConstraints);
        this.jTextFieldName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jTextFieldName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/j2seproject/ui/customizer/Bundle").getString("AD_AACH_ProjectName_JLabel"));
        this.jLabelJarFiles.setLabelFor(this.jListArtifacts);
        Mnemonics.setLocalizedText((JLabel)this.jLabelJarFiles, (String)NbBundle.getMessage((Class)AntArtifactChooser.class, (String)"LBL_AACH_ProjectJarFiles_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelJarFiles, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jListArtifacts);
        this.jListArtifacts.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/j2seproject/ui/customizer/Bundle").getString("AD_AACH_ProjectJarFiles_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            File file = jFileChooser.getSelectedFile();
            Project project = this.getProject(file);
            this.populateAccessory(project);
        }
    }

    private Project getProject(File file) {
        if (file == null) {
            return null;
        }
        try {
            File file2 = FileUtil.normalizeFile((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file2);
            if (fileObject != null) {
                return ProjectManager.getDefault().findProject(fileObject);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return null;
    }

    private void populateAccessory(Project project) {
        DefaultListModel defaultListModel = (DefaultListModel)this.jListArtifacts.getModel();
        defaultListModel.clear();
        this.jTextFieldName.setText(project == null ? "" : ProjectUtils.getInformation((Project)project).getDisplayName());
        if (project != null) {
            ArrayList<AntArtifact> arrayList = new ArrayList<AntArtifact>();
            for (int i = 0; i < this.artifactTypes.length; ++i) {
                arrayList.addAll(Arrays.asList(AntArtifactQuery.findArtifactsByType((Project)project, (String)this.artifactTypes[i])));
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AntArtifact antArtifact = (AntArtifact)iterator.next();
                URI[] uRIArray = antArtifact.getArtifactLocations();
                for (int i = 0; i < uRIArray.length; ++i) {
                    defaultListModel.addElement(new ArtifactItem(antArtifact, uRIArray[i]));
                }
            }
            this.jListArtifacts.setSelectionInterval(0, defaultListModel.size());
        }
    }

    public static ArtifactItem[] showDialog(String[] stringArray, Project project, Component component) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage((Class)AntArtifactChooser.class, (String)"LBL_AACH_Title"));
        jFileChooser.setApproveButtonText(NbBundle.getMessage((Class)AntArtifactChooser.class, (String)"LBL_AACH_SelectProject"));
        jFileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)AntArtifactChooser.class, (String)"AD_AACH_SelectProject"));
        AntArtifactChooser antArtifactChooser = new AntArtifactChooser(stringArray, jFileChooser);
        jFileChooser.setAccessory(antArtifactChooser);
        jFileChooser.setPreferredSize(new Dimension(650, 380));
        jFileChooser.setCurrentDirectory(FoldersListSettings.getDefault().getLastUsedArtifactFolder());
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            Project project2 = antArtifactChooser.getProject(file = FileUtil.normalizeFile((File)file));
            if (project2 == null) {
                return null;
            }
            if (project2.getProjectDirectory().equals(project.getProjectDirectory())) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)AntArtifactChooser.class, (String)"MSG_AACH_RefToItself"), 1));
                return null;
            }
            if (ProjectUtils.hasSubprojectCycles((Project)project, (Project)project2)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)AntArtifactChooser.class, (String)"MSG_AACH_Cycles"), 1));
                return null;
            }
            FoldersListSettings.getDefault().setLastUsedArtifactFolder(FileUtil.normalizeFile((File)jFileChooser.getCurrentDirectory()));
            Object[] objectArray = new Object[antArtifactChooser.jListArtifacts.getModel().getSize()];
            int n2 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!antArtifactChooser.jListArtifacts.isSelectedIndex(i)) continue;
                objectArray[n2] = antArtifactChooser.jListArtifacts.getModel().getElementAt(i);
                ++n2;
            }
            ArtifactItem[] artifactItemArray = new ArtifactItem[n2];
            System.arraycopy(objectArray, 0, artifactItemArray, 0, n2);
            return artifactItemArray;
        }
        return null;
    }

    public static class ArtifactItem {
        private AntArtifact artifact;
        private URI artifactURI;

        public ArtifactItem(AntArtifact antArtifact, URI uRI) {
            this.artifact = antArtifact;
            this.artifactURI = uRI;
        }

        public AntArtifact getArtifact() {
            return this.artifact;
        }

        public URI getArtifactURI() {
            return this.artifactURI;
        }

        public String toString() {
            return this.artifactURI.toString();
        }
    }
}

