/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerCompile;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerJar;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerJavadoc;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerSources;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.modules.java.j2seproject.wsclient.CustomizerWSClientHost;
import org.netbeans.modules.java.j2seproject.wsclient.NoWebServiceClientsPanel;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CustomizerProviderImpl
implements CustomizerProvider {
    private final Project project;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFileHelper;
    private ProjectCustomizer.Category[] categories;
    private ProjectCustomizer.CategoryComponentProvider panelProvider;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private static Map project2Dialog = new HashMap();
    private static final String BUILD_CATEGORY = "BuildCategory";
    private static final String RUN_CATEGORY = "RunCategory";
    private static final String GENERAL = "General";
    private static final String SOURCES = "Sources";
    private static final String LIBRARIES = "Libraries";
    private static final String BUILD = "Build";
    private static final String BUILD_TESTS = "BuildTests";
    private static final String JAR = "Jar";
    private static final String JAVADOC = "Javadoc";
    private static final String RUN = "Run";
    private static final String RUN_TESTS = "RunTests";
    private static final String WEBSERVICECLIENTS = "WebServiceClients";
    private static final String WEBSERVICE_CATEGORY = "WebServiceCategory";

    public CustomizerProviderImpl(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, GeneratedFilesHelper generatedFilesHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.evaluator = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.genFileHelper = generatedFilesHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String string) {
        this.showCustomizer(string, null);
    }

    public void showCustomizer(String string, String string2) {
        Dialog dialog = (Dialog)project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.show();
            return;
        }
        J2SEProjectProperties j2SEProjectProperties = new J2SEProjectProperties((J2SEProject)this.project, this.updateHelper, this.evaluator, this.refHelper, this.genFileHelper);
        this.init(j2SEProjectProperties);
        OptionListener optionListener = new OptionListener(this.project, j2SEProjectProperties);
        if (string != null && string2 != null) {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!string.equals(this.categories[i].getName())) continue;
                JComponent jComponent = this.panelProvider.create(this.categories[i]);
                if (!(jComponent instanceof SubCategoryProvider)) break;
                ((SubCategoryProvider)((Object)jComponent)).showSubCategory(string2);
                break;
            }
        }
        dialog = ProjectCustomizer.createCustomizerDialog((ProjectCustomizer.Category[])this.categories, (ProjectCustomizer.CategoryComponentProvider)this.panelProvider, (String)string, (ActionListener)optionListener, null);
        dialog.addWindowListener(optionListener);
        dialog.setTitle(MessageFormat.format(NbBundle.getMessage((Class)CustomizerProviderImpl.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        project2Dialog.put(this.project, dialog);
        dialog.show();
    }

    private void init(J2SEProjectProperties j2SEProjectProperties) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)CustomizerProviderImpl.class);
        ProjectCustomizer.Category category = ProjectCustomizer.Category.create((String)SOURCES, (String)resourceBundle.getString("LBL_Config_Sources"), null, null);
        ProjectCustomizer.Category category2 = ProjectCustomizer.Category.create((String)LIBRARIES, (String)resourceBundle.getString("LBL_Config_Libraries"), null, null);
        ProjectCustomizer.Category category3 = ProjectCustomizer.Category.create((String)BUILD, (String)resourceBundle.getString("LBL_Config_Build"), null, null);
        ProjectCustomizer.Category category4 = ProjectCustomizer.Category.create((String)JAR, (String)resourceBundle.getString("LBL_Config_Jar"), null, null);
        ProjectCustomizer.Category category5 = ProjectCustomizer.Category.create((String)JAVADOC, (String)resourceBundle.getString("LBL_Config_Javadoc"), null, null);
        ProjectCustomizer.Category category6 = ProjectCustomizer.Category.create((String)RUN, (String)resourceBundle.getString("LBL_Config_Run"), null, null);
        ProjectCustomizer.Category category7 = ProjectCustomizer.Category.create((String)RUN_TESTS, (String)resourceBundle.getString("LBL_Config_Test"), null, null);
        ProjectCustomizer.Category category8 = ProjectCustomizer.Category.create((String)BUILD_CATEGORY, (String)resourceBundle.getString("LBL_Config_BuildCategory"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[]{category3, category4, category5});
        ProjectCustomizer.Category category9 = ProjectCustomizer.Category.create((String)WEBSERVICECLIENTS, (String)resourceBundle.getString("LBL_Config_WebServiceClients"), null, null);
        ProjectCustomizer.Category category10 = ProjectCustomizer.Category.create((String)WEBSERVICE_CATEGORY, (String)resourceBundle.getString("LBL_Config_WebServices"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[]{category9});
        this.categories = new ProjectCustomizer.Category[]{category, category2, category8, category6, category10};
        List list = null;
        WebServicesClientSupport webServicesClientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.project.getProjectDirectory());
        if (webServicesClientSupport != null) {
            list = webServicesClientSupport.getServiceClients();
        }
        this.categories = new ProjectCustomizer.Category[]{category, category2, category8, category6, category10};
        HashMap<ProjectCustomizer.Category, JPanel> hashMap = new HashMap<ProjectCustomizer.Category, JPanel>();
        hashMap.put(category, new CustomizerSources(j2SEProjectProperties));
        hashMap.put(category2, new CustomizerLibraries(j2SEProjectProperties));
        hashMap.put(category3, new CustomizerCompile(j2SEProjectProperties));
        hashMap.put(category4, new CustomizerJar(j2SEProjectProperties));
        hashMap.put(category5, new CustomizerJavadoc(j2SEProjectProperties));
        hashMap.put(category6, new CustomizerRun(j2SEProjectProperties));
        if (list != null && list.size() > 0) {
            hashMap.put(category9, new CustomizerWSClientHost(j2SEProjectProperties, list));
        } else {
            hashMap.put(category9, new NoWebServiceClientsPanel());
        }
        this.panelProvider = new PanelProvider(hashMap);
    }

    static interface SubCategoryProvider {
        public void showSubCategory(String var1);
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;
        private J2SEProjectProperties uiProperties;

        OptionListener(Project project, J2SEProjectProperties j2SEProjectProperties) {
            this.project = project;
            this.uiProperties = j2SEProjectProperties;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.uiProperties.save();
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.hide();
                dialog.dispose();
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            project2Dialog.remove(this.project);
        }

        public void windowClosing(WindowEvent windowEvent) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.hide();
                dialog.dispose();
            }
        }
    }

    private static class PanelProvider
    implements ProjectCustomizer.CategoryComponentProvider {
        private JPanel EMPTY_PANEL = new JPanel();
        private Map panels;

        PanelProvider(Map map) {
            this.panels = map;
        }

        public JComponent create(ProjectCustomizer.Category category) {
            JComponent jComponent = (JComponent)this.panels.get(category);
            return jComponent == null ? this.EMPTY_PANEL : jComponent;
        }
    }
}

