/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class LibrariesChooser
extends JPanel
implements HelpCtx.Provider {
    private Set containedLibraries;
    private JButton edit;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public LibrariesChooser(final JButton jButton, Set set) {
        this.containedLibraries = set;
        this.initComponents();
        this.jList1.setPrototypeCellValue("0123456789012345678901234");
        this.jList1.setModel(new LibrariesListModel());
        this.jList1.setCellRenderer(new LibraryRenderer());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                jButton.setEnabled(LibrariesChooser.this.jList1.getSelectedIndices().length != 0);
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LibrariesChooser.class);
    }

    public Library[] getSelectedLibraries() {
        Object[] objectArray = this.jList1.getSelectedValues();
        Library[] libraryArray = new Library[objectArray.length];
        System.arraycopy(objectArray, 0, libraryArray, 0, objectArray.length);
        return libraryArray;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.edit = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 250));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)LibrariesChooser.class).getString("AD_LibrariesChooser"));
        this.jLabel1.setDisplayedMnemonic(NbBundle.getBundle((Class)LibrariesChooser.class).getString("MNE_InstalledLibraries").charAt(0));
        this.jLabel1.setLabelFor(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle((Class)LibrariesChooser.class).getString("CTL_InstalledLibraries"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jList1);
        this.jList1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)LibrariesChooser.class).getString("AD_jScrollPaneLibraries"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.edit, (String)NbBundle.getBundle((Class)LibrariesChooser.class).getString("CTL_EditLibraries"));
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibrariesChooser.this.editLibraries(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.edit, gridBagConstraints);
        this.edit.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)LibrariesChooser.class).getString("AD_jButtonManageLibraries"));
    }

    private void editLibraries(ActionEvent actionEvent) {
        LibrariesListModel librariesListModel = (LibrariesListModel)this.jList1.getModel();
        List<Library> list = Arrays.asList(librariesListModel.getLibraries());
        LibrariesCustomizer.showCustomizer((Library)((Library)this.jList1.getSelectedValue()));
        List<Library> list2 = Arrays.asList(librariesListModel.getLibraries());
        ArrayList<Library> arrayList = new ArrayList<Library>(list2);
        arrayList.removeAll(list);
        int[] nArray = new int[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            nArray[n] = list2.indexOf(library);
            ++n;
        }
        this.jList1.setSelectedIndices(nArray);
    }

    private final class LibraryRenderer
    extends DefaultListCellRenderer {
        private static final String LIBRARY_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/libraries.gif";
        private Icon cachedIcon;

        private LibraryRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            Object var7_7 = null;
            Object var8_8 = null;
            if (object instanceof Library) {
                Library library = (Library)object;
                string = library.getDisplayName();
            }
            super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            this.setIcon(this.createIcon());
            return this;
        }

        private synchronized Icon createIcon() {
            if (this.cachedIcon == null) {
                Image image = Utilities.loadImage((String)LIBRARY_ICON);
                this.cachedIcon = new ImageIcon(image);
            }
            return this.cachedIcon;
        }
    }

    private static final class LibrariesListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private Library[] cache;

        public LibrariesListModel() {
            LibraryManager libraryManager = LibraryManager.getDefault();
            libraryManager.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = LibrariesChooser.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener), (EventListener)this, (Object)libraryManager));
        }

        public synchronized int getSize() {
            if (this.cache == null) {
                this.cache = this.createLibraries();
            }
            return this.cache.length;
        }

        public synchronized Object getElementAt(int n) {
            if (this.cache == null) {
                this.cache = this.createLibraries();
            }
            if (n >= 0 && n < this.cache.length) {
                return this.cache[n];
            }
            return null;
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = this.cache == null ? 0 : this.cache.length;
            this.cache = this.createLibraries();
            int n2 = this.cache.length;
            this.fireContentsChanged(this, 0, Math.min(n - 1, n2 - 1));
            if (n > n2) {
                this.fireIntervalRemoved(this, n2, n - 1);
            } else if (n < n2) {
                this.fireIntervalAdded(this, n, n2 - 1);
            }
        }

        public synchronized Library[] getLibraries() {
            if (this.cache == null) {
                this.cache = this.createLibraries();
            }
            return this.cache;
        }

        private Library[] createLibraries() {
            Library[] libraryArray = LibraryManager.getDefault().getLibraries();
            Arrays.sort(libraryArray, new Comparator(this){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ LibrariesListModel this$0;
                {
                    this.this$0 = librariesListModel;
                }

                public int compare(Object object, Object object2) {
                    if (!($assertionsDisabled || object instanceof Library && object2 instanceof Library)) {
                        throw new AssertionError();
                    }
                    String string = ((Library)object).getDisplayName();
                    String string2 = ((Library)object2).getDisplayName();
                    return string.compareToIgnoreCase(string2);
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$ui$customizer$LibrariesChooser == null ? (class$org$netbeans$modules$java$j2seproject$ui$customizer$LibrariesChooser = LibrariesChooser.class$("org.netbeans.modules.java.j2seproject.ui.customizer.LibrariesChooser")) : class$org$netbeans$modules$java$j2seproject$ui$customizer$LibrariesChooser).desiredAssertionStatus();
                }
            });
            return libraryArray;
        }
    }
}

