/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.J2SEProjectGenerator;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewJ2SEProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    static final int TYPE_APP = 0;
    static final int TYPE_LIB = 1;
    static final int TYPE_EXT = 2;
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final String MANIFEST_FILE = "manifest.mf";
    private static final long serialVersionUID = 1L;
    private int type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NewJ2SEProjectWizardIterator() {
        this(0);
    }

    public NewJ2SEProjectWizardIterator(int n) {
        this.type = n;
    }

    public static NewJ2SEProjectWizardIterator library() {
        return new NewJ2SEProjectWizardIterator(1);
    }

    public static NewJ2SEProjectWizardIterator existing() {
        return new NewJ2SEProjectWizardIterator(2);
    }

    private WizardDescriptor.Panel[] createPanels() {
        WizardDescriptor.Panel[] panelArray;
        if (this.type == 2) {
            WizardDescriptor.Panel[] panelArray2 = new WizardDescriptor.Panel[2];
            panelArray2[0] = new PanelConfigureProject(this.type);
            panelArray = panelArray2;
            panelArray2[1] = new PanelSourceFolders.Panel();
        } else {
            WizardDescriptor.Panel[] panelArray3 = new WizardDescriptor.Panel[1];
            panelArray = panelArray3;
            panelArray3[0] = new PanelConfigureProject(this.type);
        }
        return panelArray;
    }

    private String[] createSteps() {
        String[] stringArray;
        if (this.type == 2) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureProject");
            stringArray = stringArray2;
            stringArray2[1] = NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureSourceRoots");
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureProject");
        }
        return stringArray;
    }

    public Set instantiate() throws IOException {
        FileObject fileObject;
        AntProjectHelper antProjectHelper;
        HashSet<Object> hashSet = new HashSet<Object>();
        File file = (File)this.wiz.getProperty("projdir");
        if (file != null) {
            file = FileUtil.normalizeFile((File)file);
        }
        String string = (String)this.wiz.getProperty("name");
        String string2 = (String)this.wiz.getProperty("mainClass");
        if (this.type == 2) {
            antProjectHelper = (AntProjectHelper)this.wiz.getProperty("sourceRoot");
            fileObject = (File[])this.wiz.getProperty("testRoot");
            J2SEProjectGenerator.createProject(file, string, (File[])antProjectHelper, (File[])fileObject, MANIFEST_FILE);
            for (int i = 0; i < ((AntProjectHelper)antProjectHelper).length; ++i) {
                FileObject fileObject2 = FileUtil.toFileObject((File)antProjectHelper[i]);
                if (fileObject2 == null) continue;
                hashSet.add(fileObject2);
            }
        } else {
            antProjectHelper = J2SEProjectGenerator.createProject(file, string, string2, this.type == 0 ? MANIFEST_FILE : null);
            if (string2 != null && string2.length() > 0) {
                try {
                    fileObject = antProjectHelper.getProjectDirectory().getFileObject("src");
                    FileObject fileObject3 = this.getMainClassFO(fileObject, string2);
                    if (!$assertionsDisabled && fileObject3 == null) {
                        throw new AssertionError((Object)("sourcesRoot: " + fileObject + ", mainClass: " + string2));
                    }
                    hashSet.add(fileObject3);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            if (this.type == 1) {
                // empty if block
            }
        }
        antProjectHelper = FileUtil.toFileObject((File)file);
        if (this.type == 0 || this.type == 2) {
            NewJ2SEProjectWizardIterator.createManifest((FileObject)antProjectHelper, MANIFEST_FILE);
        }
        fileObject = ProjectManager.getDefault().findProject((FileObject)antProjectHelper);
        Integer n = (Integer)this.wiz.getProperty(PROP_NAME_INDEX);
        switch (this.type) {
            case 0: {
                FoldersListSettings.getDefault().setNewApplicationCount(n);
                break;
            }
            case 1: {
                FoldersListSettings.getDefault().setNewLibraryCount(n);
                break;
            }
            case 2: {
                FoldersListSettings.getDefault().setNewProjectCount(n);
            }
        }
        hashSet.add(antProjectHelper);
        File file2 = file = file != null ? file.getParentFile() : null;
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        return hashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz.putProperty("mainClass", null);
        if (this.type == 2) {
            this.wiz.putProperty("sourceRoot", null);
            this.wiz.putProperty("testRoot", null);
        }
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"LAB_IteratorName"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private FileObject getMainClassFO(FileObject fileObject, String string) {
        string = string.replace('.', '/');
        return fileObject.getFileObject(string + ".java");
    }

    static String getPackageName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((bl || !Character.isJavaIdentifierPart(c)) && (!bl || !Character.isJavaIdentifierStart(c))) continue;
            bl = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.length() == 0 ? NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.createData(MANIFEST_FILE);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                PrintWriter printWriter = new PrintWriter(outputStream);
                printWriter.println("Manifest-Version: 1.0");
                printWriter.println("X-COMMENT: Main-Class will be added automatically by build");
                printWriter.println();
                printWriter.flush();
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    static {
        $assertionsDisabled = !NewJ2SEProjectWizardIterator.class.desiredAssertionStatus();
    }
}

