/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.j2seproject.ui.wizards.FolderList;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProjectVisual;
import org.netbeans.modules.java.j2seproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private Panel firer;
    private WizardDescriptor wizardDescriptor;
    public static final String INITIAL_SOURCE_ROOT = "EXISTING_SOURCES_CURRENT_DIRECTORY";
    private JLabel jLabel3;
    private JPanel sourcePanel;
    private JPanel testsPanel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage((Class)PanelConfigureProjectVisual.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"TXT_JavaExtSourcesProjectLocation"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel);
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("files".equals(propertyChangeEvent.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        File file = (File)wizardDescriptor.getProperty("projdir");
        ((FolderList)this.sourcePanel).setProjectFolder(file);
        ((FolderList)this.testsPanel).setProjectFolder(file);
        File[] fileArray = (File[])wizardDescriptor.getProperty("sourceRoot");
        if (!$assertionsDisabled && fileArray == null) {
            throw new AssertionError((Object)"sourceRoot property must be initialized!");
        }
        ((FolderList)this.sourcePanel).setFiles(fileArray);
        File[] fileArray2 = (File[])wizardDescriptor.getProperty("testRoot");
        if (!$assertionsDisabled && fileArray2 == null) {
            throw new AssertionError((Object)"testRoot property must be initialized!");
        }
        ((FolderList)this.testsPanel).setFiles(fileArray2);
        File file2 = null;
        FileObject fileObject = Templates.getExistingSourcesFolder((WizardDescriptor)this.wizardDescriptor);
        if (fileObject != null) {
            file2 = FileUtil.toFile((FileObject)fileObject);
        }
        if (file2 != null && file2.isDirectory()) {
            ((FolderList)this.sourcePanel).setLastUsedDir(file2);
            ((FolderList)this.testsPanel).setLastUsedDir(file2);
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        File[] fileArray = ((FolderList)this.sourcePanel).getFiles();
        File[] fileArray2 = ((FolderList)this.testsPanel).getFiles();
        wizardDescriptor.putProperty("sourceRoot", (Object)fileArray);
        wizardDescriptor.putProperty("testRoot", (Object)fileArray2);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File[] fileArray;
        File[] fileArray2;
        File file = (File)wizardDescriptor.getProperty("projdir");
        String string = PanelSourceFolders.checkValidity(file, fileArray2 = ((FolderList)this.sourcePanel).getFiles(), fileArray = ((FolderList)this.testsPanel).getFiles());
        if (string == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        return false;
    }

    static String checkValidity(File file, File[] fileArray, File[] fileArray2) {
        String string;
        int n;
        String string2 = file.getAbsolutePath();
        for (n = 0; n < fileArray.length; ++n) {
            if (!fileArray[n].isDirectory() || !fileArray[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_IllegalSources"), fileArray[n].getAbsolutePath());
            }
            string = fileArray[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (n = 0; n < fileArray2.length; ++n) {
            if (!fileArray2[n].isDirectory() || !fileArray2[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_IllegalTests"), fileArray[n].getAbsolutePath());
            }
            string = fileArray2[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private void searchClassFiles(File[] fileArray) throws WizardValidationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        for (int i = 0; i < fileArray.length; ++i) {
            object4 = FileUtil.toFileObject((File)fileArray[i]);
            if (object4 == null) continue;
            object3 = object4.getData(true);
            while (!bl && object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (!$assertionsDisabled && !(object2 instanceof FileObject)) {
                    throw new AssertionError((Object)("Instance of FileObject: " + object2));
                }
                object = (FileObject)object2;
                bl = "class".equals(object.getExt()) && !object.isVirtual();
            }
        }
        if (bl) {
            JButton jButton = new JButton(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"TXT_DeleteOption"));
            object4 = new JButton(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"TXT_KeepOption"));
            object3 = new JButton(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"TXT_CancelOption"));
            ((AbstractButton)object4).setMnemonic(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_KeepOption").charAt(0));
            jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_DeleteOption"));
            ((JButton)object4).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_KeepOption"));
            ((JButton)object3).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_CancelOption"));
            object2 = new NotifyDescriptor((Object)NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{jButton, object4, object3}, (Object)jButton);
            object = DialogDisplayer.getDefault().notify(object2);
            if (jButton.equals(object)) {
                this.deleteClassFiles(fileArray);
            } else if (!object4.equals(object)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void deleteClassFiles(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            FileObject fileObject = FileUtil.toFileObject((File)fileArray[i]);
            Enumeration enumeration = fileObject.getData(true);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!$assertionsDisabled && !(e instanceof FileObject)) {
                    throw new AssertionError((Object)("Instance of FileObject: " + e));
                }
                FileObject fileObject2 = (FileObject)e;
                try {
                    if (!"class".equals(fileObject2.getExt())) continue;
                    fileObject2.delete();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.sourcePanel = new FolderList(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_SourceRoots").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_AddSourceFolder").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_RemoveSourceFolder").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"));
        this.testsPanel = new FolderList(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_TestRoots").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_AddTestFolder").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MNE_RemoveTestFolder").charAt(0), NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"AD_RemoveTestFolder"));
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"ACSD_PanelSourceFolders"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"LBL_SourceDirectoriesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)PanelSourceFolders.class).getString("ACSN_jLabel3"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)PanelSourceFolders.class).getString("ACSD_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.sourcePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.testsPanel, gridBagConstraints);
    }

    static {
        $assertionsDisabled = !PanelSourceFolders.class.desiredAssertionStatus();
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private ArrayList listeners;
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(changeListener);
        }

        public void readSettings(Object object) {
            this.settings = (WizardDescriptor)object;
            this.component.read(this.settings);
            Object object2 = this.component.getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.settings.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders == null ? (class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders = PanelSourceFolders.class$("org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders")) : class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChangeEvent() {
            Iterator iterator = null;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                iterator = ((ArrayList)this.listeners.clone()).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }
    }
}

