/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.lang.reflect.Modifier;
import java.text.Format;
import java.text.MessageFormat;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

final class EventSetInheritanceAnalyser {
    static final /* synthetic */ boolean $assertionsDisabled;

    EventSetInheritanceAnalyser() {
    }

    static ClassMember detectPropertyChangeSupport(JavaClass javaClass) throws JmiException {
        return EventSetInheritanceAnalyser.findSupport(javaClass, "java.beans.PropertyChangeSupport");
    }

    static ClassMember detectVetoableChangeSupport(JavaClass javaClass) throws JmiException {
        return EventSetInheritanceAnalyser.findSupport(javaClass, "java.beans.VetoableChangeSupport");
    }

    private static ClassMember findSupport(JavaClass javaClass, String string) throws JmiException {
        Field field;
        Object object;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String string2 = string;
        if (javaClass == null || "java.lang.Object".equals(javaClass.getName())) {
            return null;
        }
        JavaClass javaClass2 = javaClass.getSuperClass();
        if (javaClass2 == null || javaClass2 instanceof UnresolvedClass) {
            return null;
        }
        List list = JMIUtils.getMethods((ClassDefinition)javaClass2);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (Method)object2.next();
            if (Modifier.isPrivate(object.getModifiers()) || !object.getParameters().isEmpty() || !string2.equals((field = object.getType()).getName())) continue;
            return object;
        }
        object2 = JMIUtils.getFields(javaClass2);
        object = object2.iterator();
        while (object.hasNext()) {
            field = (Field)object.next();
            if (Modifier.isPrivate(field.getModifiers()) || !string2.equals(field.getType().getName())) continue;
            return field;
        }
        return EventSetInheritanceAnalyser.findSupport(javaClass2, string);
    }

    static String showInheritanceEventDialog(ClassMember classMember, String string) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String string2 = EventSetInheritanceAnalyser.getInheritanceEventSupportName(classMember, string);
        if (classMember != null) {
            Object[] objectArray = new Object[]{classMember.getDeclaringClass().getName(), string};
            String string3 = MessageFormat.format(PatternNode.getString("MSG_Inheritance_Found"), objectArray);
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string3, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                return string2;
            }
        }
        return null;
    }

    static String getInheritanceEventSupportName(ClassMember classMember, String string) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        Format format = SourceNodes.createElementFormat((String)"{n}({p})");
        String string2 = null;
        if (classMember != null) {
            string2 = classMember instanceof Method ? format.format(classMember) : classMember.getName();
        }
        return string2;
    }

    static {
        $assertionsDisabled = !EventSetInheritanceAnalyser.class.desiredAssertionStatus();
    }
}

