/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public final class EventSetPattern
extends Pattern {
    static final String[] WELL_KNOWN_LISTENERS;
    protected Method addListenerMethod = null;
    protected Method removeListenerMethod = null;
    private Type type;
    private boolean isUnicast = false;
    protected String name;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EventSetPattern(PatternAnalyser patternAnalyser, Method method, Method method2) {
        super(patternAnalyser);
        if (method == null || method2 == null) {
            throw new NullPointerException();
        }
        this.addListenerMethod = method;
        this.removeListenerMethod = method2;
        this.isUnicast = this.testUnicast();
        this.findEventSetType();
        this.name = this.findEventSetName();
    }

    private EventSetPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static EventSetPattern create(PatternAnalyser patternAnalyser, String string, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        EventSetPattern eventSetPattern = new EventSetPattern(patternAnalyser);
        eventSetPattern.type = patternAnalyser.findType(string);
        if (eventSetPattern.type == null || !(eventSetPattern.type instanceof JavaClass)) {
            return null;
        }
        eventSetPattern.name = Introspector.decapitalize(((JavaClass)eventSetPattern.type).getSimpleName());
        eventSetPattern.isUnicast = bl3;
        String string2 = null;
        if (n == 1) {
            if (bl3) {
                BeanPatternGenerator.unicastListenerField(eventSetPattern.getDeclaringClass(), eventSetPattern.type, true);
            } else {
                BeanPatternGenerator.listenersArrayListField(eventSetPattern.getDeclaringClass(), eventSetPattern.type, true);
            }
        } else if (n == 2 && !bl3) {
            string2 = BeanPatternGenerator.eventListenerListField(eventSetPattern.getDeclaringClass(), eventSetPattern.type, true).getName();
        }
        if (bl3) {
            eventSetPattern.generateAddListenerMethod(BeanPatternGenerator.ucAddBody(eventSetPattern.type, n), true);
            eventSetPattern.generateRemoveListenerMethod(BeanPatternGenerator.ucRemoveBody(eventSetPattern.type, n), true);
        } else {
            eventSetPattern.generateAddListenerMethod(BeanPatternGenerator.mcAddBody(eventSetPattern.type, n, string2), true);
            eventSetPattern.generateRemoveListenerMethod(BeanPatternGenerator.mcRemoveBody(eventSetPattern.type, n, string2), true);
        }
        if (bl) {
            JavaClass javaClass = (JavaClass)eventSetPattern.type;
            List list = JMIUtils.getMethods((ClassDefinition)javaClass);
            boolean bl4 = javaClass.isInterface();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                if ((method.getModifiers() & 1) == 0 && (!bl4 || (method.getModifiers() & 6) != 0)) continue;
                if (bl3) {
                    BeanPatternGenerator.unicastFireMethod(eventSetPattern.getDeclaringClass(), eventSetPattern.type, method, n, bl2);
                    continue;
                }
                BeanPatternGenerator.fireMethod(eventSetPattern.getDeclaringClass(), eventSetPattern.type, method, n, string2, bl2);
            }
        }
        return eventSetPattern;
    }

    private Field getEstimatedListenerField() {
        Field field;
        if (this.isUnicast) {
            field = BeanPatternGenerator.unicastListenerField(this.getDeclaringClass(), this.getType(), false);
        } else {
            field = BeanPatternGenerator.listenersArrayListField(this.getDeclaringClass(), this.getType(), false);
            if (field == null) {
                field = BeanPatternGenerator.eventListenerListField(this.getDeclaringClass(), this.getType(), false);
            }
        }
        return field;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) throws IllegalArgumentException, JmiException {
        if (!Utilities.isJavaIdentifier((String)string) || string.indexOf("Listener") <= 0) {
            throw new IllegalArgumentException("Invalid event source name");
        }
        string = EventSetPattern.capitalizeFirstLetter(string);
        String string2 = "add" + string;
        String string3 = "remove" + string;
        JMIUtils.beginTrans(true);
        boolean bl = true;
        try {
            if (this.addListenerMethod.isValid() && this.removeListenerMethod.isValid()) {
                this.addListenerMethod.setName(string2);
                this.removeListenerMethod.setName(string3);
                this.name = Introspector.decapitalize(string);
            }
            bl = false;
        }
        finally {
            JMIUtils.endTrans(bl);
        }
    }

    protected static boolean isValidName(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            return false;
        }
        return string.indexOf("Listener") > 0;
    }

    public boolean isUnicast() {
        return this.isUnicast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsUnicast(boolean bl) throws JmiException {
        if (bl == this.isUnicast) {
            return;
        }
        JMIUtils.beginTrans(true);
        boolean bl2 = true;
        try {
            if (!this.addListenerMethod.isValid()) {
                return;
            }
            List list = this.addListenerMethod.getExceptionNames();
            if (bl) {
                JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent((Element)this.addListenerMethod);
                MultipartId multipartId = javaModelPackage.getMultipartId().createMultipartId("java.util.TooManyListenersException", null, null);
                list.add(multipartId);
            } else {
                JavaClass javaClass = this.patternAnalyser.findClassElement("java.util.TooManyListenersException");
                if (!$assertionsDisabled && javaClass == null) {
                    throw new AssertionError();
                }
                LinkedList<MultipartId> linkedList = new LinkedList<MultipartId>();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    MultipartId multipartId = (MultipartId)iterator.next();
                    JavaClass javaClass2 = (JavaClass)multipartId.getElement();
                    if (!javaClass.isSubTypeOf((ClassDefinition)javaClass2)) continue;
                    linkedList.add(multipartId);
                }
                list.removeAll(linkedList);
            }
            this.isUnicast = bl;
            bl2 = false;
        }
        finally {
            JMIUtils.endTrans(bl2);
        }
    }

    public Method getAddListenerMethod() {
        return this.addListenerMethod;
    }

    public Method getRemoveListenerMethod() {
        return this.removeListenerMethod;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(Type type) throws JmiException {
        int n = 0;
        JMIUtils.beginTrans(true);
        boolean bl = true;
        try {
            if (this.type.equals(type) || !type.isValid()) {
                return;
            }
            if (!(type instanceof JavaClass) || !PatternAnalyser.isSubclass((ClassDefinition)((JavaClass)type), (ClassDefinition)this.patternAnalyser.findClassElement("java.util.EventListener"))) {
                n = 1;
            } else {
                JavaModelPackage javaModelPackage = (JavaModelPackage)this.addListenerMethod.refImmediatePackage();
                String string = ((JavaClass)type).getSimpleName();
                List list = this.addListenerMethod.getParameters();
                list.clear();
                Parameter parameter = javaModelPackage.getParameter().createParameter();
                parameter.setName("listener");
                parameter.setType(type);
                list.add(parameter);
                list = this.removeListenerMethod.getParameters();
                list.clear();
                parameter = javaModelPackage.getParameter().createParameter();
                parameter.setName("listener");
                parameter.setType(type);
                list.add(parameter);
                String string2 = MessageFormat.format(PatternNode.getString("FMT_ChangeEventSourceName"), EventSetPattern.capitalizeFirstLetter(string));
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) {
                    this.setName(string);
                }
                this.type = type;
            }
            bl = false;
        }
        finally {
            JMIUtils.endTrans(bl);
        }
        switch (n) {
            case 1: {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_InvalidListenerInterface"), 0));
            }
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        return super.getCookie(clazz);
    }

    public void destroy() throws JmiException {
        List list;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (this.addListenerMethod != null && this.addListenerMethod.isValid()) {
            this.addListenerMethod.refDelete();
        }
        if (this.removeListenerMethod != null && this.removeListenerMethod.isValid()) {
            this.removeListenerMethod.refDelete();
        }
        JavaClass javaClass = this.getDeclaringClass();
        JavaClass javaClass2 = (JavaClass)this.type;
        boolean bl = false;
        if (javaClass2 != null) {
            list = JMIUtils.getMethods((ClassDefinition)javaClass2);
            List list2 = JMIUtils.getMethods((ClassDefinition)javaClass);
            String string = javaClass2.getSimpleName();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                String string2 = "fire" + Pattern.capitalizeFirstLetter(string) + Pattern.capitalizeFirstLetter(method.getName());
                if (!Modifier.isPublic(method.getModifiers())) continue;
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Method method2 = (Method)iterator2.next();
                    if (!method2.isValid() || !method2.getName().equals(string2)) continue;
                    if (!bl) {
                        String string3 = MessageFormat.format(PatternNode.getString("FMT_DeleteFire"), new Object[0]);
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string3, 0);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.NO_OPTION)) {
                            return;
                        }
                        bl = true;
                    }
                    method2.refDelete();
                }
            }
        }
        if ((list = this.getEstimatedListenerField()) != null && list.isValid() && list.getReferences().isEmpty()) {
            list.refDelete();
        }
    }

    EventSetPattern(EventSetPattern eventSetPattern, EventSetPattern eventSetPattern2) {
        super(eventSetPattern2.patternAnalyser);
        this.addListenerMethod = eventSetPattern2.addListenerMethod;
        this.removeListenerMethod = eventSetPattern2.removeListenerMethod;
        this.isUnicast = eventSetPattern2.isUnicast;
        this.type = eventSetPattern2.type;
        this.name = eventSetPattern2.name;
    }

    private void findEventSetType() {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        this.type = ((Parameter)this.addListenerMethod.getParameters().get(0)).getType();
    }

    private String findEventSetName() {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String string = this.addListenerMethod.getName().substring(3);
        this.name = Introspector.decapitalize(string);
        return this.name;
    }

    private boolean testUnicast() {
        return this.findTooManyListenersException() != null;
    }

    JavaClass findTooManyListenersException() {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent((Element)this.addListenerMethod);
        Type type = javaModelPackage.getType().resolve("java.util.TooManyListenersException");
        if (type instanceof UnresolvedClass || !(type instanceof JavaClass)) {
            return null;
        }
        JavaClass javaClass = (JavaClass)type;
        List list = this.addListenerMethod.getExceptions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            if (!javaClass2.isSubTypeOf((ClassDefinition)javaClass)) continue;
            return javaClass2;
        }
        return null;
    }

    void generateAddListenerMethod(String string, boolean bl) throws JmiException {
        Object object;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass javaClass = this.getDeclaringClass();
        if (javaClass == null) {
            throw new IllegalStateException("Missing declaring class");
        }
        JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent((Element)javaClass);
        Method method = javaModelPackage.getMethod().createMethod();
        int n = 33;
        Parameter parameter = javaModelPackage.getParameter().createParameter();
        parameter.setName("listener");
        parameter.setType(this.type);
        method.setName("add" + EventSetPattern.capitalizeFirstLetter(this.getName()));
        method.setTypeName((TypeReference)javaModelPackage.getMultipartId().createMultipartId("void", null, null));
        List list = method.getParameters();
        list.add(parameter);
        if (javaClass.isInterface()) {
            n &= 0xFFFFFFDF;
        } else if (string != null) {
            method.setBodyText(string);
        }
        method.setModifiers(n);
        if (this.isUnicast) {
            object = javaModelPackage.getMultipartId().createMultipartId("java.util.TooManyListenersException", null, null);
            method.getExceptionNames().add(object);
        }
        if (bl) {
            object = MessageFormat.format(PatternNode.getString("COMMENT_AddListenerMethod"), ((JavaClass)this.type).getSimpleName());
            method.setJavadocText((String)object);
        }
        javaClass.getContents().add(method);
        this.addListenerMethod = method;
    }

    void generateRemoveListenerMethod(String string, boolean bl) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass javaClass = this.getDeclaringClass();
        if (javaClass == null) {
            throw new IllegalStateException("Missing declaring class");
        }
        JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent((Element)javaClass);
        Method method = javaModelPackage.getMethod().createMethod();
        int n = 33;
        Parameter parameter = javaModelPackage.getParameter().createParameter();
        parameter.setName("listener");
        parameter.setType(this.type);
        method.setName("remove" + EventSetPattern.capitalizeFirstLetter(this.getName()));
        method.setTypeName((TypeReference)javaModelPackage.getMultipartId().createMultipartId("void", null, null));
        List list = method.getParameters();
        list.add(parameter);
        if (javaClass.isInterface()) {
            n &= 0xFFFFFFDF;
        } else if (string != null) {
            method.setBodyText(string);
        }
        method.setModifiers(n);
        if (bl) {
            String string2 = MessageFormat.format(PatternNode.getString("COMMENT_RemoveListenerMethod"), ((JavaClass)this.type).getSimpleName());
            method.setJavadocText(string2);
        }
        javaClass.getContents().add(method);
        this.removeListenerMethod = method;
    }

    void copyProperties(EventSetPattern eventSetPattern) throws JmiException {
        boolean bl;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        boolean bl2 = bl = !eventSetPattern.getType().equals(this.getType()) || !eventSetPattern.getName().equals(this.getName()) || eventSetPattern.isUnicast() != this.isUnicast();
        if (eventSetPattern.getAddListenerMethod() != this.addListenerMethod) {
            this.addListenerMethod = eventSetPattern.getAddListenerMethod();
        }
        if (eventSetPattern.getRemoveListenerMethod() != this.removeListenerMethod) {
            this.removeListenerMethod = eventSetPattern.getRemoveListenerMethod();
        }
        if (bl) {
            this.isUnicast = this.testUnicast();
            this.findEventSetType();
            this.isUnicast = this.testUnicast();
            this.name = this.findEventSetName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }

    static {
        $assertionsDisabled = !EventSetPattern.class.desiredAssertionStatus();
        WELL_KNOWN_LISTENERS = new String[]{"java.awt.event.ActionListener", "java.awt.event.ContainerListener", "java.awt.event.FocusListener", "java.awt.event.ItemListener", "java.awt.event.KeyListener", "java.awt.event.MouseListener", "java.awt.event.MouseMotionListener", "java.awt.event.WindowListener", "java.beans.PropertyChangeListener", "java.beans.VetoableChangeListener", "javax.swing.event.CaretListener", "javax.swing.event.ChangeListener", "javax.swing.event.DocumentListener", "javax.swing.event.HyperlinkListener", "javax.swing.event.MenuListener", "javax.swing.event.MouseInputListener", "javax.swing.event.PopupMenuListener", "javax.swing.event.TableColumnModelListener", "javax.swing.event.TableModelListener", "javax.swing.event.TreeModelListener", "javax.swing.event.UndoableEditListener"};
    }
}

