/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.EventTypeEditor;
import org.netbeans.modules.beans.IconBases;
import org.netbeans.modules.beans.PatternNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

public final class EventSetPatternNode
extends PatternNode
implements IconBases {
    public EventSetPatternNode(EventSetPattern eventSetPattern, boolean bl) {
        super(eventSetPattern, Children.LEAF, bl);
        this.superSetName(eventSetPattern.getName());
    }

    protected void setPatternName(String string) throws JmiException {
        if (this.pattern.getName().equals(string)) {
            return;
        }
        if (this.testNameValidity(string)) {
            ((EventSetPattern)this.pattern).setName(string);
        }
    }

    boolean testNameValidity(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)EventSetPatternNode.getString("MSG_Not_Valid_Identifier"), 0));
            return false;
        }
        if (string.indexOf("Listener") <= 0) {
            String string2 = MessageFormat.format(EventSetPatternNode.getString("FMT_InvalidEventSourceName"), string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            return false;
        }
        return true;
    }

    protected String resolveIconBase() {
        if (((EventSetPattern)this.pattern).isUnicast()) {
            return "org/netbeans/modules/beans/resources/eventSetUnicast";
        }
        return "org/netbeans/modules/beans/resources/eventSetMulticast";
    }

    public String getShortDescription() {
        return (((EventSetPattern)this.pattern).isUnicast() ? PatternNode.getString("HINT_UnicastEventSet") : PatternNode.getString("HINT_MulticastEventSet")) + " : " + this.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createNameProperty(this.writeable));
        set.put(this.createTypeProperty(this.writeable));
        set.put(this.createIsUnicastProperty(this.writeable));
        set.put(this.createAddListenerProperty(false));
        set.put(this.createRemoveListenerProperty(false));
        return sheet;
    }

    public Node cloneNode() {
        return new EventSetPatternNode((EventSetPattern)this.pattern, this.writeable);
    }

    protected Node.Property createTypeProperty(boolean bl) {
        return new PatternNode.PatternPropertySupport("type", Type.class, bl){

            public Object getValue() {
                return ((EventSetPattern)EventSetPatternNode.this.pattern).getType();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                try {
                    EventSetPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                    ((EventSetPattern)EventSetPatternNode.this.pattern).setType((Type)object);
                }
                catch (JmiException jmiException) {
                    throw new InvocationTargetException(jmiException);
                }
                finally {
                    EventSetPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new EventTypeEditor();
            }
        };
    }

    protected Node.Property createIsUnicastProperty(boolean bl) {
        return new PatternNode.PatternPropertySupport("isUnicast", Boolean.TYPE, bl){

            public Object getValue() {
                return ((EventSetPattern)EventSetPatternNode.this.pattern).isUnicast() ? Boolean.TRUE : Boolean.FALSE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Boolean)) {
                    throw new IllegalArgumentException();
                }
                try {
                    try {
                        EventSetPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                        ((EventSetPattern)EventSetPatternNode.this.pattern).setIsUnicast((Boolean)object);
                        EventSetPatternNode.this.setIconBase(EventSetPatternNode.this.resolveIconBase());
                    }
                    finally {
                        EventSetPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                    }
                }
                catch (JmiException jmiException) {
                    throw new InvocationTargetException(jmiException);
                }
            }
        };
    }

    protected Node.Property createAddListenerProperty(boolean bl) {
        return new PatternNode.PatternPropertySupport("addListener", String.class, bl){

            public Object getValue() {
                Method method = ((EventSetPattern)EventSetPatternNode.this.pattern).getAddListenerMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }

    protected Node.Property createRemoveListenerProperty(boolean bl) {
        return new PatternNode.PatternPropertySupport("removeListener", String.class, bl){

            public Object getValue() {
                Method method = ((EventSetPattern)EventSetPatternNode.this.pattern).getRemoveListenerMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }
}

