/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.beans.PatternAnalyser;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public abstract class Pattern {
    PatternAnalyser patternAnalyser;
    private DataObject src;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Pattern(PatternAnalyser patternAnalyser) {
        this.patternAnalyser = patternAnalyser;
        try {
            this.src = DataObject.find((FileObject)patternAnalyser.findFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(4096, (Throwable)dataObjectNotFoundException);
        }
    }

    public abstract String getName();

    public abstract void setName(String var1);

    public JavaClass getDeclaringClass() {
        return this.patternAnalyser.getClassElement();
    }

    Node.Cookie getCookie(Class clazz) {
        if (this.src != null && clazz.isAssignableFrom(this.src.getClass())) {
            return this.src;
        }
        return null;
    }

    public void destroy() throws JmiException {
    }

    static String capitalizeFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
    }
}

