/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public final class PatternAnalyser
implements Node.Cookie {
    private static final int PROPERTIES_RESERVE = 11;
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String ADD_PREFIX = "add";
    private static final String REMOVE_PREFIX = "remove";
    private ArrayList currentPropertyPatterns = new ArrayList();
    private ArrayList currentIdxPropertyPatterns = new ArrayList();
    private ArrayList currentEventSetPatterns = new ArrayList();
    private HashMap propertyPatterns;
    private HashMap idxPropertyPatterns;
    private HashMap eventSetPatterns;
    private JavaClass classElement;
    private JavaClass referenceClassElement;
    private boolean analyzed = false;
    private boolean ignore;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PatternAnalyser(JavaClass javaClass) {
        this.classElement = javaClass;
    }

    public PatternAnalyser(JavaClass javaClass, JavaClass javaClass2) {
        this(javaClass);
        this.referenceClassElement = javaClass2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void analyzeAll() {
        if (this.ignore) {
            return;
        }
        this.analyzed = true;
        this.propertyPatterns = new HashMap(11);
        this.idxPropertyPatterns = new HashMap();
        this.eventSetPatterns = new HashMap();
        try {
            JMIUtils.beginTrans(false);
            try {
                if (!this.classElement.isValid()) {
                    return;
                }
                this.resolveMethods();
                this.resolveFields();
                this.resolveChangesOfProperties();
                this.resolveChangesOfIdxProperties();
                this.resolveChangesOfEventSets();
            }
            finally {
                JMIUtils.endTrans();
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify(4096, (Throwable)jmiException);
        }
    }

    boolean isAnalyzed() {
        return this.analyzed;
    }

    void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    public Collection getPropertyPatterns() {
        return this.currentPropertyPatterns;
    }

    public Collection getIdxPropertyPatterns() {
        return this.currentIdxPropertyPatterns;
    }

    public Collection getEventSetPatterns() {
        return this.currentEventSetPatterns;
    }

    public JavaClass getClassElement() {
        return this.classElement;
    }

    private void resolveMethods() throws JmiException {
        Object object;
        String string;
        Object object2;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        List list = JMIUtils.getMethods((ClassDefinition)this.classElement);
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (Method)iterator.next();
            string = object2.getName();
            int n = string.length();
            if ((string.startsWith(GET_PREFIX) && n > GET_PREFIX.length() || string.startsWith(SET_PREFIX) && n > SET_PREFIX.length() || string.startsWith(IS_PREFIX) && n > IS_PREFIX.length()) && (object = this.analyseMethodForProperties((Method)object2)) != null) {
                this.addProperty((PropertyPattern)object);
            }
            if ((!string.startsWith(ADD_PREFIX) || n <= ADD_PREFIX.length()) && (!string.startsWith(REMOVE_PREFIX) || n <= REMOVE_PREFIX.length())) continue;
            this.analyseMethodForEventSets((Method)object2, hashMap, hashMap2);
        }
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (hashMap2.get(object2) == null || ((String)object2).indexOf("Listener:") <= 0) continue;
            string = (Method)hashMap.get(object2);
            Method method = (Method)hashMap2.get(object2);
            object = string.getParameters();
            Type type = ((Parameter)object.get(0)).getType();
            if (!(type instanceof ClassDefinition) || !PatternAnalyser.isSubclass((ClassDefinition)type, (ClassDefinition)this.findClassElement("java.util.EventListener"))) continue;
            EventSetPattern eventSetPattern = new EventSetPattern(this, (Method)string, method);
            this.addEventSet(eventSetPattern);
        }
    }

    private void resolveFields() throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        List list = JMIUtils.getFields(this.classElement);
        String string = PropertyActionSettings.getDefault().getPropStyle();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Type type;
            PropertyPattern propertyPattern;
            Field field = (Field)iterator.next();
            if ((field.getModifiers() & 8) != 0) continue;
            String string2 = field.getName();
            if (string2.startsWith(string)) {
                string2 = string2.substring(1);
            }
            if ((propertyPattern = (PropertyPattern)this.propertyPatterns.get(string2)) == null) {
                propertyPattern = (PropertyPattern)this.idxPropertyPatterns.get(string2);
            }
            if (propertyPattern == null || (type = propertyPattern.getType()) == null || !type.equals(field.getType())) continue;
            propertyPattern.setEstimatedField(field);
        }
    }

    private void resolveChangesOfProperties() {
        this.currentPropertyPatterns = PatternAnalyser.resolveChanges(this.currentPropertyPatterns, this.propertyPatterns, LevelComparator.PROPERTY);
    }

    private void resolveChangesOfIdxProperties() {
        this.currentIdxPropertyPatterns = PatternAnalyser.resolveChanges(this.currentIdxPropertyPatterns, this.idxPropertyPatterns, LevelComparator.IDX_PROPERTY);
    }

    private void resolveChangesOfEventSets() {
        this.currentEventSetPatterns = PatternAnalyser.resolveChanges(this.currentEventSetPatterns, this.eventSetPatterns, LevelComparator.EVENT_SET);
    }

    static ArrayList resolveChanges(Collection collection, Map map, LevelComparator levelComparator) throws JmiException {
        JMIUtils.isInsideTrans();
        ArrayList arrayList = new ArrayList(collection);
        ArrayList arrayList2 = new ArrayList(map.size());
        arrayList2.addAll(map.values());
        ArrayList<Pattern> arrayList3 = new ArrayList<Pattern>(map.size() + 5);
        for (int i = 0; i <= levelComparator.getLevels(); ++i) {
            Iterator iterator = arrayList2.iterator();
            block1: while (iterator.hasNext()) {
                Pattern pattern = (Pattern)iterator.next();
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    Pattern pattern2 = (Pattern)iterator2.next();
                    if (!levelComparator.compare(i, pattern2, pattern)) continue;
                    iterator2.remove();
                    iterator.remove();
                    levelComparator.copyProperties(pattern2, pattern);
                    arrayList3.add(pattern2);
                    continue block1;
                }
            }
        }
        arrayList3.addAll(arrayList2);
        return arrayList3;
    }

    PropertyPattern analyseMethodForProperties(Method method) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        int n = method.getModifiers();
        if (Modifier.isStatic(n)) {
            return null;
        }
        String string = method.getName();
        Parameter[] parameterArray = method.getParameters().toArray(new Parameter[0]);
        Type type = method.getType();
        PropertyPattern propertyPattern = null;
        try {
            if (parameterArray.length == 0) {
                if (string.startsWith(GET_PREFIX)) {
                    propertyPattern = new PropertyPattern(this, method, null);
                } else if (JMIUtils.isPrimitiveType(type, PrimitiveTypeKindEnum.BOOLEAN) && string.startsWith(IS_PREFIX)) {
                    propertyPattern = new PropertyPattern(this, method, null);
                }
            } else if (parameterArray.length == 1) {
                if (JMIUtils.isPrimitiveType(parameterArray[0].getType(), PrimitiveTypeKindEnum.INT) && string.startsWith(GET_PREFIX)) {
                    propertyPattern = new IdxPropertyPattern(this, null, null, method, null);
                } else if (JMIUtils.isPrimitiveType(type, PrimitiveTypeKindEnum.VOID) && string.startsWith(SET_PREFIX)) {
                    propertyPattern = new PropertyPattern(this, null, method);
                }
            } else if (parameterArray.length == 2 && JMIUtils.isPrimitiveType(parameterArray[0].getType(), PrimitiveTypeKindEnum.INT) && string.startsWith(SET_PREFIX)) {
                propertyPattern = new IdxPropertyPattern(this, null, null, null, method);
            }
        }
        catch (IntrospectionException introspectionException) {
            ErrorManager.getDefault().notify(1, (Throwable)introspectionException);
            propertyPattern = null;
        }
        return propertyPattern;
    }

    void analyseMethodForEventSets(Method method, Map map, Map map2) throws JmiException {
        Type type;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        int n = method.getModifiers();
        if (Modifier.isStatic(n)) {
            return;
        }
        String string = method.getName();
        Parameter[] parameterArray = method.getParameters().toArray(new Parameter[0]);
        Type type2 = method.getType();
        if (parameterArray.length == 1 && JMIUtils.isPrimitiveType(type2, PrimitiveTypeKindEnum.VOID) && (type = parameterArray[0].getType()) instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)type;
            if (string.startsWith(ADD_PREFIX) && string.substring(3).equals(javaClass.getSimpleName())) {
                String string2 = string.substring(3) + ":" + javaClass.getName();
                map.put(string2, method);
            } else if (string.startsWith(REMOVE_PREFIX) && string.substring(6).equals(javaClass.getSimpleName())) {
                String string3 = string.substring(6) + ":" + javaClass.getName();
                map2.put(string3, method);
            }
        }
    }

    private void addProperty(PropertyPattern propertyPattern) {
        boolean bl = propertyPattern instanceof IdxPropertyPattern;
        HashMap hashMap = bl ? this.idxPropertyPatterns : this.propertyPatterns;
        String string = propertyPattern.getName();
        PropertyPattern propertyPattern2 = (PropertyPattern)this.propertyPatterns.get(string);
        if (propertyPattern2 == null) {
            propertyPattern2 = (PropertyPattern)this.idxPropertyPatterns.get(string);
        }
        if (propertyPattern2 == null) {
            hashMap.put(string, propertyPattern);
            return;
        }
        Type type = propertyPattern2.getType();
        Type type2 = propertyPattern.getType();
        if (type != null && type2 != null && !type.equals(type2)) {
            hashMap.put(string, propertyPattern);
            return;
        }
        boolean bl2 = propertyPattern2 instanceof IdxPropertyPattern;
        if (bl || bl2) {
            if (bl && !bl2) {
                this.propertyPatterns.remove(propertyPattern2.getName());
            } else if (!bl && bl2) {
                this.idxPropertyPatterns.remove(propertyPattern2.getName());
            }
            IdxPropertyPattern idxPropertyPattern = new IdxPropertyPattern(propertyPattern2, propertyPattern);
            this.idxPropertyPatterns.put(string, idxPropertyPattern);
        } else {
            PropertyPattern propertyPattern3 = new PropertyPattern(propertyPattern2, propertyPattern);
            this.propertyPatterns.put(string, propertyPattern3);
        }
    }

    void addEventSet(EventSetPattern eventSetPattern) {
        String string = eventSetPattern.getName() + eventSetPattern.getType().getName();
        EventSetPattern eventSetPattern2 = (EventSetPattern)this.eventSetPatterns.get(string);
        if (eventSetPattern2 == null) {
            this.eventSetPatterns.put(string, eventSetPattern);
            return;
        }
        EventSetPattern eventSetPattern3 = new EventSetPattern(eventSetPattern2, eventSetPattern);
        this.eventSetPatterns.put(string, eventSetPattern3);
    }

    static boolean isSubclass(ClassDefinition classDefinition, ClassDefinition classDefinition2) {
        if (classDefinition == null || classDefinition2 == null) {
            return false;
        }
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        return classDefinition.isSubTypeOf(classDefinition2);
    }

    public static FileObject fileObjectForElement(Element element) {
        return JavaMetamodel.getManager().getFileObject(element.getResource());
    }

    public static JavaClass findClassElement(String string, Pattern pattern) {
        return pattern.patternAnalyser.findClassElement(string);
    }

    public FileObject findFileObject() {
        return PatternAnalyser.fileObjectForElement((Element)(this.referenceClassElement != null ? this.referenceClassElement : this.classElement));
    }

    JavaClass findClassElement(String string) {
        Type type = this.findType(string);
        if (type instanceof JavaClass) {
            return (JavaClass)type;
        }
        return null;
    }

    Type findType(String string) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass javaClass = this.referenceClassElement != null ? this.referenceClassElement : this.classElement;
        Type type = null;
        if (javaClass.isValid()) {
            type = JavaMetamodel.getManager().getJavaExtent((Element)javaClass).getType().resolve(string);
        }
        return type;
    }

    static {
        $assertionsDisabled = !PatternAnalyser.class.desiredAssertionStatus();
    }

    static abstract class LevelComparator {
        static LevelComparator PROPERTY = new Property();
        static LevelComparator IDX_PROPERTY = new IdxProperty();
        static LevelComparator EVENT_SET = new EventSet();

        LevelComparator() {
        }

        abstract boolean compare(int var1, Pattern var2, Pattern var3);

        abstract int getLevels();

        abstract void copyProperties(Pattern var1, Pattern var2);

        static class EventSet
        extends LevelComparator {
            EventSet() {
            }

            boolean compare(int n, Pattern pattern, Pattern pattern2) {
                switch (n) {
                    case 0: {
                        return ((EventSetPattern)pattern).getAddListenerMethod() == ((EventSetPattern)pattern2).getAddListenerMethod() || ((EventSetPattern)pattern).getRemoveListenerMethod() == ((EventSetPattern)pattern2).getRemoveListenerMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 0;
            }

            void copyProperties(Pattern pattern, Pattern pattern2) {
                ((EventSetPattern)pattern).copyProperties((EventSetPattern)pattern2);
            }
        }

        static class IdxProperty
        extends LevelComparator {
            IdxProperty() {
            }

            boolean compare(int n, Pattern pattern, Pattern pattern2) {
                switch (n) {
                    case 0: {
                        return ((IdxPropertyPattern)pattern).getIndexedGetterMethod() == ((IdxPropertyPattern)pattern2).getIndexedGetterMethod() && ((IdxPropertyPattern)pattern).getIndexedSetterMethod() == ((IdxPropertyPattern)pattern2).getIndexedSetterMethod();
                    }
                    case 1: {
                        return ((IdxPropertyPattern)pattern).getIndexedGetterMethod() == ((IdxPropertyPattern)pattern2).getIndexedGetterMethod();
                    }
                    case 2: {
                        return ((IdxPropertyPattern)pattern).getIndexedSetterMethod() == ((IdxPropertyPattern)pattern2).getIndexedSetterMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 2;
            }

            void copyProperties(Pattern pattern, Pattern pattern2) {
                ((IdxPropertyPattern)pattern).copyProperties((IdxPropertyPattern)pattern2);
            }
        }

        static class Property
        extends LevelComparator {
            Property() {
            }

            boolean compare(int n, Pattern pattern, Pattern pattern2) {
                switch (n) {
                    case 0: {
                        return ((PropertyPattern)pattern).getGetterMethod() == ((PropertyPattern)pattern2).getGetterMethod() && ((PropertyPattern)pattern).getSetterMethod() == ((PropertyPattern)pattern2).getSetterMethod();
                    }
                    case 1: {
                        return ((PropertyPattern)pattern).getGetterMethod() == ((PropertyPattern)pattern2).getGetterMethod();
                    }
                    case 2: {
                        return ((PropertyPattern)pattern).getSetterMethod() == ((PropertyPattern)pattern2).getSetterMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 2;
            }

            void copyProperties(Pattern pattern, Pattern pattern2) {
                ((PropertyPattern)pattern).copyProperties((PropertyPattern)pattern2);
            }
        }
    }
}

