/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.EventSetPatternNode;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.IdxPropertyPatternNode;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.PropertyPatternNode;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class PatternChildren
extends Children.Keys {
    static final RequestProcessor ANALYZER = new RequestProcessor("Bean patterns analyser", 1);
    private boolean wri = true;
    private Listener elementListener = new Listener(this);
    private RequestProcessor.Task refreshTask;
    private PatternAnalyser patternAnalyser;
    private final JavaClass classElement;
    static /* synthetic */ Class class$org$netbeans$modules$beans$PatternChildren;

    public PatternChildren(JavaClass javaClass) {
        this(javaClass, true);
    }

    public PatternChildren(JavaClass javaClass, boolean bl) {
        this.classElement = javaClass;
        this.patternAnalyser = new PatternAnalyser(javaClass);
        PropertyActionSettings.getDefault().addPropertyChangeListener(this.elementListener);
        this.wri = bl;
    }

    protected void addNotify() {
        super.addNotify();
        this.refreshAllKeys();
    }

    protected void refreshAllKeys() {
        this.scheduleRefresh();
    }

    private synchronized void scheduleRefresh() {
        if (this.refreshTask == null) {
            this.refreshTask = ANALYZER.create((Runnable)this.elementListener);
        }
        this.refreshTask.schedule(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshKeys(int n) {
        JMIUtils.beginTrans(false);
        try {
            try {
                this.elementListener.unregisterAll();
                this.elementListener.reassignMethodListener(this.classElement);
                this.elementListener.reassignFieldListener(this.classElement);
                this.elementListener.assignFeaturesListener(this.classElement);
                this.patternAnalyser.analyzeAll();
            }
            finally {
                JMIUtils.endTrans();
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify(4096, (Throwable)jmiException);
        }
        this.setKeys(this.collectAllKeys());
    }

    private Collection collectAllKeys() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.getKeysOfType(256));
        linkedList.addAll(this.getKeysOfType(512));
        linkedList.addAll(this.getKeysOfType(1024));
        return linkedList;
    }

    PatternAnalyser getPatternAnalyser() {
        return this.patternAnalyser;
    }

    public void removeAll() {
        this.elementListener.unregisterAll();
        this.setKeys(Collections.EMPTY_LIST);
    }

    protected Node[] createNodes(Object object) {
        return new Node[]{this.createPatternNode(object)};
    }

    private Node createPatternNode(Object object) {
        if (object instanceof IdxPropertyPattern) {
            return new IdxPropertyPatternNode((IdxPropertyPattern)object, this.wri);
        }
        if (object instanceof PropertyPattern) {
            return new PropertyPatternNode((PropertyPattern)object, this.wri);
        }
        if (object instanceof EventSetPattern) {
            return new EventSetPatternNode((EventSetPattern)object, this.wri);
        }
        ErrorManager.getDefault().notify(16, (Throwable)new IllegalStateException("Unknown key: " + object));
        return null;
    }

    protected Collection getKeysOfType(int n) {
        ArrayList arrayList = null;
        if ((n & 0x100) != 0) {
            arrayList = new ArrayList(this.patternAnalyser.getPropertyPatterns());
            Collections.sort(arrayList, new PatternComparator());
        }
        if ((n & 0x200) != 0) {
            arrayList = new ArrayList(this.patternAnalyser.getIdxPropertyPatterns());
            Collections.sort(arrayList, new PatternComparator());
        }
        if ((n & 0x400) != 0) {
            arrayList = new ArrayList(this.patternAnalyser.getEventSetPatterns());
            Collections.sort(arrayList, new PatternComparator());
        }
        return arrayList;
    }

    private static final class PatternComparator
    implements Comparator {
        private PatternComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Pattern)object).getName().compareTo(((Pattern)object2).getName());
        }

        public boolean equals(Object object) {
            return object instanceof PatternComparator;
        }
    }

    static final class Listener
    extends WeakReference
    implements MDRChangeListener,
    PropertyChangeListener,
    Runnable {
        List knownFields;
        List knownMethods;
        JavaClass classElement;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Listener(PatternChildren patternChildren) {
            super(patternChildren, Utilities.activeReferenceQueue());
        }

        private PatternChildren getChildren() {
            PatternChildren patternChildren = (PatternChildren)((Object)this.get());
            if (patternChildren != null) {
                return patternChildren;
            }
            this.unregisterAll();
            PropertyActionSettings.getDefault().removePropertyChangeListener(this);
            return null;
        }

        private void reassignMethodListener(JavaClass javaClass) throws JmiException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            List list = JMIUtils.getMethods((ClassDefinition)javaClass);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MDRChangeSource mDRChangeSource = (MDRChangeSource)iterator.next();
                mDRChangeSource.addListener((MDRChangeListener)this);
            }
            this.knownMethods = list;
        }

        private void reassignFieldListener(JavaClass javaClass) throws JmiException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            List list = JMIUtils.getFields(javaClass);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MDRChangeSource mDRChangeSource = (MDRChangeSource)iterator.next();
                mDRChangeSource.addListener((MDRChangeListener)this);
            }
            this.knownFields = list;
        }

        private void assignFeaturesListener(JavaClass javaClass) throws JmiException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            ((MDRChangeSource)javaClass).addListener((MDRChangeListener)this);
            this.classElement = javaClass;
        }

        synchronized void unregisterAll() {
            MDRChangeSource mDRChangeSource;
            Object object;
            List list = this.knownFields;
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    mDRChangeSource = (MDRChangeSource)object.next();
                    mDRChangeSource.removeListener((MDRChangeListener)this);
                    this.knownFields = null;
                }
            }
            if ((object = this.knownMethods) != null) {
                mDRChangeSource = object.iterator();
                while (mDRChangeSource.hasNext()) {
                    MDRChangeSource mDRChangeSource2 = (MDRChangeSource)mDRChangeSource.next();
                    mDRChangeSource2.removeListener((MDRChangeListener)this);
                    this.knownMethods = null;
                }
            }
            if (this.classElement != null) {
                ((MDRChangeSource)this.classElement).removeListener((MDRChangeListener)this);
                this.classElement = null;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (PropertyActionSettings.getDefault() == object && !"prop_style".equals(string)) {
                return;
            }
            PatternChildren patternChildren = this.getChildren();
            if (patternChildren != null) {
                patternChildren.scheduleRefresh();
            }
        }

        public void run() {
            PatternChildren patternChildren = this.getChildren();
            if (patternChildren != null) {
                patternChildren.refreshKeys(1792);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void change(MDRChangeEvent mDRChangeEvent) {
            PatternChildren patternChildren;
            boolean bl = false;
            try {
                JMIUtils.beginTrans(false);
                try {
                    bl = this.checkChangeEvent(mDRChangeEvent);
                }
                finally {
                    JMIUtils.endTrans();
                }
            }
            catch (JmiException jmiException) {
                ErrorManager.getDefault().notify(4096, (Throwable)jmiException);
            }
            if (bl && (patternChildren = this.getChildren()) != null) {
                patternChildren.refreshAllKeys();
            }
        }

        private boolean checkChangeEvent(MDRChangeEvent mDRChangeEvent) {
            Object object = mDRChangeEvent.getSource();
            if (object instanceof Element && ((Element)object).isValid() && mDRChangeEvent instanceof AttributeEvent) {
                AttributeEvent attributeEvent = (AttributeEvent)mDRChangeEvent;
                String string = attributeEvent.getAttributeName();
                if (object instanceof JavaClass ? "contents".equals(string) : "name".equals(string) || "modifiers".equals(string) || "typeName".equals(string) || "parameters".equals(string)) {
                    return true;
                }
            }
            return false;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$PatternChildren == null ? (class$org$netbeans$modules$beans$PatternChildren = PatternChildren.class$("org.netbeans.modules.beans.PatternChildren")) : class$org$netbeans$modules$beans$PatternChildren).desiredAssertionStatus();
        }
    }
}

