/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import javax.jmi.reflect.JmiException;
import javax.swing.Action;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.beans.IconBases;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternProperties;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.openide.ErrorManager;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public abstract class PatternNode
extends AbstractNode
implements IconBases,
PatternProperties,
PropertyChangeListener {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[]{"mode"};
    private static final SystemAction[] DEFAULT_ACTIONS = new SystemAction[]{SystemAction.get((Class)DeleteAction.class), SystemAction.get((Class)RenameAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    protected Pattern pattern;
    protected boolean writeable;

    public PatternNode(Pattern pattern, Children children, boolean bl) {
        super(children);
        this.pattern = pattern;
        this.writeable = bl;
        this.setIconBase(this.resolveIconBase());
        this.setActions(DEFAULT_ACTIONS);
        this.pattern.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pattern));
        this.displayFormat = null;
    }

    public String getShortDescription() {
        return super.getShortDescription();
    }

    protected abstract String resolveIconBase();

    public Action getPreferredAction() {
        return SystemAction.get((Class)OpenAction.class);
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public boolean canRename() {
        return this.writeable;
    }

    public boolean canDestroy() {
        return this.writeable;
    }

    public Transferable clipboardCopy() throws IOException {
        return super.clipboardCopy();
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.writeable) {
            throw new IOException();
        }
        return super.clipboardCopy();
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.writeable;
    }

    public void setActions(SystemAction[] systemActionArray) {
        this.systemActions = systemActionArray;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = super.getCookie(clazz);
        if (cookie == null) {
            cookie = this.pattern.getCookie(clazz);
        }
        return cookie;
    }

    public boolean equals(Object object) {
        return object instanceof PatternNode && this.pattern.equals(((PatternNode)object).pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setName(String string) {
        try {
            JMIUtils.beginTrans(true);
            boolean bl = true;
            try {
                this.pattern.patternAnalyser.setIgnore(true);
                this.setPatternName(string);
                bl = false;
            }
            finally {
                this.pattern.patternAnalyser.setIgnore(false);
                JMIUtils.endTrans(bl);
            }
            this.superSetName(string);
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify(4096, (Throwable)jmiException);
        }
    }

    public final void superSetName(String string) {
        super.setName(string);
    }

    protected abstract void setPatternName(String var1) throws JmiException;

    protected Node.Property createNameProperty(boolean bl) {
        return new PatternPropertySupport("name", String.class, bl){

            public Object getValue() {
                return PatternNode.this.pattern.getName();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                String string = (String)object;
                try {
                    JMIUtils.beginTrans(true);
                    boolean bl = true;
                    try {
                        PatternNode.this.pattern.patternAnalyser.setIgnore(true);
                        PatternNode.this.setPatternName(string);
                        bl = false;
                    }
                    finally {
                        PatternNode.this.pattern.patternAnalyser.setIgnore(false);
                        JMIUtils.endTrans(bl);
                    }
                }
                catch (JmiException jmiException) {
                    throw new InvocationTargetException(jmiException);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException();
                }
                PatternNode.this.superSetName(string);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        try {
            JMIUtils.beginTrans(true);
            boolean bl = true;
            try {
                this.pattern.destroy();
                bl = false;
            }
            finally {
                JMIUtils.endTrans(bl);
            }
        }
        catch (JmiException jmiException) {
            IOException iOException = new IOException();
            iOException.initCause(jmiException);
            throw iOException;
        }
        super.destroy();
    }

    protected static String getFormattedMethodName(Method method) {
        String string = null;
        Format format = SourceNodes.createElementFormat((String)"{n} ({p})");
        try {
            if (method != null) {
                string = format.format(method);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify(4096, (Throwable)illegalArgumentException);
        }
        return string != null ? string : PatternNode.getString("LAB_NoMethod");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setIconBase(this.resolveIconBase());
        this.superSetName(this.pattern.getName());
        this.firePropertyChange(null, null, null);
    }

    static String getString(String string) {
        return NbBundle.getBundle((String)"org.netbeans.modules.beans.Bundle").getString(string);
    }

    static abstract class PatternPropertySupport
    extends PropertySupport {
        public PatternPropertySupport(String string, Class clazz, boolean bl) {
            super(string, clazz, PatternNode.getString("PROP_" + string), PatternNode.getString("HINT_" + string), true, bl);
        }

        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(PatternNode.getString("MSG_Cannot_Write"));
            }
        }
    }
}

