/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.IconBases;
import org.netbeans.modules.beans.ModePropertyEditor;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.PropertyTypeEditor;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

public class PropertyPatternNode
extends PatternNode
implements IconBases {
    public PropertyPatternNode(PropertyPattern propertyPattern, boolean bl) {
        super(propertyPattern, Children.LEAF, bl);
        this.superSetName(propertyPattern.getName());
    }

    protected String resolveIconBase() {
        switch (((PropertyPattern)this.pattern).getMode()) {
            case 1: {
                return "org/netbeans/modules/beans/resources/propertyRW";
            }
            case 2: {
                return "org/netbeans/modules/beans/resources/propertyRO";
            }
            case 4: {
                return "org/netbeans/modules/beans/resources/propertyWO";
            }
        }
        return null;
    }

    String getTypeForHint() {
        return PatternNode.getString("HINT_Property");
    }

    public String getShortDescription() {
        String string;
        switch (((PropertyPattern)this.pattern).getMode()) {
            case 1: {
                string = PatternNode.getString("HINT_ReadWriteProperty");
                break;
            }
            case 2: {
                string = PatternNode.getString("HINT_ReadOnlyProperty");
                break;
            }
            case 4: {
                string = PatternNode.getString("HINT_WriteOnlyProperty");
                break;
            }
            default: {
                string = "";
            }
        }
        return string + " " + this.getTypeForHint() + " : " + this.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createNameProperty(this.writeable));
        set.put(this.createTypeProperty(this.writeable));
        set.put(this.createModeProperty(this.writeable));
        set.put(this.createGetterProperty(false));
        set.put(this.createSetterProperty(false));
        set.put(this.createFieldProperty(false));
        return sheet;
    }

    public Node cloneNode() {
        return new PropertyPatternNode((PropertyPattern)this.pattern, this.writeable);
    }

    protected void setPatternName(String string) throws JmiException {
        if (this.pattern.getName().equals(string)) {
            return;
        }
        if (this.testNameValidity(string)) {
            ((PropertyPattern)this.pattern).setName(string);
        }
    }

    boolean testNameValidity(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Identifier"), 0));
            return false;
        }
        return true;
    }

    protected Node.Property createTypeProperty(boolean bl) {
        return new PatternNode.PatternPropertySupport("type", Type.class, bl){

            public Object getValue() {
                return ((PropertyPattern)PropertyPatternNode.this.pattern).getType();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                try {
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                    ((PropertyPattern)PropertyPatternNode.this.pattern).setType((Type)object);
                }
                catch (JmiException jmiException) {
                    throw new InvocationTargetException(jmiException);
                }
                finally {
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new PropertyTypeEditor();
            }
        };
    }

    void fire() {
        this.firePropertyChange(null, null, null);
    }

    protected Node.Property createModeProperty(boolean bl) {
        return new PatternNode.PatternPropertySupport("mode", Integer.TYPE, bl){

            public Object getValue() {
                return new Integer(((PropertyPattern)PropertyPatternNode.this.pattern).getMode());
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                try {
                    ((PropertyPattern)PropertyPatternNode.this.pattern).setMode((Integer)object);
                }
                catch (JmiException jmiException) {
                    throw new InvocationTargetException(jmiException);
                }
                catch (GenerateBeanException generateBeanException) {
                    throw new InvocationTargetException(generateBeanException);
                }
                finally {
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                }
                PropertyPatternNode.this.setIconBase(PropertyPatternNode.this.resolveIconBase());
            }

            public PropertyEditor getPropertyEditor() {
                return new ModePropertyEditor();
            }
        };
    }

    protected Node.Property createGetterProperty(boolean bl) {
        return new PatternNode.PatternPropertySupport("getter", String.class, bl){

            public Object getValue() {
                Method method = ((PropertyPattern)PropertyPatternNode.this.pattern).getGetterMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }

    protected Node.Property createSetterProperty(boolean bl) {
        return new PatternNode.PatternPropertySupport("setter", String.class, bl){

            public Object getValue() {
                Method method = ((PropertyPattern)PropertyPatternNode.this.pattern).getSetterMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }

    protected Node.Property createFieldProperty(boolean bl) {
        return new PatternNode.PatternPropertySupport("estimatedField", String.class, bl){

            public Object getValue() {
                Format format = SourceNodes.createElementFormat((String)"{t} {n}");
                Field field = ((PropertyPattern)PropertyPatternNode.this.pattern).getEstimatedField();
                String string = null;
                try {
                    if (field != null) {
                        string = format.format(field);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)illegalArgumentException);
                }
                return string != null ? string : PatternNode.getString("LAB_NoField");
            }
        };
    }
}

