/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.util.NbBundle;

public class PropertyTypeEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor {
    private final String[] types = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "String"};

    public String getAsText() {
        Type type = (Type)this.getValue();
        return type == null ? "" : type.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsText(String string) throws IllegalArgumentException {
        String string2;
        if (string == null || (string2 = string.trim()).length() == 0) {
            throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException(string), NbBundle.getMessage((Class)PropertyTypeEditor.class, (String)"MSG_Not_Valid_Type"));
        }
        Type type = (Type)this.getValue();
        try {
            Type type2;
            JMIUtils.beginTrans(false);
            try {
                JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent((Element)type);
                type2 = javaModelPackage.getType().resolve(string2);
            }
            finally {
                JMIUtils.endTrans();
            }
            this.setValue(type2);
        }
        catch (JmiException jmiException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(jmiException);
            throw illegalArgumentException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object object) {
        JMIUtils.beginTrans(false);
        try {
            if (!(object instanceof Type) || JMIUtils.isPrimitiveType((Type)object, PrimitiveTypeKindEnum.VOID)) {
                throw new IllegalArgumentException();
            }
        }
        finally {
            JMIUtils.endTrans();
        }
        super.setValue(object);
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public String[] getTags() {
        return this.types;
    }

    public Component getInPlaceCustomEditor() {
        return null;
    }

    public boolean hasInPlaceCustomEditor() {
        return false;
    }

    public boolean supportsEditingTaggedValues() {
        return true;
    }
}

