/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.jmi.reflect.JmiException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternGroupNode;
import org.netbeans.modules.beans.PatternNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;

public final class UEventSetPatternPanel
extends JPanel
implements ActionListener {
    private Dialog dialog;
    private PatternGroupNode groupNode;
    private boolean forInterface = false;
    private transient PatternAnalyser patternAnalyser;
    static final long serialVersionUID = 4317314528606244073L;
    private JPanel eventSetPanel;
    private JLabel typeLabel;
    private JCheckBox passEventCheckBox;
    private JCheckBox fireCheckBox;
    private JPanel optionsPanel;
    private JLabel textLabel;
    private JRadioButton emptyRadioButton;
    private JPanel mainPanel;
    private JComboBox typeComboBox;
    private JRadioButton implRadioButton;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UEventSetPatternPanel(PatternAnalyser patternAnalyser) {
        this.patternAnalyser = patternAnalyser;
        this.initComponents();
        this.initAccessibility();
        for (int i = 0; i < EventSetPattern.WELL_KNOWN_LISTENERS.length; ++i) {
            this.typeComboBox.addItem(EventSetPattern.WELL_KNOWN_LISTENERS[i]);
        }
        this.typeComboBox.setSelectedItem("");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.emptyRadioButton);
        buttonGroup.add(this.implRadioButton);
        ((TitledBorder)this.eventSetPanel.getBorder()).setTitle(PatternNode.getString("CTL_UEventSetPanel_eventSetPanel"));
        ((TitledBorder)this.optionsPanel.getBorder()).setTitle(PatternNode.getString("CTL_UEventSetPanel_optionsPanel"));
        this.typeLabel.setText(PatternNode.getString("CTL_UEventSetPanel_typeLabel"));
        this.typeLabel.setDisplayedMnemonic(PatternNode.getString("CTL_UEventSetPanel_typeLabel_Mnemonic").charAt(0));
        this.typeLabel.setLabelFor(this.typeComboBox);
        this.typeComboBox.setToolTipText(PatternNode.getString("ACS_UEventSetPanel_typeComboBoxA11yDesc"));
        this.textLabel.setText(PatternNode.getString("CTL_UEventSetPanel_textLabel"));
        this.emptyRadioButton.setText(PatternNode.getString("CTL_UEventSetPanel_emptyRadioButton"));
        this.emptyRadioButton.setMnemonic(PatternNode.getString("CTL_UEventSetPanel_emptyRadioButton_Mnemonic").charAt(0));
        this.emptyRadioButton.setToolTipText(PatternNode.getString("ACS_UEventSetPanel_emptyRadioButtonA11yDesc"));
        this.implRadioButton.setText(PatternNode.getString("CTL_UEventSetPanel_implRadioButton"));
        this.implRadioButton.setMnemonic(PatternNode.getString("CTL_UEventSetPanel_implRadioButton_Mnemonic").charAt(0));
        this.implRadioButton.setToolTipText(PatternNode.getString("ACS_UEventSetPanel_implRadioButtonA11yDesc"));
        this.fireCheckBox.setText(PatternNode.getString("CTL_UEventSetPanel_fireCheckBox"));
        this.fireCheckBox.setMnemonic(PatternNode.getString("CTL_UEventSetPanel_fireCheckBox_Mnemonic").charAt(0));
        this.fireCheckBox.setToolTipText(PatternNode.getString("ACS_UEventSetPanel_fireCheckBoxA11yDesc"));
        this.passEventCheckBox.setText(PatternNode.getString("CTL_UEventSetPanel_passEventCheckBox"));
        this.passEventCheckBox.setMnemonic(PatternNode.getString("CTL_UEventSetPanel_passEventCheckBox_Mnemonic").charAt(0));
        this.passEventCheckBox.setToolTipText(PatternNode.getString("ACS_UEventSetPanel_passEventCheckBoxA11yDesc"));
        HelpCtx.setHelpIDString((JComponent)this, (String)"beans.eventsets");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACSD_UEventSetPanelDialog"));
        this.typeLabel.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACS_UEventSetPanel_typeLabelA11yDesc"));
        this.typeComboBox.getAccessibleContext().setAccessibleName(PatternNode.getString("ACS_UEventSetPanel_typeComboBoxA11yName"));
        this.textLabel.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACS_UEventSetPanel_textLabelA11yDesc"));
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.eventSetPanel = new JPanel();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.textLabel = new JLabel();
        this.optionsPanel = new JPanel();
        this.emptyRadioButton = new JRadioButton();
        this.implRadioButton = new JRadioButton();
        this.fireCheckBox = new JCheckBox();
        this.passEventCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.eventSetPanel.setLayout(new GridBagLayout());
        this.eventSetPanel.setBorder(new TitledBorder(new EtchedBorder(null, new Color(149, 142, 130)), "eventSetPanel"));
        this.typeLabel.setText("typeLabel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.eventSetPanel.add((Component)this.typeLabel, gridBagConstraints);
        this.typeComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.eventSetPanel.add((Component)this.typeComboBox, gridBagConstraints);
        this.textLabel.setText("textLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 2);
        this.eventSetPanel.add((Component)this.textLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.eventSetPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.setBorder(new TitledBorder(new EtchedBorder(null, new Color(149, 142, 130)), "optionsPanel"));
        this.emptyRadioButton.setSelected(true);
        this.emptyRadioButton.setText("emptyRadioButton");
        this.emptyRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UEventSetPatternPanel.this.emptyRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.optionsPanel.add((Component)this.emptyRadioButton, gridBagConstraints);
        this.implRadioButton.setText("implRadioButton");
        this.implRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UEventSetPatternPanel.this.implRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.optionsPanel.add((Component)this.implRadioButton, gridBagConstraints);
        this.fireCheckBox.setText("fireCheckBox");
        this.fireCheckBox.setEnabled(false);
        this.fireCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UEventSetPatternPanel.this.fireCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.fireCheckBox, gridBagConstraints);
        this.passEventCheckBox.setText("passEventCheckBox");
        this.passEventCheckBox.setEnabled(false);
        this.passEventCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UEventSetPatternPanel.this.passEventCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 2, 4);
        this.optionsPanel.add((Component)this.passEventCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    private void fireCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void implRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void emptyRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void passEventCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    Result getResult() {
        Result result = new Result();
        result.type = this.typeComboBox.getEditor().getItem().toString();
        if (this.implRadioButton.isSelected()) {
            result.implementation = 1;
        }
        if (this.fireCheckBox.isSelected()) {
            result.firing = true;
        }
        if (this.passEventCheckBox.isSelected()) {
            result.passEvent = true;
        }
        return result;
    }

    private void protectControls() {
        this.implRadioButton.setEnabled(!this.forInterface);
        this.fireCheckBox.setEnabled(!this.emptyRadioButton.isSelected());
        this.passEventCheckBox.setEnabled(!this.emptyRadioButton.isSelected() && this.fireCheckBox.isSelected());
    }

    void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    void setForInterface(boolean bl) {
        this.forInterface = bl;
        this.protectControls();
    }

    void setGroupNode(PatternGroupNode patternGroupNode) {
        this.groupNode = patternGroupNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dialog == null) {
            return;
        }
        if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
            String string = this.typeComboBox.getEditor().getItem().toString().trim();
            if (string.length() <= 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Type"), 0));
                this.typeComboBox.requestFocus();
                return;
            }
            try {
                JMIUtils.beginTrans(false);
                try {
                    if (!this.validateType(string)) {
                        return;
                    }
                }
                finally {
                    JMIUtils.endTrans();
                }
            }
            catch (JmiException jmiException) {
                ErrorManager.getDefault().notify(4096, (Throwable)jmiException);
            }
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    private boolean validateType(String string) throws JmiException {
        EventSetPattern eventSetPattern;
        Type type;
        try {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            type = this.patternAnalyser.findType(string);
            if (type == null || !(type instanceof JavaClass)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Type"), 0));
                this.typeComboBox.requestFocus();
                return false;
            }
            eventSetPattern = this.groupNode.findEventSetPattern(type);
            if (eventSetPattern != null) {
                String string2 = MessageFormat.format(PatternNode.getString("MSG_EventSet_Exists"), eventSetPattern.getName());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
                this.typeComboBox.requestFocus();
                return false;
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify(4096, (Throwable)jmiException);
            return false;
        }
        eventSetPattern = this.patternAnalyser.findClassElement("java.util.EventListener");
        if (!((JavaClass)type).isSubTypeOf((ClassDefinition)eventSetPattern)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_InvalidListenerInterface"), 0));
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !UEventSetPatternPanel.class.desiredAssertionStatus();
    }

    class Result {
        String type;
        int implementation = 0;
        boolean firing = false;
        boolean passEvent = false;

        Result() {
        }
    }
}

