/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.io.IOException;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public final class BeanInfoSource {
    private static final String BEANINFO_NAME_EXT = "BeanInfo";
    private static final String DESCRIPTOR_SECTION = "BeanDescriptor";
    private static final String PROPERTIES_SECTION = "Properties";
    private static final String EVENTSETS_SECTION = "Events";
    private static final String ICONS_SECTION = "Icons";
    private static final String IDX_SECTION = "Idx";
    private static final String METHODS_SECTION = "Methods";
    private static final String SUPERCLASS_SECTION = "Superclass";
    private JavaClass classElement;
    private DataObject biDataObject = null;
    private JavaEditor javaEditor = null;

    public BeanInfoSource(JavaClass javaClass) {
        this.classElement = javaClass;
        this.findBeanInfo();
    }

    boolean exists() {
        return this.biDataObject != null;
    }

    boolean isNbBeanInfo() {
        if (!this.exists() || this.javaEditor == null) {
            return false;
        }
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(PROPERTIES_SECTION);
        JavaEditor.InteriorSection interiorSection2 = this.javaEditor.findInteriorSection(EVENTSETS_SECTION);
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(IDX_SECTION);
        return interiorSection != null && interiorSection2 != null && simpleSection != null;
    }

    boolean hasIconInfo() {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(ICONS_SECTION);
        return simpleSection != null;
    }

    boolean isNbBeanInfoDescriptor() {
        if (!this.exists() || this.javaEditor == null) {
            return false;
        }
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(DESCRIPTOR_SECTION);
        return interiorSection != null;
    }

    boolean isNbSuperclass() {
        if (!this.exists() || this.javaEditor == null) {
            return false;
        }
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(SUPERCLASS_SECTION);
        return interiorSection != null;
    }

    void findBeanInfo() {
        this.javaEditor = null;
        Resource resource = this.classElement.getResource();
        if (resource == null) {
            return;
        }
        DataObject dataObject = JavaMetamodel.getManager().getDataObject(resource);
        if (dataObject == null) {
            return;
        }
        FileObject fileObject = dataObject.getFolder().getPrimaryFile();
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject(dataObject.getName() + BEANINFO_NAME_EXT, "java");
        if (fileObject2 == null) {
            return;
        }
        try {
            this.biDataObject = DataObject.find((FileObject)fileObject2);
            this.javaEditor = (JavaEditor)this.biDataObject.getCookie(JavaEditor.class);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    void delete() throws IOException {
        this.biDataObject.delete();
    }

    void createFromTemplate(boolean bl) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Templates");
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject("Beans");
        if (fileObject2 == null) {
            return;
        }
        FileObject fileObject3 = null;
        fileObject3 = bl ? fileObject2.getFileObject(BEANINFO_NAME_EXT, "java") : fileObject2.getFileObject("BeanInfoNoIcon", "java");
        if (fileObject3 == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject3);
            Resource resource = this.classElement.getResource();
            if (resource == null) {
                return;
            }
            DataObject dataObject2 = JavaMetamodel.getManager().getDataObject(resource);
            if (dataObject2 == null) {
                return;
            }
            DataFolder dataFolder = dataObject2.getFolder();
            this.biDataObject = dataObject.createFromTemplate(dataFolder, dataObject2.getName() + BEANINFO_NAME_EXT);
            this.javaEditor = (JavaEditor)this.biDataObject.getCookie(JavaEditor.class);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    DataObject getDataObject() {
        return this.biDataObject;
    }

    void open() {
        this.javaEditor.open();
    }

    void setDescriptorSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(DESCRIPTOR_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getDescriptorSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(DESCRIPTOR_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    void setPropertiesSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(PROPERTIES_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getPropertiesSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(PROPERTIES_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    void setMethodsSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(METHODS_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getMethodsSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(METHODS_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    void setEventSetsSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(EVENTSETS_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getEventSetsSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(EVENTSETS_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    String getIconsSection() {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(ICONS_SECTION);
        if (simpleSection != null) {
            return simpleSection.getText();
        }
        return null;
    }

    void setIconsSection(String string) {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(ICONS_SECTION);
        if (simpleSection != null) {
            simpleSection.setText(string);
        }
    }

    String getDefaultIdxSection() {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(IDX_SECTION);
        if (simpleSection != null) {
            return simpleSection.getText();
        }
        return null;
    }

    void setDefaultIdxSection(String string) {
        JavaEditor.SimpleSection simpleSection = this.javaEditor.findSimpleSection(IDX_SECTION);
        if (simpleSection != null) {
            simpleSection.setText(string);
        }
    }

    void setSuperclassSection(String string, String string2) {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(SUPERCLASS_SECTION);
        if (interiorSection != null) {
            interiorSection.setHeader(string);
            interiorSection.setBottom(string2);
        }
    }

    String getSuperclassSection() {
        JavaEditor.InteriorSection interiorSection = this.javaEditor.findInteriorSection(SUPERCLASS_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }
}

