/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BiAnalyser;
import org.netbeans.modules.beans.beaninfo.IconBases;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public abstract class BiFeature
implements IconBases,
Node.Cookie,
Comparable {
    private static final String TEXT_EXPERT = "setExpert";
    private static final String TEXT_HIDDEN = "setHidden";
    private static final String TEXT_PREFERRED = "setPreferred";
    private static final String TEXT_DISPLAY_NAME = "setDisplayName";
    private static final String TEXT_SHORT_DESCRIPTION = "setShortDescription";
    private String displayName = null;
    private boolean expert = false;
    private boolean hidden = false;
    private String name = null;
    private boolean preferred = false;
    private String shortDescription = null;
    private boolean included = true;
    private String brackets = "]";
    static /* synthetic */ Class class$org$netbeans$modules$beans$beaninfo$BiFeature;

    public BiFeature(Pattern pattern) {
        this(pattern.getName());
    }

    public BiFeature(org.netbeans.jmi.javamodel.Method method) throws JmiException {
        this(method.getName());
        this.displayName = "\"\"";
    }

    protected BiFeature() {
        this("beanDescriptor");
    }

    private BiFeature(String string) {
        this.name = string;
    }

    abstract String getCreationString();

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean bl) {
        this.expert = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean bl) {
        this.preferred = bl;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    abstract String getBracketedName();

    String getBrackets() {
        return this.brackets;
    }

    void setBrackets(String string) {
        this.brackets = string;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean bl) {
        this.included = bl;
    }

    public String getToolTip() {
        return this.getName();
    }

    Collection getCustomizationStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.expert) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_EXPERT).append(" ( true )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.hidden) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_HIDDEN).append(" ( true )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.preferred) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_PREFERRED).append(" ( true )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.displayName != null && this.displayName.trim().length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_DISPLAY_NAME).append(" ( ");
            stringBuffer.append(this.displayName).append(" )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.shortDescription != null && this.shortDescription.trim().length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_SHORT_DESCRIPTION).append(" ( ");
            stringBuffer.append(this.shortDescription).append(" )");
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    void analyzeCustomization(Collection collection) throws GenerateBeanException {
        this.setIncluded(false);
        Iterator iterator = collection.iterator();
        String string = this.getBracketedName();
        String string2 = string + "=new";
        String string3 = string + "." + TEXT_EXPERT;
        String string4 = string + "." + TEXT_HIDDEN;
        String string5 = string + "." + TEXT_PREFERRED;
        String string6 = string + "." + TEXT_DISPLAY_NAME;
        String string7 = string + "." + TEXT_SHORT_DESCRIPTION;
        while (iterator.hasNext()) {
            String string8;
            String string9 = (String)iterator.next();
            if (string9.indexOf(string2) != -1) {
                this.setIncluded(true);
                this.analyzeCreationString(string9);
                continue;
            }
            if (string9.indexOf(string3) != -1) {
                this.setExpert(true);
                continue;
            }
            if (string9.indexOf(string4) != -1) {
                this.setHidden(true);
                continue;
            }
            if (string9.indexOf(string5) != -1) {
                this.setPreferred(true);
                continue;
            }
            if (string9.indexOf(string6) != -1) {
                string8 = BiAnalyser.getArgumentParameter(string9);
                if (string8 == null) continue;
                this.setDisplayName(string8);
                continue;
            }
            if (string9.indexOf(string7) != -1) {
                string8 = BiAnalyser.getArgumentParameter(string9);
                if (string8 == null) continue;
                this.setShortDescription(string8);
                continue;
            }
            this.analyzeCustomizationString(string9);
        }
    }

    abstract String getIconBase(boolean var1);

    abstract void analyzeCreationString(String var1);

    abstract void analyzeCustomizationString(String var1);

    public int compareTo(Object object) {
        if (!(object instanceof BiFeature)) {
            return -1;
        }
        BiFeature biFeature = (BiFeature)object;
        return this.getName().compareToIgnoreCase(biFeature.getName());
    }

    public static final class Method
    extends BiFeature {
        org.netbeans.jmi.javamodel.Method element;
        private String varName;
        private String toolTip;
        private org.netbeans.jmi.javamodel.Method me;
        private static Map PRIMITIVE_2_CLASS;
        private String creationString;
        static final /* synthetic */ boolean $assertionsDisabled;

        Method(org.netbeans.jmi.javamodel.Method method, PatternAnalyser patternAnalyser) throws GenerateBeanException {
            super(method);
            this.element = method;
            this.me = method;
            this.toolTip = Method.initToolTip(this.element);
            this.creationString = Method.initCreationString(this.element);
        }

        String getBracketedName() {
            return "[METHOD_" + this.getName() + "]";
        }

        private static String findPrimitiveClass(String string) {
            if (PRIMITIVE_2_CLASS == null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("int", "Integer.TYPE");
                hashMap.put("boolean", "Boolean.TYPE");
                hashMap.put("char", "Character.TYPE");
                hashMap.put("long", "Long.TYPE");
                hashMap.put("short", "Short.TYPE");
                hashMap.put("byte", "Byte.TYPE");
                hashMap.put("float", "Float.TYPE");
                hashMap.put("double", "Double.TYPE");
                PRIMITIVE_2_CLASS = Collections.unmodifiableMap(hashMap);
            }
            return (String)PRIMITIVE_2_CLASS.get(string);
        }

        private static String getTypeClass(Type type) throws JmiException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            if (type instanceof PrimitiveType) {
                return Method.findPrimitiveClass(type.getName());
            }
            if (type instanceof Array) {
                return Method.resolveArrayClass((Array)type);
            }
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getDefinition().getName() + ".class";
            }
            if (type instanceof ClassDefinition) {
                return ((ClassDefinition)type).getName() + ".class";
            }
            throw new IllegalStateException("Unknown type" + type);
        }

        private static String resolveArrayClass(Array array) {
            Array array2 = array;
            int n = 0;
            while (array2 instanceof Array) {
                array2 = array2.getType();
                ++n;
            }
            if (array2 instanceof ParameterizedType) {
                char[] cArray = new char[n * 2];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = 91;
                    cArray[++i] = 93;
                }
                return ((ParameterizedType)array2).getDefinition().getName() + String.valueOf(cArray) + ".class";
            }
            return array.getName() + ".class";
        }

        public String getToolTip() {
            return this.toolTip;
        }

        private static String initToolTip(org.netbeans.jmi.javamodel.Method method) throws GenerateBeanException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            try {
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(method.getName() + "(");
                List list = method.getParameters();
                int n = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Parameter parameter = (Parameter)iterator.next();
                    if (n++ > 0) {
                        stringBuffer.append(", ");
                    }
                    try {
                        stringBuffer.append(parameter.getType().getName());
                    }
                    catch (NullPointerException nullPointerException) {
                        ErrorManager.getDefault().annotate((Throwable)nullPointerException, "method: " + method);
                        ErrorManager.getDefault().annotate((Throwable)nullPointerException, "i: " + n);
                        ErrorManager.getDefault().annotate((Throwable)nullPointerException, "param: " + parameter);
                        if (parameter != null) {
                            ErrorManager.getDefault().annotate((Throwable)nullPointerException, "type: " + parameter.getType());
                        }
                        throw nullPointerException;
                    }
                }
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
            catch (JmiException jmiException) {
                throw new GenerateBeanException(jmiException);
            }
        }

        org.netbeans.jmi.javamodel.Method getElement() {
            return this.element;
        }

        String getCreationString() {
            return this.creationString;
        }

        private static String initCreationString(org.netbeans.jmi.javamodel.Method method) throws GenerateBeanException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            try {
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append("new MethodDescriptor ( ");
                stringBuffer.append(method.getDeclaringClass().getName() + ".class.getMethod(\"" + method.getName() + "\", ");
                stringBuffer.append("new Class[] {");
                List list = method.getParameters();
                int n = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Parameter parameter = (Parameter)iterator.next();
                    if (n++ > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(Method.getTypeClass(parameter.getType()));
                }
                stringBuffer.append("}))");
                return stringBuffer.toString();
            }
            catch (JmiException jmiException) {
                throw new GenerateBeanException(jmiException);
            }
        }

        String getIconBase(boolean bl) {
            if (bl) {
                return "org/netbeans/modules/beans/resources/bifMethod_S";
            }
            return "org/netbeans/modules/beans/resources/bifMethod_" + (this.isIncluded() ? "S" : "N");
        }

        void analyzeCustomizationString(String string) {
        }

        void analyzeCreationString(String string) {
        }

        void analyzeCustomization(Collection collection) throws GenerateBeanException {
            String string;
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            if (this.me != null) {
                string = (String)BiAnalyser.normalizeText(this.getCreationString()).toArray()[0];
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    int n = string2.indexOf(string);
                    if (n <= -1) continue;
                    this.varName = string2.substring(string2.indexOf("methods[METHOD_") + 15, n - 2);
                    break;
                }
                this.me = null;
            }
            string = this.getName();
            this.setName(this.varName);
            super.analyzeCustomization(collection);
            this.setName(string);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$beaninfo$BiFeature == null ? (class$org$netbeans$modules$beans$beaninfo$BiFeature = BiFeature.class$("org.netbeans.modules.beans.beaninfo.BiFeature")) : class$org$netbeans$modules$beans$beaninfo$BiFeature).desiredAssertionStatus();
        }
    }

    public static final class EventSet
    extends BiFeature
    implements Comparator {
        EventSetPattern pattern;
        private static final String TEXT_UNICAST = "setUnicast";
        private static final String TEXT_IN_DEFAULT = "setInDefaultEventSet";
        private boolean isInDefaultEventSet = true;
        private String creationString;
        static final /* synthetic */ boolean $assertionsDisabled;

        EventSet(EventSetPattern eventSetPattern) throws GenerateBeanException {
            super(eventSetPattern);
            this.pattern = eventSetPattern;
            this.creationString = this.initCreationString();
        }

        public boolean isUnicast() {
            return this.pattern.isUnicast();
        }

        public boolean isInDefaultEventSet() {
            return this.isInDefaultEventSet;
        }

        public void setInDefaultEventSet(boolean bl) {
            this.isInDefaultEventSet = bl;
        }

        String getBracketedName() {
            return "[EVENT_" + this.getName() + "]";
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof org.netbeans.jmi.javamodel.Method) || !(object2 instanceof org.netbeans.jmi.javamodel.Method)) {
                throw new IllegalArgumentException();
            }
            org.netbeans.jmi.javamodel.Method method = (org.netbeans.jmi.javamodel.Method)object;
            org.netbeans.jmi.javamodel.Method method2 = (org.netbeans.jmi.javamodel.Method)object2;
            return method.getName().compareTo(method2.getName());
        }

        String getCreationString() {
            return this.creationString;
        }

        private String initCreationString() throws GenerateBeanException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            try {
                ArrayList arrayList;
                Object object;
                StringBuffer stringBuffer = new StringBuffer(100);
                try {
                    Type type = this.pattern.getType();
                    object = (JavaClass)type;
                    arrayList = new ArrayList(JMIUtils.getMethods((ClassDefinition)object));
                    Collections.sort(arrayList, this);
                }
                catch (IllegalStateException illegalStateException) {
                    ErrorManager.getDefault().notify((Throwable)illegalStateException);
                    arrayList = Collections.EMPTY_LIST;
                }
                stringBuffer.append("new EventSetDescriptor ( ");
                stringBuffer.append(this.pattern.getDeclaringClass().getName() + ".class, ");
                stringBuffer.append("\"" + this.getName() + "\", ");
                stringBuffer.append(this.pattern.getType().getName() + ".class, ");
                stringBuffer.append("new String[] {");
                int n = 0;
                object = arrayList.iterator();
                while (object.hasNext()) {
                    org.netbeans.jmi.javamodel.Method method = (org.netbeans.jmi.javamodel.Method)object.next();
                    if (n++ > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("\"" + method.getName() + "\"");
                }
                stringBuffer.append("}, ");
                stringBuffer.append("\"" + this.pattern.getAddListenerMethod().getName() + "\", ");
                stringBuffer.append("\"" + this.pattern.getRemoveListenerMethod().getName() + "\" )");
                return stringBuffer.toString();
            }
            catch (JmiException jmiException) {
                throw new GenerateBeanException(jmiException);
            }
        }

        String getIconBase(boolean bl) {
            if (bl) {
                if (this.isUnicast()) {
                    return "org/netbeans/modules/beans/resources/bifEventSetUC_S";
                }
                return "org/netbeans/modules/beans/resources/bifEventSetMC_S";
            }
            if (this.isUnicast()) {
                return "org/netbeans/modules/beans/resources/bifEventSetUC_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifEventSetMC_" + (this.isIncluded() ? "S" : "N");
        }

        Collection getCustomizationStrings() {
            Collection collection = super.getCustomizationStrings();
            StringBuffer stringBuffer = new StringBuffer(100);
            if (this.isUnicast()) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_UNICAST).append(" ( true )");
                collection.add(stringBuffer.toString());
            }
            if (!this.isInDefaultEventSet) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_IN_DEFAULT).append(" ( false )");
                collection.add(stringBuffer.toString());
            }
            return collection;
        }

        void analyzeCustomizationString(String string) {
            String string2 = this.getBracketedName();
            String string3 = string2 + "." + TEXT_IN_DEFAULT;
            if (string.indexOf(string3) != -1) {
                this.setInDefaultEventSet(false);
                return;
            }
        }

        void analyzeCreationString(String string) {
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$beaninfo$BiFeature == null ? (class$org$netbeans$modules$beans$beaninfo$BiFeature = BiFeature.class$("org.netbeans.modules.beans.beaninfo.BiFeature")) : class$org$netbeans$modules$beans$beaninfo$BiFeature).desiredAssertionStatus();
        }
    }

    public static final class IdxProperty
    extends Property {
        private boolean niGetter;
        private boolean niSetter;
        IdxPropertyPattern pattern;
        private String indexedGetterName;
        private String indexedSetterName;
        static final /* synthetic */ boolean $assertionsDisabled;

        IdxProperty(IdxPropertyPattern idxPropertyPattern) throws GenerateBeanException {
            super(idxPropertyPattern);
            this.pattern = idxPropertyPattern;
            this.niGetter = this.hasNiGetter();
            this.niSetter = this.hasNiSetter();
            try {
                if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                    throw new AssertionError();
                }
                org.netbeans.jmi.javamodel.Method method = this.pattern.getIndexedGetterMethod();
                this.indexedGetterName = method == null ? null : method.getName();
                method = this.pattern.getIndexedSetterMethod();
                this.indexedSetterName = method == null ? null : method.getName();
            }
            catch (JmiException jmiException) {
                throw new GenerateBeanException(jmiException);
            }
        }

        boolean isNiGetter() {
            return this.niGetter;
        }

        void setNiGetter(boolean bl) {
            this.niGetter = this.hasNiGetter() ? bl : false;
        }

        boolean isNiSetter() {
            return this.niSetter;
        }

        void setNiSetter(boolean bl) {
            this.niGetter = this.hasNiSetter() ? bl : false;
        }

        boolean hasNiGetter() {
            return this.pattern.getGetterMethod() != null;
        }

        boolean hasNiSetter() {
            return this.pattern.getGetterMethod() != null;
        }

        String getCreationString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("new IndexedPropertyDescriptor ( ");
            stringBuffer.append("\"" + this.getName() + "\", ");
            stringBuffer.append(this.getDeclaringClassName() + ".class, ");
            if (this.getGetterName() != null && this.niGetter) {
                stringBuffer.append("\"" + this.getGetterName() + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.getSetterName() != null && this.niSetter) {
                stringBuffer.append("\"" + this.getSetterName() + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.indexedGetterName != null && this.getMode() != 4) {
                stringBuffer.append("\"" + this.indexedGetterName + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.indexedSetterName != null && this.getMode() != 2) {
                stringBuffer.append("\"" + this.indexedSetterName + "\" )");
            } else {
                stringBuffer.append("null )");
            }
            return stringBuffer.toString();
        }

        String getIconBase(boolean bl) {
            if (bl) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_S";
            }
            if (this.getMode() == 2) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.getMode() == 4) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        void analyzeCreationString(String string) {
            String[] stringArray = BiAnalyser.getParameters(string);
            if (stringArray.length == 6 && this.getMode() == 1) {
                if (stringArray[4].equals("null")) {
                    this.setMode(4);
                } else if (stringArray[5].equals("null")) {
                    this.setMode(2);
                }
                if (this.hasNiGetter() && stringArray[2].equals(null)) {
                    this.niGetter = false;
                }
                if (this.hasNiGetter() && stringArray[3].equals(null)) {
                    this.niSetter = false;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$beaninfo$BiFeature == null ? (class$org$netbeans$modules$beans$beaninfo$BiFeature = BiFeature.class$("org.netbeans.modules.beans.beaninfo.BiFeature")) : class$org$netbeans$modules$beans$beaninfo$BiFeature).desiredAssertionStatus();
        }
    }

    public static class Property
    extends BiFeature {
        private PropertyPattern pattern;
        private static final String TEXT_BOUND = "setBound";
        private static final String TEXT_CONSTRAINED = "setConstrained";
        private static final String TEXT_PROPERTY_EDITOR = "setPropertyEditorClass";
        private boolean bound;
        private boolean constrained;
        private int mode;
        private String propertyEditorClass;
        private String declaringClassName;
        private String getterName;
        private String setterName;
        static final /* synthetic */ boolean $assertionsDisabled;

        Property(PropertyPattern propertyPattern) throws GenerateBeanException {
            super(propertyPattern);
            this.mode = propertyPattern.getMode();
            this.pattern = propertyPattern;
            try {
                if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                    throw new AssertionError();
                }
                this.declaringClassName = this.pattern.getDeclaringClass().getName();
                org.netbeans.jmi.javamodel.Method method = this.pattern.getGetterMethod();
                this.getterName = method == null ? null : method.getName();
                method = this.pattern.getSetterMethod();
                this.setterName = method == null ? null : method.getName();
            }
            catch (JmiException jmiException) {
                throw new GenerateBeanException(jmiException);
            }
        }

        protected final String getDeclaringClassName() {
            return this.declaringClassName;
        }

        protected final String getGetterName() {
            return this.getterName;
        }

        protected final String getSetterName() {
            return this.setterName;
        }

        public boolean isBound() {
            return this.bound;
        }

        String getBracketedName() {
            return "[PROPERTY_" + this.getName() + "]";
        }

        public void setBound(boolean bl) {
            this.bound = bl;
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        public void setConstrained(boolean bl) {
            this.constrained = bl;
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int n) {
            this.mode = n;
        }

        public boolean modeChangeable() {
            return this.pattern.getMode() == 1;
        }

        public String getPropertyEditorClass() {
            return this.propertyEditorClass;
        }

        public void setPropertyEditorClass(String string) {
            this.propertyEditorClass = string;
        }

        String getCreationString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("new PropertyDescriptor ( ");
            stringBuffer.append("\"" + this.getName() + "\", ");
            stringBuffer.append(this.declaringClassName + ".class, ");
            if (this.getterName != null && this.getMode() != 4) {
                stringBuffer.append("\"" + this.getterName + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.setterName != null && this.getMode() != 2) {
                stringBuffer.append("\"" + this.setterName + "\" )");
            } else {
                stringBuffer.append("null )");
            }
            return stringBuffer.toString();
        }

        String getIconBase(boolean bl) {
            if (bl) {
                return "org/netbeans/modules/beans/resources/bifPropertyRW_S";
            }
            if (this.mode == 2) {
                return "org/netbeans/modules/beans/resources/bifPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.mode == 4) {
                return "org/netbeans/modules/beans/resources/bifPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        Collection getCustomizationStrings() {
            Collection collection = super.getCustomizationStrings();
            StringBuffer stringBuffer = new StringBuffer(100);
            if (this.bound) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_BOUND).append(" ( true )");
                collection.add(stringBuffer.toString());
            }
            if (this.constrained) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_CONSTRAINED).append(" ( true )");
                collection.add(stringBuffer.toString());
            }
            if (this.propertyEditorClass != null && this.propertyEditorClass.trim().length() > 0) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_PROPERTY_EDITOR).append(" ( ");
                stringBuffer.append(this.propertyEditorClass).append(" )");
                collection.add(stringBuffer.toString());
            }
            return collection;
        }

        void analyzeCustomizationString(String string) {
            String string2 = this.getBracketedName();
            String string3 = string2 + "." + TEXT_BOUND;
            String string4 = string2 + "." + TEXT_CONSTRAINED;
            String string5 = string2 + "." + TEXT_PROPERTY_EDITOR;
            if (string.indexOf(string3) != -1) {
                this.setBound(true);
                return;
            }
            if (string.indexOf(string4) != -1) {
                this.setConstrained(true);
                return;
            }
            int n = string.indexOf(string5);
            if (n != -1) {
                String string6 = string.substring(n + string5.length());
                String[] stringArray = BiAnalyser.getParameters(string6);
                if (stringArray.length > 0) {
                    this.setPropertyEditorClass(stringArray[0]);
                }
                return;
            }
        }

        void analyzeCreationString(String string) {
            String[] stringArray = BiAnalyser.getParameters(string);
            if (stringArray.length == 4 && this.mode == 1) {
                if (stringArray[2].equals("null")) {
                    this.mode = 4;
                } else if (stringArray[3].equals("null")) {
                    this.mode = 2;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$beaninfo$BiFeature == null ? (class$org$netbeans$modules$beans$beaninfo$BiFeature = BiFeature.class$("org.netbeans.modules.beans.beaninfo.BiFeature")) : class$org$netbeans$modules$beans$beaninfo$BiFeature).desiredAssertionStatus();
        }
    }

    public static final class Descriptor
    extends BiFeature {
        JavaClass element;
        String customizer;
        private String beanName;

        Descriptor(JavaClass javaClass) throws GenerateBeanException {
            this.element = javaClass;
            this.beanName = Descriptor.initBeanName(this.element);
        }

        String getCreationString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("new BeanDescriptor  ( ");
            stringBuffer.append(this.getBeanName() + ".class , ");
            stringBuffer.append(String.valueOf(this.getCustomizer()) + " )");
            return stringBuffer.toString();
        }

        String getIconBase(boolean bl) {
            return "org/netbeans/modules/beans/resources/bifDescriptor";
        }

        Collection getCustomizationStrings() {
            Collection collection = super.getCustomizationStrings();
            return collection;
        }

        void analyzeCustomizationString(String string) {
        }

        void analyzeCreationString(String string) {
            int n = string.indexOf(44);
            int n2 = string.lastIndexOf(41);
            if (n != -1 && n2 != -1 && ++n < n2) {
                this.setCustomizer(string.substring(n, n2));
            } else {
                this.setCustomizer(null);
            }
        }

        String getBracketedName() {
            return this.getName();
        }

        String getBrackets() {
            return "";
        }

        public String getCustomizer() {
            return this.customizer;
        }

        public void setCustomizer(String string) {
            this.customizer = string;
        }

        public boolean isIncluded() {
            return true;
        }

        private static String initBeanName(JavaClass javaClass) throws GenerateBeanException {
            try {
                return javaClass.getName();
            }
            catch (JmiException jmiException) {
                throw new GenerateBeanException(jmiException);
            }
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

