/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class BiIconEditor
extends PropertyEditorSupport {
    private static final String BEAN_ICONEDITOR_HELP = "beans.icon";
    private FileObject sourceFileObject;
    static ResourceBundle bundle = NbBundle.getBundle((Class)BiIconEditor.class);
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public static boolean isImage(String string) {
        return (string = string.toLowerCase()).endsWith(".jpg") || string.endsWith(".gif") || string.endsWith(".jpeg") || string.endsWith(".jpe") || string.equals("jpg") || string.equals("gif") || string.equals("jpeg") || string.equals("jpe");
    }

    public BiIconEditor(FileObject fileObject) {
        this.sourceFileObject = fileObject;
    }

    public String getSourceName() {
        if (this.getValue() instanceof BiImageIcon) {
            return ((BiImageIcon)this.getValue()).getName();
        }
        return null;
    }

    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return "null";
        }
        if (object instanceof BiImageIcon) {
            BiImageIcon biImageIcon = (BiImageIcon)object;
            return biImageIcon.getName();
        }
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        try {
            this.setValue(this.iconFromText(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private BiImageIcon iconFromText(String string) throws IllegalArgumentException {
        BiImageIcon biImageIcon;
        try {
            if (string.length() == 0 || string.equals("null")) {
                biImageIcon = null;
            } else {
                ClassPath classPath = ClassPath.getClassPath((FileObject)this.sourceFileObject, (String)"classpath/source");
                URL uRL = classPath.findResource(string.substring(1)).getURL();
                biImageIcon = new BiImageIcon(uRL, string);
            }
        }
        catch (Throwable throwable) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                throwable.printStackTrace();
            }
            throw new IllegalArgumentException(throwable.toString());
        }
        return biImageIcon;
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new IconPanel();
    }

    private static class ResourceSelector
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();

        public ResourceSelector(Node node) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelector"));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelector"));
            this.manager.setRootContext(node);
            BeanTreeView beanTreeView = new BeanTreeView();
            beanTreeView.setPopupAllowed(false);
            beanTreeView.setDefaultActionAllowed(false);
            beanTreeView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
            beanTreeView.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelectorView"));
            beanTreeView.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelectorView"));
            this.add((Component)beanTreeView, "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height = Math.max(dimension.height, Utilities.getUsableScreenBounds().height / 2);
            return dimension;
        }

        public Node[] getNodes() {
            return this.manager.getSelectedNodes();
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }

    private static class RootNode
    extends FilterNode {
        RootNode(Node node, String string) {
            super(node);
            if (string != null) {
                this.disableDelegation(12);
                this.setDisplayName(string);
            }
        }
    }

    class IconPanel
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        JRadioButton rbClasspath;
        JRadioButton rbNoPicture;
        JTextField tfName;
        JButton bSelect;
        JScrollPane spImage;
        static final long serialVersionUID = -6904264999063788703L;

        IconPanel() {
            this.setLayout(new BorderLayout(6, 6));
            this.setBorder(new EmptyBorder(6, 6, 6, 6));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_IconPanelA11yName"));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_IconPanelA11yDesc"));
            JPanel jPanel = new JPanel(new BorderLayout(3, 3));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(new TitledBorder(new EtchedBorder(), bundle.getString("CTL_ImageSourceType")));
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(new EmptyBorder(0, 3, 0, 3));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel3.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 17;
            this.rbClasspath = new JRadioButton(bundle.getString("CTL_Classpath"));
            jPanel3.add(this.rbClasspath);
            this.rbClasspath.setToolTipText(bundle.getString("ACS_ClasspathA11yDesc"));
            this.rbClasspath.setMnemonic(bundle.getString("CTL_Classpath_Mnemonic").charAt(0));
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.rbClasspath, gridBagConstraints);
            JLabel jLabel = new JLabel(bundle.getString("CTL_ClasspathExample"));
            jPanel3.add(jLabel);
            jLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ClasspathExampleA11yDesc"));
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.rbNoPicture = new JRadioButton(bundle.getString("CTL_NoPicture"));
            jPanel3.add(this.rbNoPicture);
            this.rbNoPicture.setToolTipText(bundle.getString("ACS_NoPictureA11yDesc"));
            this.rbNoPicture.setMnemonic(bundle.getString("CTL_NoPicture_Mnemonic").charAt(0));
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.rbNoPicture, gridBagConstraints);
            jLabel = new JLabel(bundle.getString("CTL_Null"));
            jPanel3.add(jLabel);
            jLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NullA11yDesc"));
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbClasspath);
            buttonGroup.add(this.rbNoPicture);
            this.rbClasspath.setSelected(true);
            jPanel2.add((Component)jPanel3, "West");
            jPanel.add((Component)jPanel2, "North");
            jPanel2 = new JPanel(new BorderLayout(6, 6));
            JLabel jLabel2 = new JLabel(bundle.getString("CTL_ImageSourceName"));
            jLabel2.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ImageSourceNameA11yDesc"));
            jLabel2.setDisplayedMnemonic(bundle.getString("CTL_ImageSourceName_Mnemonic").charAt(0));
            jPanel2.add((Component)jLabel2, "West");
            this.tfName = new JTextField();
            jPanel2.add((Component)this.tfName, "Center");
            jLabel2.setLabelFor(this.tfName);
            this.tfName.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameTextFieldA11yName"));
            this.tfName.setToolTipText(bundle.getString("ACS_ImageSourceNameTextFieldA11yDesc"));
            this.bSelect = new JButton("...");
            jPanel2.add((Component)this.bSelect, "East");
            this.bSelect.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yName"));
            this.bSelect.setToolTipText(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yDesc"));
            this.bSelect.setEnabled(false);
            jPanel.add((Component)jPanel2, "South");
            this.add((Component)jPanel, "North");
            this.spImage = new JScrollPane(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(60, 60);
                }
            };
            this.add((Component)this.spImage, "Center");
            this.tfName.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.setValue();
                }
            });
            this.rbClasspath.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.bSelect.setEnabled(true);
                    this.this$1.tfName.setEnabled(true);
                    this.this$1.setValue();
                }
            });
            this.rbNoPicture.addActionListener(new ActionListener(this, BiIconEditor.this){
                private final /* synthetic */ BiIconEditor val$this$0;
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                    this.val$this$0 = biIconEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.bSelect.setEnabled(false);
                    this.this$1.tfName.setEnabled(false);
                    IconPanel.access$000(this.this$1).setValue(null);
                    this.this$1.updateIcon();
                }
            });
            this.bSelect.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    if (this.this$1.rbClasspath.isSelected() && (string = IconPanel.access$100(this.this$1)) != null) {
                        this.this$1.tfName.setText("/" + string);
                        this.this$1.setValue();
                    }
                }
            });
            this.updateIcon();
            HelpCtx.setHelpIDString((JComponent)this, (String)BiIconEditor.BEAN_ICONEDITOR_HELP);
            Icon icon = (Icon)BiIconEditor.this.getValue();
            if (icon == null) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            if (!(icon instanceof BiImageIcon)) {
                return;
            }
            this.rbClasspath.setSelected(true);
            this.bSelect.setEnabled(true);
            this.tfName.setText(((BiImageIcon)icon).getName());
        }

        void updateIcon() {
            Icon icon = (Icon)BiIconEditor.this.getValue();
            this.spImage.setViewportView(icon == null ? new JLabel() : new JLabel(icon));
            this.validate();
        }

        void setValue() {
            String string = this.tfName.getText();
            string.trim();
            if ("".equals(string)) {
                BiIconEditor.this.setValue(null);
                return;
            }
            try {
                BiIconEditor.this.setValue(BiIconEditor.this.iconFromText(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.updateIcon();
        }

        public Object getPropertyValue() throws IllegalStateException {
            BiImageIcon biImageIcon = null;
            String string = this.tfName.getText().trim();
            try {
                if (this.rbClasspath.isSelected() && string.length() != 0) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)BiIconEditor.this.sourceFileObject, (String)"classpath/source");
                    FileObject fileObject = classPath.findResource(string.substring(1));
                    try {
                        biImageIcon = new BiImageIcon(fileObject.getURL(), string);
                    }
                    catch (Throwable throwable) {
                        MessageFormat messageFormat = new MessageFormat(bundle.getString("CTL_Icon_not_exists"));
                        Object[] objectArray = new Object[]{string};
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)messageFormat.format(objectArray), 0));
                    }
                }
            }
            catch (Exception exception) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    exception.printStackTrace();
                }
                throw new IllegalStateException(exception.toString());
            }
            BiIconEditor.this.setValue(biImageIcon);
            return biImageIcon;
        }

        private List getRoots(ClassPath classPath) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(classPath.entries().size());
            Iterator iterator = classPath.entries().iterator();
            while (iterator.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
                URL uRL = entry.getURL();
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)uRL);
                FileObject[] fileObjectArray = result.getRoots();
                if (fileObjectArray.length > 0) {
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        arrayList.add(fileObjectArray[i]);
                    }
                    continue;
                }
                if (entry.getRoot() == null) continue;
                arrayList.add(entry.getRoot());
            }
            return arrayList;
        }

        private String rootDisplayName(FileObject fileObject) {
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }

        private String selectResource() {
            FileObject fileObject;
            DataObject dataObject;
            String string;
            Object object;
            FileObject fileObject2;
            Children.Array array;
            ClassPath classPath = ClassPath.getClassPath((FileObject)BiIconEditor.this.sourceFileObject, (String)"classpath/execute");
            List list = classPath == null ? Collections.EMPTY_LIST : this.getRoots(classPath);
            Node[] nodeArray = new Node[list.size()];
            int n = -1;
            try {
                array = list.listIterator();
                while (array.hasNext()) {
                    fileObject2 = (FileObject)array.next();
                    object = DataObject.find((FileObject)fileObject2);
                    string = this.rootDisplayName(fileObject2);
                    nodeArray[array.previousIndex()] = new RootNode(object.getNodeDelegate(), string);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(4096, (Throwable)dataObjectNotFoundException);
                return null;
            }
            array = new Children.Array();
            array.add(nodeArray);
            fileObject2 = new AbstractNode((Children)array);
            fileObject2.setIconBaseWithExtension("org/netbeans/modules/beans/resources/iconResourceRoot.gif");
            fileObject2.setDisplayName(bundle.getString("CTL_ClassPathName"));
            object = new ResourceSelector((Node)fileObject2);
            string = new DialogDescriptor(object, bundle.getString("CTL_OpenDialogName"));
            Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)string);
            nodeArray = object2 == DialogDescriptor.OK_OPTION ? ((ResourceSelector)object).getNodes() : null;
            String string2 = null;
            if (nodeArray != null && nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = BiIconEditor.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null && (fileObject = dataObject.getPrimaryFile()) != null) {
                if (classPath.contains(fileObject)) {
                    string2 = classPath.getResourceName(fileObject);
                } else {
                    ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                    string2 = classPath2.getResourceName(fileObject);
                }
            }
            return string2;
        }

        static /* synthetic */ BiIconEditor access$000(IconPanel iconPanel) {
            return iconPanel.BiIconEditor.this;
        }

        static /* synthetic */ String access$100(IconPanel iconPanel) {
            return iconPanel.selectResource();
        }
    }

    public static class BiImageIcon
    extends ImageIcon {
        private String name;

        public BiImageIcon() {
        }

        BiImageIcon(URL uRL, String string) {
            super(uRL);
            this.name = string;
        }

        BiImageIcon(String string, String string2) {
            super(string);
            this.name = string2;
        }

        String getName() {
            return this.name;
        }
    }
}

