/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.ByteArray;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class MessageResponse
implements Response {
    private boolean terminating = false;
    private String firstWord;

    public MessageResponse() {
    }

    public MessageResponse(String string) {
        this.firstWord = string;
    }

    public void process(LoggedDataInputStream loggedDataInputStream, ResponseServices responseServices) throws ResponseException {
        try {
            ByteArray byteArray = loggedDataInputStream.readLineBytes();
            String string = byteArray.getStringFromBytes();
            if (this.firstWord != null) {
                string = this.firstWord + " " + string;
            }
            this.terminating |= string.endsWith(" [server aborted]: received termination signal");
            this.terminating |= string.endsWith(" [server aborted]: received broken pipe signal");
            this.terminating |= string.endsWith(" [checkout aborted]: end of file from server (consult above messages if any)");
            this.terminating &= loggedDataInputStream.available() == 0;
            MessageEvent messageEvent = new MessageEvent(this, string, byteArray.getBytes(), false);
            responseServices.getEventManager().fireCVSEvent(messageEvent);
        }
        catch (EOFException eOFException) {
            throw new ResponseException(eOFException, ResponseException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException iOException) {
            throw new ResponseException(iOException);
        }
    }

    public boolean isTerminalResponse() {
        return this.terminating;
    }
}

