/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.io.File;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PlatformSettings
extends SystemOption {
    static final long serialVersionUID = -4636292603494310012L;
    private static PlatformSettings instance;
    private static final String PROP_PLATFORMS_FOLDER = "platformsFolder";
    private static final String APPLE_JAVAVM_FRAMEWORK_PATH = "/System/Library/Frameworks/JavaVM.framework/Versions/";

    public String displayName() {
        return NbBundle.getMessage((Class)PlatformSettings.class, (String)"TXT_PlatformSettings");
    }

    public File getPlatformsFolder() {
        String string = (String)this.getProperty(PROP_PLATFORMS_FOLDER);
        if (string == null) {
            File file;
            if (Utilities.getOperatingSystem() == 4096) {
                file = new File(APPLE_JAVAVM_FRAMEWORK_PATH);
            } else {
                File file2;
                file = new File(System.getProperty("user.home"));
                while ((file2 = file.getParentFile()) != null) {
                    file = file2;
                }
            }
            return file;
        }
        return new File(string);
    }

    public void setPlatformsFolder(File file) {
        this.putProperty(PROP_PLATFORMS_FOLDER, file.getAbsolutePath(), true);
    }

    public static synchronized PlatformSettings getDefault() {
        if (instance == null) {
            instance = (PlatformSettings)SystemOption.findObject((Class)PlatformSettings.class, (boolean)true);
        }
        return instance;
    }
}

