/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.platform.InstallerRegistry;
import org.netbeans.modules.java.platform.wizard.LocationChooser;
import org.netbeans.modules.java.platform.wizard.SelectorPanel;
import org.netbeans.spi.java.platform.CustomPlatformInstall;
import org.netbeans.spi.java.platform.GeneralPlatformInstall;
import org.netbeans.spi.java.platform.PlatformInstall;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PlatformInstallIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    WizardDescriptor.InstantiatingIterator typeIterator;
    int panelIndex;
    boolean hasSelectorPanel;
    WizardDescriptor wizard;
    int panelNumber = -1;
    ResourceBundle bundle = NbBundle.getBundle((Class)PlatformInstallIterator.class);
    LocationChooser.Panel locationPanel = new LocationChooser.Panel();
    SelectorPanel.Panel selectorPanel = new SelectorPanel.Panel();
    Collection listeners = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    PlatformInstallIterator() {
        this.selectorPanel.addChangeListener(this);
        this.locationPanel.addChangeListener(this);
    }

    public static PlatformInstallIterator create() {
        return new PlatformInstallIterator();
    }

    int getPanelIndex() {
        return this.panelIndex;
    }

    void updatePanelsList(JComponent[] jComponentArray) {
        String[] stringArray;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.hasSelectorPanel) {
            linkedList.add(this.bundle.getString("TXT_SelectPlatformTypeTitle"));
        }
        if (this.panelIndex == 1 || this.panelIndex == 2 || this.panelIndex == 0 && this.selectorPanel.getInstallerIterator() == null) {
            linkedList.add(this.bundle.getString("TXT_PlatformFolderTitle"));
        }
        if (this.typeIterator != null) {
            JComponent jComponent;
            String[] stringArray2;
            stringArray = this.typeIterator.current();
            if (stringArray != null && (stringArray2 = (String[])(jComponent = (JComponent)stringArray.getComponent()).getClientProperty("WizardPanel_contentData")) != null) {
                linkedList.addAll(Arrays.asList(stringArray2));
            }
        } else {
            linkedList.add(this.bundle.getString("TITLE_PlatformLocationUnknown"));
        }
        stringArray = linkedList.toArray(new String[linkedList.size()]);
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public WizardDescriptor.Panel current() {
        if (this.panelIndex == 0) {
            return this.selectorPanel;
        }
        if (this.panelIndex == 1) {
            return this.locationPanel;
        }
        return this.typeIterator.current();
    }

    public boolean hasNext() {
        if (this.panelIndex == 0) {
            WizardDescriptor.InstantiatingIterator instantiatingIterator = this.selectorPanel.getInstallerIterator();
            if (instantiatingIterator == null) {
                return true;
            }
            return instantiatingIterator.current() != null;
        }
        if (this.panelIndex == 1) {
            WizardDescriptor.InstantiatingIterator instantiatingIterator = this.locationPanel.getInstallerIterator();
            if (instantiatingIterator == null) {
                return false;
            }
            WizardDescriptor.Panel panel = instantiatingIterator.current();
            return panel != null;
        }
        return this.typeIterator.hasNext();
    }

    public boolean hasPrevious() {
        return !(this.panelIndex == 0 || this.panelIndex == 1 && !this.hasSelectorPanel || this.panelIndex == 3 && !this.hasSelectorPanel && this.typeIterator != null && !this.typeIterator.hasPrevious());
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        List list = InstallerRegistry.getDefault().getAllInstallers();
        if (list.size() > 1) {
            this.panelIndex = 0;
            this.hasSelectorPanel = true;
        } else if (list.get(0) instanceof CustomPlatformInstall) {
            this.panelIndex = 3;
            this.hasSelectorPanel = false;
            this.typeIterator = ((CustomPlatformInstall)list.get(0)).createIterator();
        } else {
            this.panelIndex = 1;
            this.hasSelectorPanel = false;
            this.locationPanel.setPlatformInstall((PlatformInstall)list.get(0));
        }
        this.updatePanelsList(new JComponent[]{(JComponent)this.current().getComponent()});
        this.wizard.setTitle(NbBundle.getMessage((Class)PlatformInstallIterator.class, (String)"TXT_AddPlatformTitle"));
        this.panelNumber = 0;
        this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(this.panelNumber));
    }

    public Set instantiate() throws IOException {
        return this.typeIterator.instantiate();
    }

    public String name() {
        if (this.panelIndex == 0) {
            return this.bundle.getString("TXT_PlatformSelectorTitle");
        }
        if (this.panelIndex == 1) {
            return this.bundle.getString("TXT_PlatformFolderTitle");
        }
        return this.typeIterator.name();
    }

    public void nextPanel() {
        if (this.panelIndex == 0) {
            this.panelIndex = this.selectorPanel.getInstallerIterator() == null ? 1 : 3;
        } else if (this.panelIndex == 1) {
            this.panelIndex = 2;
        } else {
            this.typeIterator.nextPanel();
        }
        ++this.panelNumber;
        this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(this.panelNumber));
    }

    public void previousPanel() {
        if (this.panelIndex == 1) {
            this.panelIndex = 0;
        } else if (this.panelIndex == 2) {
            if (this.typeIterator.hasPrevious()) {
                this.typeIterator.previousPanel();
            } else {
                this.panelIndex = 1;
            }
        } else if (this.panelIndex == 3) {
            if (this.typeIterator.hasPrevious()) {
                this.typeIterator.previousPanel();
            } else {
                this.panelIndex = 0;
            }
        }
        --this.panelNumber;
        this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(this.panelNumber));
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        if (this.typeIterator != null) {
            this.typeIterator.uninitialize(wizardDescriptor);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        WizardDescriptor.InstantiatingIterator instantiatingIterator;
        if (changeEvent.getSource() == this.locationPanel) {
            instantiatingIterator = this.locationPanel.getInstallerIterator();
        } else if (changeEvent.getSource() == this.selectorPanel) {
            GeneralPlatformInstall generalPlatformInstall = this.selectorPanel.getInstaller();
            if (generalPlatformInstall instanceof CustomPlatformInstall) {
                instantiatingIterator = ((CustomPlatformInstall)generalPlatformInstall).createIterator();
            } else {
                instantiatingIterator = null;
                this.locationPanel.setPlatformInstall((PlatformInstall)generalPlatformInstall);
            }
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unknown event source");
            }
            return;
        }
        if (instantiatingIterator != this.typeIterator) {
            if (this.typeIterator != null) {
                this.typeIterator.uninitialize(this.wizard);
            }
            this.typeIterator = instantiatingIterator;
            if (this.typeIterator != null) {
                this.typeIterator.initialize(this.wizard);
                this.updatePanelsList(new JComponent[]{(JComponent)this.selectorPanel.getComponent(), (JComponent)this.locationPanel.getComponent(), (JComponent)this.typeIterator.current().getComponent()});
            } else {
                this.updatePanelsList(new JComponent[]{(JComponent)this.selectorPanel.getComponent(), (JComponent)this.locationPanel.getComponent()});
            }
            this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(this.panelNumber));
        }
    }

    static {
        $assertionsDisabled = !PlatformInstallIterator.class.desiredAssertionStatus();
    }
}

