/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class JavaActions
implements ActionProvider {
    static final String NS_GENERAL = "http://www.netbeans.org/ns/freeform-project/1";
    private static final String[] ACTIONS;
    static final String FILE_SCRIPT_PATH = "nbproject/ide-file-targets.xml";
    static final String GENERAL_SCRIPT_PATH = "nbproject/ide-targets.xml";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final AuxiliaryConfiguration aux;
    private boolean setOutputsNotified;
    private static final String[] DEBUG_VM_ARGS;
    private static final String[] rootElementsOrder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JavaActions(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, AuxiliaryConfiguration auxiliaryConfiguration) {
        this.project = project;
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.aux = auxiliaryConfiguration;
    }

    public String[] getSupportedActions() {
        return ACTIONS;
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        if (string.equals("compile.single")) {
            return this.findPackageRoot(lookup) != null;
        }
        if (string.equals("debug")) {
            return true;
        }
        throw new IllegalArgumentException(string);
    }

    public void invokeAction(final String string, final Lookup lookup) throws IllegalArgumentException {
        try {
            this.project.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    block4: {
                        try {
                            if (string.equals("compile.single")) {
                                JavaActions.this.handleCompileSingle(lookup);
                                break block4;
                            }
                            if (string.equals("debug")) {
                                JavaActions.this.handleDebug();
                                break block4;
                            }
                            throw new IllegalArgumentException(string);
                        }
                        catch (SAXException sAXException) {
                            throw (IOException)new IOException(sAXException.toString()).initCause(sAXException);
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private boolean alert(String string, String string2) {
        String string3 = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        String string4 = NbBundle.getMessage((Class)JavaActions.class, (String)"TITLE_generate_target_dialog", (Object)string, (Object)string3);
        String string5 = NbBundle.getMessage((Class)JavaActions.class, (String)"TEXT_generate_target_dialog", (Object)string, (Object)string2);
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string5, 3);
        message.setTitle(string4);
        message.setOptionType(2);
        JButton jButton = new JButton(NbBundle.getMessage((Class)JavaActions.class, (String)"LBL_generate"));
        jButton.setDefaultCapable(true);
        message.setOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)message) == jButton;
    }

    private boolean alertOutputs(String string) {
        JButton jButton = new JButton(NbBundle.getMessage((Class)JavaActions.class, (String)"CTL_SetOutput"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)JavaActions.class, (String)"AD_SetOutput"));
        jButton.setDefaultCapable(true);
        String string2 = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        String string3 = NbBundle.getMessage((Class)JavaActions.class, (String)"TITLE_set_outputs_dialog", (Object)string, (Object)string2);
        String string4 = NbBundle.getMessage((Class)JavaActions.class, (String)"TEXT_set_outputs_dialog");
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string4, 3);
        message.setTitle(string3);
        message.setOptionType(2);
        message.setOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)message) == jButton) {
            CustomizerProvider customizerProvider = (CustomizerProvider)this.project.getLookup().lookup(CustomizerProvider.class);
            if (!$assertionsDisabled && customizerProvider == null) {
                throw new AssertionError();
            }
            customizerProvider.showCustomizer();
            return true;
        }
        return false;
    }

    private void handleCompileSingle(Lookup lookup) throws IOException, SAXException {
        if (!this.alert(NbBundle.getMessage((Class)JavaActions.class, (String)"ACTION_compile.single"), FILE_SCRIPT_PATH)) {
            return;
        }
        Document document = this.readCustomScript(FILE_SCRIPT_PATH);
        this.ensurePropertiesCopied(document.getDocumentElement());
        Comment comment = document.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_edit_target") + " ");
        document.getDocumentElement().appendChild(comment);
        comment = document.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_more_info_x.single") + " ");
        document.getDocumentElement().appendChild(comment);
        String string = "files";
        AntLocation antLocation = this.findPackageRoot(lookup);
        if (!$assertionsDisabled && antLocation == null) {
            throw new AssertionError(lookup);
        }
        Element element = this.createCompileSingleTarget(document, lookup, string, antLocation);
        document.getDocumentElement().appendChild(element);
        this.writeCustomScript(document, FILE_SCRIPT_PATH);
        String string2 = "\\.java$";
        String string3 = element.getAttribute("name");
        this.addBinding("compile.single", FILE_SCRIPT_PATH, string3, string, antLocation.virtual, string2, "relative-path", ",");
        this.jumpToBinding("compile.single");
        this.jumpToBuildScript(FILE_SCRIPT_PATH, string3);
    }

    Element createCompileSingleTarget(Document document, Lookup lookup, String string, AntLocation antLocation) {
        String string2;
        String string3 = "compile-selected-files-in-" + antLocation.physical.getNameExt();
        Element element = document.createElement("target");
        element.setAttribute("name", string3);
        Element element2 = document.createElement("fail");
        element2.setAttribute("unless", string);
        element2.appendChild(document.createTextNode(NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_must_set_property", (Object)string)));
        element.appendChild(element2);
        String string4 = this.findClassesOutputDir(antLocation.virtual);
        if (string4 == null) {
            element.appendChild(document.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_must_set_build_classes_dir") + " "));
            string4 = "${build.classes.dir}";
        }
        Element element3 = document.createElement("mkdir");
        element3.setAttribute("dir", string4);
        element.appendChild(element3);
        Element element4 = document.createElement("javac");
        element4.setAttribute("srcdir", antLocation.virtual);
        element4.setAttribute("destdir", string4);
        element4.setAttribute("includes", "${" + string + "}");
        String string5 = this.findSourceLevel(antLocation.virtual);
        if (string5 != null) {
            element4.setAttribute("source", string5);
        }
        if ((string2 = this.findCompileClasspath(antLocation.virtual)) != null) {
            Element element5 = document.createElement("classpath");
            element5.setAttribute("path", string2);
            element4.appendChild(element5);
        }
        element.appendChild(element4);
        return element;
    }

    private void handleDebug() throws IOException, SAXException {
        Element element;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (!this.setOutputsNotified) {
            object5 = ProjectModel.createModel(Util.getProjectLocation((AntProjectHelper)this.helper, (PropertyEvaluator)this.evaluator), FileUtil.toFile((FileObject)this.project.getProjectDirectory()), this.evaluator, this.helper);
            object4 = ((ProjectModel)object5).createCompilationUnitKeys();
            if (!$assertionsDisabled && object4 == null) {
                throw new AssertionError();
            }
            boolean bl = false;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (ProjectModel.CompilationUnitKey)object3.next();
                object = ((ProjectModel)object5).getCompilationUnit((ProjectModel.CompilationUnitKey)object2, false);
                if (((JavaProjectGenerator.JavaCompilationUnit)object).output == null || ((JavaProjectGenerator.JavaCompilationUnit)object).output.size() <= 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.alertOutputs(NbBundle.getMessage((Class)JavaActions.class, (String)"ACTION_debug"));
                this.setOutputsNotified = true;
                return;
            }
        }
        object5 = this.findCommandBinding("run");
        object4 = null;
        Element element2 = null;
        if (object5 != null && ((String[])object5).length <= 2 && (element2 = this.findExistingBuildTarget("run")) != null) {
            object4 = this.targetUsesTaskExactlyOnce(element2, "java");
        }
        if (!this.alert(NbBundle.getMessage((Class)JavaActions.class, (String)"ACTION_debug"), object4 != null ? GENERAL_SCRIPT_PATH : FILE_SCRIPT_PATH)) {
            return;
        }
        object3 = "debug-nb";
        if (object4 != null) {
            object2 = GENERAL_SCRIPT_PATH;
            object = this.readCustomScript(GENERAL_SCRIPT_PATH);
            this.ensureImports(object.getDocumentElement(), (String)object5[0]);
            element = this.createDebugTargetFromTemplate((String)object3, element2, (Element)object4, (Document)object);
        } else {
            object2 = FILE_SCRIPT_PATH;
            object = this.readCustomScript(FILE_SCRIPT_PATH);
            this.ensurePropertiesCopied(object.getDocumentElement());
            element = this.createDebugTargetFromScratch((String)object3, (Document)object);
        }
        Comment comment = object.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_edit_target") + " ");
        object.getDocumentElement().appendChild(comment);
        comment = object.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_more_info_debug") + " ");
        object.getDocumentElement().appendChild(comment);
        object.getDocumentElement().appendChild(element);
        this.writeCustomScript((Document)object, (String)object2);
        this.addBinding("debug", (String)object2, (String)object3, null, null, null, null, null);
        this.jumpToBinding("debug");
        this.jumpToBuildScript((String)object2, (String)object3);
    }

    private Element createNbjpdastart(Document document) {
        Element element = document.createElement("nbjpdastart");
        element.setAttribute("name", ProjectUtils.getInformation((Project)this.project).getDisplayName());
        element.setAttribute("addressproperty", "jpda.address");
        element.setAttribute("transport", "dt_socket");
        return element;
    }

    private void addDebugVMArgs(Element element, Document document) {
        Node node;
        int n;
        NamedNodeMap namedNodeMap = element.getAttributes();
        boolean bl = false;
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            node = (Attr)namedNodeMap.item(n);
            if (!"fork".equals(node.getName())) continue;
            String string = node.getValue();
            if (!"on".equalsIgnoreCase(string) && !"true".equalsIgnoreCase(string) && !"yes".equalsIgnoreCase(string)) break;
            bl = true;
            break;
        }
        if (!bl) {
            element.setAttribute("fork", "true");
        }
        for (n = 0; n < DEBUG_VM_ARGS.length; ++n) {
            node = document.createElement("jvmarg");
            node.setAttribute("value", DEBUG_VM_ARGS[n]);
            element.appendChild(node);
        }
    }

    Element createDebugTargetFromTemplate(String string, Element element, Element element2, Document document) {
        NodeList nodeList = element.getChildNodes();
        int n = -1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) != element2) continue;
            n = i;
            break;
        }
        if (!$assertionsDisabled && n == -1) {
            throw new AssertionError();
        }
        Element element3 = (Element)document.importNode(element, true);
        Element element4 = (Element)element3.getChildNodes().item(n);
        element3.setAttribute("name", string);
        Element element5 = this.createNbjpdastart(document);
        String string2 = element4.getAttribute("classpath");
        if (string2.length() > 0) {
            Element element6 = document.createElement("classpath");
            element6.setAttribute("path", string2);
            element5.appendChild(element6);
        } else {
            NodeList nodeList2 = element4.getElementsByTagName("classpath");
            if (nodeList2.getLength() == 1) {
                Element element7 = (Element)document.importNode(nodeList2.item(0), true);
                element5.appendChild(element7);
            }
        }
        element3.insertBefore(element5, element4);
        this.addDebugVMArgs(element4, document);
        return element3;
    }

    Element createDebugTargetFromScratch(String string, Document document) {
        Element element = document.createElement("target");
        element.setAttribute("name", string);
        Element element2 = document.createElement("path");
        element2.setAttribute("id", "cp");
        element2.appendChild(document.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_set_runtime_cp") + " "));
        element.appendChild(element2);
        Element element3 = this.createNbjpdastart(document);
        Element element4 = document.createElement("classpath");
        element4.setAttribute("refid", "cp");
        element3.appendChild(element4);
        element.appendChild(element3);
        element.appendChild(document.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_set_main_class") + " "));
        Element element5 = document.createElement("java");
        element5.setAttribute("classname", "some.main.Class");
        element4 = document.createElement("classpath");
        element4.setAttribute("refid", "cp");
        element5.appendChild(element4);
        this.addDebugVMArgs(element5, document);
        element.appendChild(element5);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document readCustomScript(String string) throws IOException, SAXException {
        FileObject fileObject = this.helper.getProjectDirectory().getFileObject(string);
        if (fileObject != null) {
            InputStream inputStream = fileObject.getInputStream();
            try {
                Document document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)true, null, null);
                return document;
            }
            finally {
                inputStream.close();
            }
        }
        Document document = XMLUtil.createDocument((String)"project", null, null, null);
        Element element = document.getDocumentElement();
        String string2 = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        element.setAttribute("name", NbBundle.getMessage((Class)JavaActions.class, (String)"LBL_generated_script_name", (Object)string2));
        return document;
    }

    void ensurePropertiesCopied(Element element) {
        if (element.getAttribute("basedir").length() > 0) {
            return;
        }
        element.setAttribute("basedir", "..");
        Element element2 = this.helper.getPrimaryConfigurationData(true);
        Element element3 = Util.findElement((Element)element2, (String)"properties", (String)NS_GENERAL);
        if (element3 != null) {
            Iterator iterator = Util.findSubElements((Element)element3).iterator();
            while (iterator.hasNext()) {
                String string;
                Element element4 = (Element)iterator.next();
                Element element5 = element.getOwnerDocument().createElement("property");
                if (element4.getLocalName().equals("property")) {
                    string = element4.getAttribute("name");
                    if (!$assertionsDisabled && string == null) {
                        throw new AssertionError();
                    }
                    String string2 = Util.findText((Element)element4);
                    if (!$assertionsDisabled && string2 == null) {
                        throw new AssertionError();
                    }
                    element5.setAttribute("name", string);
                    element5.setAttribute("value", string2);
                } else if (element4.getLocalName().equals("property-file")) {
                    string = Util.findText((Element)element4);
                    if (!$assertionsDisabled && string == null) {
                        throw new AssertionError();
                    }
                    element5.setAttribute("file", string);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError(element4);
                }
                element.appendChild(element5);
            }
        }
    }

    void ensureImports(Element element, String string) throws IOException, SAXException {
        Object object;
        String string2;
        String string3;
        File file;
        if (element.getAttribute("basedir").length() > 0) {
            return;
        }
        String string4 = this.evaluator.evaluate(string);
        if (string4 == null) {
            return;
        }
        String string5 = this.helper.resolveFile(string4).toURI().toString();
        Document document = XMLUtil.parse((InputSource)new InputSource(string5), (boolean)false, (boolean)true, null, null);
        String string6 = document.getDocumentElement().getAttribute("basedir");
        if (string6.length() == 0) {
            string6 = ".";
        }
        if ((file = new File(string4)).isAbsolute()) {
            string3 = string4;
            string2 = new File(string6).isAbsolute() ? string6 : PropertyUtils.resolveFile((File)file.getParentFile(), (String)string6).getAbsolutePath();
        } else {
            object = "../";
            string3 = (String)object + string4;
            if (new File(string6).isAbsolute()) {
                string2 = string6;
            } else {
                int n = string4.replace(File.separatorChar, '/').lastIndexOf(47);
                string2 = n == -1 ? (String)object + string6 : (String)object + string4.substring(0, n + 1) + string6;
                string2 = string2.replaceAll("/\\.$", "");
            }
        }
        element.setAttribute("basedir", string2);
        object = element.getOwnerDocument().createElement("import");
        object.setAttribute("file", string3);
        element.appendChild((Node)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCustomScript(Document document, String string) throws IOException {
        FileObject fileObject = this.helper.getProjectDirectory().getFileObject(string);
        if (fileObject == null) {
            fileObject = FileUtil.createData((FileObject)this.helper.getProjectDirectory(), (String)string);
        }
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private Iterator compilationUnitsIterator() {
        Element element = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (element == null) {
            return Collections.EMPTY_SET.iterator();
        }
        List list = Util.findSubElements((Element)element);
        return list.iterator();
    }

    AntLocation findPackageRoot(Lookup lookup) {
        Iterator iterator = this.compilationUnitsIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!$assertionsDisabled && !element.getLocalName().equals("compilation-unit")) {
                throw new AssertionError(element);
            }
            List list = Classpaths.findPackageRootNames(element);
            Map map = Classpaths.findPackageRootsByName(this.helper, this.evaluator, list);
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                FileObject fileObject = (FileObject)entry.getValue();
                if (!JavaActions.containsSelectedJavaSources(fileObject, lookup)) continue;
                return new AntLocation((String)entry.getKey(), fileObject);
            }
        }
        return null;
    }

    static boolean containsSelectedJavaSources(FileObject fileObject, Lookup lookup) {
        Object object;
        HashSet<FileObject> hashSet = new HashSet<FileObject>(lookup.lookup(new Lookup.Template(FileObject.class)).allInstances());
        Iterator iterator = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances().iterator();
        while (iterator.hasNext()) {
            object = (DataObject)iterator.next();
            hashSet.add(object.getPrimaryFile());
        }
        if (hashSet.isEmpty()) {
            return false;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            FileObject fileObject2 = (FileObject)object.next();
            if (fileObject2.isData() && !fileObject2.hasExt("java")) {
                return false;
            }
            if (fileObject2 == fileObject || FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) continue;
            return false;
        }
        return true;
    }

    private Element findCompilationUnit(String string) {
        Iterator iterator = this.compilationUnitsIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Iterator iterator2 = Util.findSubElements((Element)element).iterator();
            while (iterator2.hasNext()) {
                Element element2 = (Element)iterator2.next();
                if (!element2.getLocalName().equals("package-root") || !Util.findText((Element)element2).equals(string)) continue;
                return element;
            }
        }
        return null;
    }

    String findClassesOutputDir(String string) {
        Element element = this.findCompilationUnit(string);
        if (element != null) {
            return this.findClassesOutputDir(element);
        }
        return null;
    }

    private String findClassesOutputDir(Element element) {
        Iterator iterator = Util.findSubElements((Element)element).iterator();
        while (iterator.hasNext()) {
            URL uRL;
            String string;
            String string2;
            Element element2 = (Element)iterator.next();
            if (!element2.getLocalName().equals("built-to") || (string2 = this.evaluator.evaluate(string = Util.findText((Element)element2))) == null) continue;
            File file = this.helper.resolveFile(string2);
            try {
                uRL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
            if (FileUtil.isArchiveFile((URL)uRL)) continue;
            return string;
        }
        return null;
    }

    String findSourceLevel(String string) {
        Element element;
        Element element2 = this.findCompilationUnit(string);
        if (element2 != null && (element = Util.findElement((Element)element2, (String)"source-level", (String)"http://www.netbeans.org/ns/freeform-project-java/2")) != null) {
            return Util.findText((Element)element);
        }
        return null;
    }

    String findCompileClasspath(String string) {
        Element element = this.findCompilationUnit(string);
        if (element != null) {
            Iterator iterator = Util.findSubElements((Element)element).iterator();
            while (iterator.hasNext()) {
                String string2;
                Element element2 = (Element)iterator.next();
                if (!element2.getLocalName().equals("classpath") || !(string2 = element2.getAttribute("mode")).equals("compile")) continue;
                return Util.findText((Element)element2);
            }
        }
        return null;
    }

    void addBinding(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IOException {
        Element element = this.helper.getPrimaryConfigurationData(true);
        Element element2 = Util.findElement((Element)element, (String)"ide-actions", (String)NS_GENERAL);
        if (element2 == null) {
            element2 = element.getOwnerDocument().createElementNS(NS_GENERAL, "ide-actions");
            Util.appendChildElement((Element)element, (Element)element2, (String[])rootElementsOrder);
        }
        Document document = element.getOwnerDocument();
        Element element3 = document.createElementNS(NS_GENERAL, "action");
        element3.setAttribute("name", string);
        Element element4 = document.createElementNS(NS_GENERAL, "script");
        element4.appendChild(document.createTextNode(string2));
        element3.appendChild(element4);
        Element element5 = document.createElementNS(NS_GENERAL, "target");
        element5.appendChild(document.createTextNode(string3));
        element3.appendChild(element5);
        if (string4 != null) {
            Element element6;
            Element element7 = document.createElementNS(NS_GENERAL, "context");
            Element element8 = document.createElementNS(NS_GENERAL, "property");
            element8.appendChild(document.createTextNode(string4));
            element7.appendChild(element8);
            Element element9 = document.createElementNS(NS_GENERAL, "folder");
            element9.appendChild(document.createTextNode(string5));
            element7.appendChild(element9);
            if (string6 != null) {
                element6 = document.createElementNS(NS_GENERAL, "pattern");
                element6.appendChild(document.createTextNode(string6));
                element7.appendChild(element6);
            }
            element6 = document.createElementNS(NS_GENERAL, "format");
            element6.appendChild(document.createTextNode(string7));
            element7.appendChild(element6);
            Element element10 = document.createElementNS(NS_GENERAL, "arity");
            if (string8 != null) {
                Element element11 = document.createElementNS(NS_GENERAL, "separated-files");
                element11.appendChild(document.createTextNode(string8));
                element10.appendChild(element11);
            } else {
                element10.appendChild(document.createElementNS(NS_GENERAL, "one-file-only"));
            }
            element7.appendChild(element10);
            element3.appendChild(element7);
        } else {
            Element element12;
            Element element13 = Util.findElement((Element)element, (String)"view", (String)NS_GENERAL);
            if (element13 != null && (element12 = Util.findElement((Element)element13, (String)"context-menu", (String)NS_GENERAL)) != null) {
                Element element14 = document.createElementNS(NS_GENERAL, "ide-action");
                element14.setAttribute("name", string);
                element12.appendChild(element14);
            }
        }
        element2.appendChild(element3);
        this.helper.putPrimaryConfigurationData(element, true);
        ProjectManager.getDefault().saveProject(this.project);
    }

    private void jumpToBuildScript(String string, String string2) {
        this.jumpToFile(string, string2, "target", "name");
    }

    private void jumpToBinding(String string) {
        this.jumpToFile("nbproject/project.xml", string, "action", "name");
    }

    private void jumpToFile(String string, String string2, String string3, String string4) {
        DataObject dataObject;
        int n;
        FileObject fileObject = this.helper.getProjectDirectory().getFileObject(string);
        if (fileObject == null) {
            return;
        }
        try {
            n = JavaActions.findLine(fileObject, string2, string3, string4);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return;
        }
        if (n == -1) {
            n = 0;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new AssertionError((Object)dataObjectNotFoundException);
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie != null) {
            try {
                lineCookie.getLineSet().getCurrent(n).show(2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ErrorManager.getDefault().getInstance(JavaActions.class.getName()).log(16, indexOutOfBoundsException + " [file=" + fileObject + " match=" + string2 + " line=" + n + "]");
                lineCookie.getLineSet().getCurrent(0).show(2);
            }
        }
    }

    static final int findLine(FileObject fileObject, String string, String string2, String string3) throws IOException, SAXException, ParserConfigurationException {
        InputSource inputSource = new InputSource(fileObject.getURL().toString());
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        int[] nArray = new int[]{-1};
        class Handler
        extends DefaultHandler {
            private Locator locator;
            private final /* synthetic */ int[] val$line;
            private final /* synthetic */ String val$elementLocalName;
            private final /* synthetic */ String val$match;
            private final /* synthetic */ String val$elementAttributeName;

            Handler(int[] nArray, String string, String string2, String string3) {
                this.val$line = nArray;
                this.val$elementLocalName = string;
                this.val$match = string2;
                this.val$elementAttributeName = string3;
            }

            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (this.val$line[0] == -1 && string2.equals(this.val$elementLocalName) && this.val$match.equals(attributes.getValue(this.val$elementAttributeName))) {
                    this.val$line[0] = this.locator.getLineNumber() - 1;
                }
            }
        }
        sAXParser.parse(inputSource, (DefaultHandler)new Handler(nArray, string2, string, string3));
        return nArray[0];
    }

    Element findExistingBuildTarget(String string) throws IOException, SAXException {
        String string2;
        String[] stringArray = this.findCommandBinding(string);
        if (stringArray == null) {
            return null;
        }
        String string3 = stringArray[0];
        if (!$assertionsDisabled && string3 == null) {
            throw new AssertionError();
        }
        if (stringArray.length == 1) {
            string2 = null;
        } else if (stringArray.length == 2) {
            string2 = stringArray[1];
        } else {
            return null;
        }
        String string4 = this.evaluator.evaluate(string3);
        if (string4 == null) {
            return null;
        }
        File file = this.helper.resolveFile(string4);
        String string5 = file.toURI().toString();
        Document document = XMLUtil.parse((InputSource)new InputSource(string5), (boolean)false, (boolean)true, null, null);
        if (string2 == null && (string2 = document.getDocumentElement().getAttribute("default")) == null) {
            return null;
        }
        Iterator iterator = Util.findSubElements((Element)document.getDocumentElement()).iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!element.getLocalName().equals("target") || !string2.equals(element.getAttribute("name"))) continue;
            return element;
        }
        return null;
    }

    String[] findCommandBinding(String string) {
        Element element = this.helper.getPrimaryConfigurationData(true);
        Element element2 = Util.findElement((Element)element, (String)"ide-actions", (String)NS_GENERAL);
        if (element2 == null) {
            return null;
        }
        String string2 = "build.xml";
        Iterator iterator = Util.findSubElements((Element)element2).iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            if (!$assertionsDisabled && !element3.getLocalName().equals("action")) {
                throw new AssertionError();
            }
            if (!element3.getAttribute("name").equals(string)) continue;
            Element element4 = Util.findElement((Element)element3, (String)"script", (String)NS_GENERAL);
            if (element4 != null) {
                string2 = Util.findText((Element)element4);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            Iterator iterator2 = Util.findSubElements((Element)element3).iterator();
            while (iterator2.hasNext()) {
                Element element5 = (Element)iterator2.next();
                if (!element5.getLocalName().equals("target")) continue;
                arrayList.add(Util.findText((Element)element5));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    Element targetUsesTaskExactlyOnce(Element element, String string) {
        Iterator iterator = Util.findSubElements((Element)element).iterator();
        Element element2 = null;
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            if (!element3.getLocalName().equals(string)) continue;
            if (element2 != null) {
                return null;
            }
            element2 = element3;
        }
        return element2;
    }

    static {
        $assertionsDisabled = !JavaActions.class.desiredAssertionStatus();
        ACTIONS = new String[]{"compile.single", "debug"};
        DEBUG_VM_ARGS = new String[]{"-Xdebug", "-Xnoagent", "-Djava.compiler=none", "-Xrunjdwp:transport=dt_socket,address=${jpda.address}"};
        rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects"};
    }

    static final class AntLocation {
        public final String virtual;
        public final FileObject physical;

        public AntLocation(String string, FileObject fileObject) {
            this.virtual = string;
            this.physical = fileObject;
        }

        public String toString() {
            return "AntLocation[" + this.virtual + "=" + this.physical + "]";
        }
    }
}

