/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.modules.java.freeform.ui.SourceFoldersPanel;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClasspathPanel
extends JPanel
implements HelpCtx.Provider {
    private DefaultListModel listModel;
    private File lastChosenFile = null;
    private boolean isSeparateClasspath = true;
    private List compUnitsKeys;
    private boolean ignoreEvent;
    private ProjectModel model;
    private JButton addClasspath;
    private JList classpath;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JButton moveDown;
    private JButton moveUp;
    private JButton removeClasspath;
    private JCheckBox separateClasspath;
    private JComboBox sourceFolder;

    public ClasspathPanel() {
        this(true);
    }

    public ClasspathPanel(boolean bl) {
        this.initComponents();
        this.jTextArea1.setBackground(this.getBackground());
        this.listModel = new DefaultListModel();
        this.classpath.setModel(this.listModel);
        if (!bl) {
            this.jTextArea1.setText(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_Explanation"));
        }
        this.jTextArea1.setDisabledTextColor(this.jLabel2.getForeground());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ClasspathPanel.class);
    }

    private void updateControls() {
        this.sourceFolder.removeAllItems();
        this.compUnitsKeys = this.model.createCompilationUnitKeys();
        this.isSeparateClasspath = !ProjectModel.isSingleCompilationUnit(this.compUnitsKeys);
        List list = ClasspathPanel.createComboContent(this.compUnitsKeys, this.model.getEvaluator(), this.model.getNBProjectFolder());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.sourceFolder.addItem(string);
        }
        if (list.size() > 0) {
            this.ignoreEvent = true;
            this.sourceFolder.setSelectedIndex(0);
            this.ignoreEvent = false;
        }
        this.loadClasspath();
        boolean bl = this.model.canHaveSeparateClasspath();
        this.separateClasspath.setEnabled(bl);
        if (bl && this.isSeparateClasspath && !this.model.canCreateSingleCompilationUnit()) {
            this.separateClasspath.setEnabled(false);
        }
        this.jLabel2.setEnabled(bl && this.isSeparateClasspath);
        this.sourceFolder.setEnabled(bl && this.isSeparateClasspath);
        this.ignoreEvent = true;
        this.separateClasspath.setSelected(this.isSeparateClasspath);
        this.ignoreEvent = false;
        this.addClasspath.setEnabled(this.compUnitsKeys.size() > 0);
        this.classpath.setEnabled(this.compUnitsKeys.size() > 0);
    }

    static List createComboContent(List list, PropertyEvaluator propertyEvaluator, File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProjectModel.CompilationUnitKey compilationUnitKey = (ProjectModel.CompilationUnitKey)iterator.next();
            String string = compilationUnitKey.locations.size() == 1 ? (compilationUnitKey.label != null ? compilationUnitKey.label + " [" + SourceFoldersPanel.getLocationDisplayName(propertyEvaluator, file, (String)compilationUnitKey.locations.get(0)) + "]" : ClasspathPanel.convertListToString(compilationUnitKey.locations)) : ClasspathPanel.convertListToString(compilationUnitKey.locations);
            arrayList.add(string);
        }
        return arrayList;
    }

    private static String convertListToString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(File.pathSeparatorChar + " ");
        }
        return stringBuffer.toString();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.addClasspath = new JButton();
        this.removeClasspath = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.classpath = new JList();
        this.jPanel1 = new JPanel();
        this.sourceFolder = new JComboBox();
        this.moveUp = new JButton();
        this.moveDown = new JButton();
        this.jTextArea1 = new JTextArea();
        this.separateClasspath = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(275, 202));
        this.jLabel2.setLabelFor(this.sourceFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_jLabel2"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_jLabel2"));
        this.jLabel3.setLabelFor(this.classpath);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_jLabel3"));
        Mnemonics.setLocalizedText((AbstractButton)this.addClasspath, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"BTN_ClasspathPanel_addClasspath"));
        this.addClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.addClasspathActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.addClasspath, gridBagConstraints);
        this.addClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_addClasspath"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeClasspath, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"BTN_ClasspathPanel_removeClasspath"));
        this.removeClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.removeClasspathActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.removeClasspath, gridBagConstraints);
        this.removeClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_removeClasspath"));
        this.classpath.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClasspathPanel.this.classpathValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.classpath);
        this.classpath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_classpath"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.sourceFolder.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ClasspathPanel.this.sourceFolderItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.sourceFolder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.moveUp.setText(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Up"));
        this.moveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.moveUpActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.moveUp, gridBagConstraints);
        this.moveUp.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_ClasspathPanel_noveUp"));
        this.moveDown.setText(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Down"));
        this.moveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.moveDownActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.moveDown, gridBagConstraints);
        this.moveDown.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_ClasspathPanel_moveDown"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"MSG_ClasspathPanel_jTextArea"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSN_ClasspathPanel_jTextArea"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_jTextArea"));
        this.separateClasspath.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.separateClasspath, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_sepatateClasspath"));
        this.separateClasspath.setMargin(new Insets(0, 0, 0, 0));
        this.separateClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.separateClasspathActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.separateClasspath, gridBagConstraints);
        this.separateClasspath.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_ClasspathPanel_separateClasspath"));
    }

    private void classpathValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private void separateClasspathActionPerformed(ActionEvent actionEvent) {
        if (this.ignoreEvent) {
            return;
        }
        this.applyChanges();
        this.isSeparateClasspath = this.separateClasspath.isSelected();
        this.model.updateCompilationUnits(this.isSeparateClasspath);
        this.updateControls();
    }

    private void moveDownActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.classpath.getSelectedIndices();
        if (nArray.length == 0 || nArray[nArray.length - 1] == this.listModel.getSize() - 1) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Object e = this.listModel.remove(n);
            this.listModel.add(++n, e);
            nArray[i] = n;
        }
        this.classpath.setSelectedIndices(nArray);
        this.applyChanges();
        this.updateButtons();
    }

    private void moveUpActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.classpath.getSelectedIndices();
        if (nArray.length == 0 || nArray[0] == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Object e = this.listModel.remove(n);
            this.listModel.add(--n, e);
            nArray[i] = n;
        }
        this.classpath.setSelectedIndices(nArray);
        this.applyChanges();
        this.updateButtons();
    }

    private void sourceFolderItemStateChanged(ItemEvent itemEvent) {
        if (this.ignoreEvent) {
            return;
        }
        if (itemEvent.getStateChange() == 2) {
            int n = this.findIndex(itemEvent.getItem());
            if (n != -1) {
                this.saveClasspath(n);
            }
        } else {
            this.loadClasspath();
        }
        this.updateButtons();
    }

    private int findIndex(Object object) {
        for (int i = 0; i < this.sourceFolder.getModel().getSize(); ++i) {
            if (!this.sourceFolder.getModel().getElementAt(i).equals(object)) continue;
            return i;
        }
        return -1;
    }

    private void saveClasspath(int n) {
        ProjectModel.CompilationUnitKey compilationUnitKey = (ProjectModel.CompilationUnitKey)this.compUnitsKeys.get(n);
        JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = this.model.getCompilationUnit(compilationUnitKey, this.model.isTestSourceFolder(n));
        this.updateCompilationUnitCompileClasspath(javaCompilationUnit);
    }

    private void loadClasspath() {
        int n;
        if (this.isSeparateClasspath) {
            n = this.sourceFolder.getSelectedIndex();
            if (n == -1) {
                return;
            }
        } else {
            n = 0;
        }
        ProjectModel.CompilationUnitKey compilationUnitKey = (ProjectModel.CompilationUnitKey)this.compUnitsKeys.get(n);
        JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = this.model.getCompilationUnit(compilationUnitKey, this.model.isTestSourceFolder(n));
        this.updateJListClassPath(javaCompilationUnit.classpath);
    }

    private void updateCompilationUnitCompileClasspath(JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit) {
        Object object;
        ArrayList<JavaProjectGenerator.JavaCompilationUnit.CP> arrayList = javaCompilationUnit.classpath;
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                JavaProjectGenerator.JavaCompilationUnit.CP cP = (JavaProjectGenerator.JavaCompilationUnit.CP)object.next();
                if (!cP.mode.equals("compile")) continue;
                object.remove();
            }
        }
        if (this.classpath.getModel().getSize() == 0) {
            return;
        }
        object = new StringBuffer();
        for (int i = 0; i < this.classpath.getModel().getSize(); ++i) {
            File file = new File((String)this.classpath.getModel().getElementAt(i));
            String string = Util.relativizeLocation((File)this.model.getBaseFolder(), (File)this.model.getNBProjectFolder(), (File)file);
            ((StringBuffer)object).append(string);
            if (i + 1 >= this.classpath.getModel().getSize()) continue;
            ((StringBuffer)object).append(File.pathSeparatorChar);
        }
        if (((StringBuffer)object).length() > 0) {
            if (arrayList == null) {
                javaCompilationUnit.classpath = arrayList = new ArrayList<JavaProjectGenerator.JavaCompilationUnit.CP>();
            }
            JavaProjectGenerator.JavaCompilationUnit.CP cP = new JavaProjectGenerator.JavaCompilationUnit.CP();
            cP.mode = "compile";
            cP.classpath = ((StringBuffer)object).toString();
            arrayList.add(cP);
        }
    }

    private void updateJListClassPath(List list) {
        this.listModel.removeAllElements();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit.CP cP = (JavaProjectGenerator.JavaCompilationUnit.CP)iterator.next();
            if (!cP.mode.equals("compile")) continue;
            String[] stringArray = PropertyUtils.tokenizePath((String)this.model.getEvaluator().evaluate(cP.classpath));
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                string = PropertyUtils.resolveFile((File)this.model.getNBProjectFolder(), (String)string).getAbsolutePath();
                if (string == null) continue;
                this.listModel.addElement(string);
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int[] nArray = this.classpath.getSelectedIndices();
        this.removeClasspath.setEnabled(this.listModel.getSize() > 0 && nArray.length != 0);
        this.moveUp.setEnabled(nArray.length > 0 && nArray[0] != 0);
        this.moveDown.setEnabled(nArray.length > 0 && nArray[nArray.length - 1] != this.listModel.getSize() - 1);
    }

    private void removeClasspathActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.classpath.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            this.listModel.remove(nArray[i] - i);
        }
        this.applyChanges();
        this.updateButtons();
    }

    private void addClasspathActionPerformed(ActionEvent actionEvent) {
        Object object;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(true);
        if (this.lastChosenFile != null) {
            jFileChooser.setSelectedFile(this.lastChosenFile);
        } else {
            object = this.model.getBaseFolder().listFiles();
            if (object != null && ((File[])object).length > 0) {
                jFileChooser.setSelectedFile(object[0]);
            } else {
                jFileChooser.setSelectedFile(this.model.getBaseFolder());
            }
        }
        jFileChooser.setDialogTitle(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_Browse_Classpath"));
        object = new SimpleFileFilter(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
        jFileChooser.setFileFilter((FileFilter)object);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (0 == jFileChooser.showOpenDialog(this)) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = FileUtil.normalizeFile((File)fileArray[i]);
                if (!((FileFilter)object).accept(file)) continue;
                this.listModel.addElement(file.getAbsolutePath());
                this.lastChosenFile = file;
            }
            this.applyChanges();
            this.updateButtons();
        }
    }

    private void applyChanges() {
        if (this.isSeparateClasspath) {
            if (this.sourceFolder.getSelectedIndex() != -1) {
                this.saveClasspath(this.sourceFolder.getSelectedIndex());
            }
        } else {
            this.saveClasspath(0);
        }
    }

    public void setModel(ProjectModel projectModel) {
        this.model = projectModel;
        this.updateControls();
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class Panel
    implements ProjectPropertiesPanel,
    ChangeListener {
        private ClasspathPanel panel;
        private ProjectModel model;

        public Panel(ProjectModel projectModel) {
            this.model = projectModel;
        }

        public void storeValues() {
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$ClasspathPanel == null ? (class$org$netbeans$modules$java$freeform$ui$ClasspathPanel = ClasspathPanel.class$("org.netbeans.modules.java.freeform.ui.ClasspathPanel")) : class$org$netbeans$modules$java$freeform$ui$ClasspathPanel), (String)"LBL_ProjectCustomizer_Category_Classpath");
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = new ClasspathPanel(false);
                this.panel.setModel(this.model);
                this.model.addChangeListener(this);
            }
            return this.panel;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.panel.updateControls();
        }

        public int getPreferredPosition() {
            return 200;
        }
    }
}

