/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;

public class ProjectModel {
    private File baseFolder;
    private File nbProjectFolder;
    private PropertyEvaluator evaluator;
    private String sourceLevel;
    private List sourceFolders;
    public List javaCompilationUnitsList;
    private Set addedSourceFolders;
    private Set removedSourceFolders;
    public static final String TYPE_JAVA = "java";
    public static final String CLASSPATH_MODE_COMPILE = "compile";
    private static final SpecificationVersion JDK_MAX_SUPPORTED_VERSION;
    private final Set listeners = new HashSet(1);
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProjectModel(File file, File file2, PropertyEvaluator propertyEvaluator, List list, List list2) {
        this.baseFolder = file;
        this.nbProjectFolder = file2;
        this.evaluator = propertyEvaluator;
        this.sourceFolders = list;
        this.javaCompilationUnitsList = list2;
        if (this.javaCompilationUnitsList.size() > 0) {
            this.sourceLevel = ((JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get((int)0)).sourceLevel;
        }
        if (this.sourceLevel == null) {
            this.setSourceLevel(ProjectModel.getDefaultSourceLevel());
        }
        this.resetState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    private void resetState() {
        this.addedSourceFolders = new HashSet();
        this.removedSourceFolders = new HashSet();
    }

    public static ProjectModel createEmptyModel(File file, File file2, PropertyEvaluator propertyEvaluator) {
        return new ProjectModel(file, file2, propertyEvaluator, new ArrayList(), new ArrayList());
    }

    public static ProjectModel createModel(final File file, final File file2, final PropertyEvaluator propertyEvaluator, final AntProjectHelper antProjectHelper) {
        return (ProjectModel)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                ProjectModel projectModel = new ProjectModel(file, file2, propertyEvaluator, JavaProjectGenerator.getSourceFolders(antProjectHelper, ProjectModel.TYPE_JAVA), JavaProjectGenerator.getJavaCompilationUnits(antProjectHelper, Util.getAuxiliaryConfiguration((AntProjectHelper)antProjectHelper)));
                ProjectModel.updateStyle(projectModel.sourceFolders);
                return projectModel;
            }
        });
    }

    public static void instantiateJavaProject(AntProjectHelper antProjectHelper, ProjectModel projectModel) throws IOException {
        List list;
        List list2 = projectModel.updatePrincipalSourceFolders(projectModel.sourceFolders, true);
        if (list2.size() > 0) {
            JavaProjectGenerator.putSourceFolders(antProjectHelper, list2, null);
        }
        if (list2.size() > 0) {
            JavaProjectGenerator.putSourceViews(antProjectHelper, list2, null);
        }
        JavaProjectGenerator.putJavaCompilationUnits(antProjectHelper, Util.getAuxiliaryConfiguration((AntProjectHelper)antProjectHelper), projectModel.javaCompilationUnitsList);
        List list3 = JavaProjectGenerator.guessExports(projectModel.evaluator, projectModel.baseFolder, JavaProjectGenerator.getTargetMappings(antProjectHelper), projectModel.javaCompilationUnitsList);
        if (list3.size() > 0) {
            JavaProjectGenerator.putExports(antProjectHelper, list3);
        }
        if ((list = JavaProjectGenerator.guessSubprojects(projectModel.evaluator, projectModel.javaCompilationUnitsList, projectModel.baseFolder, projectModel.nbProjectFolder)).size() > 0) {
            JavaProjectGenerator.putSubprojects(antProjectHelper, list);
        }
        projectModel.resetState();
    }

    public static void saveProject(final AntProjectHelper antProjectHelper, final ProjectModel projectModel) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                JavaProjectGenerator.putSourceFolders(antProjectHelper, projectModel.sourceFolders, ProjectModel.TYPE_JAVA);
                JavaProjectGenerator.putSourceViews(antProjectHelper, projectModel.sourceFolders, "packages");
                List list = JavaProjectGenerator.getSourceFolders(antProjectHelper, null);
                list = projectModel.updatePrincipalSourceFolders(list, false);
                JavaProjectGenerator.putSourceFolders(antProjectHelper, list, null);
                AuxiliaryConfiguration auxiliaryConfiguration = Util.getAuxiliaryConfiguration((AntProjectHelper)antProjectHelper);
                JavaProjectGenerator.putJavaCompilationUnits(antProjectHelper, auxiliaryConfiguration, projectModel.javaCompilationUnitsList);
                projectModel.resetState();
                List list2 = JavaProjectGenerator.guessExports(projectModel.getEvaluator(), projectModel.baseFolder, JavaProjectGenerator.getTargetMappings(antProjectHelper), projectModel.javaCompilationUnitsList);
                JavaProjectGenerator.putExports(antProjectHelper, list2);
                List list3 = JavaProjectGenerator.guessSubprojects(projectModel.getEvaluator(), projectModel.javaCompilationUnitsList, projectModel.baseFolder, projectModel.nbProjectFolder);
                JavaProjectGenerator.putSubprojects(antProjectHelper, list3);
                List list4 = JavaProjectGenerator.guessBuildFolders(projectModel.getEvaluator(), projectModel.javaCompilationUnitsList, projectModel.baseFolder, projectModel.nbProjectFolder);
                JavaProjectGenerator.putBuildFolders(antProjectHelper, list4);
                return null;
            }
        });
    }

    List updatePrincipalSourceFolders(List list, boolean bl) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>(list);
        Iterator iterator = this.addedSourceFolders.iterator();
        while (iterator.hasNext()) {
            JavaProjectGenerator.SourceFolder sourceFolder;
            object2 = (String)iterator.next();
            if (!this.isExternalSourceRoot((String)object2)) continue;
            boolean bl2 = false;
            object = "";
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                sourceFolder = (JavaProjectGenerator.SourceFolder)iterator2.next();
                if (sourceFolder.location.equals(object2) && sourceFolder.type == null) {
                    bl2 = true;
                    break;
                }
                if (!sourceFolder.location.equals(object2) || sourceFolder.type == null) continue;
                object = sourceFolder.label;
            }
            if (bl2) continue;
            sourceFolder = new JavaProjectGenerator.SourceFolder();
            sourceFolder.location = object2;
            sourceFolder.label = object;
            arrayList.add(sourceFolder);
        }
        iterator = this.removedSourceFolders.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (!this.isExternalSourceRoot((String)object2)) continue;
            Iterator iterator3 = arrayList.iterator();
            while (iterator3.hasNext()) {
                object = (JavaProjectGenerator.SourceFolder)iterator3.next();
                if (!((JavaProjectGenerator.SourceFolder)object).location.equals(object2) || ((JavaProjectGenerator.SourceFolder)object).type != null) continue;
                iterator3.remove();
            }
        }
        if (bl && !this.baseFolder.equals(this.nbProjectFolder)) {
            object2 = new JavaProjectGenerator.SourceFolder();
            ((JavaProjectGenerator.SourceFolder)object2).location = "${project.dir}";
            ((JavaProjectGenerator.SourceFolder)object2).label = this.baseFolder.getName();
            arrayList.add(object2);
        }
        return arrayList;
    }

    private boolean isExternalSourceRoot(String string) {
        File file;
        String string2;
        String string3 = this.baseFolder.getAbsolutePath();
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separatorChar;
        }
        if (!(string2 = this.nbProjectFolder.getAbsolutePath()).endsWith(File.separator)) {
            string2 = string2 + File.separatorChar;
        }
        if ((file = Util.resolveFile((PropertyEvaluator)this.evaluator, (File)this.baseFolder, (String)string)) == null) {
            return false;
        }
        string = file.getAbsolutePath();
        return !string.startsWith(string3) && !string.startsWith(string2);
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public File getNBProjectFolder() {
        return this.nbProjectFolder;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public int getSourceFoldersCount() {
        return this.sourceFolders.size();
    }

    public JavaProjectGenerator.SourceFolder getSourceFolder(int n) {
        return (JavaProjectGenerator.SourceFolder)this.sourceFolders.get(n);
    }

    public void moveSourceFolder(int n, int n2) {
        JavaProjectGenerator.SourceFolder sourceFolder = (JavaProjectGenerator.SourceFolder)this.sourceFolders.remove(n);
        this.sourceFolders.add(n2, sourceFolder);
    }

    public void addSourceFolder(JavaProjectGenerator.SourceFolder sourceFolder, boolean bl) {
        Object object;
        List list = this.createCompilationUnitKeys();
        boolean bl2 = ProjectModel.isSingleCompilationUnit(list);
        if (bl2) {
            object = (JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get(0);
            if (((JavaProjectGenerator.JavaCompilationUnit)object).isTests != bl) {
                this.updateCompilationUnits(true);
                bl2 = false;
            }
        }
        this.sourceFolders.add(sourceFolder);
        if (bl2) {
            if (TYPE_JAVA.equals(sourceFolder.type)) {
                object = (JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get(0);
                ((JavaProjectGenerator.JavaCompilationUnit)object).packageRoots.add(sourceFolder.location);
            }
        } else {
            object = this.createCompilationUnitKeys().iterator();
            while (object.hasNext()) {
                CompilationUnitKey compilationUnitKey = (CompilationUnitKey)object.next();
                this.getCompilationUnit(compilationUnitKey, bl);
            }
        }
        if (this.removedSourceFolders.contains(sourceFolder.location)) {
            this.removedSourceFolders.remove(sourceFolder.location);
        } else {
            this.addedSourceFolders.add(sourceFolder.location);
        }
        this.fireChangeEvent();
    }

    public void removeSourceFolder(int n) {
        JavaProjectGenerator.SourceFolder sourceFolder = (JavaProjectGenerator.SourceFolder)this.sourceFolders.get(n);
        if (TYPE_JAVA.equals(sourceFolder.type)) {
            this.removeSourceLocation(sourceFolder.location);
        }
        this.sourceFolders.remove(n);
        if (this.addedSourceFolders.contains(sourceFolder.location)) {
            this.addedSourceFolders.remove(sourceFolder.location);
        } else {
            this.removedSourceFolders.add(sourceFolder.location);
        }
        this.fireChangeEvent();
    }

    public void clearSourceFolders() {
        this.sourceFolders.clear();
        this.javaCompilationUnitsList.clear();
        this.fireChangeEvent();
    }

    public String getSourceLevel() {
        return this.sourceLevel;
    }

    public void setSourceLevel(String string) {
        if (this.sourceLevel == null && string == null || this.sourceLevel != null && this.sourceLevel.equals(string)) {
            return;
        }
        this.sourceLevel = string;
        Iterator iterator = this.javaCompilationUnitsList.iterator();
        while (iterator.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = (JavaProjectGenerator.JavaCompilationUnit)iterator.next();
            javaCompilationUnit.sourceLevel = string;
        }
    }

    public boolean canHaveSeparateClasspath() {
        return this.sourceFolders.size() > 1 || this.javaCompilationUnitsList.size() > 1;
    }

    public boolean canCreateSingleCompilationUnit() {
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = this.javaCompilationUnitsList.iterator();
        while (iterator.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = (JavaProjectGenerator.JavaCompilationUnit)iterator.next();
            if (javaCompilationUnit.isTests) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        return !bl || !bl2;
    }

    public static boolean isSingleCompilationUnit(List list) {
        return list.size() == 1 && ((CompilationUnitKey)list.get((int)0)).label == null;
    }

    public List createCompilationUnitKeys() {
        CompilationUnitKey compilationUnitKey;
        Object object;
        ArrayList<CompilationUnitKey> arrayList = new ArrayList<CompilationUnitKey>();
        Iterator iterator = this.javaCompilationUnitsList.iterator();
        while (iterator.hasNext()) {
            object = (JavaProjectGenerator.JavaCompilationUnit)iterator.next();
            compilationUnitKey = new CompilationUnitKey();
            compilationUnitKey.locations = ((JavaProjectGenerator.JavaCompilationUnit)object).packageRoots;
            compilationUnitKey.label = null;
            arrayList.add(compilationUnitKey);
        }
        iterator = this.sourceFolders.iterator();
        while (iterator.hasNext()) {
            object = (JavaProjectGenerator.SourceFolder)iterator.next();
            if (!TYPE_JAVA.equals(((JavaProjectGenerator.SourceFolder)object).type)) continue;
            compilationUnitKey = new CompilationUnitKey();
            compilationUnitKey.locations = new ArrayList();
            compilationUnitKey.locations.add(((JavaProjectGenerator.SourceFolder)object).location);
            compilationUnitKey.label = ((JavaProjectGenerator.SourceFolder)object).label;
            int n = arrayList.indexOf(compilationUnitKey);
            if (n != -1) {
                CompilationUnitKey compilationUnitKey2 = (CompilationUnitKey)arrayList.get(n);
                compilationUnitKey2.label = ((JavaProjectGenerator.SourceFolder)object).label;
                continue;
            }
            boolean bl = false;
            Iterator iterator2 = this.javaCompilationUnitsList.iterator();
            while (iterator2.hasNext()) {
                JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = (JavaProjectGenerator.JavaCompilationUnit)iterator2.next();
                if (!javaCompilationUnit.packageRoots.contains(((JavaProjectGenerator.SourceFolder)object).location)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(compilationUnitKey);
        }
        return arrayList;
    }

    public void updateCompilationUnits(boolean bl) {
        if (bl) {
            Object object;
            Object object2;
            Object object3;
            String string = null;
            List list = null;
            if (this.javaCompilationUnitsList.size() > 0) {
                object3 = ((JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get((int)0)).classpath;
                if (object3 != null) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (JavaProjectGenerator.JavaCompilationUnit.CP)object2.next();
                        if (!((JavaProjectGenerator.JavaCompilationUnit.CP)object).mode.equals(CLASSPATH_MODE_COMPILE)) continue;
                        string = ((JavaProjectGenerator.JavaCompilationUnit.CP)object).classpath;
                        break;
                    }
                }
                list = ((JavaProjectGenerator.JavaCompilationUnit)this.javaCompilationUnitsList.get((int)0)).output;
            }
            this.javaCompilationUnitsList.clear();
            object3 = this.sourceFolders.iterator();
            while (object3.hasNext()) {
                object2 = (JavaProjectGenerator.SourceFolder)object3.next();
                object = new JavaProjectGenerator.JavaCompilationUnit();
                ((JavaProjectGenerator.JavaCompilationUnit)object).packageRoots = new ArrayList();
                ((JavaProjectGenerator.JavaCompilationUnit)object).packageRoots.add(((JavaProjectGenerator.SourceFolder)object2).location);
                if (string != null) {
                    JavaProjectGenerator.JavaCompilationUnit.CP cP = new JavaProjectGenerator.JavaCompilationUnit.CP();
                    cP.mode = CLASSPATH_MODE_COMPILE;
                    cP.classpath = string;
                    ((JavaProjectGenerator.JavaCompilationUnit)object).classpath = new ArrayList();
                    ((JavaProjectGenerator.JavaCompilationUnit)object).classpath.add(cP);
                }
                if (list != null) {
                    ((JavaProjectGenerator.JavaCompilationUnit)object).output = new ArrayList();
                    ((JavaProjectGenerator.JavaCompilationUnit)object).output.addAll(list);
                }
                ((JavaProjectGenerator.JavaCompilationUnit)object).sourceLevel = this.sourceLevel;
                this.javaCompilationUnitsList.add(object);
            }
        } else {
            Object object;
            Object object4;
            Object object5;
            JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit;
            Object object6;
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.sourceFolders.iterator();
            while (iterator.hasNext()) {
                object6 = (JavaProjectGenerator.SourceFolder)iterator.next();
                arrayList.add(((JavaProjectGenerator.SourceFolder)object6).location);
            }
            object6 = new LinkedHashSet();
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            iterator = this.javaCompilationUnitsList.iterator();
            while (iterator.hasNext()) {
                javaCompilationUnit = (JavaProjectGenerator.JavaCompilationUnit)iterator.next();
                if (javaCompilationUnit.output != null) {
                    linkedHashSet.addAll(javaCompilationUnit.output);
                }
                if (javaCompilationUnit.classpath == null) continue;
                object5 = javaCompilationUnit.classpath.iterator();
                while (object5.hasNext()) {
                    object4 = (JavaProjectGenerator.JavaCompilationUnit.CP)object5.next();
                    if (!((JavaProjectGenerator.JavaCompilationUnit.CP)object4).mode.equals(CLASSPATH_MODE_COMPILE)) continue;
                    object = PropertyUtils.tokenizePath((String)((JavaProjectGenerator.JavaCompilationUnit.CP)object4).classpath);
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        object6.add(object[i]);
                    }
                }
            }
            this.javaCompilationUnitsList.clear();
            javaCompilationUnit = new JavaProjectGenerator.JavaCompilationUnit();
            javaCompilationUnit.packageRoots = arrayList;
            object5 = new JavaProjectGenerator.JavaCompilationUnit.CP();
            if (object6.size() > 0) {
                object4 = new StringBuffer();
                iterator = object6.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    ((StringBuffer)object4).append((String)object);
                    if (!iterator.hasNext()) continue;
                    ((StringBuffer)object4).append(File.pathSeparatorChar);
                }
                ((JavaProjectGenerator.JavaCompilationUnit.CP)object5).classpath = ((StringBuffer)object4).toString();
                ((JavaProjectGenerator.JavaCompilationUnit.CP)object5).mode = CLASSPATH_MODE_COMPILE;
                javaCompilationUnit.classpath = new ArrayList();
                javaCompilationUnit.classpath.add(object5);
            }
            javaCompilationUnit.output = new ArrayList(linkedHashSet);
            javaCompilationUnit.sourceLevel = this.sourceLevel;
            this.javaCompilationUnitsList.add(javaCompilationUnit);
        }
        this.fireChangeEvent();
    }

    public JavaProjectGenerator.JavaCompilationUnit getCompilationUnit(CompilationUnitKey compilationUnitKey, boolean bl) {
        JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit;
        Iterator iterator = this.javaCompilationUnitsList.iterator();
        while (iterator.hasNext()) {
            javaCompilationUnit = (JavaProjectGenerator.JavaCompilationUnit)iterator.next();
            if (!((Object)javaCompilationUnit.packageRoots).equals(compilationUnitKey.locations)) continue;
            return javaCompilationUnit;
        }
        javaCompilationUnit = new JavaProjectGenerator.JavaCompilationUnit();
        javaCompilationUnit.packageRoots = compilationUnitKey.locations;
        javaCompilationUnit.sourceLevel = this.sourceLevel;
        javaCompilationUnit.isTests = bl;
        this.javaCompilationUnitsList.add(javaCompilationUnit);
        return javaCompilationUnit;
    }

    private void removeSourceLocation(String string) {
        Iterator iterator = this.javaCompilationUnitsList.iterator();
        while (iterator.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = (JavaProjectGenerator.JavaCompilationUnit)iterator.next();
            if (javaCompilationUnit.packageRoots.contains(string)) {
                javaCompilationUnit.packageRoots.remove(string);
            }
            if (javaCompilationUnit.packageRoots.size() != 0) continue;
            iterator.remove();
        }
    }

    private static void updateStyle(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JavaProjectGenerator.SourceFolder sourceFolder = (JavaProjectGenerator.SourceFolder)iterator.next();
            if (!$assertionsDisabled && !sourceFolder.type.equals(TYPE_JAVA)) {
                throw new AssertionError();
            }
            sourceFolder.style = "packages";
        }
    }

    void setSourceFolders(List list) {
        this.sourceFolders = list;
    }

    List getSourceFolders() {
        return this.sourceFolders;
    }

    void setJavaCompilationUnits(List list) {
        this.javaCompilationUnitsList = list;
    }

    List getJavaCompilationUnits() {
        return this.javaCompilationUnitsList;
    }

    public static String getDefaultSourceLevel() {
        JavaPlatform javaPlatform = JavaPlatform.getDefault();
        SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
        if (specificationVersion.compareTo((Object)JDK_MAX_SUPPORTED_VERSION) > 0) {
            specificationVersion = JDK_MAX_SUPPORTED_VERSION;
        }
        return specificationVersion.toString();
    }

    public boolean isTestSourceFolder(int n) {
        return this.isTestSourceFolder(this.getSourceFolder(n));
    }

    public boolean isTestSourceFolder(JavaProjectGenerator.SourceFolder sourceFolder) {
        Iterator iterator = this.javaCompilationUnitsList.iterator();
        while (iterator.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = (JavaProjectGenerator.JavaCompilationUnit)iterator.next();
            if (!javaCompilationUnit.packageRoots.contains(sourceFolder.location)) continue;
            return javaCompilationUnit.isTests;
        }
        return false;
    }

    static {
        $assertionsDisabled = !ProjectModel.class.desiredAssertionStatus();
        JDK_MAX_SUPPORTED_VERSION = new SpecificationVersion("1.5");
    }

    public static class CompilationUnitKey {
        public List locations;
        public String label;

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CompilationUnitKey)) {
                return false;
            }
            CompilationUnitKey compilationUnitKey = (CompilationUnitKey)object;
            return ((Object)this.locations).equals(compilationUnitKey.locations);
        }

        public int hashCode() {
            return ((Object)this.locations).hashCode() * 7;
        }

        public String toString() {
            return "PM.CUK:[label=" + this.label + ", locations=" + this.locations + ", this=" + super.toString() + "]";
        }
    }
}

