/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.progress.aggregate.ProgressMonitor;
import org.openide.util.Cancellable;

public final class AggregateProgressHandle {
    private ProgressMonitor monitor;
    private ProgressHandle handle;
    static final int WORKUNITS = 10000;
    private boolean finished;
    private Collection contributors;
    private int current;

    AggregateProgressHandle(String string, ProgressContributor[] progressContributorArray, Cancellable cancellable, Action action, boolean bl) {
        this.handle = ProgressHandleFactory.createHandle(string, cancellable, action);
        this.finished = false;
        this.contributors = new ArrayList();
        if (progressContributorArray != null) {
            for (int i = 0; i < progressContributorArray.length; ++i) {
                this.addContributor(progressContributorArray[i]);
            }
        }
    }

    public void start() {
        this.start(-1L);
    }

    public synchronized void start(long l) {
        this.handle.start(10000, l);
        this.current = 0;
    }

    public synchronized void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.handle.finish();
    }

    public void setInitialDelay(int n) {
        this.handle.setInitialDelay(n);
    }

    public synchronized void addContributor(ProgressContributor progressContributor) {
        Iterator iterator;
        if (this.finished) {
            return;
        }
        int n = this.contributors.size();
        int n2 = 0;
        double d = 0.0;
        if (n > 0) {
            iterator = this.contributors.iterator();
            while (iterator.hasNext()) {
                ProgressContributor progressContributor2 = (ProgressContributor)iterator.next();
                n2 += progressContributor2.getRemainingParentWorkUnits();
                d += 1.0 - progressContributor2.getCompletedRatio();
            }
        } else {
            n2 = 10000;
            d = 0.0;
        }
        int n3 = (int)((double)n2 / (d + 1.0));
        iterator = this.contributors.iterator();
        while (iterator.hasNext()) {
            ProgressContributor progressContributor3 = (ProgressContributor)iterator.next();
            int n4 = (int)((1.0 - progressContributor3.getCompletedRatio()) * (double)n3);
            n2 -= n4;
            progressContributor3.setAvailableParentWorkUnits(n4);
        }
        progressContributor.setAvailableParentWorkUnits(n2);
        this.contributors.add(progressContributor);
        progressContributor.setParent(this);
    }

    int getCurrentProgress() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processContributorStep(ProgressContributor progressContributor, String string, int n) {
        AggregateProgressHandle aggregateProgressHandle = this;
        synchronized (aggregateProgressHandle) {
            if (this.finished) {
                return;
            }
            this.current += n;
            this.handle.progress(string, this.current);
        }
        if (this.monitor != null) {
            this.monitor.progressed(progressContributor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processContributorStart(ProgressContributor progressContributor, String string) {
        AggregateProgressHandle aggregateProgressHandle = this;
        synchronized (aggregateProgressHandle) {
            if (this.finished) {
                return;
            }
            if (string != null) {
                this.handle.progress(string);
            }
        }
        if (this.monitor != null) {
            this.monitor.started(progressContributor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processContributorFinish(ProgressContributor progressContributor) {
        AggregateProgressHandle aggregateProgressHandle = this;
        synchronized (aggregateProgressHandle) {
            if (this.finished) {
                return;
            }
            this.contributors.remove(progressContributor);
            if (this.contributors.size() == 0) {
                this.finish();
            }
        }
        if (this.monitor != null) {
            this.monitor.finished(progressContributor);
        }
    }

    public void setMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
    }

    public void setDisplayName(String string) {
        this.handle.setDisplayName(string);
    }

    JComponent extractComponent() {
        return ProgressHandleFactory.createProgressComponent(this.handle);
    }
}

