/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress.aggregate;

import org.netbeans.api.progress.aggregate.AggregateProgressHandle;

public final class ProgressContributor {
    private String id;
    private int workunits;
    private int current;
    private int parentUnits;
    private int lastParentedUnit;
    private AggregateProgressHandle parent;
    static final /* synthetic */ boolean $assertionsDisabled;

    ProgressContributor(String string) {
        this.id = string;
        this.workunits = 0;
        this.current = 0;
        this.lastParentedUnit = 0;
    }

    public String getTrackingId() {
        return this.id;
    }

    void setParent(AggregateProgressHandle aggregateProgressHandle) {
        this.parent = aggregateProgressHandle;
    }

    int getWorkUnits() {
        return this.workunits;
    }

    int getRemainingParentWorkUnits() {
        return this.parentUnits;
    }

    void setAvailableParentWorkUnits(int n) {
        this.parentUnits = n;
    }

    double getCompletedRatio() {
        return this.workunits == 0 ? 0.0 : (double)(this.current / this.workunits);
    }

    public void start(int n) {
        if (this.parent == null) {
            return;
        }
        this.workunits = n;
        this.parent.processContributorStart(this, null);
    }

    public void finish() {
        if (this.parent == null) {
            return;
        }
        if (this.current < this.workunits) {
            this.progress(null, this.workunits);
        }
        this.parent.processContributorFinish(this);
    }

    public void progress(int n) {
        this.progress(null, n);
    }

    public void progress(String string) {
        this.progress(string, this.current);
    }

    public void progress(String string, int n) {
        if (this.parent == null) {
            return;
        }
        if (!($assertionsDisabled || n >= this.current && n <= this.workunits)) {
            throw new AssertionError();
        }
        if (string != null && n == this.current) {
            this.parent.processContributorStep(this, string, 0);
            return;
        }
        this.current = n;
        int n2 = this.current - this.lastParentedUnit;
        double d = 1.0 / ((double)this.parentUnits / (double)(this.workunits - this.lastParentedUnit));
        if ((double)n2 >= d) {
            int n3 = (int)((double)n2 / d);
            this.lastParentedUnit += (int)((double)n3 * d);
            this.parentUnits -= n3;
            this.parent.processContributorStep(this, string, n3);
        }
    }

    static {
        $assertionsDisabled = !ProgressContributor.class.desiredAssertionStatus();
    }
}

