/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.CreatedModifiedFilesFactory;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;

public final class CreatedModifiedFiles {
    private final SortedSet createdPaths = new TreeSet();
    private final SortedSet modifiedPaths = new TreeSet();
    private final SortedSet invalidPaths = new TreeSet();
    private final NbModuleProject project;
    private final List operations = new ArrayList();
    private LayerUtils.LayerHandle layerHandle;

    LayerUtils.LayerHandle getLayerHandle() {
        if (this.layerHandle == null) {
            this.layerHandle = LayerUtils.layerForProject(this.project);
        }
        return this.layerHandle;
    }

    public CreatedModifiedFiles(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    public void add(Operation operation) {
        this.operations.add(operation);
        this.createdPaths.addAll(Arrays.asList(operation.getCreatedPaths()));
        this.modifiedPaths.addAll(Arrays.asList(operation.getModifiedPaths()));
        this.invalidPaths.addAll(Arrays.asList(operation.getInvalidPaths()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        boolean bl = false;
        if (this.layerHandle != null) {
            bl = this.layerHandle.isAutosave();
            this.layerHandle.setAutosave(false);
        }
        try {
            Iterator iterator = this.operations.iterator();
            while (iterator.hasNext()) {
                Operation operation = (Operation)iterator.next();
                operation.run();
            }
            if (this.layerHandle != null) {
                this.layerHandle.save();
            }
            Object var5_4 = null;
            if (this.layerHandle != null) {
                this.layerHandle.setAutosave(bl);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.layerHandle != null) {
                this.layerHandle.setAutosave(bl);
            }
            throw throwable;
        }
    }

    public String[] getCreatedPaths() {
        if (this.createdPaths == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.createdPaths.size()];
        return this.createdPaths.toArray(stringArray);
    }

    public String[] getModifiedPaths() {
        if (this.modifiedPaths == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.modifiedPaths.size()];
        return this.modifiedPaths.toArray(stringArray);
    }

    public String[] getInvalidPaths() {
        if (this.invalidPaths == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.invalidPaths.size()];
        return this.invalidPaths.toArray(stringArray);
    }

    public Operation createFile(String string, URL uRL) {
        return CreatedModifiedFilesFactory.createFile(this.project, string, uRL);
    }

    public Operation createFileWithSubstitutions(String string, URL uRL, Map map) {
        return CreatedModifiedFilesFactory.createFileWithSubstitutions(this.project, string, uRL, map);
    }

    public Operation bundleKey(String string, String string2, String string3) {
        return CreatedModifiedFilesFactory.bundleKey(this.project, string2, string3, string);
    }

    public Operation bundleKeyDefaultBundle(String string, String string2) {
        return CreatedModifiedFilesFactory.bundleKeyDefaultBundle(this.project, string, string2);
    }

    public Operation addLoaderSection(String string, String string2) {
        return CreatedModifiedFilesFactory.addLoaderSection(this.project, string, string2);
    }

    public Operation addLookupRegistration(String string, String string2) {
        return CreatedModifiedFilesFactory.addLookupRegistration(this.project, string, string2);
    }

    public Operation addModuleDependency(String string, int n, SpecificationVersion specificationVersion, boolean bl) {
        return CreatedModifiedFilesFactory.addModuleDependency(this.project, string, n, specificationVersion, bl);
    }

    public Operation createLayerEntry(String string, URL uRL, Map map, String string2, Map map2) {
        return CreatedModifiedFilesFactory.createLayerEntry(this, this.project, string, uRL, map, string2, map2);
    }

    public Operation createLayerAttribute(final String string, final String string2, final Object object) {
        return this.layerModifications(new LayerOperation(){

            public void run(FileSystem fileSystem) throws IOException {
                FileObject fileObject = fileSystem.findResource(string);
                if (fileObject == null) {
                    throw new IOException(string);
                }
                fileObject.setAttribute(string2, object);
            }
        }, Collections.EMPTY_SET);
    }

    public Operation orderLayerEntry(final String string, final String string2, final String string3) {
        return this.layerModifications(new LayerOperation(){

            public void run(FileSystem fileSystem) throws IOException {
                FileObject fileObject = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)string);
                fileObject.setAttribute(string2 + '/' + string3, (Object)Boolean.TRUE);
            }
        }, Collections.EMPTY_SET);
    }

    public Operation layerModifications(LayerOperation layerOperation, Set set) {
        return CreatedModifiedFilesFactory.layerModifications(this.project, layerOperation, set, this);
    }

    public static interface LayerOperation {
        public void run(FileSystem var1) throws IOException;
    }

    public static interface Operation {
        public void run() throws IOException;

        public String[] getModifiedPaths();

        public String[] getCreatedPaths();

        public String[] getInvalidPaths();
    }
}

