/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EditableManifest {
    private static final String MANIFEST_VERSION = "Manifest-Version";
    private static final String MANIFEST_VERSION_VALUE = "1.0";
    private final Section mainSection;
    private final List sections;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$EditableManifest;

    public EditableManifest() {
        try {
            this.mainSection = new Section(Collections.singletonList(new Line(MANIFEST_VERSION, MANIFEST_VERSION_VALUE)), true, 1);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        this.sections = new ArrayList();
    }

    public EditableManifest(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        this.sections = new LinkedList();
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = null;
        while (true) {
            String string;
            if ((string = bufferedReader.readLine()) == null || string.length() > 0 && n > 0) {
                object2 = new Section(arrayList, object3 == null, n);
                if (object3 == null) {
                    object3 = object2;
                } else {
                    this.sections.add(object2);
                }
                arrayList.clear();
                n = 0;
            }
            if (string == null) break;
            if (string.length() > 0) {
                if (string.charAt(0) == ' ') {
                    if (arrayList.isEmpty()) {
                        throw new IOException("Continuation lines only allowed for attributes");
                    }
                    object = (Line)arrayList.remove(arrayList.size() - 1);
                    object2 = new Line(((Line)object).name, ((Line)object).value + string.substring(1), ((Line)object).text + System.getProperty("line.separator") + string);
                } else {
                    object2 = new Line(string);
                }
                arrayList.add(object2);
                continue;
            }
            ++n;
        }
        this.mainSection = object3;
        object2 = new HashSet();
        object = this.sections.iterator();
        while (object.hasNext()) {
            Section section = (Section)object.next();
            if (object2.add(section.name)) continue;
            throw new IOException("Duplicated section names: " + section.name);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        this.mainSection.write(outputStreamWriter, !this.sections.isEmpty());
        Iterator iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            ((Section)iterator.next()).write(outputStreamWriter, iterator.hasNext());
        }
        ((Writer)outputStreamWriter).flush();
    }

    public void addSection(String string) throws IllegalArgumentException {
        int n;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.findSection(string) != null) {
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < this.sections.size(); ++n) {
            Section section = (Section)this.sections.get(n);
            if (section.name.compareTo(string) > 0) break;
        }
        this.sections.add(n, new Section(string));
    }

    public void removeSection(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            if (!section.name.equals(string)) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(string);
    }

    public Set getSectionNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            hashSet.add(section.name);
        }
        return hashSet;
    }

    private Section findSection(String string) {
        if (string == null) {
            return this.mainSection;
        }
        Iterator iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            if (!section.name.equals(string)) continue;
            return section;
        }
        return null;
    }

    public String getAttribute(String string, String string2) throws IllegalArgumentException {
        Section section = this.findSection(string2);
        if (section == null) {
            throw new IllegalArgumentException(string2);
        }
        return section.getAttribute(string);
    }

    public void setAttribute(String string, String string2, String string3) throws IllegalArgumentException {
        Section section = this.findSection(string3);
        if (section == null) {
            throw new IllegalArgumentException(string3);
        }
        section.setAttribute(string, string2);
    }

    public void removeAttribute(String string, String string2) throws IllegalArgumentException {
        Section section = this.findSection(string2);
        if (section == null) {
            throw new IllegalArgumentException(string2);
        }
        section.removeAttribute(string);
    }

    public Set getAttributeNames(String string) throws IllegalArgumentException {
        Section section = this.findSection(string);
        if (section == null) {
            throw new IllegalArgumentException(string);
        }
        return section.getAttributeNames();
    }

    private static void newline(Writer writer) throws IOException {
        writer.write(System.getProperty("line.separator"));
    }

    private static final class Section {
        private static final String NAME = "Name";
        public final String name;
        private final List lines;
        private final int blankLinesAfter;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Section(List list, boolean bl, int n) throws IOException {
            Object object;
            this.lines = new ArrayList(list);
            this.blankLinesAfter = n;
            if (bl) {
                this.name = null;
                if (!list.isEmpty()) {
                    object = (Line)list.get(0);
                    if (((Line)object).name.equalsIgnoreCase(NAME)) {
                        throw new IOException("Cannot start with a named section");
                    }
                }
            } else {
                if (!$assertionsDisabled && list.isEmpty()) {
                    throw new AssertionError();
                }
                object = (Line)list.get(0);
                if (!((Line)object).name.equalsIgnoreCase(NAME)) {
                    throw new IOException("Section did not start with Name");
                }
                this.name = ((Line)object).value;
                if (this.name.length() == 0) {
                    throw new IOException("Cannot have a blank section name");
                }
            }
            object = new HashSet();
            Iterator iterator = list.iterator();
            if (!bl) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                String string = ((Line)iterator.next()).name;
                if (string.equals(NAME)) {
                    throw new IOException("Sections not separated by blank lines");
                }
                if (object.add(string.toLowerCase(Locale.US))) continue;
                throw new IOException("Duplicated attributes in a section: " + string);
            }
        }

        public Section(String string) {
            this.name = string;
            this.lines = new ArrayList();
            this.lines.add(new Line(NAME, string));
            this.blankLinesAfter = 1;
        }

        private Line findAttribute(String string) {
            Iterator iterator = this.lines.iterator();
            if (this.name != null) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                Line line = (Line)iterator.next();
                if (!line.name.equalsIgnoreCase(string)) continue;
                return line;
            }
            return null;
        }

        private int findAttributeIndex(String string) {
            int n;
            int n2 = n = this.name != null ? 1 : 0;
            while (n < this.lines.size()) {
                Line line = (Line)this.lines.get(n);
                if (line.name.equalsIgnoreCase(string)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public String getAttribute(String string) {
            Line line = this.findAttribute(string);
            if (line != null) {
                return line.value;
            }
            return null;
        }

        public void setAttribute(String string, String string2) {
            int n;
            int n2 = n = this.name != null ? 1 : 0;
            while (n < this.lines.size()) {
                Line line = (Line)this.lines.get(n);
                if (string.equalsIgnoreCase(line.name)) {
                    if (line.value.equals(string2)) {
                        return;
                    }
                    this.lines.remove(n);
                    int n3 = string.equalsIgnoreCase(EditableManifest.MANIFEST_VERSION) ? 0 : n;
                    this.lines.add(n3, new Line(string, string2));
                    return;
                }
                ++n;
            }
            if (string.equalsIgnoreCase(EditableManifest.MANIFEST_VERSION)) {
                n = 0;
            } else {
                int n4;
                n = this.lines.size();
                int n5 = n4 = this.name != null ? 1 : 0;
                while (n4 < this.lines.size()) {
                    Line line = (Line)this.lines.get(n4);
                    int n6 = line.name.compareToIgnoreCase(string);
                    if (!$assertionsDisabled && n6 == 0) {
                        throw new AssertionError();
                    }
                    if (n6 > 0 && !line.name.equalsIgnoreCase(EditableManifest.MANIFEST_VERSION)) {
                        n = n4;
                        break;
                    }
                    ++n4;
                }
            }
            this.lines.add(n, new Line(string, string2));
        }

        public void removeAttribute(String string) throws IllegalArgumentException {
            int n = this.findAttributeIndex(string);
            if (n == -1) {
                throw new IllegalArgumentException(string);
            }
            this.lines.remove(n);
        }

        public Set getAttributeNames() {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.lines.iterator();
            if (this.name != null) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                hashSet.add(((Line)iterator.next()).name);
            }
            return hashSet;
        }

        public void write(Writer writer, boolean bl) throws IOException {
            Iterator iterator = this.lines.iterator();
            while (iterator.hasNext()) {
                Line line = (Line)iterator.next();
                line.write(writer);
            }
            for (int i = 0; i < this.blankLinesAfter; ++i) {
                EditableManifest.newline(writer);
            }
            if (bl && this.blankLinesAfter == 0) {
                EditableManifest.newline(writer);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$EditableManifest == null ? (class$org$netbeans$modules$apisupport$project$EditableManifest = EditableManifest.class$("org.netbeans.modules.apisupport.project.EditableManifest")) : class$org$netbeans$modules$apisupport$project$EditableManifest).desiredAssertionStatus();
        }
    }

    private static final class Line {
        private static final Pattern NAME_VALUE;
        public final String text;
        public final String name;
        public final String value;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Line(String string) throws IOException {
            this.text = string;
            if (!$assertionsDisabled && string.length() <= 0) {
                throw new AssertionError();
            }
            Matcher matcher = NAME_VALUE.matcher(string);
            if (!matcher.matches()) {
                throw new IOException("Malformed line: " + string);
            }
            this.name = matcher.group(1);
            this.value = matcher.group(2);
        }

        public Line(String string, String string2) {
            this(string, string2, string + ": " + string2);
        }

        public Line(String string, String string2, String string3) {
            this.name = string;
            this.value = string2;
            this.text = string3;
        }

        public void write(Writer writer) throws IOException {
            writer.write(this.text);
            EditableManifest.newline(writer);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$EditableManifest == null ? (class$org$netbeans$modules$apisupport$project$EditableManifest = EditableManifest.class$("org.netbeans.modules.apisupport.project.EditableManifest")) : class$org$netbeans$modules$apisupport$project$EditableManifest).desiredAssertionStatus();
            NAME_VALUE = Pattern.compile("([^: ]+) *: *(.*)");
        }
    }
}

