/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.Util;
import org.openide.filesystems.FileObject;
import org.openide.modules.Dependency;

public final class ManifestManager {
    private String codeNameBase;
    private String releaseVersion;
    private String specificationVersion;
    private String implementationVersion;
    private String[] provTokens;
    private String provTokensString;
    private String[] requiredTokens;
    private String localizingBundle;
    private String layer;
    private String classPath;
    private PackageExport[] publicPackages;
    private boolean deprecated;
    public static final String OPENIDE_MODULE = "OpenIDE-Module";
    public static final String OPENIDE_MODULE_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
    public static final String OPENIDE_MODULE_IMPLEMENTATION_VERSION = "OpenIDE-Module-Implementation-Version";
    public static final String OPENIDE_MODULE_PROVIDES = "OpenIDE-Module-Provides";
    public static final String OPENIDE_MODULE_REQUIRES = "OpenIDE-Module-Requires";
    public static final String OPENIDE_MODULE_LAYER = "OpenIDE-Module-Layer";
    public static final String OPENIDE_MODULE_LOCALIZING_BUNDLE = "OpenIDE-Module-Localizing-Bundle";
    public static final String OPENIDE_MODULE_PUBLIC_PACKAGES = "OpenIDE-Module-Public-Packages";
    public static final String OPENIDE_MODULE_FRIENDS = "OpenIDE-Module-Friends";
    public static final String CLASS_PATH = "Class-Path";
    static final PackageExport[] EMPTY_EXPORTED_PACKAGES = new PackageExport[0];
    public static final ManifestManager NULL_INSTANCE = new ManifestManager();

    private ManifestManager() {
        this.provTokens = new String[0];
        this.requiredTokens = new String[0];
    }

    private ManifestManager(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, PackageExport[] packageExportArray, boolean bl) {
        this.codeNameBase = string;
        this.releaseVersion = string2;
        this.specificationVersion = string3;
        this.implementationVersion = string4;
        this.provTokensString = string5;
        this.provTokens = this.parseTokens(string5);
        this.requiredTokens = this.parseTokens(string6);
        this.localizingBundle = string7;
        this.layer = string8;
        this.classPath = string9;
        this.publicPackages = packageExportArray;
        this.deprecated = bl;
    }

    private String[] parseTokens(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ManifestManager getInstance(File file, boolean bl) {
        ManifestManager manifestManager;
        block12: {
            FileInputStream fileInputStream;
            block11: {
                manifestManager = null;
                fileInputStream = null;
                if (!file.exists()) break block11;
                fileInputStream = new FileInputStream(file);
                Manifest manifest = new Manifest(fileInputStream);
                manifestManager = ManifestManager.getInstance(manifest, bl);
            }
            Object var6_6 = null;
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
                break block12;
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
            }
            break block12;
            {
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                    Object var6_7 = null;
                    try {
                        if (fileInputStream != null) {
                            ((InputStream)fileInputStream).close();
                        }
                        break block12;
                    }
                    catch (IOException iOException2) {
                        Util.err.notify(1, (Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                }
                throw throwable;
            }
        }
        return manifestManager == null ? new ManifestManager() : manifestManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManifestManager getInstanceFromJAR(File file) {
        ManifestManager manifestManager;
        JarFile jarFile = new JarFile(file, false);
        try {
            manifestManager = ManifestManager.getInstance(jarFile.getManifest(), true);
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
                return new ManifestManager();
            }
        }
        jarFile.close();
        return manifestManager;
    }

    public static ManifestManager getInstance(Manifest manifest, boolean bl) {
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue(OPENIDE_MODULE);
        String string2 = null;
        String string3 = null;
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n == -1) {
                string2 = string;
            } else {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
        }
        PackageExport[] packageExportArray = null;
        if (bl) {
            packageExportArray = EMPTY_EXPORTED_PACKAGES;
            String string4 = attributes.getValue(OPENIDE_MODULE_PUBLIC_PACKAGES);
            if (string4 != null) {
                packageExportArray = ManifestManager.parseExportedPackages(string4);
            }
        }
        boolean bl2 = "true".equals(attributes.getValue("OpenIDE-Module-Deprecated"));
        ManifestManager manifestManager = new ManifestManager(string2, string3, attributes.getValue(OPENIDE_MODULE_SPECIFICATION_VERSION), attributes.getValue(OPENIDE_MODULE_IMPLEMENTATION_VERSION), attributes.getValue(OPENIDE_MODULE_PROVIDES), attributes.getValue(OPENIDE_MODULE_REQUIRES), attributes.getValue(OPENIDE_MODULE_LOCALIZING_BUNDLE), attributes.getValue(OPENIDE_MODULE_LAYER), attributes.getValue(CLASS_PATH), packageExportArray, bl2);
        return manifestManager;
    }

    static void createManifest(FileObject fileObject, String string, String string2, String string3, String string4) throws IOException {
        EditableManifest editableManifest = new EditableManifest();
        editableManifest.setAttribute(OPENIDE_MODULE, string, null);
        editableManifest.setAttribute(OPENIDE_MODULE_SPECIFICATION_VERSION, string2, null);
        editableManifest.setAttribute(OPENIDE_MODULE_LOCALIZING_BUNDLE, string3, null);
        if (string4 != null) {
            editableManifest.setAttribute(OPENIDE_MODULE_LAYER, string4, null);
        }
        Util.storeManifest(fileObject, editableManifest);
    }

    private static PackageExport[] parseExportedPackages(String string) {
        PackageExport[] packageExportArray = null;
        if (string.trim().equals("-")) {
            packageExportArray = EMPTY_EXPORTED_PACKAGES;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            ArrayList<PackageExport> arrayList = new ArrayList<PackageExport>(Math.max(stringTokenizer.countTokens(), 1));
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                if (string3.endsWith(".*")) {
                    string2 = string3.substring(0, string3.length() - 2);
                    Dependency.create((int)1, (String)string2);
                    if (string2.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string);
                    }
                    arrayList.add(new PackageExport(string2, false));
                    continue;
                }
                if (string3.endsWith(".**")) {
                    string2 = string3.substring(0, string3.length() - 3);
                    Dependency.create((int)1, (String)string2);
                    if (string2.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string);
                    }
                    arrayList.add(new PackageExport(string2, true));
                    continue;
                }
                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string);
            }
            if (arrayList.isEmpty()) {
                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + string);
            }
            packageExportArray = arrayList.toArray(new PackageExport[arrayList.size()]);
        }
        return packageExportArray;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getProvidedTokensString() {
        return this.provTokensString;
    }

    public String[] getProvidedTokens() {
        return this.provTokens;
    }

    public String[] getRequiredTokens() {
        return this.requiredTokens;
    }

    public String getLocalizingBundle() {
        return this.localizingBundle;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public static final class PackageExport {
        private final String pkg;
        private final boolean recursive;

        public PackageExport(String string, boolean bl) {
            this.pkg = string;
            this.recursive = bl;
        }

        public String getPackage() {
            return this.pkg;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "/**" : "") + "]";
        }
    }
}

