/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NbModuleProjectGenerator {
    public static final String PLATFORM_PROPERTIES_PATH = "nbproject/platform.properties";
    static final /* synthetic */ boolean $assertionsDisabled;

    private NbModuleProjectGenerator() {
    }

    public static void createStandAloneModule(final File file, final String string, final String string2, final String string3, final String string4, final String string5) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    FileObject fileObject = NbModuleProjectGenerator.createProjectDir(file);
                    if (ProjectManager.getDefault().findProject(fileObject) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject);
                    }
                    NbModuleProjectGenerator.createProjectXML(fileObject, string, NbModuleTypeProvider.STANDALONE);
                    NbModuleProjectGenerator.createPlatformProperties(fileObject, string5);
                    NbModuleProjectGenerator.createManifest(fileObject, string, string3, string4);
                    if (string3 != null) {
                        NbModuleProjectGenerator.createBundle(fileObject, string3, string2);
                    }
                    if (string4 != null) {
                        NbModuleProjectGenerator.createLayerInSrc(fileObject, string4);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(fileObject);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void createSuiteComponentModule(final File file, final String string, final String string2, final String string3, final String string4, final File file2) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    FileObject fileObject = NbModuleProjectGenerator.createProjectDir(file);
                    if (ProjectManager.getDefault().findProject(fileObject) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject);
                    }
                    NbModuleProjectGenerator.createProjectXML(fileObject, string, NbModuleTypeProvider.SUITE_COMPONENT);
                    NbModuleProjectGenerator.createSuiteProperties(fileObject, file2);
                    NbModuleProjectGenerator.createManifest(fileObject, string, string3, string4);
                    if (string3 != null) {
                        NbModuleProjectGenerator.createBundle(fileObject, string3, string2);
                    }
                    if (string4 != null) {
                        NbModuleProjectGenerator.createLayerInSrc(fileObject, string4);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(fileObject);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    NbModuleProjectGenerator.appendToSuite(string, fileObject, file2);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void createSuiteLibraryModule(final File file, final String string, final String string2, final String string3, final File file2, final File file3, final File[] fileArray) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public Object run() throws IOException {
                    FileObject fileObject = NbModuleProjectGenerator.createProjectDir(file);
                    if (ProjectManager.getDefault().findProject(fileObject) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject);
                    }
                    EditableProperties editableProperties = new EditableProperties(true);
                    editableProperties.put((Object)"is.autoload", (Object)"true");
                    HashSet<String> hashSet = new HashSet<String>();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    File file4 = new File(file, "release/modules/ext");
                    if (!file4.mkdirs()) {
                        Util.err.log("cannot create release directory.");
                    }
                    FileObject fileObject2 = FileUtil.toFileObject((File)file4);
                    for (int i = 0; i < fileArray.length; ++i) {
                        FileObject fileObject3 = FileUtil.toFileObject((File)fileArray[i]);
                        if (fileObject3 == null) continue;
                        ZipFile zipFile = null;
                        FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject2, (String)fileObject3.getName());
                        zipFile = new JarFile(fileArray[i]);
                        Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                        while (enumeration.hasMoreElements()) {
                            String string4;
                            int n;
                            JarEntry jarEntry = enumeration.nextElement();
                            if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class") || (n = (string4 = jarEntry.getName()).lastIndexOf(47)) <= -1) continue;
                            String string22 = string4.substring(0, n);
                            hashSet.add(string22.replace('/', '.'));
                        }
                        hashMap.put("ext/" + fileObject3.getNameExt(), "release/modules/ext/" + fileObject3.getNameExt());
                        Object var16_19 = null;
                        if (zipFile == null) continue;
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException2) {
                            Util.err.notify(1, (Throwable)iOException2);
                        }
                        continue;
                        {
                            catch (IOException iOException) {
                                Util.err.notify((Throwable)iOException);
                                var16_19 = null;
                                if (zipFile == null) continue;
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException2) {
                                    Util.err.notify(1, (Throwable)iOException2);
                                }
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            var16_19 = null;
                            if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException2) {
                                    Util.err.notify(1, (Throwable)iOException2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (file3 != null && file3.exists()) {
                        FileObject fileObject4 = FileUtil.toFileObject((File)file3);
                        try {
                            FileUtil.copyFile((FileObject)fileObject4, (FileObject)fileObject, (String)fileObject4.getName());
                            editableProperties.put((Object)"license.file", (Object)("${basedir}/" + fileObject4.getNameExt()));
                        }
                        catch (IOException iOException) {
                            Util.err.notify((Throwable)iOException);
                        }
                    }
                    ProjectXMLManager.generateLibraryModuleTemplate(NbModuleProjectGenerator.createFileObject(fileObject, "nbproject/project.xml"), string, NbModuleTypeProvider.SUITE_COMPONENT, hashSet, hashMap);
                    NbModuleProjectGenerator.createSuiteProperties(fileObject, file2);
                    NbModuleProjectGenerator.createManifest(fileObject, string, string3, null);
                    NbModuleProjectGenerator.createBundle(fileObject, string3, string2);
                    NbModuleProjectGenerator.appendToSuite(string, fileObject, file2);
                    FileObject fileObject5 = NbModuleProjectGenerator.createFileObject(fileObject, "nbproject/project.properties");
                    Util.storeProperties(fileObject5, editableProperties);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void createNetBeansOrgModule(final File file, final String string, final String string2, final String string3, final String string4) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    File file2 = ModuleList.findNetBeansOrg(file);
                    if (file2 == null) {
                        throw new IllegalArgumentException(file + " doesn't " + "point to directory within the netbeans.org CVS tree");
                    }
                    FileObject fileObject = NbModuleProjectGenerator.createProjectDir(file);
                    if (ProjectManager.getDefault().findProject(fileObject) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject);
                    }
                    NbModuleProjectGenerator.createNetBeansOrgBuildXML(fileObject, string, file2);
                    NbModuleProjectGenerator.createProjectXML(fileObject, string, NbModuleTypeProvider.NETBEANS_ORG);
                    NbModuleProjectGenerator.createManifest(fileObject, string, string3, string4);
                    NbModuleProjectGenerator.createBundle(fileObject, string3, string2);
                    NbModuleProjectGenerator.createLayerInSrc(fileObject, string4);
                    NbModuleProjectGenerator.createEmptyTestDir(fileObject);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static void createProjectXML(FileObject fileObject, String string, NbModuleTypeProvider.NbModuleType nbModuleType) throws IOException {
        ProjectXMLManager.generateEmptyModuleTemplate(NbModuleProjectGenerator.createFileObject(fileObject, "nbproject/project.xml"), string, nbModuleType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNetBeansOrgBuildXML(FileObject fileObject, String string, File file) throws IOException {
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, "build.xml");
        Document document = XMLUtil.createDocument((String)"project", null, null, null);
        Element element = document.getDocumentElement();
        element.setAttribute("name", PropertyUtils.relativizeFile((File)file, (File)FileUtil.toFile((FileObject)fileObject)));
        element.setAttribute("default", "netbeans");
        element.setAttribute("basedir", ".");
        Element element2 = document.createElement("description");
        element2.appendChild(document.createTextNode("Builds, tests, and runs the project " + string));
        element.appendChild(element2);
        element2 = document.createElement("import");
        element2.setAttribute("file", PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)fileObject), (File)new File(file, "nbbuild/templates/projectized.xml")));
        element.appendChild(element2);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public static void createSuiteProperties(FileObject fileObject, File file) throws IOException {
        String string;
        String string2;
        File file2 = FileUtil.toFile((FileObject)fileObject);
        if (CollocationQuery.areCollocated((File)file2, (File)file)) {
            string2 = "${basedir}/" + PropertyUtils.relativizeFile((File)file2, (File)file);
            string = "nbproject/suite.properties";
        } else {
            string2 = file.getAbsolutePath();
            string = "nbproject/private/suite-private.properties";
        }
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.setProperty("suite.dir", string2);
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, string);
        Util.storeProperties(fileObject2, editableProperties);
    }

    private static void appendToSuite(String string, FileObject fileObject, File file) throws IOException {
        Object object;
        File file2 = FileUtil.toFile((FileObject)fileObject);
        File file3 = new File(file, "nbproject/project.properties");
        FileObject fileObject2 = file3.exists() ? FileUtil.toFileObject((File)file3) : NbModuleProjectGenerator.createFileObject(file3);
        EditableProperties editableProperties = Util.loadProperties(fileObject2);
        String string2 = "project." + string;
        if (CollocationQuery.areCollocated((File)file2, (File)file)) {
            editableProperties.setProperty(string2, PropertyUtils.relativizeFile((File)file, (File)file2));
        } else {
            object = new File(file, "nbproject/private/private.properties");
            FileObject fileObject3 = ((File)object).exists() ? FileUtil.toFileObject((File)object) : NbModuleProjectGenerator.createFileObject((File)object);
            EditableProperties editableProperties2 = Util.loadProperties(fileObject3);
            editableProperties2.setProperty(string2, file2.getAbsolutePath());
            Util.storeProperties(fileObject3, editableProperties2);
        }
        object = editableProperties.getProperty("modules");
        if (object == null) {
            object = "";
        }
        if (((String)object).length() > 0) {
            object = (String)object + ":";
        }
        object = (String)object + "${" + string2 + "}";
        editableProperties.setProperty("modules", ((String)object).split("(?<=:)", -1));
        Util.storeProperties(fileObject2, editableProperties);
    }

    private static void createPlatformProperties(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, PLATFORM_PROPERTIES_PATH);
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.put((Object)"nbplatform.active", (Object)string);
        Util.storeProperties(fileObject2, editableProperties);
    }

    private static void createManifest(FileObject fileObject, String string, String string2, String string3) throws IOException {
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, "manifest.mf");
        ManifestManager.createManifest(fileObject2, string, "1.0", string2, string3);
    }

    private static void createBundle(FileObject fileObject, String string, String string2) throws IOException {
        String string3 = "src/" + string.replace('\\', '/');
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, string3);
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.put((Object)"OpenIDE-Module-Name", (Object)string2);
        Util.storeProperties(fileObject2, editableProperties);
    }

    private static void createLayerInSrc(FileObject fileObject, String string) throws IOException {
        NbModuleProjectGenerator.createLayer(fileObject, "src/" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject createLayer(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, string);
        FileLock fileLock = fileObject2.lock();
        try {
            InputStream inputStream = NbModuleProjectGenerator.class.getResourceAsStream("ui/resources/layer_template.xml");
            try {
                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                try {
                    FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
        return fileObject2;
    }

    private static void createEmptyTestDir(FileObject fileObject) throws IOException {
        FileUtil.createFolder((FileObject)fileObject, (String)"test/unit/src");
    }

    private static FileObject createProjectDir(File file) throws IOException {
        FileObject fileObject;
        if (!file.exists()) {
            NbModuleProjectGenerator.refreshFolder(file);
            if (!file.mkdirs()) {
                throw new IOException("Can not create project folder \"" + file.getAbsolutePath() + "\"");
            }
            NbModuleProjectGenerator.refreshFileSystem(file);
        }
        if ((fileObject = FileUtil.toFileObject((File)file)) == null) {
            throw new IOException("No such dir on disk: " + file);
        }
        if (!$assertionsDisabled && !fileObject.isFolder()) {
            throw new AssertionError((Object)("Not really a dir: " + file));
        }
        return fileObject;
    }

    private static void refreshFolder(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            fileObject.refresh(false);
        }
    }

    private static void refreshFileSystem(File file) throws FileStateInvalidException {
        File file2 = file;
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        if (fileObject != null) {
            fileObject.getFileSystem().refresh(false);
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("At least disk roots must be mounted! " + file2));
            }
            Util.err.log(16, "Cannot resolvefile object for " + file2.getAbsolutePath());
        }
    }

    private static FileObject createFileObject(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            throw new IllegalArgumentException("File " + fileObject2 + " already exists.");
        }
        fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        return fileObject2;
    }

    private static FileObject createFileObject(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            throw new IllegalArgumentException("Cannot create: " + file);
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return NbModuleProjectGenerator.createFileObject(FileUtil.toFileObject((File)file2), file.getName());
    }

    static {
        $assertionsDisabled = !NbModuleProjectGenerator.class.desiredAssertionStatus();
    }
}

