/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ProjectXMLManager {
    private static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final String BINARY_ORIGIN = "binary-origin";
    private static final String BUILD_PREREQUISITE = "build-prerequisite";
    private static final String CLASS_PATH_BINARY_ORIGIN = "binary-origin";
    private static final String CLASS_PATH_EXTENSION = "class-path-extension";
    private static final String CLASS_PATH_RUNTIME_PATH = "runtime-relative-path";
    private static final String CODE_NAME_BASE = "code-name-base";
    private static final String COMPILE_DEPENDENCY = "compile-dependency";
    private static final String DATA = "data";
    private static final String DEPENDENCY = "dependency";
    private static final String EXTRA_COMPILATION_UNIT = "extra-compilation-unit";
    private static final String FRIEND = "friend";
    private static final String FRIEND_PACKAGES = "friend-packages";
    private static final String IMPLEMENTATION_VERSION = "implementation-version";
    private static final String MODULE_DEPENDENCIES = "module-dependencies";
    private static final String PACKAGE = "package";
    private static final String PUBLIC_PACKAGES = "public-packages";
    private static final String RELEASE_VERSION = "release-version";
    private static final String RUN_DEPENDENCY = "run-dependency";
    private static final String SPECIFICATION_VERSION = "specification-version";
    private static final String STANDALONE = "standalone";
    private static final String SUBPACKAGES = "subpackages";
    private static final String SUITE_COMPONENT = "suite-component";
    private AntProjectHelper helper;
    private NbPlatform plaf;
    private String cnb;
    private SortedSet directDeps;
    private ManifestManager.PackageExport[] publicPackages;
    private String[] cpExtensions;
    private String[] friends;
    private Element confData;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProjectXMLManager(AntProjectHelper antProjectHelper) {
        this.helper = antProjectHelper;
    }

    public void setModuleType(NbModuleTypeProvider.NbModuleType nbModuleType) {
        Element element;
        Element element2 = this.getConfData();
        Document document = element2.getOwnerDocument();
        Element element3 = ProjectXMLManager.findElement(element2, STANDALONE);
        if (element3 != null && nbModuleType == NbModuleTypeProvider.STANDALONE) {
            return;
        }
        Element element4 = ProjectXMLManager.findElement(element2, SUITE_COMPONENT);
        if (element4 != null && nbModuleType == NbModuleTypeProvider.SUITE_COMPONENT) {
            return;
        }
        if (element4 == null && element3 == null && nbModuleType == NbModuleTypeProvider.NETBEANS_ORG) {
            return;
        }
        if (element4 != null) {
            element2.removeChild(element4);
        }
        if (element3 != null) {
            element2.removeChild(element3);
        }
        if ((element = ProjectXMLManager.createTypeElement(document, nbModuleType)) != null) {
            element2.insertBefore(element, ProjectXMLManager.findModuleDependencies(element2));
        }
        this.helper.putPrimaryConfigurationData(element2, true);
    }

    public SortedSet getDirectDependencies(NbPlatform nbPlatform) throws IOException {
        if (this.plaf == nbPlatform && this.directDeps != null) {
            return this.directDeps;
        }
        this.directDeps = new TreeSet();
        Element element = ProjectXMLManager.findModuleDependencies(this.getConfData());
        List list = Util.findSubElements(element);
        ModuleList moduleList = this.getModuleList(nbPlatform);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2;
            Element element3;
            ModuleDependency moduleDependency;
            Object object;
            Element element4 = (Element)iterator.next();
            Element element5 = ProjectXMLManager.findElement(element4, CODE_NAME_BASE);
            String string = Util.findText(element5);
            ModuleEntry moduleEntry = moduleList.getEntry(string);
            if (moduleEntry == null) {
                Util.err.log(16, "Detected dependency on module which cannot be found in the current module's universe (platform, suite): " + string + " (skipping)");
                continue;
            }
            Element element6 = ProjectXMLManager.findElement(element4, RUN_DEPENDENCY);
            if (element6 == null) {
                if (this.directDeps.add(new ModuleDependency(moduleEntry))) continue;
                object = "Corrupted project metadata (project.xml). Duplicate dependency entry found: " + moduleEntry;
                Util.err.log(16, (String)object);
                throw new IllegalStateException((String)object);
            }
            object = ProjectXMLManager.findElement(element6, RELEASE_VERSION);
            String string2 = null;
            if (object != null) {
                string2 = Util.findText((Element)object);
            }
            Element element7 = ProjectXMLManager.findElement(element6, SPECIFICATION_VERSION);
            String string3 = null;
            if (element7 != null) {
                string3 = Util.findText(element7);
            }
            if (this.directDeps.add(moduleDependency = new ModuleDependency(moduleEntry, string2, string3, (element3 = ProjectXMLManager.findElement(element4, COMPILE_DEPENDENCY)) != null, (element2 = ProjectXMLManager.findElement(element6, IMPLEMENTATION_VERSION)) != null))) continue;
            String string4 = "Corrupted project metadata (project.xml). Duplicate dependency entry found: " + moduleDependency;
            Util.err.log(16, string4);
            throw new IllegalStateException(string4);
        }
        return this.directDeps;
    }

    public void removeDependency(String string) {
        Element element = this.getConfData();
        Element element2 = ProjectXMLManager.findModuleDependencies(element);
        List list = Util.findSubElements(element2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            Element element4 = ProjectXMLManager.findElement(element3, CODE_NAME_BASE);
            String string2 = Util.findText(element4);
            if (!string.equals(string2)) continue;
            element2.removeChild(element3);
        }
        this.helper.putPrimaryConfigurationData(element, true);
    }

    public void removeDependencies(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.add(((ModuleDependency)iterator.next()).getModuleEntry().getCodeNameBase());
        }
        this.removeDependenciesByCNB(hashSet);
    }

    public void removeDependenciesByCNB(Collection collection) {
        Element element = this.getConfData();
        Element element2 = ProjectXMLManager.findModuleDependencies(element);
        List list = Util.findSubElements(element2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            Element element4 = ProjectXMLManager.findElement(element3, CODE_NAME_BASE);
            String string = Util.findText(element4);
            if (collection.remove(string)) {
                element2.removeChild(element3);
            }
            if (collection.size() != 0) continue;
        }
        if (collection.size() != 0) {
            Util.err.log(16, "Some modules weren't deleted: " + collection);
        }
        this.helper.putPrimaryConfigurationData(element, true);
    }

    public void editDependency(ModuleDependency moduleDependency, ModuleDependency moduleDependency2) {
        Element element = this.getConfData();
        Element element2 = ProjectXMLManager.findModuleDependencies(element);
        List list = Util.findSubElements(element2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            Element element4 = ProjectXMLManager.findElement(element3, CODE_NAME_BASE);
            String string = Util.findText(element4);
            if (!string.equals(moduleDependency.getModuleEntry().getCodeNameBase())) continue;
            element2.removeChild(element3);
            Element element5 = iterator.hasNext() ? (Element)iterator.next() : null;
            ProjectXMLManager.createModuleDependencyElement(element2, moduleDependency2, element5);
            break;
        }
        this.helper.putPrimaryConfigurationData(element, true);
    }

    public void addDependency(ModuleDependency moduleDependency) throws IOException {
        HashSet<ModuleDependency> hashSet = new HashSet<ModuleDependency>(1);
        hashSet.add(moduleDependency);
        this.addDependencies(hashSet);
    }

    public void addDependencies(Set set) throws IOException {
        SortedSet sortedSet = this.getDirectDependencies(this.plaf);
        sortedSet.addAll(set);
        this.replaceDependencies(sortedSet);
    }

    public void replaceDependencies(Set set) {
        Element element = this.getConfData();
        Document document = element.getOwnerDocument();
        Element element2 = ProjectXMLManager.findModuleDependencies(element);
        element.removeChild(element2);
        element2 = ProjectXMLManager.createModuleElement(document, MODULE_DEPENDENCIES);
        Element element3 = ProjectXMLManager.findPublicPackagesElement(element);
        if (element3 == null) {
            element3 = ProjectXMLManager.findFriendsElement(element);
        }
        if (!$assertionsDisabled && element3 == null) {
            throw new AssertionError((Object)"There must be public-packages or friend-packages element according to XSD");
        }
        element.insertBefore(element2, element3);
        TreeSet treeSet = new TreeSet(ModuleDependency.CODE_NAME_BASE_COMPARATOR);
        treeSet.addAll(set);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
            ProjectXMLManager.createModuleDependencyElement(element2, moduleDependency, null);
        }
        this.helper.putPrimaryConfigurationData(element, true);
    }

    public void removeClassPathExtensions() {
        Element element = this.getConfData();
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/nb-module-project/2", CLASS_PATH_EXTENSION);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element.removeChild(nodeList.item(i));
        }
        this.helper.putPrimaryConfigurationData(element, true);
    }

    public void replaceClassPathExtensions(HashMap hashMap) {
        this.removeClassPathExtensions();
        if (hashMap != null && hashMap.size() > 0) {
            Element element = this.getConfData();
            Document document = element.getOwnerDocument();
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Element element2 = ProjectXMLManager.createModuleElement(document, CLASS_PATH_EXTENSION);
                Element element3 = ProjectXMLManager.createModuleElement(document, CLASS_PATH_RUNTIME_PATH, (String)entry.getKey());
                Element element4 = ProjectXMLManager.createModuleElement(document, "binary-origin", (String)entry.getValue());
                element2.appendChild(element3);
                element2.appendChild(element4);
                element.appendChild(element2);
            }
            this.helper.putPrimaryConfigurationData(element, true);
        }
    }

    public void replacePublicPackages(String[] stringArray) {
        this.removePublicAndFriends();
        Element element = this.getConfData();
        Document document = element.getOwnerDocument();
        Element element2 = ProjectXMLManager.createModuleElement(document, PUBLIC_PACKAGES);
        this.insertPublicOrFriend(element2);
        for (int i = 0; i < stringArray.length; ++i) {
            element2.appendChild(ProjectXMLManager.createModuleElement(document, PACKAGE, stringArray[i]));
        }
        this.helper.putPrimaryConfigurationData(element, true);
        this.publicPackages = null;
    }

    private void insertPublicOrFriend(Element element) {
        Element element2 = ProjectXMLManager.findElement(this.getConfData(), CLASS_PATH_EXTENSION);
        if (element2 == null) {
            element2 = ProjectXMLManager.findElement(this.getConfData(), EXTRA_COMPILATION_UNIT);
        }
        this.getConfData().insertBefore(element, element2);
    }

    public void replaceFriends(String[] stringArray, String[] stringArray2) {
        int n;
        this.removePublicAndFriends();
        Element element = this.getConfData();
        Document document = element.getOwnerDocument();
        Element element2 = ProjectXMLManager.createModuleElement(document, FRIEND_PACKAGES);
        this.insertPublicOrFriend(element2);
        for (n = 0; n < stringArray.length; ++n) {
            element2.appendChild(ProjectXMLManager.createModuleElement(document, FRIEND, stringArray[n]));
        }
        for (n = 0; n < stringArray2.length; ++n) {
            element2.appendChild(ProjectXMLManager.createModuleElement(document, PACKAGE, stringArray2[n]));
        }
        this.helper.putPrimaryConfigurationData(element, true);
        this.publicPackages = null;
    }

    public ManifestManager.PackageExport[] getPublicPackages() {
        if (this.publicPackages == null) {
            this.publicPackages = ProjectXMLManager.findPublicPackages(this.getConfData());
        }
        return this.publicPackages;
    }

    public String[] getFriends() {
        if (this.friends == null) {
            this.friends = ProjectXMLManager.findFriends(this.getConfData());
        }
        return this.friends;
    }

    public String[] getBinaryOrigins() {
        if (this.cpExtensions != null) {
            return this.cpExtensions;
        }
        List list = Util.findSubElements(this.getConfData());
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = list.iterator();
        while (stringArray.hasNext()) {
            Element element;
            Element element2 = (Element)stringArray.next();
            if (!CLASS_PATH_EXTENSION.equals(element2.getTagName()) || (element = ProjectXMLManager.findElement(element2, "binary-origin")) == null) continue;
            treeSet.add(Util.findText(element));
        }
        stringArray = new String[treeSet.size()];
        return treeSet.toArray(stringArray);
    }

    public String getCodeNameBase() {
        if (this.cnb == null) {
            Element element = ProjectXMLManager.findElement(this.getConfData(), CODE_NAME_BASE);
            this.cnb = Util.findText(element);
        }
        return this.cnb;
    }

    static void createModuleDependencyElement(Element element, ModuleDependency moduleDependency, Element element2) {
        Document document = element.getOwnerDocument();
        Element element3 = ProjectXMLManager.createModuleElement(document, DEPENDENCY);
        element.insertBefore(element3, element2);
        element3.appendChild(ProjectXMLManager.createModuleElement(document, CODE_NAME_BASE, moduleDependency.getModuleEntry().getCodeNameBase()));
        if (moduleDependency.hasCompileDependency()) {
            element3.appendChild(ProjectXMLManager.createModuleElement(document, BUILD_PREREQUISITE));
            element3.appendChild(ProjectXMLManager.createModuleElement(document, COMPILE_DEPENDENCY));
        }
        Element element4 = ProjectXMLManager.createModuleElement(document, RUN_DEPENDENCY);
        element3.appendChild(element4);
        String string = moduleDependency.getReleaseVersion();
        if (string != null && !string.trim().equals("")) {
            element4.appendChild(ProjectXMLManager.createModuleElement(document, RELEASE_VERSION, string));
        }
        if (moduleDependency.hasImplementationDepedendency()) {
            element4.appendChild(ProjectXMLManager.createModuleElement(document, IMPLEMENTATION_VERSION));
        } else {
            String string2 = moduleDependency.getSpecificationVersion();
            if (string2 != null && !"".equals(string2)) {
                element4.appendChild(ProjectXMLManager.createModuleElement(document, SPECIFICATION_VERSION, string2));
            }
        }
    }

    private void removePublicAndFriends() {
        Element element;
        Element element2 = ProjectXMLManager.findFriendsElement(this.getConfData());
        if (element2 != null) {
            this.getConfData().removeChild(element2);
        }
        if ((element = ProjectXMLManager.findPublicPackagesElement(this.getConfData())) != null) {
            this.getConfData().removeChild(element);
        }
    }

    private static Element findElement(Element element, String string) {
        return Util.findElement(element, string, "http://www.netbeans.org/ns/nb-module-project/2");
    }

    static Element findModuleDependencies(Element element) {
        return ProjectXMLManager.findElement(element, MODULE_DEPENDENCIES);
    }

    private static Element findPublicPackagesElement(Element element) {
        return ProjectXMLManager.findElement(element, PUBLIC_PACKAGES);
    }

    private static Element findFriendsElement(Element element) {
        return ProjectXMLManager.findElement(element, FRIEND_PACKAGES);
    }

    private static Element createModuleElement(Document document, String string) {
        return document.createElementNS("http://www.netbeans.org/ns/nb-module-project/2", string);
    }

    private static Element createModuleElement(Document document, String string, String string2) {
        Element element = ProjectXMLManager.createModuleElement(document, string);
        element.appendChild(document.createTextNode(string2));
        return element;
    }

    private static Element createSuiteElement(Document document, String string) {
        return document.createElementNS("http://www.netbeans.org/ns/nb-module-suite-project/1", string);
    }

    private static Element createSuiteElement(Document document, String string, String string2) {
        Element element = ProjectXMLManager.createSuiteElement(document, string);
        element.appendChild(document.createTextNode(string2));
        return element;
    }

    private ModuleList getModuleList(NbPlatform nbPlatform) throws IOException {
        if (nbPlatform != null) {
            return ModuleList.getModuleList(FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), nbPlatform.getDestDir());
        }
        return ModuleList.getModuleList(FileUtil.toFile((FileObject)this.helper.getProjectDirectory()));
    }

    private static Set findAllPackages(Element element) {
        HashSet<ManifestManager.PackageExport> hashSet = new HashSet<ManifestManager.PackageExport>();
        List list = Util.findSubElements(element);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (PACKAGE.equals(element2.getTagName())) {
                hashSet.add(new ManifestManager.PackageExport(Util.findText(element2), false));
                continue;
            }
            if (!SUBPACKAGES.equals(element2.getTagName())) continue;
            hashSet.add(new ManifestManager.PackageExport(Util.findText(element2), true));
        }
        return hashSet;
    }

    public static ManifestManager.PackageExport[] findPublicPackages(Element element) {
        Element element2 = ProjectXMLManager.findPublicPackagesElement(element);
        HashSet hashSet = new HashSet();
        if (element2 != null) {
            hashSet.addAll(ProjectXMLManager.findAllPackages(element2));
        }
        if ((element2 = ProjectXMLManager.findFriendsElement(element)) != null) {
            hashSet.addAll(ProjectXMLManager.findAllPackages(element2));
        }
        return hashSet.isEmpty() ? ManifestManager.EMPTY_EXPORTED_PACKAGES : hashSet.toArray(new ManifestManager.PackageExport[hashSet.size()]);
    }

    public static String[] findFriends(Element element) {
        Element element2 = ProjectXMLManager.findFriendsElement(element);
        if (element2 != null) {
            List list = Util.findSubElements(element2);
            TreeSet<String> treeSet = new TreeSet<String>();
            String[] stringArray = list.iterator();
            while (stringArray.hasNext()) {
                Element element3 = (Element)stringArray.next();
                if (!FRIEND.equals(element3.getTagName())) continue;
                treeSet.add(Util.findText(element3));
            }
            stringArray = new String[treeSet.size()];
            return treeSet.toArray(stringArray);
        }
        return null;
    }

    static void generateEmptyModuleTemplate(FileObject fileObject, String string, NbModuleTypeProvider.NbModuleType nbModuleType) throws IOException {
        Document document = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element element = document.createElementNS(PROJECT_NS, "type");
        element.appendChild(document.createTextNode("org.netbeans.modules.apisupport.project"));
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElementNS(PROJECT_NS, "configuration");
        document.getDocumentElement().appendChild(element2);
        Element element3 = ProjectXMLManager.createModuleElement(element2.getOwnerDocument(), DATA);
        element2.appendChild(element3);
        Document document2 = element3.getOwnerDocument();
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, CODE_NAME_BASE, string));
        Element element4 = ProjectXMLManager.createTypeElement(document2, nbModuleType);
        if (element4 != null) {
            element3.appendChild(element4);
        }
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, MODULE_DEPENDENCIES));
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, PUBLIC_PACKAGES));
        ProjectXMLManager.safelyWrite(fileObject, document);
    }

    static void generateLibraryModuleTemplate(FileObject fileObject, String string, NbModuleTypeProvider.NbModuleType nbModuleType, Set set, Map map) throws IOException {
        Document document = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element element = document.createElementNS(PROJECT_NS, "type");
        element.appendChild(document.createTextNode("org.netbeans.modules.apisupport.project"));
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElementNS(PROJECT_NS, "configuration");
        document.getDocumentElement().appendChild(element2);
        Element element3 = ProjectXMLManager.createModuleElement(element2.getOwnerDocument(), DATA);
        element2.appendChild(element3);
        Document document2 = element3.getOwnerDocument();
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, CODE_NAME_BASE, string));
        Element element4 = ProjectXMLManager.createTypeElement(document2, nbModuleType);
        if (element4 != null) {
            element3.appendChild(element4);
        }
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, MODULE_DEPENDENCIES));
        Element element5 = ProjectXMLManager.createModuleElement(document2, PUBLIC_PACKAGES);
        element3.appendChild(element5);
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            element5.appendChild(ProjectXMLManager.createModuleElement(document2, PACKAGE, (String)iterator.next()));
        }
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Element element6 = ProjectXMLManager.createModuleElement(document2, CLASS_PATH_EXTENSION);
            element3.appendChild(element6);
            Map.Entry entry = (Map.Entry)iterator.next();
            element6.appendChild(ProjectXMLManager.createModuleElement(document2, CLASS_PATH_RUNTIME_PATH, (String)entry.getKey()));
            element6.appendChild(ProjectXMLManager.createModuleElement(document2, "binary-origin", (String)entry.getValue()));
        }
        ProjectXMLManager.safelyWrite(fileObject, document);
    }

    private static Element createTypeElement(Document document, NbModuleTypeProvider.NbModuleType nbModuleType) {
        Element element = null;
        if (nbModuleType == NbModuleTypeProvider.STANDALONE) {
            element = ProjectXMLManager.createModuleElement(document, STANDALONE);
        } else if (nbModuleType == NbModuleTypeProvider.SUITE_COMPONENT) {
            element = ProjectXMLManager.createModuleElement(document, SUITE_COMPONENT);
        }
        return element;
    }

    public static void generateEmptySuiteTemplate(FileObject fileObject, String string) throws IOException {
        Document document = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element element = document.createElementNS(PROJECT_NS, "type");
        element.appendChild(document.createTextNode("org.netbeans.modules.apisupport.project.suite"));
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElementNS(PROJECT_NS, "configuration");
        document.getDocumentElement().appendChild(element2);
        Element element3 = ProjectXMLManager.createSuiteElement(element2.getOwnerDocument(), DATA);
        element2.appendChild(element3);
        Document document2 = element3.getOwnerDocument();
        element3.appendChild(ProjectXMLManager.createSuiteElement(document2, "name", string));
        ProjectXMLManager.safelyWrite(fileObject, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safelyWrite(FileObject fileObject, Document document) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private Element getConfData() {
        if (this.confData == null) {
            this.confData = this.helper.getPrimaryConfigurationData(true);
        }
        return this.confData;
    }

    static {
        $assertionsDisabled = !ProjectXMLManager.class.desiredAssertionStatus();
    }
}

