/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class Util {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.project");
    private static final String SFS_VALID_PATH_RE = "(\\p{Alnum}|\\/|_)+";

    private Util() {
    }

    public static Element findElement(Element element, String string, String string2) {
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element3 = (Element)nodeList.item(i);
            if ((string2 != null || !string.equals(element3.getTagName())) && (string2 == null || !string.equals(element3.getLocalName()) || !string2.equals(element3.getNamespaceURI()))) continue;
            if (element2 == null) {
                element2 = element3;
                continue;
            }
            return null;
        }
        return element2;
    }

    public static String findText(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static List findSubElements(Element element) throws IllegalArgumentException {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                arrayList.add((Element)node);
                continue;
            }
            if (node.getNodeType() == 3) {
                String string = ((Text)node).getNodeValue();
                if (string.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + element + ": " + string);
            }
            if (node.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + element + ": " + node);
        }
        return arrayList;
    }

    public static URL urlForDir(File file) {
        try {
            URL uRL = FileUtil.normalizeFile((File)file).toURI().toURL();
            String string = uRL.toExternalForm();
            if (string.endsWith("/")) {
                return uRL;
            }
            return new URL(string + "/");
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public static URL urlForJar(File file) {
        try {
            return FileUtil.getArchiveRoot((URL)FileUtil.normalizeFile((File)file).toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public static URL urlForDirOrJar(File file) {
        try {
            URL uRL = FileUtil.normalizeFile((File)file).toURI().toURL();
            if (FileUtil.isArchiveFile((URL)uRL)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            } else {
                String string = uRL.toExternalForm();
                if (!string.endsWith("/")) {
                    uRL = new URL(string + "/");
                }
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public static String getDisplayName(FileObject fileObject) {
        try {
            Project project = ProjectManager.getDefault().findProject(fileObject);
            return ProjectUtils.getInformation((Project)project).getDisplayName();
        }
        catch (IOException iOException) {
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }
    }

    public static String normalizeCNB(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ".", true);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!bl) {
                if (string2.equals(".")) continue;
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c)) continue;
                    stringBuffer.append(c);
                }
            } else if (string2.equals(".")) {
                stringBuffer.append(string2);
            }
            bl = !bl;
        }
        return stringBuffer.toString().replaceAll("\\.$", "");
    }

    public static boolean isValidCodeNameBase(String string) {
        if (string.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!bl) {
                if (string2.equals(".")) {
                    return false;
                }
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (!(i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c))) continue;
                    return false;
                }
            } else if (!string2.equals(".")) {
                return false;
            }
            bl = !bl;
        }
        return bl;
    }

    public static LocalizedBundleInfo findLocalizedBundleInfo(FileObject fileObject, Manifest manifest) {
        String string = ManifestManager.getInstance(manifest, false).getLocalizingBundle();
        try {
            if (string != null) {
                ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                Iterator iterator = Util.getPossibleResources(string);
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    FileObject fileObject2 = fileObject.getFileObject(string2);
                    if (fileObject2 == null) continue;
                    arrayList.add(fileObject2);
                }
                if (!arrayList.isEmpty()) {
                    Collections.reverse(arrayList);
                    return LocalizedBundleInfo.load(arrayList.toArray(new FileObject[arrayList.size()]));
                }
            }
        }
        catch (IOException iOException) {
            err.notify(1, (Throwable)iOException);
        }
        return null;
    }

    public static LocalizedBundleInfo findLocalizedBundleInfo(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)new File(file, "src"));
        FileObject fileObject2 = FileUtil.toFileObject((File)new File(file, "manifest.mf"));
        LocalizedBundleInfo localizedBundleInfo = null;
        Manifest manifest = Util.getManifest(fileObject2);
        if (fileObject != null && manifest != null) {
            localizedBundleInfo = Util.findLocalizedBundleInfo(fileObject, manifest);
        }
        return localizedBundleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalizedBundleInfo findLocalizedBundleInfoFromJAR(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            try {
                Iterator iterator;
                ArrayList<JarFile> arrayList;
                ArrayList arrayList2;
                block18: {
                    Object object;
                    Manifest manifest = jarFile.getManifest();
                    String string = ManifestManager.getInstance(manifest, false).getLocalizingBundle();
                    if (string == null) return null;
                    arrayList2 = new ArrayList();
                    arrayList = new ArrayList<JarFile>();
                    String string2 = file.getName();
                    int n = string2.lastIndexOf(46);
                    if (n == -1) {
                        n = string2.length();
                    }
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n);
                    Iterator iterator2 = NbBundle.getLocalizingSuffixes();
                    while (iterator2.hasNext()) {
                        object = (String)iterator2.next();
                        File file2 = new File(file.getParentFile(), "locale" + File.separatorChar + string3 + (String)object + string4);
                        if (!file2.isFile()) continue;
                        JarFile jarFile2 = new JarFile(file2);
                        arrayList.add(jarFile2);
                        Util.addBundlesFromJar(jarFile2, arrayList2, string);
                    }
                    Util.addBundlesFromJar(jarFile, arrayList2, string);
                    if (arrayList2.isEmpty()) break block18;
                    Collections.reverse(arrayList2);
                    object = LocalizedBundleInfo.load(arrayList2.toArray(new InputStream[arrayList2.size()]));
                    Object var15_15 = null;
                    Iterator iterator3 = arrayList2.iterator();
                    while (iterator3.hasNext()) {
                        ((InputStream)iterator3.next()).close();
                    }
                    iterator3 = arrayList.iterator();
                    while (true) {
                        if (!iterator3.hasNext()) {
                            jarFile.close();
                            return object;
                        }
                        ((JarFile)iterator3.next()).close();
                    }
                }
                try {
                    Object var15_16 = null;
                    iterator = arrayList2.iterator();
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    Iterator iterator4 = arrayList2.iterator();
                    while (iterator4.hasNext()) {
                        ((InputStream)iterator4.next()).close();
                    }
                    iterator4 = arrayList.iterator();
                    while (iterator4.hasNext()) {
                        ((JarFile)iterator4.next()).close();
                    }
                    throw throwable;
                }
                while (iterator.hasNext()) {
                    ((InputStream)iterator.next()).close();
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((JarFile)iterator.next()).close();
                }
                return null;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException iOException) {
            err.notify(1, (Throwable)iOException);
        }
        return null;
    }

    private static void addBundlesFromJar(JarFile jarFile, List list, String string) throws IOException {
        Iterator iterator = Util.getPossibleResources(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            ZipEntry zipEntry = jarFile.getEntry(string2);
            if (zipEntry == null) continue;
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            list.add(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditableProperties loadProperties(FileObject fileObject) throws IOException {
        InputStream inputStream = fileObject.getInputStream();
        EditableProperties editableProperties = new EditableProperties(true);
        try {
            editableProperties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        return editableProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(FileObject fileObject, EditableProperties editableProperties) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                editableProperties.store(outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditableManifest loadManifest(FileObject fileObject) throws IOException {
        InputStream inputStream = fileObject.getInputStream();
        try {
            EditableManifest editableManifest;
            EditableManifest editableManifest2 = editableManifest = new EditableManifest(inputStream);
            return editableManifest2;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeManifest(FileObject fileObject, EditableManifest editableManifest) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                editableManifest.write(outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public static URL findJavadocForNetBeansOrgModules(ModuleDependency moduleDependency) {
        ModuleEntry moduleEntry = moduleDependency.getModuleEntry();
        File file = moduleEntry.getDestDir();
        File file2 = null;
        if (file.getParent() != null) {
            file2 = file.getParentFile().getParentFile();
        }
        if (file2 == null) {
            throw new IllegalArgumentException("ModuleDependency " + moduleDependency + " doesn't represent nb.org module");
        }
        File file3 = new File(file2, "nbbuild/build/javadoc");
        URL[] uRLArray = null;
        if (file3.exists()) {
            File[] fileArray = file3.listFiles();
            uRLArray = new URL[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                uRLArray[i] = Util.urlForDirOrJar(fileArray[i]);
            }
        }
        return uRLArray == null ? null : Util.findJavadocURL(moduleDependency.getModuleEntry().getCodeNameBase().replace('.', '-'), uRLArray);
    }

    public static URL findJavadoc(ModuleDependency moduleDependency, NbPlatform nbPlatform) {
        String string = moduleDependency.getModuleEntry().getCodeNameBase().replace('.', '-');
        URL[] uRLArray = nbPlatform.getJavadocRoots();
        return uRLArray == null ? null : Util.findJavadocURL(string, uRLArray);
    }

    public static boolean isValidSFSPath(String string) {
        return string.matches(SFS_VALID_PATH_RE);
    }

    private static URL findJavadocURL(String string, URL[] uRLArray) {
        URL uRL = null;
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL2 = uRLArray[i];
            try {
                uRL = Util.normalizeURL(new URL(uRL2, string + "/index.html"));
                if (uRL == null && uRL2.toExternalForm().indexOf(string) != -1) {
                    uRL = Util.normalizeURL(new URL(uRL2, "index.html"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL != null) break;
        }
        return uRL;
    }

    private static URL normalizeURL(URL uRL) {
        return URLMapper.findFileObject((URL)uRL) == null ? null : uRL;
    }

    private static Iterator getPossibleResources(String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf(46);
        if (n != -1 && n > string.lastIndexOf(47)) {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        } else {
            string3 = string;
            string2 = "";
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Iterator iterator = NbBundle.getLocalizingSuffixes();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            String string5 = string3 + string4 + string2;
            linkedHashSet.add(string5);
            linkedHashSet.add(string5);
        }
        return linkedHashSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(FileObject fileObject) {
        if (fileObject != null) {
            Manifest manifest;
            InputStream inputStream = fileObject.getInputStream();
            try {
                manifest = new Manifest(inputStream);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    err.notify(1, (Throwable)iOException);
                }
            }
            inputStream.close();
            return manifest;
        }
        return null;
    }

    public static Comparator projectDisplayNameComparator() {
        return new Comparator(){
            private final Collator LOC_COLLATOR = Collator.getInstance();

            public int compare(Object object, Object object2) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                ProjectInformation projectInformation2 = ProjectUtils.getInformation((Project)((Project)object2));
                int n = this.LOC_COLLATOR.compare(projectInformation.getDisplayName(), projectInformation2.getDisplayName());
                if (n != 0) {
                    return n;
                }
                n = projectInformation.getName().compareTo(projectInformation2.getName());
                if (n != 0) {
                    return n;
                }
                return System.identityHashCode(object) - System.identityHashCode(object2);
            }
        };
    }

    public static final class UserPropertiesFileProvider
    implements PropertyProvider,
    PropertyChangeListener,
    ChangeListener {
        private final PropertyEvaluator eval;
        private final File basedir;
        private final List listeners = new ArrayList();
        private PropertyProvider delegate;

        public UserPropertiesFileProvider(PropertyEvaluator propertyEvaluator, File file) {
            this.eval = propertyEvaluator;
            this.basedir = file;
            propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
            this.computeDelegate();
        }

        private void computeDelegate() {
            String string;
            if (this.delegate != null) {
                this.delegate.removeChangeListener((ChangeListener)this);
            }
            if ((string = this.eval.getProperty("user.properties.file")) != null) {
                this.delegate = PropertyUtils.propertiesFilePropertyProvider((File)PropertyUtils.resolveFile((File)this.basedir, (String)string));
                this.delegate.addChangeListener((ChangeListener)this);
            } else {
                this.delegate = PropertyUtils.globalPropertyProvider();
                this.delegate.addChangeListener((ChangeListener)this);
            }
        }

        public Map getProperties() {
            if (this.delegate != null) {
                return this.delegate.getProperties();
            }
            return Collections.EMPTY_MAP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("user.properties.file")) {
                this.computeDelegate();
                this.fireChange();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            Iterator iterator;
            ChangeEvent changeEvent = new ChangeEvent(this);
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                iterator = new HashSet(this.listeners).iterator();
            }
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }
    }

    public static abstract class ComputedPropertyProvider
    implements PropertyProvider,
    PropertyChangeListener {
        private final PropertyEvaluator eval;
        private final List listeners = new ArrayList();

        protected ComputedPropertyProvider(PropertyEvaluator propertyEvaluator) {
            this.eval = propertyEvaluator;
            propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        }

        protected abstract Map getProperties(Map var1);

        protected abstract Set inputProperties();

        public final Map getProperties() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Iterator iterator = this.inputProperties().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashMap.put(string, this.eval.getProperty(string));
            }
            return this.getProperties(hashMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Iterator iterator;
            String string = propertyChangeEvent.getPropertyName();
            if (string != null && !this.inputProperties().contains(string)) {
                return;
            }
            ChangeEvent changeEvent = new ChangeEvent(this);
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                iterator = new HashSet(this.listeners).iterator();
            }
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }
    }
}

