/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

final class BadgingSupport
implements FileSystem.Status,
FileChangeListener {
    private String suffix = "";
    private ClassPath classpath;
    private final FileSystem fs;
    private final FileChangeListener fileChangeListener;
    private final List listeners = new ArrayList();

    public BadgingSupport(FileSystem fileSystem) {
        this.fs = fileSystem;
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        fileSystem.addFileChangeListener(this.fileChangeListener);
    }

    public void setClasspath(ClassPath classPath) {
        this.classpath = classPath;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public void addFileStatusListener(FileStatusListener fileStatusListener) {
        this.listeners.add(fileStatusListener);
    }

    public void removeFileStatusListener(FileStatusListener fileStatusListener) {
        this.listeners.remove(fileStatusListener);
    }

    private void fireFileStatusChanged(FileStatusEvent fileStatusEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((FileStatusListener)iterator.next()).annotationChanged(fileStatusEvent);
        }
    }

    public String annotateName(String string, Set set) {
        return BadgingSupport.annotateNameGeneral(string, set, this.suffix, this.fileChangeListener, this.classpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static String annotateNameGeneral(String string, Set set, String string2, FileChangeListener fileChangeListener, ClassPath classPath) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            URL[] uRLArray;
            FileObject fileObject2 = (FileObject)iterator.next();
            String string3 = (String)fileObject2.getAttribute("SystemFileSystem.localizingBundle");
            if (string3 != null) {
                try {
                    uRLArray = LayerUtils.currentify(new URL("nbresloc:/" + string3.replace('.', '/') + ".properties"), string2, classPath);
                    for (int i = 0; i < uRLArray.length; ++i) {
                        InputStream inputStream = uRLArray[i].openStream();
                        try {
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            String string4 = fileObject2.getPath();
                            String string5 = properties.getProperty(string4);
                            FileObject fileObject3 = URLMapper.findFileObject((URL)uRLArray[i]);
                            if (fileObject3 != null) {
                                fileObject3.removeFileChangeListener(fileChangeListener);
                                fileObject3.addFileChangeListener(fileChangeListener);
                                fileObject3.getParent().removeFileChangeListener(fileChangeListener);
                                fileObject3.getParent().addFileChangeListener(fileChangeListener);
                            }
                            if (string5 == null) continue;
                            if (fileObject2.getPath().startsWith("Menu/")) {
                                String string6 = Actions.cutAmpersand((String)string5);
                                return string6;
                            }
                            String string7 = string5;
                            return string7;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                    return NbBundle.getMessage((Class)BadgingSupport.class, (String)"LBL_no_such_bundle", (Object)string, (Object)string3);
                }
            }
            if (fileObject2.hasExt("instance")) {
                return BadgingSupport.getInstanceLabel(fileObject2);
            }
            if (!fileObject2.hasExt("shadow") || (uRLArray = fileObject2.getAttribute("originalFile")) == null || !(uRLArray instanceof String)) continue;
            try {
                fileObject = fileObject2.getFileSystem().findResource((String)uRLArray);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                fileObject = null;
            }
            if (fileObject == null || !fileObject.hasExt("instance")) continue;
            return BadgingSupport.getInstanceLabel(fileObject);
        }
        return string;
    }

    private static String getInstanceLabel(FileObject fileObject) {
        String string;
        String string2;
        try {
            string2 = (InstanceCookie)DataObject.find((FileObject)fileObject).getCookie(InstanceCookie.class);
            if (string2 != null) {
                Object object = string2.instanceCreate();
                if (object instanceof Action) {
                    String string3 = (String)((Action)object).getValue("Name");
                    if (string3 != null) {
                        return Actions.cutAmpersand((String)string3);
                    }
                    return object.toString();
                }
                if (object instanceof Presenter.Menu) {
                    return ((Presenter.Menu)object).getMenuPresenter().getText();
                }
                if (object instanceof JSeparator) {
                    return NbBundle.getMessage((Class)BadgingSupport.class, (String)"LBL_separator");
                }
                return object.toString();
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        string2 = (String)fileObject.getAttribute("instanceClass");
        if (string2 == null) {
            string2 = fileObject.getName().replace('-', '.');
        }
        if ((string = (String)fileObject.getAttribute("literal:instanceCreate")) != null && string.startsWith("new:")) {
            string2 = string.substring("new:".length());
        } else if (string != null && string.startsWith("method:")) {
            String string4 = string.substring(string.lastIndexOf(46, string.lastIndexOf(46) - 1) + 1);
            return NbBundle.getMessage((Class)BadgingSupport.class, (String)"LBL_instance_from", (Object)string4);
        }
        String string5 = string2.substring(string2.lastIndexOf(46) + 1);
        return NbBundle.getMessage((Class)BadgingSupport.class, (String)"LBL_instance_of", (Object)string5);
    }

    public Image annotateIcon(Image image, int n, Set set) {
        return BadgingSupport.annotateIconGeneral(image, n, set, this.suffix, this.fileChangeListener, this.classpath);
    }

    private static Image annotateIconGeneral(Image image, int n, Set set, String string, FileChangeListener fileChangeListener, ClassPath classPath) {
        String string2;
        if (n == 1) {
            string2 = "SystemFileSystem.icon";
        } else if (n == 2) {
            string2 = "SystemFileSystem.icon32";
        } else {
            return image;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            Object object = fileObject.getAttribute(string2);
            if (object instanceof Image) {
                return (Image)object;
            }
            if (object == null) continue;
            try {
                URL[] uRLArray = LayerUtils.currentify((URL)object, string, classPath);
                FileObject fileObject2 = URLMapper.findFileObject((URL)uRLArray[0]);
                if (fileObject2 != null) {
                    fileObject2.removeFileChangeListener(fileChangeListener);
                    fileObject2.addFileChangeListener(fileChangeListener);
                }
                return Toolkit.getDefaultToolkit().getImage(uRLArray[0]);
            }
            catch (Exception exception) {
                Util.err.notify(1, (Throwable)exception);
            }
        }
        return image;
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.someFileChange(fileEvent);
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.someFileChange((FileEvent)fileAttributeEvent);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.someFileChange((FileEvent)fileRenameEvent);
    }

    public void fileChanged(FileEvent fileEvent) {
        this.someFileChange(fileEvent);
    }

    private void someFileChange(FileEvent fileEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                BadgingSupport.this.fireFileStatusChanged(new FileStatusEvent(BadgingSupport.this.fs, true, true));
            }
        });
    }
}

