/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.BadgingSupport;
import org.netbeans.modules.apisupport.project.layers.WritableXMLFileSystem;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tax.parser.XMLParsingSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.io.TreeStreamResult;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Task;
import org.xml.sax.InputSource;

public class LayerUtils {
    private static final Map layerHandleCache;
    private static final Set XML_LIKE_TYPES;
    static final /* synthetic */ boolean $assertionsDisabled;

    private LayerUtils() {
    }

    static URL[] currentify(URL uRL, String string, ClassPath classPath) {
        if (classPath == null) {
            return new URL[]{uRL};
        }
        try {
            if (uRL.getProtocol().equals("nbres")) {
                FileObject fileObject;
                String string2 = uRL.getFile();
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                if ((fileObject = classPath.findResource(string2)) != null) {
                    return new URL[]{fileObject.getURL()};
                }
            } else if (uRL.getProtocol().equals("nbresloc")) {
                String string3;
                String string4;
                String string5;
                String string6;
                int n;
                ArrayList<URL> arrayList = new ArrayList<URL>();
                String string7 = uRL.getFile();
                if (string7.startsWith("/")) {
                    string7 = string7.substring(1);
                }
                if ((n = string7.lastIndexOf(47)) == -1) {
                    string6 = "";
                    string5 = string7;
                } else {
                    string6 = string7.substring(0, n + 1);
                    string5 = string7.substring(n + 1);
                }
                n = string5.lastIndexOf(46);
                if (n == -1) {
                    string4 = string5;
                    string3 = "";
                } else {
                    string4 = string5.substring(0, n);
                    string3 = string5.substring(n);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>(LayerUtils.computeSubVariants(string));
                arrayList2.add(string);
                Collections.reverse(arrayList2);
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    String string8 = (String)iterator.next();
                    String string9 = string6 + string4 + string8 + string3;
                    FileObject fileObject = classPath.findResource(string9);
                    if (fileObject == null) continue;
                    arrayList.add(fileObject.getURL());
                }
                if (!arrayList.isEmpty()) {
                    return arrayList.toArray(new URL[arrayList.size()]);
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Util.err.notify(16, (Throwable)fileStateInvalidException);
        }
        return new URL[]{uRL};
    }

    private static List computeSubVariants(String string) {
        int n = string.indexOf(95);
        if (n == -1) {
            return Collections.EMPTY_LIST;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        List list = LayerUtils.computeSubVariants(string2, string3);
        return list.subList(0, list.size() - 1);
    }

    private static List computeSubVariants(String string, String string2) {
        int n = string2.indexOf(95, 1);
        if (n == -1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string);
            linkedList.add(string + string2);
            return linkedList;
        }
        String string3 = string2.substring(n);
        List list = LayerUtils.computeSubVariants(string, string3);
        List list2 = LayerUtils.computeSubVariants(string + string2.substring(0, n), string3);
        LinkedList linkedList = new LinkedList(list);
        linkedList.addAll(list2);
        return linkedList;
    }

    public static LayerHandle layerForProject(NbModuleProject nbModuleProject) {
        LayerHandle layerHandle = (LayerHandle)layerHandleCache.get(nbModuleProject);
        if (layerHandle == null) {
            layerHandle = new LayerHandle(nbModuleProject);
            layerHandleCache.put(nbModuleProject, layerHandle);
        }
        return layerHandle;
    }

    public static String findGeneratedName(FileObject fileObject, String string) {
        String string2;
        Matcher matcher = Pattern.compile("(.+/)?([^/.]+)(\\.[^/]+)?").matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string);
        }
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        if (string4 == null) {
            string4 = "";
        } else if (string4.equals(".java")) {
            string4 = "_java";
        } else if (XML_LIKE_TYPES.contains(string4)) {
            string2 = string4.substring(1, 2).toUpperCase(Locale.ENGLISH);
            string3 = string3 + string2 + string4.substring(2);
            string4 = ".xml";
        }
        string2 = string3 + string4;
        if (fileObject == null || fileObject.getFileObject(string2) == null) {
            return string2;
        }
        int n = 1;
        while (fileObject.getFileObject(string2 = string3 + '_' + n + string4) != null) {
            ++n;
        }
        return string2;
    }

    static SavableTreeEditorCookie cookieForFile(FileObject fileObject) {
        return new CookieImpl(fileObject);
    }

    public static FileSystem getEffectiveSystemFilesystem(Project project) throws IOException {
        if (project instanceof NbModuleProject) {
            NbModuleProject nbModuleProject = (NbModuleProject)project;
            NbModuleTypeProvider.NbModuleType nbModuleType = ((NbModuleTypeProvider)nbModuleProject.getLookup().lookup(NbModuleTypeProvider.class)).getModuleType();
            FileSystem fileSystem = LayerUtils.layerForProject(nbModuleProject).layer(false);
            if (nbModuleType == NbModuleTypeProvider.STANDALONE) {
                Set set = LayerUtils.getPlatformJarsForStandaloneProject(nbModuleProject);
                FileSystem fileSystem2 = LayerUtils.getPlatformLayers(set);
                ClassPath classPath = LayerUtils.createLayerClasspath(Collections.singleton(nbModuleProject), set);
                return LayerUtils.mergeFilesystems(fileSystem, new FileSystem[]{fileSystem2}, classPath);
            }
            if (nbModuleType == NbModuleTypeProvider.SUITE_COMPONENT) {
                LayerHandle layerHandle;
                Object object;
                SuiteProject suiteProject = SuiteUtils.findSuite(nbModuleProject);
                if (suiteProject == null) {
                    throw new IOException("Could not load suite for " + nbModuleProject);
                }
                ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
                Set set = SuiteUtils.getSubProjects(suiteProject);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    FileSystem fileSystem3;
                    object = (NbModuleProject)iterator.next();
                    if (object == nbModuleProject || (fileSystem3 = (layerHandle = LayerUtils.layerForProject((NbModuleProject)object)).layer(false)) == null) continue;
                    arrayList.add(fileSystem3);
                }
                object = LayerUtils.getPlatformJarsForSuiteComponentProject(nbModuleProject, suiteProject);
                arrayList.add(LayerUtils.getPlatformLayers((Set)object));
                layerHandle = LayerUtils.createLayerClasspath(set, (Set)object);
                return LayerUtils.mergeFilesystems(fileSystem, arrayList.toArray(new FileSystem[arrayList.size()]), (ClassPath)layerHandle);
            }
            if (nbModuleType == NbModuleTypeProvider.NETBEANS_ORG) {
                ManifestManager manifestManager;
                NbModuleProject nbModuleProject2;
                Set set;
                block10: {
                    set = LayerUtils.getProjectsForNetBeansOrgProject(nbModuleProject);
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        FileObject fileObject;
                        FileObject fileObject2;
                        nbModuleProject2 = (NbModuleProject)iterator.next();
                        manifestManager = ManifestManager.getInstance(nbModuleProject2.getManifest(), false);
                        String string = manifestManager.getLayer();
                        if (string == null || (fileObject2 = nbModuleProject2.getSourceDirectory()) == null || (fileObject = fileObject2.getFileObject(string)) == null) continue;
                        arrayList.add(fileObject.getURL());
                    }
                    nbModuleProject2 = new XMLFileSystem();
                    try {
                        nbModuleProject2.setXmlUrls(arrayList.toArray(new URL[arrayList.size()]));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        if ($assertionsDisabled) break block10;
                        throw new AssertionError((Object)propertyVetoException);
                    }
                }
                manifestManager = LayerUtils.createLayerClasspath(set, Collections.EMPTY_SET);
                return LayerUtils.mergeFilesystems(fileSystem, new FileSystem[]{nbModuleProject2}, (ClassPath)manifestManager);
            }
            throw new AssertionError(nbModuleType);
        }
        if (project instanceof SuiteProject) {
            SuiteProject suiteProject = (SuiteProject)project;
            throw new AssertionError((Object)"XXX not yet implemented");
        }
        throw new IllegalArgumentException(project.toString());
    }

    static Set getPlatformJarsForStandaloneProject(NbModuleProject nbModuleProject) {
        NbPlatform nbPlatform = nbModuleProject.getPlatform(true);
        return LayerUtils.getPlatformJars(nbPlatform, null, null);
    }

    static Set getPlatformJarsForSuiteComponentProject(NbModuleProject nbModuleProject, SuiteProject suiteProject) {
        NbPlatform nbPlatform = suiteProject.getPlatform(true);
        PropertyEvaluator propertyEvaluator = suiteProject.getEvaluator();
        String[] stringArray = SuiteProperties.getArrayProperty(propertyEvaluator, "disabled.clusters");
        String[] stringArray2 = SuiteProperties.getArrayProperty(propertyEvaluator, "disabled.modules");
        return LayerUtils.getPlatformJars(nbPlatform, stringArray, stringArray2);
    }

    static Set getProjectsForNetBeansOrgProject(NbModuleProject nbModuleProject) throws IOException {
        ModuleList moduleList = nbModuleProject.getModuleList();
        HashSet<NbModuleProject> hashSet = new HashSet<NbModuleProject>();
        hashSet.add(nbModuleProject);
        Iterator iterator = moduleList.getAllEntriesSoft().iterator();
        while (iterator.hasNext()) {
            ModuleEntry moduleEntry = (ModuleEntry)iterator.next();
            if (moduleEntry.getClusterDirectory().getName().equals("extra")) continue;
            File file = moduleEntry.getSourceLocation();
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError(moduleEntry);
            }
            NbModuleProject nbModuleProject2 = (NbModuleProject)ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
            if (nbModuleProject2 == null) continue;
            hashSet.add(nbModuleProject2);
        }
        return hashSet;
    }

    private static Set getPlatformJars(NbPlatform nbPlatform, String[] stringArray, String[] stringArray2) {
        if (nbPlatform == null) {
            return Collections.EMPTY_SET;
        }
        Set<String> set = stringArray != null ? new HashSet<String>(Arrays.asList(stringArray)) : Collections.EMPTY_SET;
        Set<String> set2 = stringArray2 != null ? new HashSet<String>(Arrays.asList(stringArray2)) : Collections.EMPTY_SET;
        ModuleEntry[] moduleEntryArray = nbPlatform.getModules();
        HashSet<File> hashSet = new HashSet<File>(moduleEntryArray.length);
        for (int i = 0; i < moduleEntryArray.length; ++i) {
            if (set.contains(moduleEntryArray[i].getClusterDirectory().getName()) || set2.contains(moduleEntryArray[i].getCodeNameBase())) continue;
            hashSet.add(moduleEntryArray[i].getJarLocation());
        }
        return hashSet;
    }

    private static FileSystem getPlatformLayers(Set set) throws IOException {
        File file;
        block3: {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                file = (File)iterator.next();
                ManifestManager manifestManager = ManifestManager.getInstanceFromJAR(file);
                String string = manifestManager.getLayer();
                if (string == null) continue;
                arrayList.add(new URL("jar:" + file.toURI() + "!/" + string));
            }
            file = new XMLFileSystem();
            try {
                file.setXmlUrls(arrayList.toArray(new URL[arrayList.size()]));
            }
            catch (PropertyVetoException propertyVetoException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)propertyVetoException);
            }
        }
        return file;
    }

    static ClassPath createLayerClasspath(Set set, Set set2) throws IOException {
        Object object;
        Object object2;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (NbModuleProject)iterator.next();
            object = ((NbModuleProject)object2).getSourceDirectory();
            if (object == null) continue;
            arrayList.add(object.getURL());
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            object2 = (File)iterator.next();
            arrayList.add(FileUtil.getArchiveRoot((URL)((File)object2).toURI().toURL()));
            object = new File(((File)object2).getParentFile(), "locale");
            if (!((File)object).isDirectory()) continue;
            String string = ((File)object2).getName();
            int n = string.lastIndexOf(46);
            if (n == -1) {
                n = string.length();
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n);
            String[] stringArray = ((File)object).list();
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string2) || !stringArray[i].endsWith(string3) || stringArray[i].charAt(n) != '_') continue;
                arrayList.add(FileUtil.getArchiveRoot((URL)new File((File)object, stringArray[i]).toURI().toURL()));
            }
        }
        return ClassPathSupport.createClassPath((URL[])arrayList.toArray(new URL[arrayList.size()]));
    }

    private static FileSystem mergeFilesystems(FileSystem fileSystem, FileSystem[] fileSystemArray, ClassPath classPath) {
        if (fileSystem == null) {
            fileSystem = new XMLFileSystem();
        }
        FileSystem[] fileSystemArray2 = new FileSystem[fileSystemArray.length + 1];
        fileSystemArray2[0] = fileSystem;
        System.arraycopy(fileSystemArray, 0, fileSystemArray2, 1, fileSystemArray.length);
        class BadgingMergedFileSystem
        extends MultiFileSystem {
            private final BadgingSupport status;
            private final /* synthetic */ FileSystem[] val$layers;
            private final /* synthetic */ ClassPath val$cp;

            public BadgingMergedFileSystem(FileSystem[] fileSystemArray, ClassPath classPath) {
                this.val$layers = fileSystemArray;
                this.val$cp = classPath;
                super(fileSystemArray);
                this.status = new BadgingSupport((FileSystem)this);
                this.status.setClasspath(this.val$cp);
                this.status.setSuffix("_" + Locale.getDefault());
            }

            public FileSystem.Status getStatus() {
                return this.status;
            }
        }
        return new BadgingMergedFileSystem(fileSystemArray2, classPath);
    }

    static {
        $assertionsDisabled = !LayerUtils.class.desiredAssertionStatus();
        layerHandleCache = new WeakHashMap();
        XML_LIKE_TYPES = new HashSet();
        XML_LIKE_TYPES.add(".settings");
        XML_LIKE_TYPES.add(".wstcref");
        XML_LIKE_TYPES.add(".wsmode");
        XML_LIKE_TYPES.add(".wsgrp");
        XML_LIKE_TYPES.add(".wsmgr");
    }

    public static final class LayerHandle {
        private final NbModuleProject project;
        private FileSystem fs;
        private SavableTreeEditorCookie cookie;
        private boolean autosave;

        LayerHandle(NbModuleProject nbModuleProject) {
            this.project = nbModuleProject;
        }

        public synchronized FileSystem layer(boolean bl) {
            if (this.fs == null) {
                FileObject fileObject = this.getLayerFile();
                if (fileObject == null) {
                    if (!bl) {
                        return null;
                    }
                    try {
                        String string = ManifestManager.getInstance(this.project.getManifest(), false).getLayer();
                        if (string == null) {
                            string = this.newLayerPath();
                            FileObject fileObject2 = this.project.getManifestFile();
                            EditableManifest editableManifest = Util.loadManifest(fileObject2);
                            editableManifest.setAttribute("OpenIDE-Module-Layer", string, null);
                            Util.storeManifest(fileObject2, editableManifest);
                        }
                        fileObject = NbModuleProjectGenerator.createLayer(this.project.getProjectDirectory(), this.project.evaluator().getProperty("src.dir") + '/' + this.newLayerPath());
                    }
                    catch (IOException iOException) {
                        Util.err.notify(1, (Throwable)iOException);
                        this.fs = FileUtil.createMemoryFileSystem();
                        return this.fs;
                    }
                }
                try {
                    this.cookie = LayerUtils.cookieForFile(fileObject);
                    this.fs = new WritableXMLFileSystem(fileObject.getURL(), this.cookie, null);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    throw new AssertionError((Object)fileStateInvalidException);
                }
                this.cookie.addPropertyChangeListener(new PropertyChangeListener(this){
                    private final /* synthetic */ LayerHandle this$0;
                    {
                        this.this$0 = layerHandle;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (LayerHandle.access$100(this.this$0) && "dirty".equals(propertyChangeEvent.getPropertyName())) {
                            try {
                                this.this$0.save();
                            }
                            catch (IOException iOException) {
                                Util.err.notify(1, (Throwable)iOException);
                            }
                        }
                    }
                });
            }
            return this.fs;
        }

        public void save() throws IOException {
            if (this.cookie == null) {
                throw new IOException("Cannot save a nonexistent layer");
            }
            this.cookie.save();
        }

        public FileObject getLayerFile() {
            Manifest manifest = this.project.getManifest();
            if (manifest == null) {
                return null;
            }
            String string = ManifestManager.getInstance(manifest, false).getLayer();
            if (string == null) {
                return null;
            }
            return this.project.getSourceDirectory().getFileObject(string);
        }

        public void setAutosave(boolean bl) {
            this.autosave = bl;
            if (bl && this.cookie != null) {
                try {
                    this.cookie.save();
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                }
            }
        }

        public boolean isAutosave() {
            return this.autosave;
        }

        private String newLayerPath() {
            return this.project.getCodeNameBase().replace('.', '/') + "/resources/layer.xml";
        }

        static /* synthetic */ boolean access$100(LayerHandle layerHandle) {
            return layerHandle.autosave;
        }
    }

    private static final class CookieImpl
    implements SavableTreeEditorCookie,
    FileChangeListener {
        private TreeDocumentRoot root;
        private boolean dirty;
        private Exception problem;
        private final FileObject f;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private boolean saving;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CookieImpl(FileObject fileObject) {
            this.f = fileObject;
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject));
        }

        public TreeDocumentRoot getDocumentRoot() {
            return this.root;
        }

        public int getStatus() {
            if (this.problem != null) {
                return 3;
            }
            if (this.root != null) {
                return 1;
            }
            return 0;
        }

        public TreeDocumentRoot openDocumentRoot() throws IOException, TreeException {
            if (this.root == null) {
                try {
                    boolean bl = this.dirty;
                    int n = this.getStatus();
                    this.root = new XMLParsingSupport().parse(new InputSource(this.f.getURL().toExternalForm()));
                    this.problem = null;
                    this.dirty = false;
                    this.pcs.firePropertyChange("dirty", bl, false);
                    this.pcs.firePropertyChange("status", n, 1);
                }
                catch (IOException iOException) {
                    this.problem = iOException;
                    throw iOException;
                }
                catch (TreeException treeException) {
                    this.problem = treeException;
                    throw treeException;
                }
                ((TreeObject)this.root).addPropertyChangeListener(new PropertyChangeListener(this){
                    private final /* synthetic */ CookieImpl this$0;
                    {
                        this.this$0 = cookieImpl;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        CookieImpl.access$000(this.this$0);
                    }
                });
            }
            return this.root;
        }

        public Task prepareDocumentRoot() {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        private void modified() {
            if (!this.dirty) {
                this.dirty = true;
                this.pcs.firePropertyChange("dirty", false, true);
            }
        }

        public boolean isDirty() {
            return this.dirty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void save() throws IOException {
            if (this.root == null || !this.dirty) {
                return;
            }
            if (!$assertionsDisabled && this.saving) {
                throw new AssertionError();
            }
            this.saving = true;
            try {
                FileLock fileLock = this.f.lock();
                try {
                    OutputStream outputStream = this.f.getOutputStream(fileLock);
                    try {
                        new TreeStreamResult(outputStream).getWriter(this.root).writeDocument();
                    }
                    catch (TreeException treeException) {
                        throw (IOException)new IOException(treeException.toString()).initCause(treeException);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            finally {
                this.saving = false;
            }
            this.dirty = false;
            this.pcs.firePropertyChange("dirty", true, false);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.changed();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.changed();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.changed();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        private synchronized void changed() {
            if (this.saving) {
                return;
            }
            this.problem = null;
            this.dirty = false;
            this.root = null;
            this.pcs.firePropertyChange("documentRoot", null, null);
        }

        static /* synthetic */ void access$000(CookieImpl cookieImpl) {
            cookieImpl.modified();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$layers$LayerUtils == null ? (class$org$netbeans$modules$apisupport$project$layers$LayerUtils = LayerUtils.class$("org.netbeans.modules.apisupport.project.layers.LayerUtils")) : class$org$netbeans$modules$apisupport$project$layers$LayerUtils).desiredAssertionStatus();
        }
    }

    static interface SavableTreeEditorCookie
    extends TreeEditorCookie {
        public static final String PROP_DIRTY = "dirty";

        public boolean isDirty();

        public void save() throws IOException;
    }
}

