/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCDATASection;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeText;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class WritableXMLFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Attr,
AbstractFileSystem.Change,
AbstractFileSystem.Info,
AbstractFileSystem.List,
FileChangeListener,
PropertyChangeListener {
    private final TreeEditorCookie cookie;
    private TreeDocumentRoot doc;
    private URL location;
    private String suffix;
    private final FileChangeListener fileChangeListener;
    private ClassPath classpath;
    private static final Set warnedAboutDupeKids;
    private final Set orderAbsorbers = new HashSet();
    private static final int INDENT_STEP = 4;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WritableXMLFileSystem(URL uRL, TreeEditorCookie treeEditorCookie, ClassPath classPath) {
        this.attr = this;
        this.change = this;
        this.info = this;
        this.list = this;
        this.cookie = treeEditorCookie;
        try {
            this.doc = treeEditorCookie.openDocumentRoot();
        }
        catch (TreeException treeException) {
            Util.err.notify(1, (Throwable)treeException);
        }
        catch (IOException iOException) {
            Util.err.notify(1, (Throwable)iOException);
        }
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        treeEditorCookie.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)treeEditorCookie));
        this.setLocation(uRL);
        this.setClasspath(classPath);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException("WritableXMLFileSystem is not persistent");
    }

    private void setLocation(URL uRL) {
        String string = uRL.toExternalForm();
        if (string.endsWith("/")) {
            throw new IllegalArgumentException(string);
        }
        this.location = uRL;
    }

    private void setClasspath(ClassPath classPath) {
        this.classpath = classPath;
    }

    public String getDisplayName() {
        FileObject fileObject = URLMapper.findFileObject((URL)this.location);
        if (fileObject != null) {
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }
        return this.location.toExternalForm();
    }

    public boolean isReadOnly() {
        return false;
    }

    private TreeElement getRootElement() {
        if (this.doc == null) {
            return null;
        }
        Iterator iterator = this.doc.getChildNodes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TreeElement)) continue;
            return (TreeElement)e;
        }
        return null;
    }

    private TreeElement findElement(String string) {
        return WritableXMLFileSystem.findElementIn(this.getRootElement(), string);
    }

    private static TreeElement findElementIn(TreeElement treeElement, String string) {
        String string2;
        String string3;
        if (treeElement == null) {
            return null;
        }
        if (string.equals("")) {
            return treeElement;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        TreeElement treeElement2 = null;
        Iterator iterator = treeElement.getChildNodes(TreeElement.class).iterator();
        while (iterator.hasNext()) {
            TreeAttribute treeAttribute;
            TreeElement treeElement3 = (TreeElement)iterator.next();
            if (!treeElement3.getLocalName().equals("file") && !treeElement3.getLocalName().equals("folder") || (treeAttribute = treeElement3.getAttribute("name")) == null || !treeAttribute.getValue().equals(string3)) continue;
            treeElement2 = treeElement3;
            break;
        }
        return WritableXMLFileSystem.findElementIn(treeElement2, string2);
    }

    public boolean folder(String string) {
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return false;
        }
        boolean bl = treeElement.getLocalName().equals("folder");
        return bl;
    }

    public String[] children(String string) {
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return new String[0];
        }
        Iterator iterator = treeElement.getChildNodes(TreeElement.class).iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            TreeAttribute treeAttribute;
            TreeElement treeElement2 = (TreeElement)iterator.next();
            if (!treeElement2.getLocalName().equals("file") && !treeElement2.getLocalName().equals("folder") || (treeAttribute = treeElement2.getAttribute("name")) == null) continue;
            String string2 = treeAttribute.getValue();
            if (hashSet.add(string2)) {
                arrayList.add(string2);
                continue;
            }
            if (!warnedAboutDupeKids.add(this.location + ":" + string + "/" + string2) || !string.equals("")) continue;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private byte[] getContentsOf(String string) throws FileNotFoundException {
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            throw new FileNotFoundException(string);
        }
        TreeAttribute treeAttribute = treeElement.getAttribute("url");
        if (treeAttribute != null) {
            try {
                URL[] uRLArray = LayerUtils.currentify(new URL(this.location, treeAttribute.getValue()), this.suffix, this.classpath);
                URLConnection uRLConnection = uRLArray[0].openConnection();
                uRLConnection.connect();
                InputStream inputStream = uRLConnection.getInputStream();
                byte[] byArray = new byte[uRLConnection.getContentLength()];
                if (inputStream.read(byArray) != byArray.length) {
                    throw new IOException("wrong content length");
                }
                FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[0]);
                if (fileObject != null) {
                    fileObject.removeFileChangeListener(this.fileChangeListener);
                    fileObject.addFileChangeListener(this.fileChangeListener);
                }
                return byArray;
            }
            catch (IOException iOException) {
                throw new FileNotFoundException(iOException.getMessage());
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = treeElement.getChildNodes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof TreeCDATASection) {
                stringBuffer.append(((TreeCDATASection)e).getData());
                continue;
            }
            if (!(e instanceof TreeText)) continue;
            stringBuffer.append(((TreeText)e).getData().trim());
        }
        try {
            return stringBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FileNotFoundException(unsupportedEncodingException.getMessage());
        }
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        return new ByteArrayInputStream(this.getContentsOf(string));
    }

    public OutputStream outputStream(final String string) throws IOException {
        final TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            throw new FileNotFoundException(string);
        }
        TreeAttribute treeAttribute = treeElement.getAttribute("url");
        if (treeAttribute != null) {
            String string2 = treeAttribute.getValue();
            if (URI.create(string2).isAbsolute()) {
                throw new IOException(string);
            }
            FileObject fileObject = URLMapper.findFileObject((URL)new URL(this.location, string2));
            if (fileObject == null) {
                throw new FileNotFoundException(string);
            }
            final FileLock fileLock = fileObject.lock();
            return new FilterOutputStream(fileObject.getOutputStream(fileLock)){

                public void close() throws IOException {
                    super.close();
                    fileLock.releaseLock();
                }
            };
        }
        return new ByteArrayOutputStream(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                block11: {
                    super.close();
                    byte[] byArray = this.toByteArray();
                    FileObject fileObject = WritableXMLFileSystem.this.findLayerParent();
                    String string2 = LayerUtils.findGeneratedName(fileObject, string);
                    if (!$assertionsDisabled && string2.indexOf(47) != -1) {
                        throw new AssertionError((Object)string2);
                    }
                    FileObject fileObject2 = fileObject.createData(string2);
                    FileLock fileLock = fileObject2.lock();
                    try {
                        OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                        try {
                            outputStream.write(byArray);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    finally {
                        fileLock.releaseLock();
                    }
                    fileObject2.addFileChangeListener(WritableXMLFileSystem.this.fileChangeListener);
                    try {
                        treeElement.addAttribute("url", string2);
                    }
                    catch (ReadOnlyException readOnlyException) {
                        throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
                    }
                    catch (InvalidArgumentException invalidArgumentException) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError((Object)invalidArgumentException);
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$layers$WritableXMLFileSystem == null ? (class$org$netbeans$modules$apisupport$project$layers$WritableXMLFileSystem = WritableXMLFileSystem.class$("org.netbeans.modules.apisupport.project.layers.WritableXMLFileSystem")) : class$org$netbeans$modules$apisupport$project$layers$WritableXMLFileSystem).desiredAssertionStatus();
            }
        };
    }

    private FileObject findLayerParent() throws IOException {
        String string = this.location.toExternalForm();
        int n = string.lastIndexOf(47);
        if (!$assertionsDisabled && n == -1) {
            throw new AssertionError((Object)string);
        }
        FileObject fileObject = URLMapper.findFileObject((URL)new URL(string.substring(0, n + 1)));
        if (fileObject == null) {
            throw new IOException(string);
        }
        return fileObject;
    }

    private void createFileOrFolder(String string, boolean bl) throws IOException {
        String string2;
        String string3;
        int n = string.lastIndexOf(47);
        if (n == -1) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        TreeElement treeElement = this.findElement(string3);
        if (treeElement == null) {
            throw new FileNotFoundException(string3);
        }
        try {
            TreeElement treeElement2 = new TreeElement(bl ? "folder" : "file", true);
            treeElement2.addAttribute("name", string2);
            WritableXMLFileSystem.appendWithIndent(treeElement, (TreeChild)treeElement2);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)invalidArgumentException);
            }
        }
        catch (ReadOnlyException readOnlyException) {
            throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
        }
    }

    public void createFolder(String string) throws IOException {
        this.createFileOrFolder(string, true);
    }

    public void createData(String string) throws IOException {
        this.createFileOrFolder(string, false);
    }

    public void delete(String string) throws IOException {
        FileObject fileObject;
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            throw new FileNotFoundException(string);
        }
        TreeAttribute treeAttribute = treeElement.getAttribute("url");
        if (treeAttribute != null && !URI.create(treeAttribute.getValue()).isAbsolute() && (fileObject = URLMapper.findFileObject((URL)new URL(this.location, treeAttribute.getValue()))) != null) {
            fileObject.removeFileChangeListener(this.fileChangeListener);
            fileObject.delete();
        }
        try {
            WritableXMLFileSystem.deleteWithIndent((TreeChild)treeElement);
        }
        catch (ReadOnlyException readOnlyException) {
            throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
        }
    }

    public void rename(String string, String string2) throws IOException {
        block7: {
            TreeElement treeElement = this.findElement(string);
            if (treeElement == null) {
                throw new FileNotFoundException(string);
            }
            int n = string2.lastIndexOf(47) + 1;
            if (n != string.lastIndexOf(47) + 1 || !string.substring(0, n).equals(string2.substring(0, n))) {
                throw new IOException("Cannot rename to a different dir: " + string + " -> " + string2);
            }
            String string3 = string2.substring(n);
            if (!$assertionsDisabled && string3.indexOf(47) != -1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && string3.length() <= 0) {
                throw new AssertionError();
            }
            try {
                treeElement.getAttribute("name").setValue(string3);
            }
            catch (ReadOnlyException readOnlyException) {
                throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)invalidArgumentException);
            }
        }
    }

    public Enumeration attributes(String string) {
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return Enumerations.empty();
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        Iterator iterator = treeElement.getChildNodes(TreeElement.class).iterator();
        while (iterator.hasNext()) {
            TreeAttribute treeAttribute;
            TreeElement treeElement2 = (TreeElement)iterator.next();
            if (!treeElement2.getLocalName().equals("attr") || (treeAttribute = treeElement2.getAttribute("name")) == null) continue;
            arrayList.add(treeAttribute.getValue());
        }
        return Collections.enumeration(arrayList);
    }

    public Object readAttribute(String string, String string2) {
        if (string2.equals("WritableXMLFileSystem.cp")) {
            return this.classpath;
        }
        if (string2.equals("WritableXMLFileSystem.location")) {
            return this.location;
        }
        if (string2.equals("DataFolder.Index.reorderable")) {
            return Boolean.TRUE;
        }
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return null;
        }
        boolean bl = false;
        if (string2.startsWith("literal:")) {
            string2 = string2.substring("literal:".length());
            bl = true;
        }
        Iterator iterator = treeElement.getChildNodes(TreeElement.class).iterator();
        while (iterator.hasNext()) {
            TreeAttribute treeAttribute;
            TreeElement treeElement2 = (TreeElement)iterator.next();
            if (!treeElement2.getLocalName().equals("attr") || (treeAttribute = treeElement2.getAttribute("name")) == null || !string2.equals(treeAttribute.getValue())) continue;
            try {
                String string3;
                treeAttribute = treeElement2.getAttribute("stringvalue");
                if (treeAttribute != null) {
                    string3 = treeAttribute.getValue();
                    StringBuffer stringBuffer = new StringBuffer(string3.length());
                    for (int i = 0; i < string3.length(); ++i) {
                        char c = string3.charAt(i);
                        if (c == '\\' && string3.charAt(i + 1) == 'u' && i + 5 < string3.length()) {
                            String string4 = string3.substring(i + 2, i + 6);
                            try {
                                stringBuffer.append((char)Integer.parseInt(string4, 16));
                                i += 5;
                            }
                            catch (NumberFormatException numberFormatException) {
                                stringBuffer.append(c);
                            }
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                    return stringBuffer.toString();
                }
                treeAttribute = treeElement2.getAttribute("boolvalue");
                if (treeAttribute != null) {
                    return Boolean.valueOf(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("urlvalue");
                if (treeAttribute != null) {
                    return new URL(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("newvalue");
                if (treeAttribute != null) {
                    string3 = treeAttribute.getValue();
                    if (!bl) continue;
                    return "new:" + string3;
                }
                treeAttribute = treeElement2.getAttribute("methodvalue");
                if (treeAttribute == null) continue;
                string3 = treeAttribute.getValue();
                if (!bl) continue;
                return "method:" + string3;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public void writeAttribute(String string, String string2, Object object) throws IOException {
        Object object2;
        TreeElement treeElement;
        Object object3;
        Object object4;
        if (object != null && object.getClass().getName().equals("org.openide.filesystems.MultiFileObject$VoidValue")) {
            object = null;
        }
        if (object == null && string2.indexOf(47) != -1) {
            object4 = string + '/' + string2;
            if (this.orderAbsorbers.remove(object4)) {
                return;
            }
            object = Boolean.FALSE;
        }
        if (string.indexOf(47) == -1) {
            object4 = this.orderAbsorbers.iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                if (!((String)object3).startsWith(string + '/')) continue;
                object4.remove();
            }
        }
        if (string2.equals("OpenIDE-Folder-Order") && object instanceof String) {
            object4 = Collections.list(new StringTokenizer((String)object, "/"));
            if (!object4.isEmpty()) {
                object3 = new HashSet<String>(Arrays.asList(this.children(string)));
                Iterator iterator = object4.iterator();
                String string3 = (String)iterator.next();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (object3.contains(string3) || object3.contains(string4)) {
                        this.writeAttribute(string, string3 + '/' + string4, Boolean.TRUE);
                    }
                    string3 = string4;
                }
            }
            for (int i = 0; i < object4.size() - 1; ++i) {
                for (int j = i + 1; j < object4.size(); ++j) {
                    this.orderAbsorbers.add(string + '/' + (String)object4.get(i) + '/' + (String)object4.get(j));
                }
            }
            return;
        }
        object4 = this.findElement(string);
        if (object4 == null) {
            throw new FileNotFoundException(string);
        }
        object3 = null;
        Iterator iterator = object4.getChildNodes(TreeElement.class).iterator();
        while (iterator.hasNext()) {
            treeElement = (TreeElement)iterator.next();
            if (!treeElement.getLocalName().equals("attr") || (object2 = treeElement.getAttribute("name")) == null || !object2.getValue().equals(string2)) continue;
            object3 = treeElement;
            break;
        }
        try {
            treeElement = new TreeElement("attr", true);
            treeElement.addAttribute("name", string2);
            if (object instanceof String) {
                object2 = (String)object;
                String string5 = "newvalue:";
                String string6 = "methodvalue:";
                if (((String)object2).startsWith(string5)) {
                    treeElement.addAttribute("newvalue", ((String)object2).substring(string5.length()));
                } else if (((String)object2).startsWith(string6)) {
                    treeElement.addAttribute("methodvalue", ((String)object2).substring(string6.length()));
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < ((String)object2).length(); ++i) {
                        char c = ((String)object2).charAt(i);
                        if (Character.isISOControl(c) || c == '&' || c == '<' || c == '>' || c == '\"' || c == '\'') {
                            stringBuffer.append(WritableXMLFileSystem.encodeChar(c));
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                    treeElement.addAttribute("stringvalue", stringBuffer.toString());
                }
            } else if (object instanceof URL) {
                treeElement.addAttribute("urlvalue", ((URL)object).toExternalForm());
            } else if (object instanceof Boolean) {
                treeElement.addAttribute("boolvalue", object.toString());
            } else if (object instanceof Character) {
                treeElement.addAttribute("charvalue", object.toString());
            } else if (object instanceof Integer) {
                treeElement.addAttribute("intvalue", object.toString());
            } else if (object != null) {
                throw new UnsupportedOperationException("XXX: " + object);
            }
            if (object != null && object3 == null) {
                WritableXMLFileSystem.appendWithIndent((TreeElement)object4, (TreeChild)treeElement);
            } else if (object != null) {
                object4.replaceChild((TreeChild)object3, (TreeChild)treeElement);
            } else if (object3 != null) {
                WritableXMLFileSystem.deleteWithIndent((TreeChild)object3);
            }
        }
        catch (InvalidArgumentException invalidArgumentException) {
            throw new AssertionError((Object)invalidArgumentException);
        }
        catch (ReadOnlyException readOnlyException) {
            throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
        }
    }

    private static String encodeChar(char c) {
        String string = Integer.toString(c, 16);
        return "\\u" + "0000".substring(0, "0000".length() - string.length()).concat(string);
    }

    public void renameAttributes(String string, String string2) {
    }

    public void deleteAttributes(String string) {
    }

    public boolean readOnly(String string) {
        return false;
    }

    public String mimeType(String string) {
        return null;
    }

    public long size(String string) {
        try {
            return this.getContentsOf(string).length;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 0L;
        }
    }

    public void markUnimportant(String string) {
    }

    public Date lastModified(String string) {
        FileObject fileObject;
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return new Date(0L);
        }
        TreeAttribute treeAttribute = treeElement.getAttribute("url");
        if (treeAttribute == null) {
            return new Date(0L);
        }
        String string2 = treeAttribute.getValue();
        if (URI.create(string2).isAbsolute()) {
            return new Date(0L);
        }
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(this.location, string2));
        }
        catch (MalformedURLException malformedURLException) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)malformedURLException);
            }
            return new Date(0L);
        }
        if (fileObject == null) {
            return new Date(0L);
        }
        return fileObject.lastModified();
    }

    public void lock(String string) throws IOException {
    }

    public void unlock(String string) {
    }

    private static void appendWithIndent(TreeElement treeElement, TreeChild treeChild) throws ReadOnlyException {
        block8: {
            TreeElement treeElement2 = treeElement;
            int n = -2;
            while (treeElement2 != null) {
                treeElement2 = treeElement2.getParentNode();
                ++n;
            }
            TreeChild treeChild2 = WritableXMLFileSystem.insertBefore(treeElement, treeChild);
            try {
                if (treeChild2 != null) {
                    treeElement.insertBefore(treeChild, treeChild2);
                    treeElement.insertBefore((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces((n + 1) * 4)), treeChild2);
                } else {
                    if (treeElement.hasChildNodes()) {
                        treeElement.appendChild((TreeChild)new TreeText(WritableXMLFileSystem.spaces(4)));
                    } else {
                        treeElement.appendChild((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces((n + 1) * 4)));
                    }
                    treeElement.appendChild(treeChild);
                    treeElement.appendChild((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces(n * 4)));
                }
                treeElement.normalize();
                TreeElement treeElement3 = (TreeElement)treeChild;
                if (treeElement3.getQName().equals("attr") && treeElement3.getAttribute("name").getValue().indexOf(47) != -1) {
                    WritableXMLFileSystem.resort(treeElement);
                }
            }
            catch (InvalidArgumentException invalidArgumentException) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)invalidArgumentException);
            }
        }
    }

    private static TreeChild insertBefore(TreeElement treeElement, TreeChild treeChild) throws ReadOnlyException {
        if (!(treeChild instanceof TreeElement)) {
            return null;
        }
        TreeElement treeElement2 = (TreeElement)treeChild;
        if (treeElement2.getQName().equals("file") || treeElement2.getQName().equals("folder")) {
            String string = treeElement2.getAttribute("name").getValue();
            Iterator iterator = treeElement.getChildNodes(TreeElement.class).iterator();
            while (iterator.hasNext()) {
                String string2;
                TreeAttribute treeAttribute;
                TreeElement treeElement3 = (TreeElement)iterator.next();
                if (!treeElement3.getQName().equals("file") && !treeElement3.getQName().equals("folder") || (treeAttribute = treeElement3.getAttribute("name")) == null || (string2 = treeAttribute.getValue()).compareTo(string) <= 0) continue;
                return treeElement3;
            }
            return null;
        }
        if (treeElement2.getQName().equals("attr")) {
            String string = treeElement2.getAttribute("name").getValue();
            int n = string.indexOf(47);
            if (n == -1) {
                Iterator iterator = treeElement.getChildNodes(TreeElement.class).iterator();
                while (iterator.hasNext()) {
                    TreeElement treeElement4 = (TreeElement)iterator.next();
                    if (treeElement4.getQName().equals("file") || treeElement4.getQName().equals("folder")) {
                        return treeElement4;
                    }
                    if (treeElement4.getQName().equals("attr")) {
                        String string3;
                        TreeAttribute treeAttribute = treeElement4.getAttribute("name");
                        if (treeAttribute == null || (string3 = treeAttribute.getValue()).compareTo(string) <= 0) continue;
                        return treeElement4;
                    }
                    throw new AssertionError((Object)("Weird child: " + treeElement4.getQName()));
                }
                return null;
            }
            return null;
        }
        throw new AssertionError((Object)("Weird child: " + treeElement2.getQName()));
    }

    private static void resort(TreeElement treeElement) throws ReadOnlyException {
        class Item {
            public TreeElement child;

            Item() {
            }

            boolean isAttr() {
                return this.child.getQName().equals("attr");
            }

            String getName() {
                TreeAttribute treeAttribute = this.child.getAttribute("name");
                return treeAttribute != null ? treeAttribute.getValue() : "";
            }

            boolean isOrderingAttr() {
                return this.isAttr() && this.getName().indexOf(47) != -1;
            }

            String getFormer() {
                String string = this.getName();
                return string.substring(0, string.indexOf(47));
            }

            String getLatter() {
                String string = this.getName();
                return string.substring(string.indexOf(47) + 1);
            }
        }
        Object object;
        Object object2;
        ArrayList arrayList;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < treeElement.getChildrenNumber(); ++i) {
            object7 = (TreeChild)treeElement.getChildNodes().get(i);
            if (!(object7 instanceof TreeElement)) continue;
            object6 = new Item();
            ((Item)object6).child = (TreeElement)object7;
            linkedHashSet.add(object6);
            treeSet.add(new Integer(i));
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        object7 = new LinkedHashMap();
        object6 = new LinkedHashMap();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            object5 = (Item)iterator.next();
            object4 = ((Item)object5).getName();
            if (((Item)object5).isAttr()) {
                object6.put(object4, object5);
                if (!((Item)object5).isOrderingAttr()) continue;
                linkedHashSet2.add(((Item)object5).getFormer());
                linkedHashSet2.add(((Item)object5).getLatter());
                continue;
            }
            object7.put(object4, object5);
        }
        class NameComparator
        implements Comparator {
            NameComparator() {
            }

            public int compare(Object object, Object object2) {
                Item item = (Item)object;
                Item item2 = (Item)object2;
                return item.getName().compareTo(item2.getName());
            }
        }
        object5 = new TreeSet(new NameComparator());
        object4 = new TreeSet(new NameComparator());
        LinkedHashSet<Object> linkedHashSet3 = new LinkedHashSet<Object>();
        iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            object3 = (Item)iterator.next();
            arrayList = ((Item)object3).getName();
            if (((Item)object3).isAttr()) {
                if (((Item)object3).isOrderingAttr()) {
                    object2 = (Item)object7.get(((Item)object3).getFormer());
                    if (object2 != null) {
                        object = (Set)linkedHashMap.get(object2);
                        if (object == null) {
                            object = new LinkedHashSet<Object>();
                            linkedHashMap.put(object2, object);
                        }
                        object.add(object3);
                    }
                    if ((object = (Item)object7.get(((Item)object3).getLatter())) != null) {
                        LinkedHashSet<LinkedHashSet<Object>> linkedHashSet4 = new LinkedHashSet<LinkedHashSet<Object>>();
                        linkedHashSet4.add((LinkedHashSet<Object>)object);
                        linkedHashMap.put(object3, linkedHashSet4);
                    }
                    linkedHashSet3.add(object3);
                    continue;
                }
                object5.add(object3);
                continue;
            }
            if (linkedHashSet2.contains(arrayList)) {
                linkedHashSet3.add(object3);
                continue;
            }
            object4.add(object3);
        }
        try {
            object3 = Utilities.topologicalSort(linkedHashSet3, linkedHashMap);
        }
        catch (TopologicalSortException topologicalSortException) {
            return;
        }
        iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            arrayList = (Item)iterator.next();
            treeElement.removeChild((TreeChild)((Item)((Object)arrayList)).child);
        }
        arrayList = new ArrayList(object5);
        arrayList.addAll(object3);
        arrayList.addAll(object4);
        if (!$assertionsDisabled && !new HashSet(arrayList).equals(linkedHashSet)) {
            throw new AssertionError();
        }
        iterator = arrayList.iterator();
        object2 = treeSet.iterator();
        while (iterator.hasNext()) {
            object = (Item)iterator.next();
            int n = (Integer)object2.next();
            treeElement.insertChildAt((TreeChild)((Item)object).child, n);
        }
    }

    private static String spaces(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    private static void deleteWithIndent(TreeChild treeChild) throws ReadOnlyException {
        Object object;
        block12: {
            Object object2;
            TreeChild treeChild2 = treeChild.getNextSibling();
            if (treeChild2 instanceof TreeText && ((TreeText)treeChild2).getData().matches("(\r|\n|\r\n)[ \t]+")) {
                treeChild2.removeFromContext();
            } else {
                object = treeChild.getPreviousSibling();
                if (object instanceof TreeText && ((TreeText)object).getData().matches("(\r|\n|\r\n)[ \t]+")) {
                    object.removeFromContext();
                }
            }
            object = (TreeElement)treeChild.getParentNode();
            TreeObjectList treeObjectList = object.getChildNodes();
            boolean bl = true;
            Iterator iterator = treeObjectList.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (object2 == treeChild) continue;
                if (!(object2 instanceof TreeText)) {
                    bl = false;
                    break;
                }
                if (((TreeText)object2).getData().trim().length() <= 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                try {
                    if (object.getParentNode() instanceof TreeDocumentRoot) {
                        iterator = treeObjectList.iterator();
                        while (iterator.hasNext()) {
                            ((TreeChild)iterator.next()).removeFromContext();
                        }
                        object.appendChild((TreeChild)new TreeText("\n"));
                    } else {
                        object2 = new TreeElement(object.getQName(), true);
                        TreeAttribute treeAttribute = object.getAttribute("name");
                        if (treeAttribute != null) {
                            object2.addAttribute("name", treeAttribute.getValue());
                        }
                        TreeParentNode treeParentNode = object.getParentNode();
                        treeParentNode.replaceChild(object, object2);
                        object = object2;
                    }
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError((Object)invalidArgumentException);
                }
            }
        }
        treeChild.removeFromContext();
        object.normalize();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.someFileChange(fileEvent);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.someFileChange((FileEvent)fileRenameEvent);
    }

    public void fileChanged(FileEvent fileEvent) {
        this.someFileChange(fileEvent);
    }

    private void someFileChange(FileEvent fileEvent) {
        this.refreshResource("", true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals("documentRoot")) {
            return;
        }
        if (this.cookie.getStatus() == 1 || this.cookie.getStatus() == 0) {
            try {
                this.doc = this.cookie.openDocumentRoot();
                Enumeration enumeration = this.existingFileObjects(this.getRoot());
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject = (FileObject)enumeration.nextElement();
                    this.refreshResource(fileObject.getPath(), true);
                }
            }
            catch (TreeException treeException) {
                Util.err.notify(1, (Throwable)treeException);
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
            }
        }
    }

    static {
        $assertionsDisabled = !WritableXMLFileSystem.class.desiredAssertionStatus();
        warnedAboutDupeKids = new HashSet(1);
    }
}

