/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.w3c.dom.Element;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    private final NbModuleProject project;
    private ClassPath boot;
    private ClassPath source;
    private ClassPath compile;
    private ClassPath execute;
    private ClassPath testSource;
    private ClassPath testCompile;
    private ClassPath testExecute;
    private ClassPath funcTestSource;
    private ClassPath funcTestCompile;
    private ClassPath funcTestExecute;
    private Map extraCompilationUnitsCompile = null;
    private Map extraCompilationUnitsExecute = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassPathProviderImpl(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/boot")) {
            if (this.boot == null) {
                JavaPlatform javaPlatform = ClassPathProviderImpl.findJdk(this.project.getJavacSource());
                this.boot = javaPlatform != null ? javaPlatform.getBootstrapLibraries() : ClassPathSupport.createClassPath((URL[])new URL[0]);
            }
            return this.boot;
        }
        FileObject fileObject2 = this.project.getSourceDirectory();
        FileObject fileObject3 = this.project.getTestSourceDirectory();
        FileObject fileObject4 = this.project.getFunctionalTestSourceDirectory();
        File file = this.project.getClassesDirectory();
        FileObject fileObject5 = file == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        file = this.project.getTestClassesDirectory();
        FileObject fileObject6 = file == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        File file2 = this.project.getModuleJarLocation();
        if (fileObject2 != null && (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) || fileObject == fileObject2)) {
            if (string.equals("classpath/compile")) {
                if (this.compile == null) {
                    this.compile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createCompileClasspath());
                    Util.err.log("compile/execute-time classpath for " + this.project + ": " + this.compile);
                }
                return this.compile;
            }
            if (string.equals("classpath/execute")) {
                if (this.execute == null) {
                    this.execute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createExecuteClasspath());
                }
                return this.execute;
            }
            if (string.equals("classpath/source")) {
                if (this.source == null) {
                    this.source = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject2});
                }
                return this.source;
            }
        } else if (fileObject3 != null && (FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject) || fileObject == fileObject3)) {
            if (string.equals("classpath/compile")) {
                if (this.testCompile == null) {
                    this.testCompile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestCompileClasspath());
                    Util.err.log("compile-time classpath for tests in " + this.project + ": " + this.testCompile);
                }
                return this.testCompile;
            }
            if (string.equals("classpath/execute")) {
                if (this.testExecute == null) {
                    this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath());
                    Util.err.log("runtime classpath for tests in " + this.project + ": " + this.testExecute);
                }
                return this.testExecute;
            }
            if (string.equals("classpath/source")) {
                if (this.testSource == null) {
                    this.testSource = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject3});
                }
                return this.testSource;
            }
        } else if (fileObject4 != null && (FileUtil.isParentOf((FileObject)fileObject4, (FileObject)fileObject) || fileObject == fileObject4)) {
            if (string.equals("classpath/source")) {
                if (this.funcTestSource == null) {
                    this.funcTestSource = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject4});
                }
                return this.funcTestSource;
            }
            if (string.equals("classpath/compile")) {
                if (this.funcTestCompile == null) {
                    this.funcTestCompile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createFuncTestCompileClasspath());
                    Util.err.log("compile-time classpath for func tests in " + this.project + ": " + this.funcTestCompile);
                }
                return this.funcTestCompile;
            }
            if (string.equals("classpath/execute")) {
                if (this.funcTestExecute == null) {
                    this.funcTestExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createFuncTestExecuteClasspath());
                }
                return this.funcTestExecute;
            }
        } else if (fileObject5 != null && (fileObject5.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject5, (FileObject)fileObject))) {
            if ("classpath/execute".equals(string)) {
                try {
                    ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
                    arrayList.add(ClassPathSupport.createResource((URL)fileObject5.getURL()));
                    arrayList.addAll(this.createCompileClasspath().getResources());
                    return ClassPathSupport.createClassPath(arrayList);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                    return null;
                }
            }
        } else if (fileObject6 != null && (fileObject6.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject6, (FileObject)fileObject))) {
            if ("classpath/execute".equals(string)) {
                if (this.testExecute == null) {
                    this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath());
                    Util.err.log("runtime classpath for tests in " + this.project + ": " + this.testExecute);
                }
                return this.testExecute;
            }
        } else if (FileUtil.getArchiveFile((FileObject)fileObject) != null && FileUtil.toFile((FileObject)FileUtil.getArchiveFile((FileObject)fileObject)).equals(file2) && fileObject.equals(FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)fileObject)))) {
            if ("classpath/execute".equals(string)) {
                ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
                arrayList.add(ClassPathSupport.createResource((URL)Util.urlForJar(file2)));
                arrayList.addAll(this.createCompileClasspath().getResources());
                return ClassPathSupport.createClassPath(arrayList);
            }
        } else {
            this.calculateExtraCompilationUnits();
            Iterator iterator = this.extraCompilationUnitsCompile.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                FileObject fileObject7 = (FileObject)entry.getKey();
                if (!FileUtil.isParentOf((FileObject)fileObject7, (FileObject)fileObject) && fileObject != fileObject7) continue;
                if (string.equals("classpath/compile")) {
                    return (ClassPath)entry.getValue();
                }
                if (string.equals("classpath/execute")) {
                    return (ClassPath)this.extraCompilationUnitsExecute.get(fileObject7);
                }
                if (!string.equals("classpath/source")) break;
                return ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject7});
            }
        }
        return null;
    }

    private static JavaPlatform findJdk(String string) {
        Specification specification;
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, specification = new Specification("j2se", new SpecificationVersion(string)));
        if (javaPlatformArray.length > 0) {
            int n;
            for (n = 0; n < javaPlatformArray.length; ++n) {
                if (javaPlatformArray[n].getSourceFolders().getRoots().length <= 0) continue;
                return javaPlatformArray[n];
            }
            for (n = 0; n < javaPlatformArray.length; ++n) {
                if (javaPlatformArray[n].getJavadocFolders().isEmpty()) continue;
                return javaPlatformArray[n];
            }
            return javaPlatformArray[0];
        }
        return javaPlatformManager.getDefaultPlatform();
    }

    private ClassPathImplementation createPathFromProperty(String string) {
        return ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (PropertyEvaluator)this.project.evaluator(), (String[])new String[]{string});
    }

    private ClassPathImplementation createCompileClasspath() {
        return this.createPathFromProperty("cp");
    }

    private void addPathFromProject(List list, String string) {
        String string2 = this.project.evaluator().getProperty(string);
        this.addPathFromProjectEvaluated(list, string2);
    }

    private void addPathFromProjectEvaluated(List list, String string) {
        if (string != null) {
            String[] stringArray = PropertyUtils.tokenizePath((String)string);
            for (int i = 0; i < stringArray.length; ++i) {
                list.add(ClassPathSupport.createResource((URL)Util.urlForDirOrJar(this.project.getHelper().resolveFile(stringArray[i]))));
            }
        }
    }

    private ClassPathImplementation createTestCompileClasspath() {
        return this.createPathFromProperty("test.unit.cp");
    }

    private ClassPathImplementation createTestExecuteClasspath() {
        return this.createPathFromProperty("test.unit.run.cp");
    }

    private ClassPathImplementation createFuncTestCompileClasspath() {
        return this.createPathFromProperty("test.qa-functional.cp");
    }

    private ClassPathImplementation createFuncTestExecuteClasspath() {
        return this.createPathFromProperty("test.qa-functional.run.cp");
    }

    private ClassPathImplementation createExecuteClasspath() {
        return this.createPathFromProperty("run.cp");
    }

    private void calculateExtraCompilationUnits() {
        if (this.extraCompilationUnitsCompile != null) {
            return;
        }
        this.extraCompilationUnitsCompile = new HashMap();
        this.extraCompilationUnitsExecute = new HashMap();
        Iterator iterator = this.project.getExtraCompilationUnits().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FileObject fileObject = (FileObject)entry.getKey();
            Element element = (Element)entry.getValue();
            Element element2 = Util.findElement(element, "classpath", "http://www.netbeans.org/ns/nb-module-project/2");
            if (!$assertionsDisabled && element2 == null) {
                throw new AssertionError((Object)("no <classpath> in " + element));
            }
            String string = Util.findText(element2);
            if (string == null) {
                this.extraCompilationUnitsCompile.put(fileObject, ClassPathSupport.createClassPath((URL[])new URL[0]));
                this.extraCompilationUnitsExecute.put(fileObject, ClassPathSupport.createClassPath((URL[])new URL[0]));
                continue;
            }
            String string2 = this.project.evaluator().evaluate(string);
            ArrayList arrayList = new ArrayList();
            this.addPathFromProjectEvaluated(arrayList, string2);
            this.extraCompilationUnitsCompile.put(fileObject, ClassPathSupport.createClassPath(arrayList));
            arrayList = new ArrayList(arrayList);
            Iterator iterator2 = Util.findSubElements(element).iterator();
            while (iterator2.hasNext()) {
                Element element3 = (Element)iterator2.next();
                if (!element3.getLocalName().equals("built-to")) continue;
                String string3 = Util.findText(element3);
                if (!$assertionsDisabled && string3 == null) {
                    throw new AssertionError((Object)("Null content for <built-to> in " + this.project));
                }
                String string4 = this.project.evaluator().evaluate(string3);
                if (string4 == null) continue;
                this.addPathFromProjectEvaluated(arrayList, string4);
            }
            this.extraCompilationUnitsExecute.put(fileObject, ClassPathSupport.createClassPath(arrayList));
        }
    }

    public ClassPath[] getProjectClassPaths(String string) {
        Object object;
        if ("classpath/boot".equals(string) && (object = this.project.getSourceDirectory()) != null) {
            return new ClassPath[]{this.findClassPath((FileObject)object, "classpath/boot")};
        }
        object = new ArrayList(3);
        if ("classpath/compile".equals(string)) {
            FileObject fileObject;
            FileObject fileObject2;
            FileObject fileObject3 = this.project.getSourceDirectory();
            if (fileObject3 != null) {
                object.add(this.findClassPath(fileObject3, "classpath/compile"));
            }
            if ((fileObject2 = this.project.getTestSourceDirectory()) != null) {
                object.add(this.findClassPath(fileObject2, "classpath/compile"));
            }
            if ((fileObject = this.project.getFunctionalTestSourceDirectory()) != null) {
                object.add(this.findClassPath(fileObject, "classpath/compile"));
            }
            this.calculateExtraCompilationUnits();
            object.addAll(this.extraCompilationUnitsCompile.values());
        } else if ("classpath/execute".equals(string)) {
            FileObject fileObject;
            FileObject fileObject4;
            FileObject fileObject5 = this.project.getSourceDirectory();
            if (fileObject5 != null) {
                object.add(this.findClassPath(fileObject5, "classpath/execute"));
            }
            if ((fileObject4 = this.project.getTestSourceDirectory()) != null) {
                object.add(this.findClassPath(fileObject4, "classpath/execute"));
            }
            if ((fileObject = this.project.getFunctionalTestSourceDirectory()) != null) {
                object.add(this.findClassPath(fileObject, "classpath/execute"));
            }
            this.calculateExtraCompilationUnits();
            object.addAll(this.extraCompilationUnitsExecute.values());
        } else if ("classpath/source".equals(string)) {
            FileObject fileObject;
            FileObject fileObject6;
            FileObject fileObject7 = this.project.getSourceDirectory();
            if (fileObject7 != null) {
                object.add(this.findClassPath(fileObject7, "classpath/source"));
            }
            if ((fileObject6 = this.project.getTestSourceDirectory()) != null) {
                object.add(this.findClassPath(fileObject6, "classpath/source"));
            }
            if ((fileObject = this.project.getFunctionalTestSourceDirectory()) != null) {
                object.add(this.findClassPath(fileObject, "classpath/source"));
            }
            this.calculateExtraCompilationUnits();
            Iterator iterator = this.extraCompilationUnitsCompile.keySet().iterator();
            while (iterator.hasNext()) {
                object.add(ClassPathSupport.createClassPath((FileObject[])new FileObject[]{(FileObject)iterator.next()}));
            }
        }
        return object.toArray(new ClassPath[object.size()]);
    }

    static {
        $assertionsDisabled = !ClassPathProviderImpl.class.desiredAssertionStatus();
    }
}

