/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class ModuleProjectClassPathExtender
implements ProjectClassPathExtender {
    private static final String LIBRARY_NAME = "swing-layout";
    private static final String MODULE_NAME = "org.jdesktop.layout";
    private final NbModuleProject project;

    public ModuleProjectClassPathExtender(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    public boolean addLibrary(Library library) throws IOException {
        if (library.getName().equals(LIBRARY_NAME)) {
            Comparable comparable;
            ProjectXMLManager projectXMLManager = new ProjectXMLManager(this.project.getHelper());
            Iterator iterator = projectXMLManager.getDirectDependencies(this.project.getPlatform(false)).iterator();
            while (iterator.hasNext()) {
                comparable = (ModuleDependency)iterator.next();
                if (!comparable.getModuleEntry().getCodeNameBase().equals(MODULE_NAME)) continue;
                return false;
            }
            comparable = this.project.getModuleList().getEntry(MODULE_NAME);
            if (comparable != null) {
                projectXMLManager.addDependency(new ModuleDependency((ModuleEntry)comparable));
                ProjectManager.getDefault().saveProject((Project)this.project);
                return true;
            }
            IOException iOException = new IOException("no module org.jdesktop.layout");
            Util.err.annotate((Throwable)iOException, NbBundle.getMessage((Class)ModuleProjectClassPathExtender.class, (String)"ERR_could_not_find_module", (Object)MODULE_NAME));
            throw iOException;
        }
        IOException iOException = new IOException("unknown lib " + library.getName());
        Util.err.annotate((Throwable)iOException, NbBundle.getMessage((Class)ModuleProjectClassPathExtender.class, (String)"ERR_unsupported_library", (Object)library.getDisplayName()));
        throw iOException;
    }

    public boolean addArchiveFile(FileObject fileObject) throws IOException {
        IOException iOException = new IOException("not implemented: " + fileObject);
        Util.err.annotate((Throwable)iOException, NbBundle.getMessage((Class)ModuleProjectClassPathExtender.class, (String)"ERR_jar", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)));
        throw iOException;
    }

    public boolean addAntArtifact(AntArtifact antArtifact, URI uRI) throws IOException {
        IOException iOException = new IOException("not implemented: " + uRI);
        String string = "file".equals(uRI.getScheme()) ? new File(uRI).getAbsolutePath() : uRI.toString();
        Util.err.annotate((Throwable)iOException, NbBundle.getMessage((Class)ModuleProjectClassPathExtender.class, (String)"ERR_jar", (Object)string));
        throw iOException;
    }
}

