/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public final class SubprojectProviderImpl
implements SubprojectProvider {
    private final NbModuleProject project;

    public SubprojectProviderImpl(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    public Set getSubprojects() {
        ModuleList moduleList;
        HashSet<Project> hashSet = new HashSet<Project>();
        try {
            moduleList = this.project.getModuleList();
        }
        catch (IOException iOException) {
            Util.err.notify(1, (Throwable)iOException);
            return Collections.EMPTY_SET;
        }
        Element element = this.project.getHelper().getPrimaryConfigurationData(true);
        Element element2 = Util.findElement(element, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/2");
        List list = Util.findSubElements(element2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            Element element4 = Util.findElement(element3, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2");
            String string = Util.findText(element4);
            ModuleEntry moduleEntry = moduleList.getEntry(string);
            if (moduleEntry == null) {
                Util.err.log(16, "Warning - could not find dependent module " + string + " for " + this.project);
                continue;
            }
            File file = moduleEntry.getSourceLocation();
            if (file == null) {
                Util.err.log(16, "Warning - could not find sources for dependent module " + string + " for " + this.project);
                continue;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) {
                Util.err.log(16, "Warning - could not load sources for dependent module " + string + " for " + this.project);
                continue;
            }
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project == null) {
                    Util.err.log(16, "Warning - dependent module " + string + " for " + this.project + " is not projectized");
                    continue;
                }
                hashSet.add(project);
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
            }
        }
        return hashSet;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

