/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class UpdateTrackingFileOwnerQuery
implements FileOwnerQueryImplementation {
    public Project getOwner(URI uRI) {
        if (!ModuleList.existKnownEntries()) {
            return null;
        }
        if (uRI.getScheme().equals("file")) {
            return this.getOwner(new File(uRI));
        }
        return null;
    }

    public Project getOwner(FileObject fileObject) {
        if (!ModuleList.existKnownEntries()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            return this.getOwner(file);
        }
        return null;
    }

    private Project getOwner(File file) {
        Set set = ModuleList.getKnownEntries(file);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            File file2 = ((ModuleEntry)iterator.next()).getSourceLocation();
            if (file2 == null || (fileObject = FileUtil.toFileObject((File)file2)) == null) continue;
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project == null) continue;
                return project;
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
            }
        }
        return null;
    }
}

