/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class BrandingSupport {
    private final SuiteProject suiteProject;
    private SuiteProperties suiteProperties;
    private Set brandedModules = null;
    private Set brandedBundleKeys = null;
    private Set brandedFiles = null;
    private NbPlatform platform;
    private final File brandingDir;
    private static final String NAME_OF_BRANDING_FOLDER = "branding";
    private static final String BUNDLE_NAME = "Bundle.properties";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static BrandingSupport getInstance(SuiteProperties suiteProperties) throws IOException {
        return new BrandingSupport(suiteProperties);
    }

    private BrandingSupport(SuiteProperties suiteProperties) throws IOException {
        this.suiteProperties = suiteProperties;
        this.suiteProject = suiteProperties.getProject();
        File file = FileUtil.toFile((FileObject)this.suiteProject.getProjectDirectory());
        if (!($assertionsDisabled || file != null && file.exists())) {
            throw new AssertionError();
        }
        this.brandingDir = new File(file, NAME_OF_BRANDING_FOLDER);
        this.init();
    }

    public File getProjectDirectory() {
        return FileUtil.toFile((FileObject)this.suiteProject.getProjectDirectory());
    }

    public File getBrandingRoot() {
        return new File(this.getProjectDirectory(), NAME_OF_BRANDING_FOLDER);
    }

    public File getModuleEntryDirectory(ModuleEntry moduleEntry) {
        String string = PropertyUtils.relativizeFile((File)moduleEntry.getClusterDirectory(), (File)moduleEntry.getJarLocation());
        return new File(this.getBrandingRoot(), string);
    }

    public File getLocalizingBundle(ModuleEntry moduleEntry) {
        String string;
        ManifestManager manifestManager = ManifestManager.getInstanceFromJAR(moduleEntry.getJarLocation());
        File file = null;
        if (manifestManager != null && (string = manifestManager.getLocalizingBundle()) != null) {
            file = new File(this.getModuleEntryDirectory(moduleEntry), string);
        }
        return file;
    }

    public boolean isBranded(BundleKey bundleKey) {
        boolean bl = this.getBrandedBundleKeys().contains(bundleKey);
        return bl;
    }

    public boolean isBranded(BrandedFile brandedFile) {
        boolean bl = this.getBrandedFiles().contains(brandedFile);
        return bl;
    }

    public boolean isBranded(ModuleEntry moduleEntry) {
        boolean bl = this.getBrandedModules().contains(moduleEntry);
        if (!$assertionsDisabled && bl != this.getModuleEntryDirectory(moduleEntry).exists()) {
            throw new AssertionError();
        }
        return bl;
    }

    public Set getBrandedModules() {
        return this.brandedModules;
    }

    public Set getBrandedBundleKeys() {
        return this.brandedBundleKeys;
    }

    public Set getBrandedFiles() {
        return this.brandedFiles;
    }

    public Set getLocalizingBundleKeys(String string, Set set) {
        ModuleEntry moduleEntry = this.getModuleEntry(string);
        return moduleEntry != null ? this.getLocalizingBundleKeys(moduleEntry, set) : null;
    }

    public Set getLocalizingBundleKeys(ModuleEntry moduleEntry, Set set) {
        HashSet<BundleKey> hashSet = new HashSet<BundleKey>();
        Iterator iterator = this.getBrandedBundleKeys().iterator();
        while (iterator.hasNext() && hashSet.size() != set.size()) {
            BundleKey bundleKey = (BundleKey)iterator.next();
            if (!set.contains(bundleKey.getKey())) continue;
            hashSet.add(bundleKey);
        }
        if (hashSet.size() != set.size()) {
            this.loadLocalizedBundlesFromPlatform(moduleEntry, set, hashSet);
        }
        return hashSet.size() != set.size() ? null : hashSet;
    }

    public BrandedFile getBrandedFile(String string, String string2) {
        ModuleEntry moduleEntry = this.getModuleEntry(string);
        return moduleEntry != null ? this.getBrandedFile(moduleEntry, string2) : null;
    }

    public BrandedFile getBrandedFile(ModuleEntry moduleEntry, String string) {
        BrandedFile brandedFile = null;
        try {
            brandedFile = new BrandedFile(moduleEntry, string);
            Iterator iterator = this.getBrandedFiles().iterator();
            while (iterator.hasNext()) {
                BrandedFile brandedFile2 = (BrandedFile)iterator.next();
                if (!brandedFile.equals(brandedFile2)) continue;
                brandedFile = brandedFile2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            brandedFile = null;
        }
        return brandedFile;
    }

    public BundleKey getBundleKey(String string, String string2, String string3) {
        Set set = new HashSet<String>();
        set.add(string3);
        set = this.getBundleKeys(string, string2, set);
        return set == null ? null : (BundleKey)set.toArray()[0];
    }

    public Set getBundleKeys(String string, String string2, Set set) {
        ModuleEntry moduleEntry = this.getModuleEntry(string);
        return moduleEntry != null ? this.getBundleKeys(moduleEntry, string2, set) : null;
    }

    public Set getBundleKeys(ModuleEntry moduleEntry, String string, Set set) {
        HashSet<BundleKey> hashSet = new HashSet<BundleKey>();
        Iterator iterator = this.getBrandedBundleKeys().iterator();
        while (iterator.hasNext() && hashSet.size() != set.size()) {
            BundleKey bundleKey = (BundleKey)iterator.next();
            if (!set.contains(bundleKey.getKey())) continue;
            hashSet.add(bundleKey);
        }
        if (hashSet.size() != set.size()) {
            try {
                this.loadLocalizedBundlesFromPlatform(moduleEntry, string, set, hashSet);
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
        }
        return hashSet.size() != set.size() ? null : hashSet;
    }

    private ModuleEntry getModuleEntry(String string) {
        NbPlatform nbPlatform = this.getActivePlatform();
        Iterator<ModuleEntry> iterator = Arrays.asList(nbPlatform.getModules()).iterator();
        while (iterator.hasNext()) {
            ModuleEntry moduleEntry = iterator.next();
            if (!moduleEntry.getCodeNameBase().equals(string)) continue;
            return moduleEntry;
        }
        return null;
    }

    private NbPlatform getActivePlatform() {
        NbPlatform nbPlatform = this.suiteProperties.getActivePlatform();
        if (nbPlatform != null) {
            return nbPlatform;
        }
        return NbPlatform.getDefaultPlatform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brandFile(BrandedFile brandedFile) throws IOException {
        FileOutputStream fileOutputStream;
        block8: {
            if (!brandedFile.isModified()) {
                return;
            }
            File file = brandedFile.getFileLocation();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            if (!$assertionsDisabled && !file.exists()) {
                throw new AssertionError();
            }
            InputStream inputStream = null;
            fileOutputStream = null;
            try {
                inputStream = brandedFile.getBrandingSource().openStream();
                fileOutputStream = new FileOutputStream(file);
                FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                Object var6_5 = null;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
                this.brandedFiles.add(brandedFile);
                brandedFile.modified = false;
                throw throwable;
            }
            inputStream.close();
        }
        if (fileOutputStream != null) {
            ((OutputStream)fileOutputStream).close();
        }
        this.brandedFiles.add(brandedFile);
        brandedFile.modified = false;
    }

    public void brandFile(BrandedFile brandedFile, Runnable runnable) throws IOException {
        if (!brandedFile.isModified()) {
            return;
        }
        runnable.run();
        this.brandedFiles.add(brandedFile);
        brandedFile.modified = false;
    }

    public void brandBundleKey(BundleKey bundleKey) throws IOException {
        if (bundleKey == null) {
            return;
        }
        HashSet<BundleKey> hashSet = new HashSet<BundleKey>();
        hashSet.add(bundleKey);
        this.brandBundleKeys(hashSet);
    }

    public void brandBundleKeys(Set set) throws IOException {
        Object object;
        Object object2;
        Object object3;
        this.init();
        HashMap<File, Object> hashMap = new HashMap<File, Object>();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            object3 = (BundleKey)iterator.next();
            if (!((BundleKey)object3).isModified()) continue;
            object2 = (EditableProperties)hashMap.get(((BundleKey)object3).getBrandingBundle());
            if (object2 == null) {
                object = ((BundleKey)object3).getBrandingBundle();
                if (!((File)object).exists()) {
                    ((File)object).getParentFile().mkdirs();
                    ((File)object).createNewFile();
                }
                object2 = BrandingSupport.getEditableProperties((File)object);
                hashMap.put(((BundleKey)object3).getBrandingBundle(), object2);
            }
            object2.setProperty(((BundleKey)object3).getKey(), ((BundleKey)object3).getValue());
        }
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = (File)iterator.next();
            if (!$assertionsDisabled && !((File)object3).exists()) {
                throw new AssertionError();
            }
            BrandingSupport.storeEditableProperties((EditableProperties)hashMap.get(object3), (File)object3);
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (BundleKey)object2.next();
                File file = ((BundleKey)object).getBrandingBundle();
                if (!file.equals(object3)) continue;
                this.brandedBundleKeys.add(object);
                ((BundleKey)object).modified = false;
                this.brandedModules.add(((BundleKey)object).getModuleEntry());
            }
        }
    }

    private void init() throws IOException {
        NbPlatform nbPlatform = this.getActivePlatform();
        if (this.brandedModules == null || !nbPlatform.equals(this.platform)) {
            this.brandedModules = new HashSet();
            this.brandedBundleKeys = new HashSet();
            this.brandedFiles = new HashSet();
            this.platform = nbPlatform;
            if (this.brandingDir.exists()) {
                if (!$assertionsDisabled && !this.brandingDir.isDirectory()) {
                    throw new AssertionError();
                }
                this.scanModulesInBrandingDir(this.brandingDir, this.platform.getModules());
            }
        }
    }

    private void scanModulesInBrandingDir(File file, ModuleEntry[] moduleEntryArray) throws IOException {
        if (file.getName().endsWith(".jar")) {
            ModuleEntry moduleEntry = null;
            for (int i = 0; i < moduleEntryArray.length; ++i) {
                if (!this.isBrandingForModuleEntry(file, moduleEntryArray[i])) continue;
                this.scanBrandedFiles(file, moduleEntryArray[i]);
                moduleEntry = moduleEntryArray[i];
                break;
            }
            if (moduleEntry != null) {
                this.brandedModules.add(moduleEntry);
            } else if (!$assertionsDisabled && moduleEntry == null) {
                throw new AssertionError();
            }
        } else {
            String[] stringArray = file.list();
            if (!$assertionsDisabled && stringArray == null) {
                throw new AssertionError();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!file2.isDirectory()) continue;
                this.scanModulesInBrandingDir(file2, moduleEntryArray);
            }
        }
    }

    private void scanBrandedFiles(File file, ModuleEntry moduleEntry) throws IOException {
        String[] stringArray = file.list();
        if (!$assertionsDisabled && stringArray == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (!file2.isDirectory()) {
                if (file2.getName().endsWith(BUNDLE_NAME)) {
                    if (file2 == null) continue;
                    this.loadBundleKeys(moduleEntry, file2);
                    continue;
                }
                this.loadBrandedFiles(moduleEntry, file2);
                continue;
            }
            this.scanBrandedFiles(file2, moduleEntry);
        }
    }

    private void loadBundleKeys(ModuleEntry moduleEntry, File file) throws IOException {
        EditableProperties editableProperties = BrandingSupport.getEditableProperties(file);
        Iterator iterator = editableProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.brandedBundleKeys.add(new BundleKey(moduleEntry, file, (String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private void loadBrandedFiles(ModuleEntry moduleEntry, File file) throws IOException {
        String string = PropertyUtils.relativizeFile((File)this.getModuleEntryDirectory(moduleEntry), (File)file);
        BrandedFile brandedFile = new BrandedFile(moduleEntry, file.toURI().toURL(), string);
        this.brandedFiles.add(brandedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditableProperties getEditableProperties(File file) throws IOException {
        EditableProperties editableProperties = new EditableProperties(true);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            editableProperties.load((InputStream)fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return editableProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeEditableProperties(EditableProperties editableProperties, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            editableProperties.store((OutputStream)fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    private void loadLocalizedBundlesFromPlatform(ModuleEntry moduleEntry, Set set, Set set2) {
        EditableProperties editableProperties = ModuleList.loadBundleInfo(moduleEntry.getSourceLocation()).toEditableProperties();
        Iterator iterator = editableProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!set.contains(string)) continue;
            String string2 = editableProperties.getProperty(string);
            set2.add(new BundleKey(moduleEntry, string, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedBundlesFromPlatform(ModuleEntry moduleEntry, String string, Set set, Set set2) throws IOException {
        Properties properties = new Properties();
        JarFile jarFile = new JarFile(moduleEntry.getJarLocation());
        JarEntry jarEntry = jarFile.getJarEntry(string);
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        File file = new File(this.getModuleEntryDirectory(moduleEntry), string);
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!set.contains(string2)) continue;
            String string3 = properties.getProperty(string2);
            set2.add(new BundleKey(moduleEntry, file, string2, string3));
        }
    }

    private boolean isBrandingForModuleEntry(File file, ModuleEntry moduleEntry) {
        boolean bl = moduleEntry.getJarLocation().getName().equals(file.getName());
        if (bl) {
            String string = PropertyUtils.relativizeFile((File)moduleEntry.getClusterDirectory(), (File)moduleEntry.getJarLocation().getParentFile());
            String string2 = PropertyUtils.relativizeFile((File)this.brandingDir, (File)file.getParentFile());
            bl = string.equals(string2);
        }
        return bl;
    }

    static {
        $assertionsDisabled = !BrandingSupport.class.desiredAssertionStatus();
    }

    public class BrandedFile {
        private final ModuleEntry moduleEntry;
        private final String entryPath;
        private URL brandingSource;
        private boolean modified = false;

        private BrandedFile(ModuleEntry moduleEntry, String string) throws MalformedURLException {
            this(moduleEntry, null, string);
        }

        private BrandedFile(ModuleEntry moduleEntry, URL uRL, String string) throws MalformedURLException {
            this.moduleEntry = moduleEntry;
            this.entryPath = string;
            if (uRL == null) {
                this.brandingSource = moduleEntry.getJarLocation().toURI().toURL();
                this.brandingSource = new URL("jar:" + this.brandingSource + "!/" + this.entryPath);
            } else {
                this.brandingSource = uRL;
            }
        }

        public ModuleEntry getModuleEntry() {
            return this.moduleEntry;
        }

        public String getEntryPath() {
            return this.entryPath;
        }

        public File getFileLocation() {
            return new File(BrandingSupport.this.getModuleEntryDirectory(this.getModuleEntry()), this.getEntryPath());
        }

        public URL getBrandingSource() {
            return this.brandingSource;
        }

        public void setBrandingSource(URL uRL) {
            if (!Utilities.compareObjects((Object)uRL, (Object)this.brandingSource)) {
                this.modified = true;
            }
            this.brandingSource = uRL;
        }

        public void setBrandingSource(File file) throws MalformedURLException {
            this.setBrandingSource(file.toURI().toURL());
        }

        public boolean isModified() {
            return this.modified;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof BrandedFile) {
                BrandedFile brandedFile = (BrandedFile)object;
                bl = this.getModuleEntry().equals(brandedFile.getModuleEntry()) && this.getFileLocation().equals(brandedFile.getFileLocation());
            }
            return bl;
        }
    }

    public final class BundleKey {
        private final File brandingBundle;
        private final ModuleEntry moduleEntry;
        private final String key;
        private String value;
        private boolean modified = false;

        private BundleKey(ModuleEntry moduleEntry, File file, String string, String string2) {
            this.moduleEntry = moduleEntry;
            this.key = string;
            this.value = string2;
            this.brandingBundle = file;
        }

        private BundleKey(ModuleEntry moduleEntry, String string, String string2) {
            this(moduleEntry, brandingSupport.getLocalizingBundle(moduleEntry), string, string2);
        }

        public ModuleEntry getModuleEntry() {
            return this.moduleEntry;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            if (!this.value.equals(string)) {
                this.modified = true;
            }
            this.value = string;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof BundleKey) {
                BundleKey bundleKey = (BundleKey)object;
                bl = this.getKey().equals(bundleKey.getKey()) && this.getModuleEntry().equals(bundleKey.getModuleEntry()) && this.getBrandingBundle().equals(bundleKey.getBrandingBundle());
            }
            return bl;
        }

        boolean isModified() {
            return this.modified;
        }

        public File getBrandingBundle() {
            return this.brandingBundle;
        }
    }
}

