/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class SuiteProjectGenerator {
    private static final String PLATFORM_PROPERTIES_PATH = "nbproject/platform.properties";
    public static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    public static final String PRIVATE_PROPERTIES_PATH = "nbproject/private/private.properties";
    static final /* synthetic */ boolean $assertionsDisabled;

    private SuiteProjectGenerator() {
    }

    public static void createSuiteProject(final File file, final String string) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    FileObject fileObject = SuiteProjectGenerator.createProjectDir(file);
                    if (ProjectManager.getDefault().findProject(fileObject) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject);
                    }
                    SuiteProjectGenerator.createSuiteProjectXML(fileObject);
                    SuiteProjectGenerator.createPlatformProperties(fileObject, string);
                    SuiteProjectGenerator.createProjectProperties(fileObject);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static void createSuiteProjectXML(FileObject fileObject) throws IOException {
        ProjectXMLManager.generateEmptySuiteTemplate(SuiteProjectGenerator.createFileObject(fileObject, "nbproject/project.xml"), fileObject.getNameExt());
    }

    private static void createPlatformProperties(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = SuiteProjectGenerator.createFileObject(fileObject, PLATFORM_PROPERTIES_PATH);
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.setProperty("nbplatform.active", string);
        SuiteProjectGenerator.storeProperties(fileObject2, editableProperties);
    }

    private static void createProjectProperties(FileObject fileObject) throws IOException {
        FileObject fileObject2 = SuiteProjectGenerator.createFileObject(fileObject, PROJECT_PROPERTIES_PATH);
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.setProperty("modules", "");
        SuiteProjectGenerator.storeProperties(fileObject2, editableProperties);
    }

    private static FileObject createProjectDir(File file) throws IOException {
        FileObject fileObject;
        if (!file.exists()) {
            SuiteProjectGenerator.refreshFolder(file);
            if (!file.mkdirs()) {
                throw new IOException("Can not create project folder \"" + file.getAbsolutePath() + "\"");
            }
            SuiteProjectGenerator.refreshFileSystem(file);
        }
        if ((fileObject = FileUtil.toFileObject((File)file)) == null) {
            throw new IOException("No such dir on disk: " + file);
        }
        if (!$assertionsDisabled && !fileObject.isFolder()) {
            throw new AssertionError((Object)("Not really a dir: " + file));
        }
        return fileObject;
    }

    private static void refreshFolder(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            fileObject.refresh(false);
        }
    }

    private static void refreshFileSystem(File file) throws FileStateInvalidException {
        File file2 = file;
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        if (fileObject != null) {
            fileObject.getFileSystem().refresh(false);
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("At least disk roots must be mounted! " + file2));
            }
            ErrorManager.getDefault().log(16, "Cannot resolvefile object for " + file2.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(FileObject fileObject, EditableProperties editableProperties) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                editableProperties.store(outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private static FileObject createFileObject(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            throw new IllegalArgumentException("File " + fileObject2 + " already exists.");
        }
        fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        return fileObject2;
    }

    static {
        $assertionsDisabled = !SuiteProjectGenerator.class.desiredAssertionStatus();
    }
}

