/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Image;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

class AnnotatedNode
extends AbstractNode
implements Runnable,
FileStatusListener {
    private Set files;
    private Set fileSystemListeners;
    private RequestProcessor.Task task;
    private volatile boolean iconChange;
    private volatile boolean nameChange;
    private boolean forceAnnotation;

    protected AnnotatedNode(Children children) {
        super(children, null);
    }

    protected AnnotatedNode(Children children, Lookup lookup) {
        super(children, lookup);
    }

    protected final void setFiles(Set set) {
        this.fileSystemListeners = new HashSet();
        this.files = set;
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
        while (iterator.hasNext()) {
            ErrorManager errorManager;
            FileObject fileObject = (FileObject)iterator.next();
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                if (hashSet.contains(fileSystem)) continue;
                hashSet.add(fileSystem);
                errorManager = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileSystem);
                fileSystem.addFileStatusListener((FileStatusListener)errorManager);
                this.fileSystemListeners.add(errorManager);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)fileStateInvalidException, "Cannot get " + fileObject + " filesystem, ignoring...");
                errorManager.notify(1, (Throwable)fileStateInvalidException);
            }
        }
    }

    protected final Set getFiles() {
        return this.files;
    }

    protected void setForceAnnotation(boolean bl) {
        this.forceAnnotation = bl;
    }

    protected final Image annotateIcon(Image image, int n) {
        Image image2 = image;
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fileObject = (FileObject)this.files.iterator().next();
                image2 = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return image2;
    }

    protected final String annotateName(String string) {
        String string2 = string;
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fileObject = (FileObject)this.files.iterator().next();
                string2 = fileObject.getFileSystem().getStatus().annotateName(string, this.files);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return string2;
    }

    public final void annotationChanged(FileStatusEvent fileStatusEvent) {
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().create((Runnable)this);
        }
        boolean bl = false;
        if (this.forceAnnotation || !this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
            Iterator iterator = this.files.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                if (!fileStatusEvent.hasChanged(fileObject)) continue;
                this.iconChange |= fileStatusEvent.isIconChange();
                this.nameChange |= fileStatusEvent.isNameChange();
                bl = true;
            }
        }
        if (bl) {
            this.task.schedule(50);
        }
    }

    public final void run() {
        if (this.forceAnnotation || this.iconChange) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.iconChange = false;
        }
        if (this.forceAnnotation || this.nameChange) {
            this.fireDisplayNameChange(null, null);
            this.nameChange = false;
        }
    }
}

