/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class UIUtil {
    private static WeakReference iconChooser;
    static final /* synthetic */ boolean $assertionsDisabled;

    private UIUtil() {
    }

    public static String keyToLogicalString(KeyStroke keyStroke) {
        String string = Utilities.keyToString((KeyStroke)keyStroke);
        int n = string.indexOf(45);
        return n == -1 ? string : string.substring(0, n).replace('C', 'D').replace('A', 'O') + string.substring(n);
    }

    public static void setProjectChooserDir(File file) {
        if (file == null || !file.isDirectory()) {
            return;
        }
        ProjectChooser.setProjectsFolder((File)file);
    }

    public static void setProjectChooserDirParent(File file) {
        if (file == null) {
            return;
        }
        File file2 = file.getParentFile();
        UIUtil.setProjectChooserDir(file2 != null ? file2 : (file.isDirectory() ? file : null));
    }

    public static void setText(JTextComponent jTextComponent, String string) {
        jTextComponent.setText(string);
        jTextComponent.setCaretPosition(string == null ? 0 : string.length());
    }

    public static JFileChooser getIconFileChooser() {
        JFileChooser jFileChooser;
        if (iconChooser != null && (jFileChooser = (JFileChooser)iconChooser.get()) != null) {
            return jFileChooser;
        }
        jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            jFileChooser.removeChoosableFileFilter(fileFilterArray[i]);
        }
        jFileChooser.addChoosableFileFilter(new IconFilter());
        jFileChooser.setFileView(new FileView(){

            public Icon getIcon(File file) {
                ImageIcon imageIcon;
                if ((file.getName().endsWith(".gif") || file.getName().endsWith(".png")) && (imageIcon = new ImageIcon(file.getAbsolutePath())).getIconWidth() == 16 && imageIcon.getIconHeight() == 16) {
                    return imageIcon;
                }
                return null;
            }
        });
        iconChooser = new WeakReference<JFileChooser>(jFileChooser);
        return jFileChooser;
    }

    public static JFileChooser getIconFileChooser(String string) {
        File file;
        JFileChooser jFileChooser = UIUtil.getIconFileChooser();
        String string2 = string.trim();
        if (string2.length() > 0 && (file = new File(string2)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        return jFileChooser;
    }

    public static JComboBox createPackageComboBox(SourceGroup sourceGroup) {
        JComboBox jComboBox = new JComboBox(PackageView.createListView((SourceGroup)sourceGroup));
        jComboBox.setRenderer(PackageView.listRenderer());
        return jComboBox;
    }

    public static boolean isValidPackageName(String string) {
        if (string.length() > 0 && string.charAt(0) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public static String generateTextAreaContent(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static ComboBoxModel createLayerPresenterComboModel(Project project, String string) {
        return UIUtil.createLayerPresenterComboModel(project, string, Collections.EMPTY_MAP);
    }

    public static ComboBoxModel createLayerPresenterComboModel(Project project, String string, Map map) {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        try {
            FileSystem fileSystem = LayerUtils.getEffectiveSystemFilesystem(project);
            FileObject fileObject = fileSystem.getRoot().getFileObject(string);
            if (fileObject != null) {
                Collection collection = UIUtil.getFolders(fileObject, map);
                TreeSet<LayerItemPresenter> treeSet = new TreeSet<LayerItemPresenter>();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    treeSet.add(new LayerItemPresenter((FileObject)iterator.next(), fileObject));
                }
                iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    defaultComboBoxModel.addElement(iterator.next());
                }
            }
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
        }
        return defaultComboBoxModel;
    }

    public static String getSFSPath(JComboBox jComboBox, String string) {
        String string2;
        Object object = jComboBox.getEditor().getItem();
        String string3 = null;
        if (object instanceof LayerItemPresenter) {
            string3 = ((LayerItemPresenter)object).getFullPath();
        } else if (object instanceof String && (string2 = ((String)object).trim()).length() > 0 && (string3 = UIUtil.searchLIPCategoryCombo(jComboBox, string2)) == null) {
            string3 = string2.startsWith(string) ? string2 : string + '/' + string2;
        }
        return string3;
    }

    public static NbModuleProject chooseSuiteComponent(Component component, SuiteProject suiteProject) {
        NbModuleProject nbModuleProject = null;
        Project project = UIUtil.chooseProject(component);
        if (project != null) {
            if (SuiteUtils.getSubProjects(suiteProject).contains(project)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_SuiteAlreadyContainsProject", (Object)ProjectUtils.getInformation((Project)suiteProject).getDisplayName(), (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
                return null;
            }
            NbModuleTypeProvider nbModuleTypeProvider = (NbModuleTypeProvider)project.getLookup().lookup(NbModuleTypeProvider.class);
            if (nbModuleTypeProvider == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_TryingToAddNonNBModule", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            } else if (nbModuleTypeProvider.getModuleType() == NbModuleTypeProvider.SUITE_COMPONENT) {
                Object[] objectArray = new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), UIUtil.getSuiteProjectName(project), UIUtil.getSuiteProjectDirectory(project), ProjectUtils.getInformation((Project)suiteProject).getDisplayName()};
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_MoveFromSuiteToSuite", (Object[])objectArray), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() == NotifyDescriptor.OK_OPTION) {
                    nbModuleProject = (NbModuleProject)project;
                }
            } else if (nbModuleTypeProvider.getModuleType() == NbModuleTypeProvider.STANDALONE) {
                nbModuleProject = (NbModuleProject)project;
            } else if (nbModuleTypeProvider.getModuleType() == NbModuleTypeProvider.NETBEANS_ORG) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UIUtil.class, (String)"MSG_TryingToAddNBORGModule", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            }
        }
        return nbModuleProject;
    }

    public static ListCellRenderer createProjectRenderer() {
        return new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (!(object instanceof Project)) {
                    return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                }
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, projectInformation.getDisplayName(), n, bl, bl2);
                jLabel.setIcon(projectInformation.getIcon());
                return this;
            }
        };
    }

    private static String searchLIPCategoryCombo(JComboBox jComboBox, String string) {
        String string2 = null;
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            LayerItemPresenter layerItemPresenter;
            Object e = jComboBox.getItemAt(i);
            if (!(e instanceof LayerItemPresenter) || !string.equals((layerItemPresenter = (LayerItemPresenter)jComboBox.getItemAt(i)).getDisplayName())) continue;
            string2 = layerItemPresenter.getFullPath();
            break;
        }
        return string2;
    }

    private static Project chooseProject(Component component) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        int n = jFileChooser.showOpenDialog(component);
        Project project = null;
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            UIUtil.setProjectChooserDirParent(file);
            try {
                project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }
        return project;
    }

    private static File getSuiteDirectory(Project project) {
        SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        if (!$assertionsDisabled && suiteProvider == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && suiteProvider.getSuiteDirectory() == null) {
            throw new AssertionError((Object)("Invalid suite provider for: " + project.getProjectDirectory()));
        }
        return suiteProvider.getSuiteDirectory();
    }

    private static String getSuiteProjectDirectory(Project project) {
        return UIUtil.getSuiteDirectory(project).getAbsolutePath();
    }

    private static String getSuiteProjectName(Project project) {
        return Util.getDisplayName(FileUtil.toFileObject((File)UIUtil.getSuiteDirectory(project)));
    }

    private static Collection getFolders(FileObject fileObject, Map map) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Enumeration enumeration = fileObject.getFolders(false);
        block0: while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!entry.getValue().equals(fileObject2.getAttribute((String)entry.getKey()))) continue;
                continue block0;
            }
            hashSet.add(fileObject2);
            hashSet.addAll(UIUtil.getFolders(fileObject2, map));
        }
        return hashSet;
    }

    static {
        $assertionsDisabled = !UIUtil.class.desiredAssertionStatus();
    }

    private static final class IconFilter
    extends FileFilter {
        private IconFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith("gif") || file.getName().toLowerCase().endsWith("png");
        }

        public String getDescription() {
            return "*.gif, *.png";
        }
    }

    public static class LayerItemPresenter
    implements Comparable {
        private String displayName;
        private FileObject item;
        private FileObject root;
        private boolean contentType;

        public LayerItemPresenter(FileObject fileObject, FileObject fileObject2, boolean bl) {
            this.item = fileObject;
            this.root = fileObject2;
            this.contentType = bl;
        }

        public LayerItemPresenter(FileObject fileObject, FileObject fileObject2) {
            this(fileObject, fileObject2, false);
        }

        public FileObject getFileObject() {
            return this.item;
        }

        public String getFullPath() {
            return this.item.getPath();
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = this.computeDisplayName();
            }
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public int compareTo(Object object) {
            int n = Collator.getInstance().compare(this.getDisplayName(), ((LayerItemPresenter)object).getDisplayName());
            if (n != 0) {
                return n;
            }
            return this.getFullPath().compareTo(((LayerItemPresenter)object).getFullPath());
        }

        private static String getFileObjectName(FileObject fileObject) {
            String string = null;
            try {
                string = fileObject.getFileSystem().getStatus().annotateName(fileObject.getNameExt(), Collections.singleton(fileObject));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                string = fileObject.getName();
            }
            return string;
        }

        private String computeDisplayName() {
            FileObject fileObject = this.contentType ? this.item.getParent() : this.item;
            String string = this.contentType ? "/" : " | ";
            Stack<String> stack = new Stack<String>();
            stack.push(LayerItemPresenter.getFileObjectName(fileObject));
            FileObject fileObject2 = fileObject.getParent();
            while (!this.root.getPath().equals(fileObject2.getPath())) {
                stack.push(LayerItemPresenter.getFileObjectName(fileObject2));
                fileObject2 = fileObject2.getParent();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stack.pop());
            while (!stack.empty()) {
                stringBuffer.append(string + stack.pop());
            }
            return stringBuffer.toString();
        }
    }

    public static abstract class DocumentAdapter
    implements DocumentListener {
        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(null);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(null);
        }
    }
}

