/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.BrandingSupport;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public class BasicBrandingModel {
    private BrandingSupport branding;
    private SuiteProperties suiteProps;
    public static final String NAME_PROPERTY = "app.name";
    public static final String TITLE_PROPERTY = "app.title";
    public static final String ICON_LOCATION_PROPERTY = "app.icon";
    public static final String BRANDING_TOKEN_PROPERTY = "branding.token";
    static final int ICON_WIDTH = 48;
    static final int ICON_HEIGHT = 48;
    private boolean brandingEnabled;
    private String name;
    private String title;
    private BrandingSupport.BrandedFile icon = null;
    private BrandingSupport.BundleKey productInformation = null;
    private BrandingSupport.BundleKey mainWindowTitle = null;
    private BrandingSupport.BundleKey mainWindowTitleNoProject = null;
    private BrandingSupport.BundleKey currentVersion = null;
    private BrandingSupport.BrandedFile splash = null;
    private BrandingSupport.BundleKey splashWidth = null;
    private BrandingSupport.BundleKey splashHeight = null;
    private BrandingSupport.BundleKey splashShowProgressBar = null;
    private BrandingSupport.BundleKey splashRunningTextBounds = null;
    private BrandingSupport.BundleKey splashProgressBarBounds = null;
    private BrandingSupport.BundleKey splashRunningTextFontSize = null;
    private BrandingSupport.BundleKey splashRunningTextColor = null;
    private BrandingSupport.BundleKey splashProgressBarColor = null;
    private BrandingSupport.BundleKey splashProgressBarEdgeColor = null;
    private BrandingSupport.BundleKey splashProgressBarCornerColor = null;
    private final Set listeners = new HashSet();
    private Set splashKeys = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicBrandingModel(SuiteProperties suiteProperties) {
        this.suiteProps = suiteProperties;
        this.init();
    }

    public boolean isBrandingEnabled() {
        return this.brandingEnabled;
    }

    public void setBrandingEnabled(boolean bl) {
        if (this.brandingEnabled != bl) {
            this.brandingEnabled = bl;
            this.fireChange();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.isBrandingEnabled()) {
            this.name = string;
            this.suiteProps.setProperty(NAME_PROPERTY, this.getName());
            this.suiteProps.setProperty(BRANDING_TOKEN_PROPERTY, "${app.name}");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    public void setTitle(String string) {
        if (this.isBrandingEnabled()) {
            this.title = string;
            if (this.productInformation != null) {
                this.productInformation.setValue(string);
            }
            if (this.mainWindowTitle != null) {
                this.mainWindowTitle.setValue(string + " {0}");
            }
            if (this.mainWindowTitleNoProject != null) {
                this.mainWindowTitleNoProject.setValue(string + " {0}");
            }
            if (this.currentVersion != null) {
                this.currentVersion.setValue(string + " {0}");
            }
            this.suiteProps.setProperty(TITLE_PROPERTY, this.getTitle());
        }
    }

    public URL getIconSource() {
        return this.icon != null ? this.icon.getBrandingSource() : null;
    }

    public void setIconSource(URL uRL) {
        if (this.isBrandingEnabled()) {
            this.icon.setBrandingSource(uRL);
            this.suiteProps.setProperty(ICON_LOCATION_PROPERTY, this.getIconLocation());
        }
    }

    public String getIconLocation() {
        File file = FileUtil.toFile((FileObject)this.suiteProps.getProject().getProjectDirectory());
        String string = PropertyUtils.relativizeFile((File)file, (File)this.icon.getFileLocation());
        return string;
    }

    public String getSplashLocation() {
        File file = FileUtil.toFile((FileObject)this.suiteProps.getProject().getProjectDirectory());
        String string = PropertyUtils.relativizeFile((File)file, (File)this.splash.getFileLocation());
        return string;
    }

    public void store() throws IOException {
        if (this.brandingEnabled) {
            this.getBranding().brandBundleKey(this.productInformation);
            this.getBranding().brandBundleKey(this.mainWindowTitle);
            this.getBranding().brandBundleKey(this.mainWindowTitleNoProject);
            this.getBranding().brandBundleKey(this.currentVersion);
            this.getBranding().brandFile(this.icon, this.getScaleAndStoreIconTask());
            this.getBranding().brandBundleKeys(this.splashKeys);
            this.getBranding().brandFile(this.splash);
        } else {
            this.suiteProps.removeProperty(BRANDING_TOKEN_PROPERTY);
            this.suiteProps.removeProperty(NAME_PROPERTY);
            this.suiteProps.removeProperty(TITLE_PROPERTY);
            this.suiteProps.removeProperty(ICON_LOCATION_PROPERTY);
        }
    }

    private Runnable getScaleAndStoreIconTask() throws IOException {
        return new Runnable(){

            public void run() {
                BufferedImage bufferedImage = new BufferedImage(48, 48, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                ImageIcon imageIcon = new ImageIcon(BasicBrandingModel.this.icon.getBrandingSource());
                graphics2D.drawImage(imageIcon.getImage(), 0, 0, 48, 48, Color.LIGHT_GRAY, null);
                graphics2D.dispose();
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", BasicBrandingModel.this.icon.getFileLocation());
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        };
    }

    private BrandingSupport getBranding() {
        if (this.branding == null) {
            try {
                this.branding = BrandingSupport.getInstance(this.suiteProps);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                throw new IllegalStateException(iOException.getLocalizedMessage());
            }
        }
        return this.branding;
    }

    private void init() {
        this.initBundleKeys();
        this.initName(false);
        this.initTitle(false);
        this.brandingEnabledRefresh();
    }

    void brandingEnabledRefresh() {
        this.brandingEnabled = this.suiteProps.getProperty(BRANDING_TOKEN_PROPERTY) != null;
    }

    private String getSimpleName() {
        Element element = Util.findElement(this.suiteProps.getProject().getHelper().getPrimaryConfigurationData(true), "name", "http://www.netbeans.org/ns/nb-module-suite-project/1");
        String string = element != null ? Util.findText(element) : null;
        return string != null ? string : "???";
    }

    void initName(boolean bl) {
        if (this.name == null || bl) {
            this.name = this.suiteProps.getProperty(NAME_PROPERTY);
        }
        if (this.name == null) {
            this.name = this.getSimpleName().toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_");
            if (!this.name.matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
                this.name = "app";
            }
        }
        if (!$assertionsDisabled && this.name == null) {
            throw new AssertionError();
        }
    }

    void initTitle(boolean bl) {
        if (this.title == null || bl) {
            String string = this.suiteProps.getProperty(TITLE_PROPERTY);
            if (string == null && Character.isLowerCase((string = this.getSimpleName()).charAt(0))) {
                string = String.valueOf(Character.toLowerCase(string.charAt(0))) + string.substring(1);
            }
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            this.title = string;
        }
    }

    private void initBundleKeys() {
        this.productInformation = this.getBranding().getBundleKey("org.netbeans.core", "org/netbeans/core/ui/Bundle.properties", "LBL_ProductInformation");
        if (!$assertionsDisabled && this.productInformation == null) {
            throw new AssertionError();
        }
        this.mainWindowTitle = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title");
        if (!$assertionsDisabled && this.mainWindowTitle == null) {
            throw new AssertionError();
        }
        this.mainWindowTitleNoProject = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title_No_Project");
        if (!$assertionsDisabled && this.mainWindowTitleNoProject == null) {
            throw new AssertionError();
        }
        this.currentVersion = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "currentVersion");
        if (!$assertionsDisabled && this.currentVersion == null) {
            throw new AssertionError();
        }
        this.icon = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame48.gif");
        if (!$assertionsDisabled && this.icon == null) {
            throw new AssertionError();
        }
        this.splash = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/splash.gif");
        if (!$assertionsDisabled && this.splash == null) {
            throw new AssertionError();
        }
        this.splashWidth = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_WIDTH");
        if (!$assertionsDisabled && this.splashWidth == null) {
            throw new AssertionError();
        }
        this.splashHeight = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_HEIGHT");
        if (!$assertionsDisabled && this.splashHeight == null) {
            throw new AssertionError();
        }
        this.splashShowProgressBar = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashShowProgressBar");
        if (!$assertionsDisabled && this.splashShowProgressBar == null) {
            throw new AssertionError();
        }
        this.splashRunningTextFontSize = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextFontSize");
        if (!$assertionsDisabled && this.splashRunningTextFontSize == null) {
            throw new AssertionError();
        }
        this.splashProgressBarBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarBounds");
        if (!$assertionsDisabled && this.splashProgressBarBounds == null) {
            throw new AssertionError();
        }
        this.splashRunningTextBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextBounds");
        if (!$assertionsDisabled && this.splashRunningTextBounds == null) {
            throw new AssertionError();
        }
        this.splashRunningTextColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextColor");
        if (!$assertionsDisabled && this.splashRunningTextColor == null) {
            throw new AssertionError();
        }
        this.splashProgressBarColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarColor");
        if (!$assertionsDisabled && this.splashProgressBarColor == null) {
            throw new AssertionError();
        }
        this.splashProgressBarEdgeColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarEdgeColor");
        if (!$assertionsDisabled && this.splashProgressBarEdgeColor == null) {
            throw new AssertionError();
        }
        this.splashProgressBarCornerColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarCornerColor");
        if (!$assertionsDisabled && this.splashProgressBarCornerColor == null) {
            throw new AssertionError();
        }
        this.splashKeys.clear();
        this.splashKeys.add(this.splashWidth);
        this.splashKeys.add(this.splashHeight);
        this.splashKeys.add(this.splashShowProgressBar);
        this.splashKeys.add(this.splashRunningTextBounds);
        this.splashKeys.add(this.splashProgressBarBounds);
        this.splashKeys.add(this.splashRunningTextFontSize);
        this.splashKeys.add(this.splashRunningTextColor);
        this.splashKeys.add(this.splashProgressBarColor);
        this.splashKeys.add(this.splashProgressBarEdgeColor);
        this.splashKeys.add(this.splashProgressBarCornerColor);
        this.splashKeys.remove(null);
    }

    public BrandingSupport.BundleKey getSplashWidth() {
        return this.splashWidth;
    }

    public BrandingSupport.BundleKey getSplashHeight() {
        return this.splashHeight;
    }

    public BrandingSupport.BundleKey getSplashShowProgressBar() {
        return this.splashShowProgressBar;
    }

    public BrandingSupport.BundleKey getSplashRunningTextBounds() {
        return this.splashRunningTextBounds;
    }

    public BrandingSupport.BundleKey getSplashProgressBarBounds() {
        return this.splashProgressBarBounds;
    }

    public BrandingSupport.BundleKey getSplashRunningTextFontSize() {
        return this.splashRunningTextFontSize;
    }

    public BrandingSupport.BundleKey getSplashRunningTextColor() {
        return this.splashRunningTextColor;
    }

    public BrandingSupport.BundleKey getSplashProgressBarColor() {
        return this.splashProgressBarColor;
    }

    public BrandingSupport.BundleKey getSplashProgressBarEdgeColor() {
        return this.splashProgressBarEdgeColor;
    }

    public BrandingSupport.BundleKey getSplashProgressBarCornerColor() {
        return this.splashProgressBarCornerColor;
    }

    public BrandingSupport.BrandedFile getSplash() {
        return this.splash;
    }

    static {
        $assertionsDisabled = !BasicBrandingModel.class.desiredAssertionStatus();
    }
}

