/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.ErrorManager;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

abstract class BasicCustomizer
implements CustomizerProvider,
PropertyChangeListener {
    static final String LAST_SELECTED_PANEL = "lastSelectedPanel";
    private final Project project;
    private Dialog dialog;
    private ProjectCustomizer.CategoryComponentProvider panelProvider;
    private ProjectCustomizer.Category[] categories;
    private Component lastSelectedPanel;
    private final Map panels = new HashMap();

    protected BasicCustomizer(Project project) {
        this.project = project;
    }

    abstract void storeProperties() throws IOException;

    abstract void prepareData();

    protected void setCategories(ProjectCustomizer.Category[] categoryArray) {
        this.categories = categoryArray;
    }

    protected Project getProject() {
        return this.project;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String string) {
        this.showCustomizer(string, null);
    }

    public void showCustomizer(String string, String string2) {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            return;
        }
        this.prepareData();
        Object object = new OptionListener();
        if (string == null) {
            string = this.findLastSelectedCategory();
        }
        if (this.categories == null) {
            return;
        }
        this.dialog = ProjectCustomizer.createCustomizerDialog((ProjectCustomizer.Category[])this.categories, (ProjectCustomizer.CategoryComponentProvider)this.getPanelProvider(), (String)string, (ActionListener)object, null);
        this.dialog.addWindowListener((WindowListener)object);
        this.dialog.setTitle(NbBundle.getMessage(this.getClass(), (String)"LBL_CustomizerTitle", (Object)ProjectUtils.getInformation((Project)this.getProject()).getDisplayName()));
        this.dialog.setVisible(true);
        if (string != null && string2 != null) {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!string.equals(this.categories[i].getName())) continue;
                JComponent jComponent = this.panelProvider.create(this.categories[i]);
                if (!(jComponent instanceof SubCategoryProvider)) break;
                ((SubCategoryProvider)((Object)jComponent)).showSubCategory(string2);
                break;
            }
        }
        object = this.panels.values().iterator();
        while (object.hasNext()) {
            NbPropertyPanel nbPropertyPanel = (NbPropertyPanel)object.next();
            nbPropertyPanel.checkForm();
        }
    }

    protected void createCategoryPanel(String string, String string2, NbPropertyPanel nbPropertyPanel) {
        ProjectCustomizer.Category category = ProjectCustomizer.Category.create((String)string, (String)NbBundle.getMessage(this.getClass(), (String)string2), null, null);
        this.createPanel(category, nbPropertyPanel);
    }

    protected ProjectCustomizer.Category createCategory(String string, String string2) {
        return ProjectCustomizer.Category.create((String)string, (String)NbBundle.getMessage(this.getClass(), (String)string2), null, null);
    }

    protected void createPanel(ProjectCustomizer.Category category, NbPropertyPanel nbPropertyPanel) {
        this.panels.put(category, nbPropertyPanel);
    }

    protected void listenToPanels() {
        Iterator iterator = this.panels.values().iterator();
        while (iterator.hasNext()) {
            ((Component)iterator.next()).addPropertyChangeListener(this);
        }
    }

    private ProjectCustomizer.Category findCategory(Object object) {
        Iterator iterator = this.panels.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!object.equals(entry.getValue())) continue;
            return (ProjectCustomizer.Category)entry.getKey();
        }
        throw new IllegalArgumentException(object + " panel is not known in this customizer");
    }

    public void save() {
        try {
            Boolean bl = (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    BasicCustomizer.this.storeProperties();
                    return Boolean.TRUE;
                }
            });
            if (bl == Boolean.TRUE) {
                ProjectManager.getDefault().saveProject(this.project);
            }
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "isPanelValid") {
            this.findCategory(propertyChangeEvent.getSource()).setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
        } else if (string == "errorMessage") {
            this.findCategory(propertyChangeEvent.getSource()).setErrorMessage((String)propertyChangeEvent.getNewValue());
        } else if (string == LAST_SELECTED_PANEL) {
            this.lastSelectedPanel = (Component)propertyChangeEvent.getSource();
        }
    }

    private ProjectCustomizer.CategoryComponentProvider getPanelProvider() {
        if (this.panelProvider == null) {
            this.panelProvider = new ProjectCustomizer.CategoryComponentProvider(){

                public JComponent create(ProjectCustomizer.Category category) {
                    JComponent jComponent = (JComponent)BasicCustomizer.this.panels.get(category);
                    return jComponent == null ? new JPanel() : jComponent;
                }
            };
        }
        return this.panelProvider;
    }

    private String findLastSelectedCategory() {
        String string = null;
        Iterator iterator = this.panels.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Component component = (Component)entry.getValue();
            if (component != this.lastSelectedPanel) continue;
            string = ((ProjectCustomizer.Category)entry.getKey()).getName();
            break;
        }
        return string;
    }

    static interface SubCategoryProvider {
        public void showSubCategory(String var1);
    }

    static interface LazyStorage {
        public void store();
    }

    protected class OptionListener
    extends WindowAdapter
    implements ActionListener {
        protected OptionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator = BasicCustomizer.this.panels.values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (!(v instanceof LazyStorage)) continue;
                ((LazyStorage)v).store();
            }
            BasicCustomizer.this.save();
            if (BasicCustomizer.this.dialog != null) {
                BasicCustomizer.this.dialog.setVisible(false);
                BasicCustomizer.this.dialog.dispose();
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            BasicCustomizer.this.dialog = null;
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (BasicCustomizer.this.dialog != null) {
                BasicCustomizer.this.dialog.setVisible(false);
                BasicCustomizer.this.dialog.dispose();
            }
        }
    }
}

